/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nextapp.echo2.app.filetransfer.AbstractDownloadProvider;

public class ResourceDownloadProvider
extends AbstractDownloadProvider {
    private static final int BUFFER_SIZE = 4096;
    protected String contentType;
    private String resourceName;
    private boolean fileNameProvided = true;

    public ResourceDownloadProvider(String resourceName, String contentType) {
        this.contentType = contentType;
        this.resourceName = resourceName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFileName() {
        if (this.fileNameProvided) {
            int lastSlash = this.resourceName.lastIndexOf("/");
            if (lastSlash == -1) {
                return this.resourceName;
            }
            return this.resourceName.substring(lastSlash + 1);
        }
        return null;
    }

    public boolean isFileNameProvided() {
        return this.fileNameProvided;
    }

    public void setFileNameProvided(boolean fileNameProvided) {
        this.fileNameProvided = fileNameProvided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(OutputStream out) throws IOException {
        InputStream in = null;
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        try {
            in = ResourceDownloadProvider.class.getResourceAsStream(this.resourceName);
            if (in == null) {
                throw new IllegalArgumentException("Specified resource does not exist: " + this.resourceName + ".");
            }
            do {
                if ((bytesRead = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

