/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.list;

import java.util.EventListener;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.event.ListDataEvent;
import nextapp.echo2.app.event.ListDataListener;
import nextapp.echo2.app.list.DefaultListCellRenderer;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.DefaultListSelectionModel;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.list.ListSelectionModel;

public abstract class AbstractListComponent
extends Component {
    public static final String INPUT_ACTION = "action";
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String LIST_DATA_CHANGED_PROPERTY = "listData";
    public static final String LIST_MODEL_CHANGED_PROPERTY = "listModel";
    public static final String LIST_CELL_RENDERER_CHANGED_PROPERTY = "listCellRenderer";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY = "listSelectionModel";
    public static final String SELECTION_CHANGED_PROPERTY = "listSelectionChanged";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_DISABLED_BACKGROUND = "disabledBackground";
    public static final String PROPERTY_DISABLED_BORDER = "disabledBorder";
    public static final String PROPERTY_DISABLED_FONT = "disabledFont";
    public static final String PROPERTY_DISABLED_FOREGROUND = "disabledForeground";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String PROPERTY_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String PROPERTY_ROLLOVER_FONT = "rolloverFont";
    public static final String PROPERTY_ROLLOVER_FOREGROUND = "rolloverForeground";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROPERTY_WIDTH = "width";
    public static final DefaultListCellRenderer DEFAULT_LIST_CELL_RENDERER = new DefaultListCellRenderer();
    private ChangeListener changeHandler = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.SELECTION_CHANGED_PROPERTY, null, null);
        }
    };
    private ListDataListener listDataHandler = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.LIST_DATA_CHANGED_PROPERTY, null, null);
        }
    };
    private ListCellRenderer listCellRenderer = DEFAULT_LIST_CELL_RENDERER;
    private ListModel model;
    private ListSelectionModel selectionModel;

    public AbstractListComponent() {
        this(null, null);
    }

    public AbstractListComponent(ListModel model, ListSelectionModel selectionModel) {
        if (model == null) {
            model = new DefaultListModel();
        }
        if (selectionModel == null) {
            selectionModel = new DefaultListSelectionModel();
        }
        this.setModel(model);
        this.setSelectionModel(selectionModel);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    private void fireActionEvent() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return (String)this.getProperty(PROPERTY_ACTION_COMMAND);
    }

    public Border getBorder() {
        return (Border)this.getProperty(PROPERTY_BORDER);
    }

    public ListCellRenderer getCellRenderer() {
        return this.listCellRenderer;
    }

    public Color getDisabledBackground() {
        return (Color)this.getProperty(PROPERTY_DISABLED_BACKGROUND);
    }

    public Border getDisabledBorder() {
        return (Border)this.getProperty(PROPERTY_DISABLED_BORDER);
    }

    public Font getDisabledFont() {
        return (Font)this.getProperty(PROPERTY_DISABLED_FONT);
    }

    public Color getDisabledForeground() {
        return (Color)this.getProperty(PROPERTY_DISABLED_FOREGROUND);
    }

    public Extent getHeight() {
        return (Extent)this.getProperty(PROPERTY_HEIGHT);
    }

    public Insets getInsets() {
        return (Insets)this.getProperty(PROPERTY_INSETS);
    }

    public ListModel getModel() {
        return this.model;
    }

    public Color getRolloverBackground() {
        return (Color)this.getProperty(PROPERTY_ROLLOVER_BACKGROUND);
    }

    public Font getRolloverFont() {
        return (Font)this.getProperty(PROPERTY_ROLLOVER_FONT);
    }

    public Color getRolloverForeground() {
        return (Color)this.getProperty(PROPERTY_ROLLOVER_FOREGROUND);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public String getToolTipText() {
        return (String)this.getProperty(PROPERTY_TOOL_TIP_TEXT);
    }

    public Extent getWidth() {
        return (Extent)this.getProperty(PROPERTY_WIDTH);
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public boolean isRolloverEnabled() {
        Boolean value = (Boolean)this.getProperty(PROPERTY_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    @Override
    public boolean isValidChild(Component child) {
        return false;
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (SELECTION_CHANGED_PROPERTY.equals(inputName)) {
            int[] selectedIndices = (int[])inputValue;
            ListSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.clearSelection();
            for (int i = 0; i < selectedIndices.length; ++i) {
                selectionModel.setSelectedIndex(selectedIndices[i], true);
            }
        } else if (INPUT_ACTION.equals(inputName)) {
            this.fireActionEvent();
        }
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.setProperty(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setBorder(Border newValue) {
        this.setProperty(PROPERTY_BORDER, newValue);
    }

    public void setCellRenderer(ListCellRenderer newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Cell Renderer may not be null.");
        }
        ListCellRenderer oldValue = this.listCellRenderer;
        this.listCellRenderer = newValue;
        this.firePropertyChange(LIST_CELL_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDisabledBackground(Color newValue) {
        this.setProperty(PROPERTY_DISABLED_BACKGROUND, newValue);
    }

    public void setDisabledBorder(Border newValue) {
        this.setProperty(PROPERTY_DISABLED_BORDER, newValue);
    }

    public void setDisabledFont(Font newValue) {
        this.setProperty(PROPERTY_DISABLED_FONT, newValue);
    }

    public void setDisabledForeground(Color newValue) {
        this.setProperty(PROPERTY_DISABLED_FOREGROUND, newValue);
    }

    public void setHeight(Extent newValue) {
        this.setProperty(PROPERTY_HEIGHT, newValue);
    }

    public void setInsets(Insets newValue) {
        this.setProperty(PROPERTY_INSETS, newValue);
    }

    public void setModel(ListModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Model may not be null.");
        }
        ListModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeListDataListener(this.listDataHandler);
        }
        newValue.addListDataListener(this.listDataHandler);
        this.model = newValue;
        this.firePropertyChange(LIST_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRolloverBackground(Color newValue) {
        this.setProperty(PROPERTY_ROLLOVER_BACKGROUND, newValue);
    }

    public void setRolloverEnabled(boolean newValue) {
        this.setProperty(PROPERTY_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setRolloverFont(Font newValue) {
        this.setProperty(PROPERTY_ROLLOVER_FONT, newValue);
    }

    public void setRolloverForeground(Color newValue) {
        this.setProperty(PROPERTY_ROLLOVER_FOREGROUND, newValue);
    }

    public void setSelectionModel(ListSelectionModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Selection model may not be null.");
        }
        ListSelectionModel oldValue = this.selectionModel;
        if (oldValue != null) {
            oldValue.removeChangeListener(this.changeHandler);
        }
        newValue.addChangeListener(this.changeHandler);
        this.selectionModel = newValue;
        this.firePropertyChange(SELECTION_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setToolTipText(String newValue) {
        this.setProperty(PROPERTY_TOOL_TIP_TEXT, newValue);
    }

    public void setWidth(Extent newValue) {
        this.setProperty(PROPERTY_WIDTH, newValue);
    }
}

