/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.list;

import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.event.EventListenerList;
import nextapp.echo2.app.list.ListSelectionModel;

public class DefaultListSelectionModel
implements ListSelectionModel,
Serializable {
    private EventListenerList listenerList = new EventListenerList();
    private int selectionMode = 0;
    private BitSet selection = new BitSet();
    private int minSelectedIndex = -1;

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.addListener(ChangeListener.class, l);
    }

    @Override
    public void clearSelection() {
        this.selection = new BitSet();
        this.minSelectedIndex = -1;
        this.fireValueChanged();
    }

    protected void fireValueChanged() {
        ChangeEvent e = new ChangeEvent(this);
        EventListener[] listeners = this.listenerList.getListeners(ChangeListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((ChangeListener)listeners[index]).stateChanged(e);
        }
    }

    @Override
    public int getMaxSelectedIndex() {
        return this.selection.length() - 1;
    }

    @Override
    public int getMinSelectedIndex() {
        return this.minSelectedIndex;
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.selection.get(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection.length() == 0;
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.removeListener(ChangeListener.class, l);
    }

    @Override
    public void setSelectedIndex(int index, boolean newValue) {
        block3: {
            block5: {
                block4: {
                    boolean oldValue = this.isSelectedIndex(index);
                    if (!(newValue ^ oldValue)) break block3;
                    if (!newValue) break block4;
                    if (this.selectionMode == 0 && this.getMinSelectedIndex() != -1) {
                        this.setSelectedIndex(this.getMinSelectedIndex(), false);
                    }
                    this.selection.set(index);
                    if (index >= this.minSelectedIndex && this.minSelectedIndex != -1) break block5;
                    this.minSelectedIndex = index;
                    break block5;
                }
                this.selection.clear(index);
                if (index == this.minSelectedIndex) {
                    int max = this.getMaxSelectedIndex();
                    this.minSelectedIndex = -1;
                    for (int i = 0; i <= max; ++i) {
                        if (!this.selection.get(i)) continue;
                        this.minSelectedIndex = i;
                        break;
                    }
                }
            }
            this.fireValueChanged();
        }
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        if (selectionMode != 2 && this.selectionMode == 2) {
            int maxSelectedIndex = this.getMaxSelectedIndex();
            for (int i = this.minSelectedIndex + 1; i <= maxSelectedIndex; ++i) {
                this.setSelectedIndex(i, false);
            }
        }
        this.selectionMode = selectionMode;
        this.fireValueChanged();
    }
}

