/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.text;

import java.util.EventListener;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.event.DocumentListener;
import nextapp.echo2.app.text.Document;

public abstract class TextComponent
extends Component {
    public static final String INPUT_ACTION = "action";
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String PROPERTY_ALIGNMENT = "alignment";
    public static final String PROPERTY_BACKGROUND_IMAGE = "backgroundImage";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_DISABLED_BACKGROUND = "disabledBackground";
    public static final String PROPERTY_DISABLED_BACKGROUND_IMAGE = "disabledBackgroundImage";
    public static final String PROPERTY_DISABLED_BORDER = "disabledBorder";
    public static final String PROPERTY_DISABLED_FONT = "disabledFont";
    public static final String PROPERTY_DISABLED_FOREGROUND = "disabledForeground";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_HORIZONTAL_SCROLL = "horizontalScroll";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_MAXIMUM_LENGTH = "maximumLength";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROPERTY_VERTICAL_SCROLL = "verticalScroll";
    public static final String PROPERTY_WIDTH = "width";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String DOCUMENT_CHANGED_PROPERTY = "document";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    private Document document;
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void documentUpdate(DocumentEvent e) {
            TextComponent.this.firePropertyChange(TextComponent.TEXT_CHANGED_PROPERTY, null, ((Document)e.getSource()).getText());
        }
    };

    public TextComponent(Document document) {
        this.setDocument(document);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    private void fireActionEvent() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return (String)this.getProperty(PROPERTY_ACTION_COMMAND);
    }

    public Alignment getAlignment() {
        return (Alignment)this.getProperty(PROPERTY_ALIGNMENT);
    }

    public FillImage getBackgroundImage() {
        return (FillImage)this.getProperty(PROPERTY_BACKGROUND_IMAGE);
    }

    public Border getBorder() {
        return (Border)this.getProperty(PROPERTY_BORDER);
    }

    public Color getDisabledBackground() {
        return (Color)this.getProperty(PROPERTY_DISABLED_BACKGROUND);
    }

    public FillImage getDisabledBackgroundImage() {
        return (FillImage)this.getProperty(PROPERTY_DISABLED_BACKGROUND_IMAGE);
    }

    public Border getDisabledBorder() {
        return (Border)this.getProperty(PROPERTY_DISABLED_BORDER);
    }

    public Font getDisabledFont() {
        return (Font)this.getProperty(PROPERTY_DISABLED_FONT);
    }

    public Color getDisabledForeground() {
        return (Color)this.getProperty(PROPERTY_DISABLED_FOREGROUND);
    }

    public Document getDocument() {
        return this.document;
    }

    public Extent getHeight() {
        return (Extent)this.getProperty(PROPERTY_HEIGHT);
    }

    public Extent getHorizontalScroll() {
        return (Extent)this.getProperty(PROPERTY_HORIZONTAL_SCROLL);
    }

    public Insets getInsets() {
        return (Insets)this.getProperty(PROPERTY_INSETS);
    }

    public int getMaximumLength() {
        Integer value = (Integer)this.getProperty(PROPERTY_MAXIMUM_LENGTH);
        return value == null ? -1 : value;
    }

    public String getText() {
        return this.document.getText();
    }

    public String getToolTipText() {
        return (String)this.getProperty(PROPERTY_TOOL_TIP_TEXT);
    }

    public Extent getVerticalScroll() {
        return (Extent)this.getProperty(PROPERTY_VERTICAL_SCROLL);
    }

    public Extent getWidth() {
        return (Extent)this.getProperty(PROPERTY_WIDTH);
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    @Override
    public boolean isValidChild(Component component) {
        return false;
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (TEXT_CHANGED_PROPERTY.equals(inputName)) {
            this.setText((String)inputValue);
        } else if (PROPERTY_HORIZONTAL_SCROLL.equals(inputName)) {
            this.setHorizontalScroll((Extent)inputValue);
        } else if (PROPERTY_VERTICAL_SCROLL.equals(inputName)) {
            this.setVerticalScroll((Extent)inputValue);
        } else if (INPUT_ACTION.equals(inputName)) {
            this.fireActionEvent();
        }
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.setProperty(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setAlignment(Alignment newValue) {
        this.setProperty(PROPERTY_ALIGNMENT, newValue);
    }

    public void setBackgroundImage(FillImage newValue) {
        this.setProperty(PROPERTY_BACKGROUND_IMAGE, newValue);
    }

    public void setBorder(Border newValue) {
        this.setProperty(PROPERTY_BORDER, newValue);
    }

    public void setDisabledBackground(Color newValue) {
        this.setProperty(PROPERTY_DISABLED_BACKGROUND, newValue);
    }

    public void setDisabledBackgroundImage(FillImage newValue) {
        this.setProperty(PROPERTY_DISABLED_BACKGROUND_IMAGE, newValue);
    }

    public void setDisabledBorder(Border newValue) {
        this.setProperty(PROPERTY_DISABLED_BORDER, newValue);
    }

    public void setDisabledFont(Font newValue) {
        this.setProperty(PROPERTY_DISABLED_FONT, newValue);
    }

    public void setDisabledForeground(Color newValue) {
        this.setProperty(PROPERTY_DISABLED_FOREGROUND, newValue);
    }

    public void setDocument(Document newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Document may not be null.");
        }
        Document oldValue = this.getDocument();
        if (oldValue != null) {
            oldValue.removeDocumentListener(this.documentListener);
        }
        newValue.addDocumentListener(this.documentListener);
        this.document = newValue;
    }

    public void setHeight(Extent newValue) {
        this.setProperty(PROPERTY_HEIGHT, newValue);
    }

    public void setHorizontalScroll(Extent newValue) {
        this.setProperty(PROPERTY_HORIZONTAL_SCROLL, newValue);
    }

    public void setInsets(Insets newValue) {
        this.setProperty(PROPERTY_INSETS, newValue);
    }

    public void setMaximumLength(int newValue) {
        if (newValue < 0) {
            this.setProperty(PROPERTY_MAXIMUM_LENGTH, null);
        } else {
            this.setProperty(PROPERTY_MAXIMUM_LENGTH, new Integer(newValue));
        }
    }

    public void setText(String newValue) {
        Integer maxLength = (Integer)this.getProperty(PROPERTY_MAXIMUM_LENGTH);
        if (newValue != null && maxLength != null && maxLength > 0 && newValue.length() > maxLength) {
            this.getDocument().setText(newValue.substring(0, maxLength));
        } else {
            this.getDocument().setText(newValue);
        }
    }

    public void setToolTipText(String newValue) {
        this.setProperty(PROPERTY_TOOL_TIP_TEXT, newValue);
    }

    public void setVerticalScroll(Extent newValue) {
        this.setProperty(PROPERTY_VERTICAL_SCROLL, newValue);
    }

    public void setWidth(Extent newValue) {
        this.setProperty(PROPERTY_WIDTH, newValue);
    }
}

