/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.app.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.util.PropertiesDiscovery;

public class PeerFactory {
    private final Map objectClassNameToPeerMap = new HashMap();

    public PeerFactory(String resourceName, ClassLoader classLoader) {
        try {
            Map peerNameMap = PropertiesDiscovery.loadProperties(resourceName, classLoader);
            for (String objectClassName : peerNameMap.keySet()) {
                String peerClassName = (String)peerNameMap.get(objectClassName);
                Class<?> peerClass = classLoader.loadClass(peerClassName);
                Object peer = peerClass.newInstance();
                this.objectClassNameToPeerMap.put(objectClassName, peer);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings: " + ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings: " + ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings: " + ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to load synchronize peer bindings: " + ex);
        }
    }

    public Object getPeerForObject(Class objectClass, boolean searchSuperClasses) {
        Object peer = null;
        do {
            if ((peer = this.objectClassNameToPeerMap.get(objectClass.getName())) != null) {
                return peer;
            }
            objectClass = objectClass.getSuperclass();
        } while (searchSuperClasses && objectClass != null);
        return null;
    }
}

