/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.app;

import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.extras.app.event.DropEvent;
import nextapp.echo2.extras.app.event.DropListener;

public class DragSource
extends Component {
    public static final String DROP_TARGET_LISTENERS_CHANGED_PROPERTY = "dropTargetListeners";
    public static final String INPUT_DROP = "ACTION_INPUT_DROP";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    private List dropTargets;

    public DragSource() {
    }

    public DragSource(Component draggable) {
        this.add(draggable);
    }

    public void addDropTarget(Component dropTarget) {
        if (this.getDropTargetList().indexOf(dropTarget) < 0) {
            this.getDropTargetList().add(dropTarget);
        }
    }

    public void addDropTargetListener(DropListener listener) {
        this.getEventListenerList().addListener(DropListener.class, listener);
        this.firePropertyChange(DROP_TARGET_LISTENERS_CHANGED_PROPERTY, null, listener);
    }

    public void fireDropEvent(DropEvent event) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(DropListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            DropListener listener = (DropListener)listeners[i];
            listener.dropPerformed(event);
        }
    }

    public Component getDropTargetAt(int n) {
        return (Component)this.getDropTargetList().get(n);
    }

    public int getDropTargetCount() {
        return this.getDropTargetList().size();
    }

    protected List getDropTargetList() {
        if (this.dropTargets == null) {
            this.dropTargets = new LinkedList();
        }
        return this.dropTargets;
    }

    public Component[] getDropTargets() {
        return this.getDropTargetList().toArray(new Component[0]);
    }

    public String getToolTipText(String newValue) {
        return (String)this.getProperty(PROPERTY_TOOL_TIP_TEXT);
    }

    @Override
    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if (INPUT_DROP.equals(name)) {
            this.fireDropEvent(new DropEvent((Object)this, value));
        }
    }

    public void removeAllDropTargets() {
        this.getDropTargetList().clear();
    }

    public void removeDropTarget(Component dropTarget) {
        this.getDropTargetList().remove(dropTarget);
    }

    public void removeDropTargetListener(DropListener listener) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(DropListener.class, listener);
    }

    public void setToolTipText(String newValue) {
        this.setProperty(PROPERTY_TOOL_TIP_TEXT, newValue);
    }
}

