/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import java.util.HashSet;
import java.util.Set;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.extras.app.AccordionPane;
import nextapp.echo2.extras.app.layout.AccordionPaneLayoutData;
import nextapp.echo2.extras.webcontainer.ExtrasUtil;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.LazyRenderContainer;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class AccordionPanePeer
implements ComponentSynchronizePeer,
ImageRenderSupport,
LazyRenderContainer,
PropertyUpdateProcessor {
    private static final String PROPERTY_ACTIVE_TAB = "activeTab";
    private static final String IMAGE_ID_TAB_BACKGROUND = "tabBackground";
    private static final String IMAGE_ID_TAB_ROLLOVER_BACKGROUND = "tabRolloverBackground";
    public static final String PROPERTY_LAZY_RENDER_ENABLED = "nextapp.echo2.extras.webcontainer.AccordionPanePeer.lazyRenderEnabled";
    public static final Service ACCORDION_PANE_SERVICE = JavaScriptService.forResource("Echo2Extras.AccordionPane", "/nextapp/echo2/extras/webcontainer/resource/js/AccordionPane.js");
    private PartialUpdateParticipant activeTabUpdateParticipant = new PartialUpdateParticipant(){

        @Override
        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            AccordionPanePeer.this.renderSetActiveTab(rc, update, (AccordionPane)update.getParent());
        }

        @Override
        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }
    };
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public AccordionPanePeer() {
        this.partialUpdateManager.add("activeTabIndex", this.activeTabUpdateParticipant);
    }

    private boolean configureActiveTab(ContainerInstance ci, AccordionPane accordionPane) {
        Component activeTab;
        AccordionPaneRenderState renderState = (AccordionPaneRenderState)ci.getRenderState(accordionPane);
        int componentCount = accordionPane.getVisibleComponentCount();
        int activeTabIndex = accordionPane.getActiveTabIndex();
        Component component = activeTab = activeTabIndex >= 0 && activeTabIndex < componentCount ? accordionPane.getComponent(activeTabIndex) : null;
        if (activeTab == null && renderState.activeTabId != null) {
            activeTab = this.getChildByRenderId(accordionPane, renderState.activeTabId);
        }
        if (activeTab == null) {
            if (componentCount == 0) {
                return false;
            }
            activeTab = accordionPane.getActiveTabIndex() == -1 ? accordionPane.getVisibleComponent(0) : accordionPane.getVisibleComponent(componentCount - 1);
        }
        renderState.activeTabId = activeTab.getRenderId();
        if (this.isLazyRenderEnabled(accordionPane)) {
            if (!this.isRendered(ci, accordionPane, activeTab)) {
                this.setRendered(ci, accordionPane, activeTab);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_content_" + child.getRenderId();
    }

    private Component getChildByRenderId(AccordionPane accordionPane, String renderId) {
        Component[] children = accordionPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getRenderId().equals(renderId)) continue;
            return children[i];
        }
        return null;
    }

    @Override
    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_TAB_BACKGROUND.equals(imageId)) {
            FillImage fillImage = (FillImage)component.getRenderProperty("tabBackgroundImage");
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_TAB_ROLLOVER_BACKGROUND.equals(imageId)) {
            FillImage fillImage = (FillImage)component.getRenderProperty("tabRolloverBackgroundImage");
            return fillImage == null ? null : fillImage.getImage();
        }
        return null;
    }

    private boolean isLazyRenderEnabled(AccordionPane accordionPane) {
        Boolean lazyRenderEnabled = (Boolean)accordionPane.getRenderProperty(PROPERTY_LAZY_RENDER_ENABLED);
        return lazyRenderEnabled == null ? false : lazyRenderEnabled;
    }

    @Override
    public boolean isRendered(ContainerInstance ci, Component parent, Component child) {
        if (!this.isLazyRenderEnabled((AccordionPane)parent)) {
            return true;
        }
        AccordionPaneRenderState renderState = (AccordionPaneRenderState)ci.getRenderState(parent);
        if (renderState == null) {
            return false;
        }
        return renderState.renderedChildren.contains(child);
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if (PROPERTY_ACTIVE_TAB.equals(propertyName)) {
            String propertyValue = propertyElement.getAttribute("value");
            Component[] children = component.getVisibleComponents();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].getRenderId().equals(propertyValue)) continue;
                ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "inputTabIndex", new Integer(i));
                return;
            }
        }
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        serverMessage.addLibrary(ACCORDION_PANE_SERVICE.getId());
        AccordionPane accordionPane = (AccordionPane)component;
        ContainerInstance ci = rc.getContainerInstance();
        this.resetRenderState(ci, accordionPane);
        this.configureActiveTab(ci, accordionPane);
        this.renderInitDirective(rc, accordionPane, targetId);
        Component[] children = accordionPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderAddTabDirective(rc, update, accordionPane, children[i]);
        }
        boolean lazyRenderEnabled = this.isLazyRenderEnabled(accordionPane);
        for (int i = 0; i < children.length; ++i) {
            if (lazyRenderEnabled && !this.isRendered(ci, accordionPane, children[i])) continue;
            this.renderChild(rc, update, accordionPane, children[i]);
        }
        this.renderRedrawDirective(rc, accordionPane);
    }

    private void renderAddChildren(RenderContext rc, ServerComponentUpdate update, boolean activeTabRenderRequired) {
        AccordionPaneRenderState renderState;
        AccordionPane accordionPane = (AccordionPane)update.getParent();
        ContainerInstance ci = rc.getContainerInstance();
        Component activeTab = null;
        if (activeTabRenderRequired && (activeTab = this.getChildByRenderId(accordionPane, (renderState = (AccordionPaneRenderState)ci.getRenderState(accordionPane)).activeTabId)) == null) {
            activeTabRenderRequired = false;
        }
        if (update.hasAddedChildren()) {
            Component[] addedChildren = update.getAddedChildren();
            Component[] children = accordionPane.getVisibleComponents();
            block0: for (int i = 0; i < children.length; ++i) {
                for (int j = 0; j < addedChildren.length; ++j) {
                    if (children[i] != addedChildren[j]) continue;
                    this.renderAddTabDirective(rc, update, accordionPane, children[i]);
                    continue block0;
                }
            }
            boolean lazyRenderEnabled = this.isLazyRenderEnabled(accordionPane);
            for (int i = 0; i < addedChildren.length; ++i) {
                if (lazyRenderEnabled && !this.isRendered(ci, accordionPane, addedChildren[i])) continue;
                this.renderChild(rc, update, accordionPane, addedChildren[i]);
                if (addedChildren[i] != activeTab) continue;
                activeTabRenderRequired = false;
            }
        }
        if (activeTabRenderRequired) {
            this.renderChild(rc, update, accordionPane, activeTab);
        }
    }

    private void renderAddTabDirective(RenderContext rc, ServerComponentUpdate update, AccordionPane accordionPane, Component child) {
        ContainerInstance ci = rc.getContainerInstance();
        boolean rendered = !this.isLazyRenderEnabled(accordionPane) || this.isRendered(ci, accordionPane, child);
        AccordionPaneLayoutData layoutData = (AccordionPaneLayoutData)child.getLayoutData();
        String elementId = ContainerInstance.getElementId(accordionPane);
        Element addPartElement = rc.getServerMessage().appendPartDirective("update", "ExtrasAccordionPane.MessageProcessor", "add-tab");
        addPartElement.setAttribute("eid", elementId);
        addPartElement.setAttribute("tab-id", child.getRenderId());
        addPartElement.setAttribute("tab-index", Integer.toString(accordionPane.indexOf(child)));
        if (rendered) {
            addPartElement.setAttribute("rendered", "true");
        }
        if (child instanceof Pane) {
            addPartElement.setAttribute("pane", "true");
        }
        if (layoutData != null && layoutData.getTitle() != null) {
            addPartElement.setAttribute("title", layoutData.getTitle());
        }
    }

    private void renderChild(RenderContext rc, ServerComponentUpdate update, AccordionPane accordionPane, Component child) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
    }

    private void renderInitDirective(RenderContext rc, AccordionPane accordionPane, String targetId) {
        int activeTabIndex;
        Boolean tabRolloverEnabled;
        Insets tabInsets;
        Color tabForeground;
        Border tabBorder;
        FillImage tabBackgroundImage;
        Color tabBackground;
        Insets defaultContentInsets;
        Color foreground;
        Color background;
        String elementId = ContainerInstance.getElementId(accordionPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "ExtrasAccordionPane.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        if (!accordionPane.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        if ((background = (Color)accordionPane.getRenderProperty("background")) != null) {
            initElement.setAttribute("background", ColorRender.renderCssAttributeValue(background));
        }
        if ((foreground = (Color)accordionPane.getRenderProperty("foreground")) != null) {
            initElement.setAttribute("foreground", ColorRender.renderCssAttributeValue(foreground));
        }
        if ((defaultContentInsets = (Insets)accordionPane.getRenderProperty("defaultContentInsets")) != null) {
            initElement.setAttribute("default-content-insets", InsetsRender.renderCssAttributeValue(defaultContentInsets));
        }
        if ((tabBackground = (Color)accordionPane.getRenderProperty(IMAGE_ID_TAB_BACKGROUND)) != null) {
            initElement.setAttribute("tab-background", ColorRender.renderCssAttributeValue(tabBackground));
        }
        if ((tabBackgroundImage = (FillImage)accordionPane.getRenderProperty("tabBackgroundImage")) != null) {
            CssStyle backgroundImageCssStyle = new CssStyle();
            FillImageRender.renderToStyle(backgroundImageCssStyle, rc, this, accordionPane, IMAGE_ID_TAB_BACKGROUND, tabBackgroundImage, 0);
            initElement.setAttribute("tab-background-image", backgroundImageCssStyle.renderInline());
        }
        if ((tabBorder = (Border)accordionPane.getRenderProperty("tabBorder")) != null) {
            if (tabBorder.getColor() != null) {
                initElement.setAttribute("tab-border-color", ColorRender.renderCssAttributeValue(tabBorder.getColor()));
            }
            if (tabBorder.getSize() != null && tabBorder.getSize().getUnits() == 1) {
                initElement.setAttribute("tab-border-size", Integer.toString(tabBorder.getSize().getValue()));
            }
            initElement.setAttribute("tab-border-style", BorderRender.getStyleValue(tabBorder.getStyle()));
        }
        if ((tabForeground = (Color)accordionPane.getRenderProperty("tabForeground")) != null) {
            initElement.setAttribute("tab-foreground", ColorRender.renderCssAttributeValue(tabForeground));
        }
        if ((tabInsets = (Insets)accordionPane.getRenderProperty("tabInsets")) != null) {
            initElement.setAttribute("tab-insets", InsetsRender.renderCssAttributeValue(tabInsets));
        }
        if ((tabRolloverEnabled = (Boolean)accordionPane.getRenderProperty("tabRolloverEnabled")) == null || tabRolloverEnabled.booleanValue()) {
            Color tabRolloverForeground;
            Border tabRolloverBorder;
            FillImage tabRolloverBackgroundImage;
            initElement.setAttribute("tab-rollover-enabled", "true");
            Color tabRolloverBackground = (Color)accordionPane.getRenderProperty(IMAGE_ID_TAB_ROLLOVER_BACKGROUND);
            if (tabRolloverBackground != null) {
                initElement.setAttribute("tab-rollover-background", ColorRender.renderCssAttributeValue(tabRolloverBackground));
            }
            if ((tabRolloverBackgroundImage = (FillImage)accordionPane.getRenderProperty("tabRolloverBackgroundImage")) != null) {
                CssStyle rolloverBackgroundImageCssStyle = new CssStyle();
                FillImageRender.renderToStyle(rolloverBackgroundImageCssStyle, rc, this, accordionPane, IMAGE_ID_TAB_ROLLOVER_BACKGROUND, tabRolloverBackgroundImage, 0);
                initElement.setAttribute("tab-rollover-background-image", rolloverBackgroundImageCssStyle.renderInline());
            }
            if ((tabRolloverBorder = (Border)accordionPane.getRenderProperty("tabRolloverBorder")) != null) {
                if (tabRolloverBorder.getColor() != null) {
                    initElement.setAttribute("tab-rollover-border-color", ColorRender.renderCssAttributeValue(tabRolloverBorder.getColor()));
                }
                initElement.setAttribute("tab-rollover-border-style", BorderRender.getStyleValue(tabRolloverBorder.getStyle()));
            }
            if ((tabRolloverForeground = (Color)accordionPane.getRenderProperty("tabRolloverForeground")) != null) {
                initElement.setAttribute("tab-rollover-foreground", ColorRender.renderCssAttributeValue(tabRolloverForeground));
            }
        }
        if ((activeTabIndex = accordionPane.getActiveTabIndex()) != -1 && activeTabIndex < accordionPane.getVisibleComponentCount()) {
            initElement.setAttribute("active-tab", accordionPane.getVisibleComponent(activeTabIndex).getRenderId());
        }
        partElement.appendChild(initElement);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        serverMessage.addLibrary(ACCORDION_PANE_SERVICE.getId());
        this.renderDisposeDirective(rc, (AccordionPane)component);
    }

    private void renderDisposeDirective(RenderContext rc, AccordionPane accordionPane) {
        String elementId = ContainerInstance.getElementId(accordionPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "ExtrasAccordionPane.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private void renderRedrawDirective(RenderContext rc, AccordionPane accordionPane) {
        String elementId = ContainerInstance.getElementId(accordionPane);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("update", "ExtrasAccordionPane.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("redraw");
        initElement.setAttribute("eid", elementId);
        partElement.appendChild(initElement);
    }

    private void renderRemoveChildren(RenderContext rc, ServerComponentUpdate update) {
        AccordionPane accordionPane = (AccordionPane)update.getParent();
        Component[] removedChildren = update.getRemovedChildren();
        for (int i = 0; i < removedChildren.length; ++i) {
            this.renderRemoveTabDirective(rc, update, accordionPane, removedChildren[i]);
        }
    }

    private void renderRemoveTabDirective(RenderContext rc, ServerComponentUpdate update, AccordionPane accordionPane, Component child) {
        String elementId = ContainerInstance.getElementId(accordionPane);
        Element removePartElement = rc.getServerMessage().appendPartDirective("remove", "ExtrasAccordionPane.MessageProcessor", "remove-tab");
        removePartElement.setAttribute("eid", elementId);
        removePartElement.setAttribute("tab-id", child.getRenderId());
    }

    private void renderSetActiveTab(RenderContext rc, ServerComponentUpdate update, AccordionPane accordionPane) {
        AccordionPaneRenderState renderState;
        ContainerInstance ci = rc.getContainerInstance();
        boolean activeTabRenderRequired = this.configureActiveTab(ci, accordionPane);
        Component activeTab = null;
        if (activeTabRenderRequired && (activeTab = this.getChildByRenderId(accordionPane, (renderState = (AccordionPaneRenderState)ci.getRenderState(accordionPane)).activeTabId)) != null) {
            this.renderChild(rc, update, accordionPane, activeTab);
        }
        this.renderSetActiveTabDirective(rc, update, accordionPane);
    }

    private void renderSetActiveTabDirective(RenderContext rc, ServerComponentUpdate update, AccordionPane accordionPane) {
        Component activeTab = null;
        AccordionPaneRenderState renderState = (AccordionPaneRenderState)rc.getContainerInstance().getRenderState(accordionPane);
        activeTab = this.getChildByRenderId(accordionPane, renderState.activeTabId);
        if (activeTab == null) {
            return;
        }
        String elementId = ContainerInstance.getElementId(accordionPane);
        Element setActiveTabElement = rc.getServerMessage().appendPartDirective("update", "ExtrasAccordionPane.MessageProcessor", "set-active-tab");
        setActiveTabElement.setAttribute("eid", elementId);
        setActiveTabElement.setAttribute("active-tab", activeTab.getRenderId());
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        ContainerInstance ci = rc.getContainerInstance();
        AccordionPane accordionPane = (AccordionPane)update.getParent();
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            this.renderDisposeDirective(rc, accordionPane);
            DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(accordionPane));
            this.renderAdd(rc, update, targetId, accordionPane);
        } else {
            if (update.hasRemovedChildren() || update.hasAddedChildren()) {
                boolean activeTabRenderRequired = this.configureActiveTab(ci, accordionPane);
                if (update.hasRemovedChildren()) {
                    this.renderRemoveChildren(rc, update);
                }
                if (update.hasAddedChildren() || activeTabRenderRequired) {
                    this.renderAddChildren(rc, update, activeTabRenderRequired);
                }
                this.renderSetActiveTabDirective(rc, update, accordionPane);
                this.renderRedrawDirective(rc, accordionPane);
            }
            if (update.hasUpdatedProperties()) {
                this.partialUpdateManager.process(rc, update);
            }
        }
        return fullReplace;
    }

    private void resetRenderState(ContainerInstance ci, AccordionPane accordionPane) {
        AccordionPaneRenderState renderState = new AccordionPaneRenderState();
        ci.setRenderState(accordionPane, renderState);
    }

    private void setRendered(ContainerInstance ci, AccordionPane accordionPane, Component child) {
        AccordionPaneRenderState renderState = (AccordionPaneRenderState)ci.getRenderState(accordionPane);
        if (renderState == null) {
            renderState = new AccordionPaneRenderState();
            ci.setRenderState(accordionPane, renderState);
        }
        renderState.renderedChildren.add(child);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(ACCORDION_PANE_SERVICE);
    }

    private static class AccordionPaneRenderState
    implements RenderState {
        private String activeTabId;
        private Set renderedChildren = new HashSet();

        private AccordionPaneRenderState() {
        }
    }
}

