/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.FillImageBorder;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Pane;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.extras.app.BorderPane;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.servermessage.VirtualPosition;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BorderPanePeer
implements ComponentSynchronizePeer,
DomUpdateSupport,
ImageRenderSupport {
    public static final String PROPERTY_IE_ALPHA_RENDER_BORDER = "nextapp.echo2.extras.webcontainer.BorderPanePeer.ieAlphaRenderBorder";
    private static final String IMAGE_ID_BORDER_TOP_LEFT = "borderTopLeft";
    private static final String IMAGE_ID_BORDER_TOP = "borderTop";
    private static final String IMAGE_ID_BORDER_TOP_RIGHT = "borderTopRight";
    private static final String IMAGE_ID_BORDER_LEFT = "borderLeft";
    private static final String IMAGE_ID_BORDER_RIGHT = "borderRight";
    private static final String IMAGE_ID_BORDER_BOTTOM_LEFT = "borderBottomLeft";
    private static final String IMAGE_ID_BORDER_BOTTOM = "borderBottom";
    private static final String IMAGE_ID_BORDER_BOTTOM_RIGHT = "borderBottomRight";
    private static final Insets DEFAULT_CONTENT_INSETS = new Insets(3);
    private static final FillImageBorder DEFAULT_BORDER = new FillImageBorder(new Color(127), new Insets(20), DEFAULT_CONTENT_INSETS);

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_content";
    }

    @Override
    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_BORDER_TOP_LEFT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(0);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_TOP.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(1);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_TOP_RIGHT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(2);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_LEFT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(3);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_RIGHT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(4);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_BOTTOM_LEFT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(5);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_BOTTOM.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(6);
            return fillImage == null ? null : fillImage.getImage();
        }
        if (IMAGE_ID_BORDER_BOTTOM_RIGHT.equals(imageId)) {
            FillImageBorder fillImageBorder = (FillImageBorder)component.getRenderProperty("border");
            FillImage fillImage = fillImageBorder == null ? null : fillImageBorder.getFillImage(7);
            return fillImage == null ? null : fillImage.getImage();
        }
        return null;
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd(rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElement, targetId, htmlFragment);
    }

    private void renderBorder(RenderContext rc, Element windowDivElement, BorderPane borderPane) {
        CssStyle borderCssStyle;
        Element borderDivElement;
        int fillImageRenderFlags;
        FillImageBorder border = (FillImageBorder)borderPane.getRenderProperty("border", DEFAULT_BORDER);
        Color borderColor = border.getColor();
        Insets borderInsets = border.getBorderInsets() == null ? new Insets(0) : border.getBorderInsets();
        Document document = rc.getServerMessage().getDocument();
        String elementId = ContainerInstance.getElementId(borderPane);
        ServerMessage serverMessage = rc.getServerMessage();
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkCssPositioningOneSideOnly")) {
            VirtualPosition.renderRegister(serverMessage, elementId + "_border_t");
            VirtualPosition.renderRegister(serverMessage, elementId + "_border_l");
            VirtualPosition.renderRegister(serverMessage, elementId + "_border_r");
            VirtualPosition.renderRegister(serverMessage, elementId + "_border_b");
        }
        int borderTopPixels = ExtentRender.toPixels(borderInsets.getTop(), 0);
        int borderLeftPixels = ExtentRender.toPixels(borderInsets.getLeft(), 0);
        int borderRightPixels = ExtentRender.toPixels(borderInsets.getRight(), 0);
        int borderBottomPixels = ExtentRender.toPixels(borderInsets.getBottom(), 0);
        int n = fillImageRenderFlags = (Boolean)borderPane.getRenderProperty(PROPERTY_IE_ALPHA_RENDER_BORDER, Boolean.FALSE) != false ? 2 : 0;
        if (borderTopPixels > 0) {
            if (borderLeftPixels > 0) {
                borderDivElement = document.createElement("div");
                borderDivElement.setAttribute("id", elementId + "_border_tl");
                borderCssStyle = new CssStyle();
                borderCssStyle.setAttribute("font-size", "1px");
                ColorRender.renderToStyle(borderCssStyle, null, borderColor);
                borderCssStyle.setAttribute("position", "absolute");
                borderCssStyle.setAttribute("top", "0px");
                borderCssStyle.setAttribute("left", "0px");
                borderCssStyle.setAttribute("height", borderTopPixels + "px");
                borderCssStyle.setAttribute("width", borderLeftPixels + "px");
                FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_TOP_LEFT, border.getFillImage(0), fillImageRenderFlags);
                borderDivElement.setAttribute("style", borderCssStyle.renderInline());
                windowDivElement.appendChild(borderDivElement);
            }
            borderDivElement = document.createElement("div");
            borderDivElement.setAttribute("id", elementId + "_border_t");
            borderCssStyle = new CssStyle();
            borderCssStyle.setAttribute("font-size", "1px");
            ColorRender.renderToStyle(borderCssStyle, null, borderColor);
            borderCssStyle.setAttribute("position", "absolute");
            borderCssStyle.setAttribute("top", "0px");
            borderCssStyle.setAttribute("left", borderLeftPixels + "px");
            borderCssStyle.setAttribute("height", borderTopPixels + "px");
            borderCssStyle.setAttribute("right", borderRightPixels + "px");
            FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_TOP, border.getFillImage(1), fillImageRenderFlags);
            borderDivElement.setAttribute("style", borderCssStyle.renderInline());
            windowDivElement.appendChild(borderDivElement);
            if (borderRightPixels > 0) {
                borderDivElement = document.createElement("div");
                borderDivElement.setAttribute("id", elementId + "_border_tr");
                borderCssStyle = new CssStyle();
                borderCssStyle.setAttribute("font-size", "1px");
                ColorRender.renderToStyle(borderCssStyle, null, borderColor);
                borderCssStyle.setAttribute("position", "absolute");
                borderCssStyle.setAttribute("top", "0px");
                borderCssStyle.setAttribute("right", "0px");
                borderCssStyle.setAttribute("height", borderTopPixels + "px");
                borderCssStyle.setAttribute("width", borderRightPixels + "px");
                FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_TOP_RIGHT, border.getFillImage(2), fillImageRenderFlags);
                borderDivElement.setAttribute("style", borderCssStyle.renderInline());
                windowDivElement.appendChild(borderDivElement);
            }
        }
        if (borderLeftPixels > 0) {
            borderDivElement = document.createElement("div");
            borderDivElement.setAttribute("id", elementId + "_border_l");
            borderCssStyle = new CssStyle();
            borderCssStyle.setAttribute("font-size", "1px");
            ColorRender.renderToStyle(borderCssStyle, null, borderColor);
            borderCssStyle.setAttribute("position", "absolute");
            borderCssStyle.setAttribute("top", borderTopPixels + "px");
            borderCssStyle.setAttribute("left", "0px");
            borderCssStyle.setAttribute("width", borderLeftPixels + "px");
            borderCssStyle.setAttribute("bottom", borderBottomPixels + "px");
            FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_LEFT, border.getFillImage(3), fillImageRenderFlags);
            borderDivElement.setAttribute("style", borderCssStyle.renderInline());
            windowDivElement.appendChild(borderDivElement);
        }
        if (borderRightPixels > 0) {
            borderDivElement = document.createElement("div");
            borderDivElement.setAttribute("id", elementId + "_border_r");
            borderCssStyle = new CssStyle();
            borderCssStyle.setAttribute("font-size", "1px");
            ColorRender.renderToStyle(borderCssStyle, null, borderColor);
            borderCssStyle.setAttribute("position", "absolute");
            borderCssStyle.setAttribute("top", borderTopPixels + "px");
            borderCssStyle.setAttribute("right", "0px");
            borderCssStyle.setAttribute("width", borderRightPixels + "px");
            borderCssStyle.setAttribute("bottom", borderBottomPixels + "px");
            FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_RIGHT, border.getFillImage(4), fillImageRenderFlags);
            borderDivElement.setAttribute("style", borderCssStyle.renderInline());
            windowDivElement.appendChild(borderDivElement);
        }
        if (borderBottomPixels > 0) {
            if (borderLeftPixels > 0) {
                borderDivElement = document.createElement("div");
                borderDivElement.setAttribute("id", elementId + "_border_bl");
                borderCssStyle = new CssStyle();
                borderCssStyle.setAttribute("font-size", "1px");
                ColorRender.renderToStyle(borderCssStyle, null, borderColor);
                borderCssStyle.setAttribute("position", "absolute");
                borderCssStyle.setAttribute("bottom", "0px");
                borderCssStyle.setAttribute("left", "0px");
                borderCssStyle.setAttribute("height", borderBottomPixels + "px");
                borderCssStyle.setAttribute("width", borderLeftPixels + "px");
                FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_BOTTOM_LEFT, border.getFillImage(5), fillImageRenderFlags);
                borderDivElement.setAttribute("style", borderCssStyle.renderInline());
                windowDivElement.appendChild(borderDivElement);
            }
            borderDivElement = document.createElement("div");
            borderDivElement.setAttribute("id", elementId + "_border_b");
            borderCssStyle = new CssStyle();
            borderCssStyle.setAttribute("font-size", "1px");
            ColorRender.renderToStyle(borderCssStyle, null, borderColor);
            borderCssStyle.setAttribute("position", "absolute");
            borderCssStyle.setAttribute("bottom", "0px");
            borderCssStyle.setAttribute("left", borderLeftPixels + "px");
            borderCssStyle.setAttribute("height", borderBottomPixels + "px");
            borderCssStyle.setAttribute("right", borderRightPixels + "px");
            FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_BOTTOM, border.getFillImage(6), fillImageRenderFlags);
            borderDivElement.setAttribute("style", borderCssStyle.renderInline());
            windowDivElement.appendChild(borderDivElement);
            if (borderRightPixels > 0) {
                borderDivElement = document.createElement("div");
                borderDivElement.setAttribute("id", elementId + "_border_br");
                borderCssStyle = new CssStyle();
                borderCssStyle.setAttribute("font-size", "1px");
                ColorRender.renderToStyle(borderCssStyle, null, borderColor);
                borderCssStyle.setAttribute("position", "absolute");
                borderCssStyle.setAttribute("bottom", "0px");
                borderCssStyle.setAttribute("right", "0px");
                borderCssStyle.setAttribute("height", borderBottomPixels + "px");
                borderCssStyle.setAttribute("width", borderRightPixels + "px");
                FillImageRender.renderToStyle(borderCssStyle, rc, this, borderPane, IMAGE_ID_BORDER_BOTTOM_RIGHT, border.getFillImage(7), fillImageRenderFlags);
                borderDivElement.setAttribute("style", borderCssStyle.renderInline());
                windowDivElement.appendChild(borderDivElement);
            }
        }
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
    }

    @Override
    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        BorderPane borderPane = (BorderPane)component;
        String elementId = ContainerInstance.getElementId(borderPane);
        String bodyElementId = elementId + "_body";
        Component child = null;
        if (borderPane.getComponentCount() != 0) {
            child = borderPane.getComponent(0);
        }
        ServerMessage serverMessage = rc.getServerMessage();
        Document document = serverMessage.getDocument();
        Element borderPaneDivElement = document.createElement("div");
        borderPaneDivElement.setAttribute("id", elementId);
        CssStyle borderPaneDivCssStyle = new CssStyle();
        borderPaneDivCssStyle.setAttribute("padding", "0px");
        borderPaneDivCssStyle.setAttribute("overflow", "hidden");
        borderPaneDivCssStyle.setAttribute("position", "absolute");
        borderPaneDivCssStyle.setAttribute("top", "0px");
        borderPaneDivCssStyle.setAttribute("left", "0px");
        borderPaneDivCssStyle.setAttribute("width", "100%");
        borderPaneDivCssStyle.setAttribute("height", "100%");
        borderPaneDivElement.setAttribute("style", borderPaneDivCssStyle.renderInline());
        parentNode.appendChild(borderPaneDivElement);
        this.renderBorder(rc, borderPaneDivElement, borderPane);
        Element borderPaneBodyDivElement = document.createElement("div");
        borderPaneBodyDivElement.setAttribute("id", bodyElementId);
        CssStyle windowBodyDivCssStyle = new CssStyle();
        ColorRender.renderToStyle(windowBodyDivCssStyle, (Color)borderPane.getRenderProperty("foreground"), (Color)borderPane.getRenderProperty("background"));
        FontRender.renderToStyle(windowBodyDivCssStyle, (Font)borderPane.getRenderProperty("font"));
        if (windowBodyDivCssStyle.getAttribute("background-color") == null) {
            windowBodyDivCssStyle.setAttribute("background-color", "white");
        }
        windowBodyDivCssStyle.setAttribute("position", "absolute");
        windowBodyDivCssStyle.setAttribute("overflow", "auto");
        windowBodyDivCssStyle.setAttribute("z-index", "2");
        FillImageBorder border = (FillImageBorder)borderPane.getRenderProperty("border", DEFAULT_BORDER);
        Insets contentInsets = border.getContentInsets() == null ? new Insets(0) : border.getContentInsets();
        int left = ExtentRender.toPixels(contentInsets.getLeft(), 0);
        int right = ExtentRender.toPixels(contentInsets.getRight(), 0);
        int top = ExtentRender.toPixels(contentInsets.getTop(), 0);
        int bottom = ExtentRender.toPixels(contentInsets.getBottom(), 0);
        windowBodyDivCssStyle.setAttribute("top", top + "px");
        windowBodyDivCssStyle.setAttribute("left", left + "px");
        windowBodyDivCssStyle.setAttribute("bottom", bottom + "px");
        windowBodyDivCssStyle.setAttribute("right", right + "px");
        borderPaneBodyDivElement.setAttribute("style", windowBodyDivCssStyle.renderInline());
        borderPaneDivElement.appendChild(borderPaneBodyDivElement);
        VirtualPosition.renderRegister(serverMessage, bodyElementId);
        Element contentDivElement = document.createElement("div");
        contentDivElement.setAttribute("id", elementId + "_content");
        CssStyle contentDivCssStyle = new CssStyle();
        if (child instanceof Pane) {
            contentDivCssStyle.setAttribute("position", "absolute");
            contentDivCssStyle.setAttribute("width", "100%");
            contentDivCssStyle.setAttribute("height", "100%");
        } else {
            InsetsRender.renderToStyle(contentDivCssStyle, "padding", (Insets)borderPane.getRenderProperty("insets"));
        }
        contentDivElement.setAttribute("style", contentDivCssStyle.renderInline());
        borderPaneBodyDivElement.appendChild(contentDivElement);
        if (child != null) {
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
            if (syncPeer instanceof DomUpdateSupport) {
                ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, contentDivElement, child);
            } else {
                syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
            }
        }
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
        this.renderAdd(rc, update, targetId, update.getParent());
        return true;
    }
}

