/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.app.util.DomUtil;
import nextapp.echo2.extras.app.ColorSelect;
import nextapp.echo2.extras.webcontainer.ExtrasUtil;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.ServiceRegistry;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.service.StaticBinaryService;
import org.w3c.dom.Element;

public class ColorSelectPeer
implements ComponentSynchronizePeer,
PropertyUpdateProcessor {
    public static final Service COLOR_SELECT_SERVICE = JavaScriptService.forResource("Echo2Extras.ColorSelect", "/nextapp/echo2/extras/webcontainer/resource/js/ColorSelect.js");
    private static final Service ARROW_DOWN_IMAGE_SERVICE = StaticBinaryService.forResource("Echo2Extras.ColorSelect.ArrowDown", "image/gif", "/nextapp/echo2/extras/webcontainer/resource/image/ColorSelectArrowDown.gif");
    private static final Service ARROW_LEFT_IMAGE_SERVICE = StaticBinaryService.forResource("Echo2Extras.ColorSelect.ArrowLeft", "image/gif", "/nextapp/echo2/extras/webcontainer/resource/image/ColorSelectArrowLeft.gif");
    private static final Service ARROW_RIGHT_IMAGE_SERVICE = StaticBinaryService.forResource("Echo2Extras.ColorSelect.ArrowRight", "image/gif", "/nextapp/echo2/extras/webcontainer/resource/image/ColorSelectArrowRight.gif");
    private static final Service ARROW_UP_IMAGE_SERVICE = StaticBinaryService.forResource("Echo2Extras.ColorSelect.ArrowUp", "image/gif", "/nextapp/echo2/extras/webcontainer/resource/image/ColorSelectArrowUp.gif");
    private static final Service H_GRADIENT_IMAGE_SERVICE = StaticBinaryService.forResource("Echo2Extras.ColorSelect.HGradient", "image/png", "/nextapp/echo2/extras/webcontainer/resource/image/ColorSelectHGradient.png");
    private static final Service SV_GRADIENT_IMAGE_SERVICE = StaticBinaryService.forResource("Echo2Extras.ColorSelect.SVGradient", "image/png", "/nextapp/echo2/extras/webcontainer/resource/image/ColorSelectSVGradient.png");
    private PartialUpdateManager partialUpdateManager;
    private PartialUpdateParticipant setColorUpdateParticipant = new PartialUpdateParticipant(){

        @Override
        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            ColorSelectPeer.this.renderSetColorDirective(rc, (ColorSelect)update.getParent());
        }

        @Override
        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }
    };

    public ColorSelectPeer() {
        this.partialUpdateManager = new PartialUpdateManager();
        this.partialUpdateManager.add("color", this.setColorUpdateParticipant);
    }

    @Override
    public String getContainerId(Component component) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(COLOR_SELECT_SERVICE.getId());
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        this.renderInitDirective(rc, targetId, (ColorSelect)component);
        this.renderSetColorDirective(rc, (ColorSelect)component);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(COLOR_SELECT_SERVICE.getId());
        serverMessage.addLibrary(ExtrasUtil.JS_EXTRAS_UTIL_SERVICE.getId());
        this.renderDisposeDirective(rc, (ColorSelect)component);
    }

    private void renderDisposeDirective(RenderContext rc, ColorSelect colorSelect) {
        String elementId = ContainerInstance.getElementId(colorSelect);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "ExtrasColorSelect.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private void renderInitDirective(RenderContext rc, String containerId, ColorSelect colorSelect) {
        Extent valueWidth;
        Extent saturationHeight;
        Extent hueWidth;
        Boolean displayValue;
        String elementId = ContainerInstance.getElementId(colorSelect);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("update", "ExtrasColorSelect.MessageProcessor", "init");
        initElement.setAttribute("eid", elementId);
        initElement.setAttribute("container-eid", containerId);
        if (!colorSelect.isRenderEnabled()) {
            initElement.setAttribute("enabled", "false");
        }
        if ((displayValue = (Boolean)colorSelect.getRenderProperty("displayValue")) != null && !displayValue.booleanValue()) {
            initElement.setAttribute("display-value", "false");
        }
        if ((hueWidth = (Extent)colorSelect.getRenderProperty("hueWidth")) != null) {
            initElement.setAttribute("hue-width", ExtentRender.renderCssAttributeValue(hueWidth));
        }
        if ((saturationHeight = (Extent)colorSelect.getRenderProperty("saturationHeight")) != null) {
            initElement.setAttribute("saturation-height", ExtentRender.renderCssAttributeValue(saturationHeight));
        }
        if ((valueWidth = (Extent)colorSelect.getRenderProperty("valueWidth")) != null) {
            initElement.setAttribute("value-width", ExtentRender.renderCssAttributeValue(valueWidth));
        }
    }

    private void renderSetColorDirective(RenderContext rc, ColorSelect colorSelect) {
        String elementId = ContainerInstance.getElementId(colorSelect);
        ServerMessage serverMessage = rc.getServerMessage();
        Element setColorElement = serverMessage.appendPartDirective("update", "ExtrasColorSelect.MessageProcessor", "set-color");
        setColorElement.setAttribute("eid", elementId);
        Color color = colorSelect.getColor();
        if (color != null) {
            setColorElement.setAttribute("r", Integer.toString(color.getRed()));
            setColorElement.setAttribute("g", Integer.toString(color.getGreen()));
            setColorElement.setAttribute("b", Integer.toString(color.getBlue()));
        }
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element element) {
        Element selectionElement = DomUtil.getChildElementByTagName(element, "color");
        int r = Integer.parseInt(selectionElement.getAttribute("r"));
        int g = Integer.parseInt(selectionElement.getAttribute("g"));
        int b = Integer.parseInt(selectionElement.getAttribute("b"));
        ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "color", new Color(r, g, b));
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        if (this.partialUpdateManager.canProcess(rc, update)) {
            this.partialUpdateManager.process(rc, update);
        } else {
            DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        }
        return true;
    }

    static {
        ServiceRegistry services = WebRenderServlet.getServiceRegistry();
        services.add(COLOR_SELECT_SERVICE);
        services.add(ARROW_DOWN_IMAGE_SERVICE);
        services.add(ARROW_LEFT_IMAGE_SERVICE);
        services.add(ARROW_RIGHT_IMAGE_SERVICE);
        services.add(ARROW_UP_IMAGE_SERVICE);
        services.add(H_GRADIENT_IMAGE_SERVICE);
        services.add(SV_GRADIENT_IMAGE_SERVICE);
    }
}

