/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.extras.webcontainer;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.extras.app.DragSource;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DragSourcePeer
implements ActionProcessor,
ComponentSynchronizePeer,
DomUpdateSupport {
    public static final Service DRAG_SOURCE_SERVICE = JavaScriptService.forResource("Echo2Extras.DND", "/nextapp/echo2/extras/webcontainer/resource/js/DND.js");

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_dnd_" + ContainerInstance.getElementId(child);
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        Component target = ci.getComponentByElementId(actionElement.getAttribute("value"));
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "ACTION_INPUT_DROP", target);
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd(rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElement, targetId, htmlFragment);
    }

    private void renderInitDirective(RenderContext rc, DragSource dragSource) {
        String elementId = ContainerInstance.getElementId(dragSource);
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.addPart("postupdate", "ExtrasDragSource.MessageProcessor");
        Element initElement = serverMessage.getDocument().createElement("init");
        initElement.setAttribute("eid", elementId);
        if (dragSource.getRenderProperty("toolTipText") != null) {
            initElement.setAttribute("tooltip", (String)dragSource.getRenderProperty("toolTipText"));
        }
        for (int i = 0; i < dragSource.getDropTargetCount(); ++i) {
            Component dropTarget = dragSource.getDropTargetAt(i);
            String targetId = ContainerInstance.getElementId(dropTarget);
            Element dropTargetElement = serverMessage.getDocument().createElement("drop-target");
            dropTargetElement.setAttribute("eid", targetId);
            initElement.appendChild(dropTargetElement);
        }
        partElement.appendChild(initElement);
    }

    private void renderAddChild(RenderContext rc, ServerComponentUpdate update, Element parentElement, Component child) {
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, parentElement, child);
        } else {
            syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
        }
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(DRAG_SOURCE_SERVICE.getId());
        this.renderDisposeDirective(rc, (DragSource)component);
    }

    private void renderDisposeDirective(RenderContext rc, DragSource dragSource) {
        String elementId = ContainerInstance.getElementId(dragSource);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "ExtrasDragSource.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    @Override
    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        rc.getServerMessage().addLibrary(DRAG_SOURCE_SERVICE.getId());
        DragSource dragSource = (DragSource)component;
        this.renderInitDirective(rc, dragSource);
        String elementId = ContainerInstance.getElementId(dragSource);
        Document document = parentNode.getOwnerDocument();
        Element divElement = document.createElement("div");
        divElement.setAttribute("id", elementId);
        parentNode.appendChild(divElement);
        this.renderAddChild(rc, update, divElement, dragSource.getComponent(0));
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(update.getParent()));
        this.renderAdd(rc, update, targetId, update.getParent());
        return true;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(DRAG_SOURCE_SERVICE);
    }
}

