/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.propertyrender;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;

public class CellLayoutDataRender {
    private static String IMAGE_ID_PREFIX_LAYOUT_DATA_BACKGROUND_IMAGE = "CellLayoutData.BackgroundImage.";
    private static int IMAGE_ID_PREFIX_LAYOUT_DATA_BACKGROUND_IMAGE_LENGTH = IMAGE_ID_PREFIX_LAYOUT_DATA_BACKGROUND_IMAGE.length();

    public static ImageReference getCellLayoutDataBackgroundImage(Component component, String imageId) {
        if (imageId.startsWith(IMAGE_ID_PREFIX_LAYOUT_DATA_BACKGROUND_IMAGE)) {
            String childRenderId = imageId.substring(IMAGE_ID_PREFIX_LAYOUT_DATA_BACKGROUND_IMAGE_LENGTH);
            int childCount = component.getComponentCount();
            for (int i = 0; i < childCount; ++i) {
                Component child = component.getComponent(i);
                if (!child.getRenderId().equals(childRenderId)) continue;
                return ((CellLayoutData)child.getRenderProperty("layoutData")).getBackgroundImage().getImage();
            }
        }
        return null;
    }

    public static void renderBackgroundImageToStyle(CssStyle cssStyle, RenderContext rc, ImageRenderSupport irs, Component parent, Component child) {
        CellLayoutData layoutData = (CellLayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null || layoutData.getBackgroundImage() == null) {
            return;
        }
        FillImageRender.renderToStyle(cssStyle, rc, irs, parent, IMAGE_ID_PREFIX_LAYOUT_DATA_BACKGROUND_IMAGE + child.getRenderId(), layoutData.getBackgroundImage(), 0);
    }

    public static void renderToElementAndStyle(Element element, CssStyle cssStyle, Component component, CellLayoutData layoutData, String defaultInsetsAttributeValue) {
        if (layoutData == null) {
            if (defaultInsetsAttributeValue != null) {
                cssStyle.setAttribute("padding", defaultInsetsAttributeValue);
            }
            return;
        }
        Insets cellInsets = layoutData.getInsets();
        if (cellInsets == null) {
            if (defaultInsetsAttributeValue != null) {
                cssStyle.setAttribute("padding", defaultInsetsAttributeValue);
            }
        } else {
            cssStyle.setAttribute("padding", InsetsRender.renderCssAttributeValue(cellInsets));
        }
        ColorRender.renderToStyle(cssStyle, null, layoutData.getBackground());
        AlignmentRender.renderToElement(element, layoutData.getAlignment(), component);
    }

    public static void renderToStyle(CssStyle cssStyle, Component component, CellLayoutData layoutData, String defaultInsetsAttributeValue) {
        if (layoutData == null) {
            if (defaultInsetsAttributeValue != null) {
                cssStyle.setAttribute("padding", defaultInsetsAttributeValue);
            }
            return;
        }
        Insets cellInsets = layoutData.getInsets();
        if (cellInsets == null) {
            if (defaultInsetsAttributeValue != null) {
                cssStyle.setAttribute("padding", defaultInsetsAttributeValue);
            }
        } else {
            cssStyle.setAttribute("padding", InsetsRender.renderCssAttributeValue(cellInsets));
        }
        ColorRender.renderToStyle(cssStyle, null, layoutData.getBackground());
        AlignmentRender.renderToStyle(cssStyle, layoutData.getAlignment(), component);
    }

    private CellLayoutDataRender() {
    }
}

