/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Panel;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompositePeer
implements ComponentSynchronizePeer,
DomUpdateSupport {
    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent());
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd(rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddElement, targetId, htmlFragment);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
    }

    @Override
    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        Component child;
        ComponentSynchronizePeer syncPeer;
        Document document = parentNode.getOwnerDocument();
        Element divElement = document.createElement("div");
        divElement.setAttribute("id", ContainerInstance.getElementId(component));
        parentNode.appendChild(divElement);
        if (component.getVisibleComponentCount() == 0) {
            return;
        }
        CssStyle cssStyle = new CssStyle();
        ColorRender.renderToStyle(cssStyle, component);
        FontRender.renderToStyle(cssStyle, component);
        if (component instanceof Panel) {
            BorderRender.renderToStyle(cssStyle, (Border)component.getRenderProperty("border"));
            InsetsRender.renderToStyle(cssStyle, "padding", (Insets)component.getRenderProperty("insets"));
        }
        if (cssStyle.hasAttributes()) {
            divElement.setAttribute("style", cssStyle.renderInline());
        }
        if ((syncPeer = SynchronizePeerFactory.getPeerForComponent((child = component.getVisibleComponent(0)).getClass())) instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, divElement, child);
        } else {
            syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
        }
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        String parentId = ContainerInstance.getElementId(update.getParent());
        DomUpdate.renderElementRemove(rc.getServerMessage(), parentId);
        this.renderAdd(rc, update, targetId, update.getParent());
        return true;
    }
}

