/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.list.ListSelectionModel;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.CellLayoutDataRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TablePeer
implements ActionProcessor,
ComponentSynchronizePeer,
ImageRenderSupport,
PropertyUpdateProcessor {
    private static final String SIZING_DOTS = ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ";
    private static final String[] TABLE_INIT_KEYS = new String[]{"rollover-style", "selection-style"};
    private static final String PROPERTY_SELECTION = "selection";
    private static final String IMAGE_ID_ROLLOVER_BACKGROUND = "rolloverBackground";
    private static final String IMAGE_ID_SELECTION_BACKGROUND = "selectionBackground";
    private static final Service TABLE_SERVICE = JavaScriptService.forResource("Echo.Table", "/nextapp/echo2/webcontainer/resource/js/Table.js");
    protected PartialUpdateManager propertyRenderRegistry;

    @Override
    public String getContainerId(Component child) {
        return ContainerInstance.getElementId(child.getParent()) + "_cell_" + child.getRenderId();
    }

    @Override
    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_ROLLOVER_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("rolloverBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        if (IMAGE_ID_SELECTION_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("selectionBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        return CellLayoutDataRender.getCellLayoutDataBackgroundImage(component, imageId);
    }

    private TableLayoutData getLayoutData(Component child) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof TableLayoutData) {
            return (TableLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Table Child: " + layoutData.getClass().getName());
    }

    @Override
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "action", null);
    }

    @Override
    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if (PROPERTY_SELECTION.equals(propertyName)) {
            Element[] optionElements = DomUtil.getChildElementsByTagName(propertyElement, "row");
            int[] selectedIndices = new int[optionElements.length];
            for (int i = 0; i < optionElements.length; ++i) {
                selectedIndices[i] = Integer.parseInt(optionElements[i].getAttribute("index"));
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, PROPERTY_SELECTION, selectedIndices);
        }
    }

    @Override
    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Table table = (Table)component;
        Border border = (Border)table.getRenderProperty("border");
        Insets tableInsets = (Insets)table.getRenderProperty("insets");
        String defaultInsetsAttributeValue = tableInsets == null ? "0px" : InsetsRender.renderCssAttributeValue(tableInsets);
        CssStyle styleCss = new CssStyle();
        styleCss.setAttribute("padding", defaultInsetsAttributeValue);
        BorderRender.renderToStyle(styleCss, border);
        DomUpdate.renderStyleSheetAddRule(rc.getServerMessage(), "TD.c-" + component.getRenderId(), styleCss.renderInline());
        Element domAddTableElement = DomUpdate.renderElementAdd(rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent(rc.getServerMessage(), domAddTableElement, targetId, htmlFragment);
    }

    private void renderAddChild(RenderContext rc, ServerComponentUpdate update, Element parentElement, Component child) {
        if (!child.isVisible()) {
            return;
        }
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)((Object)syncPeer)).renderHtml(rc, update, parentElement, child);
        } else {
            syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
        }
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(TABLE_SERVICE.getId());
        this.renderDisposeDirective(rc, (Table)component);
    }

    private void renderDisposeDirective(RenderContext rc, Table table) {
        DomUpdate.renderStyleSheetRemoveRule(rc.getServerMessage(), "TD.c-" + table.getRenderId());
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EchoTable.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId(table));
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        Insets tableInsets;
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(TABLE_SERVICE.getId());
        Table table = (Table)component;
        this.renderInitDirective(rc, table);
        Border border = (Border)table.getRenderProperty("border");
        Extent borderSize = border == null ? null : border.getSize();
        String elementId = ContainerInstance.getElementId(table);
        Document document = parentNode.getOwnerDocument();
        Element tableElement = document.createElement("table");
        tableElement.setAttribute("id", elementId);
        CssStyle tableCssStyle = new CssStyle();
        tableCssStyle.setAttribute("border-collapse", "collapse");
        if (((Boolean)table.getRenderProperty("selectionEnabled", Boolean.FALSE)).booleanValue()) {
            tableCssStyle.setAttribute("cursor", "pointer");
        }
        String defaultInsetsAttributeValue = (tableInsets = (Insets)table.getRenderProperty("insets")) == null ? "0px" : InsetsRender.renderCssAttributeValue(tableInsets);
        ColorRender.renderToStyle(tableCssStyle, component);
        FontRender.renderToStyle(tableCssStyle, component);
        BorderRender.renderToStyle(tableCssStyle, border);
        if (borderSize != null && !rc.getContainerInstance().getClientProperties().getBoolean("quirkCssBorderCollapseInside")) {
            tableCssStyle.setAttribute("margin", ExtentRender.renderCssAttributeValueHalf(borderSize));
        }
        Extent width = (Extent)table.getRenderProperty("width");
        boolean render100PercentWidthWorkaround = false;
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIETablePercentWidthScrollbarError") && width != null && width.getUnits() == 2 && width.getValue() == 100) {
            width = null;
            render100PercentWidthWorkaround = true;
        }
        ExtentRender.renderToStyle(tableCssStyle, "width", width);
        tableElement.setAttribute("style", tableCssStyle.renderInline());
        parentNode.appendChild(tableElement);
        TableColumnModel columnModel = table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        boolean someColumnsHaveWidths = false;
        for (int i = 0; i < columnCount; ++i) {
            if (columnModel.getColumn(i).getWidth() == null) continue;
            someColumnsHaveWidths = true;
        }
        if (someColumnsHaveWidths) {
            Element colGroupElement = document.createElement("colgroup");
            tableElement.appendChild(colGroupElement);
            for (int i = 0; i < columnCount; ++i) {
                Element colElement = document.createElement("col");
                Extent columnWidth = columnModel.getColumn(i).getWidth();
                if (columnWidth != null) {
                    colElement.setAttribute("width", ExtentRender.renderCssAttributeValue(columnWidth));
                }
                colGroupElement.appendChild(colElement);
            }
        }
        Element tbodyElement = document.createElement("tbody");
        tbodyElement.setAttribute("id", elementId + "_tbody");
        tableElement.appendChild(tbodyElement);
        Element firstTrElement = null;
        if (table.isHeaderVisible()) {
            firstTrElement = this.renderRow(rc, update, tbodyElement, table, -1, defaultInsetsAttributeValue);
        }
        int rows = table.getModel().getRowCount();
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            if (firstTrElement == null && rowIndex == 0) {
                firstTrElement = this.renderRow(rc, update, tbodyElement, table, rowIndex, defaultInsetsAttributeValue);
                continue;
            }
            this.renderRow(rc, update, tbodyElement, table, rowIndex, defaultInsetsAttributeValue);
        }
        if (render100PercentWidthWorkaround && firstTrElement != null) {
            NodeList childNodes = firstTrElement.getChildNodes();
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                if (!"td".equals(childNodes.item(i).getNodeName())) continue;
                Element tdElement = (Element)childNodes.item(i);
                Element sizingDivElement = document.createElement("div");
                sizingDivElement.setAttribute("style", "font-size:50px;height:0px;overflow:hidden;");
                sizingDivElement.appendChild(document.createTextNode(SIZING_DOTS));
                tdElement.appendChild(sizingDivElement);
            }
        }
    }

    private void renderInitDirective(RenderContext rc, Table table) {
        String elementId = ContainerInstance.getElementId(table);
        ServerMessage serverMessage = rc.getServerMessage();
        Document document = serverMessage.getDocument();
        boolean rolloverEnabled = (Boolean)table.getRenderProperty("rolloverEnabled", Boolean.FALSE);
        boolean selectionEnabled = (Boolean)table.getRenderProperty("selectionEnabled", Boolean.FALSE);
        String rolloverStyle = "";
        if (rolloverEnabled) {
            CssStyle rolloverCssStyle = new CssStyle();
            ColorRender.renderToStyle(rolloverCssStyle, (Color)table.getRenderProperty("rolloverForeground"), (Color)table.getRenderProperty(IMAGE_ID_ROLLOVER_BACKGROUND));
            FontRender.renderToStyle(rolloverCssStyle, (Font)table.getRenderProperty("rolloverFont"));
            FillImageRender.renderToStyle(rolloverCssStyle, rc, this, table, IMAGE_ID_ROLLOVER_BACKGROUND, (FillImage)table.getRenderProperty("rolloverBackgroundImage"), 1);
            if (rolloverCssStyle.hasAttributes()) {
                rolloverStyle = rolloverCssStyle.renderInline();
            }
        }
        String selectionStyle = "";
        if (selectionEnabled) {
            CssStyle selectionCssStyle = new CssStyle();
            ColorRender.renderToStyle(selectionCssStyle, (Color)table.getRenderProperty("selectionForeground"), (Color)table.getRenderProperty(IMAGE_ID_SELECTION_BACKGROUND));
            FontRender.renderToStyle(selectionCssStyle, (Font)table.getRenderProperty("selectionFont"));
            FillImageRender.renderToStyle(selectionCssStyle, rc, this, table, IMAGE_ID_SELECTION_BACKGROUND, (FillImage)table.getRenderProperty("selectionBackgroundImage"), 1);
            if (selectionCssStyle.hasAttributes()) {
                selectionStyle = selectionCssStyle.renderInline();
            }
        }
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EchoTable.MessageProcessor", "init", TABLE_INIT_KEYS, new String[]{rolloverStyle, selectionStyle});
        Element itemElement = document.createElement("item");
        itemElement.setAttribute("eid", elementId);
        if (table.isHeaderVisible()) {
            itemElement.setAttribute("header-visible", "true");
        }
        if (table.hasActionListeners()) {
            itemElement.setAttribute("server-notify", "true");
        }
        if (rolloverEnabled) {
            itemElement.setAttribute("rollover-enabled", "true");
        }
        if (selectionEnabled) {
            itemElement.setAttribute("selection-enabled", "true");
            ListSelectionModel selectionModel = table.getSelectionModel();
            if (selectionModel.getSelectionMode() == 2) {
                itemElement.setAttribute("selection-mode", "multiple");
            }
            if (selectionModel.getMinSelectedIndex() != -1) {
                Element selectionElement = document.createElement(PROPERTY_SELECTION);
                int minimumIndex = selectionModel.getMinSelectedIndex();
                int maximumIndex = selectionModel.getMaxSelectedIndex();
                if (maximumIndex > table.getModel().getRowCount() - 1) {
                    maximumIndex = table.getModel().getRowCount() - 1;
                }
                for (int i = minimumIndex; i <= maximumIndex; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    Element rowElement = document.createElement("row");
                    rowElement.setAttribute("index", Integer.toString(i));
                    selectionElement.appendChild(rowElement);
                }
                itemElement.appendChild(selectionElement);
            }
        }
        if (!table.isRenderEnabled()) {
            itemElement.setAttribute("enabled", "false");
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    private Element renderRow(RenderContext rc, ServerComponentUpdate update, Element tbodyElement, Table table, int rowIndex, String defaultInsetsAttributeValue) {
        Document document = tbodyElement.getOwnerDocument();
        String elementId = ContainerInstance.getElementId(table);
        Element trElement = document.createElement("tr");
        if (rowIndex == -1) {
            trElement.setAttribute("id", elementId + "_tr_header");
        } else {
            trElement.setAttribute("id", elementId + "_tr_" + rowIndex);
        }
        tbodyElement.appendChild(trElement);
        String className = "c-" + table.getRenderId();
        boolean inlineStyleRequired = rc.getContainerInstance().getClientProperties().getBoolean("notSupportedCssManipulation");
        Border border = null;
        if (inlineStyleRequired) {
            border = (Border)table.getRenderProperty("border");
        }
        int columns = table.getColumnModel().getColumnCount();
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            Component childComponent = table.getCellComponent(columnIndex, rowIndex);
            Element tdElement = document.createElement("td");
            tdElement.setAttribute("id", elementId + "_cell_" + childComponent.getRenderId());
            CssStyle tdCssStyle = new CssStyle();
            if (inlineStyleRequired) {
                BorderRender.renderToStyle(tdCssStyle, border);
                CellLayoutDataRender.renderToElementAndStyle(tdElement, tdCssStyle, childComponent, this.getLayoutData(childComponent), defaultInsetsAttributeValue);
            } else {
                tdElement.setAttribute("class", className);
                CellLayoutDataRender.renderToElementAndStyle(tdElement, tdCssStyle, childComponent, this.getLayoutData(childComponent), null);
            }
            CellLayoutDataRender.renderBackgroundImageToStyle(tdCssStyle, rc, this, table, childComponent);
            if (tdCssStyle.hasAttributes()) {
                tdElement.setAttribute("style", tdCssStyle.renderInline());
            }
            trElement.appendChild(tdElement);
            this.renderAddChild(rc, update, tdElement, childComponent);
        }
        return trElement;
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        Table table = (Table)update.getParent();
        this.renderDisposeDirective(rc, table);
        DomUpdate.renderElementRemove(rc.getServerMessage(), ContainerInstance.getElementId(table));
        this.renderAdd(rc, update, targetId, table);
        return true;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TABLE_SERVICE);
    }
}

