/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webcontainer.syncpeer;

import nextapp.echo2.app.Extent;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.StaticBinaryService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class TriCellTable {
    private static final Service TRANSPARENT_SPACER_IMAGE_SERVICE = StaticBinaryService.forResource("Echo.TriCellTable.TransparentImage", "image/gif", "/nextapp/echo2/webcontainer/resource/image/Transparent.gif");
    static final int INVERTED = 1;
    static final int VERTICAL = 2;
    public static final int LEADING_TRAILING = 0;
    public static final int TRAILING_LEADING = 1;
    public static final int TOP_BOTTOM = 2;
    public static final int BOTTOM_TOP = 3;
    private Element[] tdElements;
    private Element[] marginTdElements = null;
    private Element tableElement;
    private Element tbodyElement;
    private Document document;
    private RenderContext rc;

    private TriCellTable(RenderContext rc, Document document, String id) {
        this.rc = rc;
        this.document = document;
        this.tableElement = document.createElement("table");
        this.tbodyElement = document.createElement("tbody");
        this.tbodyElement.setAttribute("id", id + "_tbody");
        this.tableElement.appendChild(this.tbodyElement);
    }

    TriCellTable(RenderContext rc, Document document, String id, int orientation0_1, Extent margin0_1) {
        this(rc, document, id);
        this.marginTdElements = new Element[1];
        this.tdElements = new Element[2];
        this.tdElements[0] = document.createElement("td");
        this.tdElements[0].setAttribute("id", id + "_td_0");
        this.tdElements[1] = document.createElement("td");
        this.tdElements[1].setAttribute("id", id + "_td_1");
        if (margin0_1 != null && margin0_1.getValue() > 0) {
            this.marginTdElements[0] = document.createElement("td");
            this.marginTdElements[0].setAttribute("id", id + "_tdmargin_0_1");
            int size = ExtentRender.toPixels(margin0_1, 1);
            if ((orientation0_1 & 2) == 0) {
                this.marginTdElements[0].setAttribute("style", "width:" + size + "px;");
                this.addSpacer(this.marginTdElements[0], size, false);
            } else {
                this.marginTdElements[0].setAttribute("style", "height:" + size + "px;");
                this.addSpacer(this.marginTdElements[0], size, true);
            }
        }
        if ((orientation0_1 & 2) == 0) {
            Element trElement = document.createElement("tr");
            trElement.setAttribute("id", id + "_tr_0_1");
            if ((orientation0_1 & 1) == 0) {
                this.addColumn(trElement, this.tdElements[0]);
                this.addColumn(trElement, this.marginTdElements[0]);
                this.addColumn(trElement, this.tdElements[1]);
            } else {
                this.addColumn(trElement, this.tdElements[1]);
                this.addColumn(trElement, this.marginTdElements[0]);
                this.addColumn(trElement, this.tdElements[0]);
            }
            this.tbodyElement.appendChild(trElement);
        } else if ((orientation0_1 & 1) == 0) {
            this.addRow(this.tdElements[0], id + "_tr_0");
            this.addRow(this.marginTdElements[0], id + "_trmargin_0_1");
            this.addRow(this.tdElements[1], id + "_tr_1");
        } else {
            this.addRow(this.tdElements[1], id + "_tr_1");
            this.addRow(this.marginTdElements[0], id + "_trmargin_0_1");
            this.addRow(this.tdElements[0], id + "_tr_0");
        }
    }

    TriCellTable(RenderContext rc, Document document, String id, int orientation0_1, Extent margin0_1, int orientation01_2, Extent margin01_2) {
        this(rc, document, id);
        this.marginTdElements = new Element[2];
        this.tdElements = new Element[3];
        this.tdElements[0] = document.createElement("td");
        this.tdElements[0].setAttribute("id", id + "_td_0");
        this.tdElements[1] = document.createElement("td");
        this.tdElements[1].setAttribute("id", id + "_td_1");
        this.tdElements[2] = document.createElement("td");
        this.tdElements[2].setAttribute("id", id + "_td_2");
        if (margin0_1 != null || margin01_2 != null) {
            int size;
            if (margin0_1 != null && margin0_1.getValue() > 0) {
                this.marginTdElements[0] = document.createElement("td");
                this.marginTdElements[0].setAttribute("id", id + "_tdmargin_0_1");
                size = ExtentRender.toPixels(margin0_1, 1);
                if ((orientation0_1 & 2) == 0) {
                    this.marginTdElements[0].setAttribute("style", "width:" + size + "px;");
                    this.addSpacer(this.marginTdElements[0], size, false);
                } else {
                    this.marginTdElements[0].setAttribute("style", "height:" + size + "px;");
                    this.addSpacer(this.marginTdElements[0], size, true);
                }
            }
            if (margin01_2 != null && margin01_2.getValue() > 0) {
                this.marginTdElements[1] = document.createElement("td");
                this.marginTdElements[1].setAttribute("id", id + "_tdmargin_01_2");
                size = ExtentRender.toPixels(margin01_2, 1);
                if ((orientation01_2 & 2) == 0) {
                    this.marginTdElements[1].setAttribute("style", "width:" + size + "px;");
                    this.addSpacer(this.marginTdElements[1], size, false);
                } else {
                    this.marginTdElements[1].setAttribute("style", "height:" + size + "px;");
                    this.addSpacer(this.marginTdElements[1], size, true);
                }
            }
        }
        if ((orientation0_1 & 2) == 0) {
            if ((orientation01_2 & 2) == 0) {
                Element trElement = document.createElement("tr");
                trElement.setAttribute("id", id + "_tr_0");
                if ((orientation01_2 & 1) != 0) {
                    this.addColumn(trElement, this.tdElements[2]);
                    this.addColumn(trElement, this.marginTdElements[1]);
                }
                if ((orientation0_1 & 1) == 0) {
                    this.addColumn(trElement, this.tdElements[0]);
                    this.addColumn(trElement, this.marginTdElements[0]);
                    this.addColumn(trElement, this.tdElements[1]);
                } else {
                    this.addColumn(trElement, this.tdElements[1]);
                    this.addColumn(trElement, this.marginTdElements[0]);
                    this.addColumn(trElement, this.tdElements[0]);
                }
                if ((orientation01_2 & 1) == 0) {
                    this.addColumn(trElement, this.marginTdElements[1]);
                    this.addColumn(trElement, this.tdElements[2]);
                }
                this.tbodyElement.appendChild(trElement);
            } else {
                int columns = margin0_1 != null && margin0_1.getValue() > 0 ? 3 : 2;
                this.tdElements[2].setAttribute("colspan", Integer.toString(columns));
                if (this.marginTdElements[1] != null) {
                    this.marginTdElements[1].setAttribute("colspan", Integer.toString(columns));
                }
                if ((orientation01_2 & 1) != 0) {
                    this.addRow(this.tdElements[2], id + "_tr_2");
                    this.addRow(this.marginTdElements[1], id + "_trmargin_01_2");
                }
                Element trElement = document.createElement("tr");
                trElement.setAttribute("id", "tr_" + id);
                if ((orientation0_1 & 1) == 0) {
                    this.addColumn(trElement, this.tdElements[0]);
                    this.addColumn(trElement, this.marginTdElements[0]);
                    this.addColumn(trElement, this.tdElements[1]);
                } else {
                    this.addColumn(trElement, this.tdElements[1]);
                    this.addColumn(trElement, this.marginTdElements[0]);
                    this.addColumn(trElement, this.tdElements[0]);
                }
                this.tbodyElement.appendChild(trElement);
                if ((orientation01_2 & 1) == 0) {
                    this.addRow(this.marginTdElements[1], id + "_trmargin_01_2");
                    this.addRow(this.tdElements[2], id + "_tr_2");
                }
            }
        } else if ((orientation01_2 & 2) == 0) {
            int rows = margin0_1 != null && margin0_1.getValue() > 0 ? 3 : 2;
            this.tdElements[2].setAttribute("rowspan", Integer.toString(rows));
            if (this.marginTdElements[1] != null) {
                this.marginTdElements[1].setAttribute("rowspan", Integer.toString(rows));
            }
            Element trElement = document.createElement("tr");
            trElement.setAttribute("id", id + "_tr_0");
            if ((orientation01_2 & 1) != 0) {
                this.addColumn(trElement, this.tdElements[2]);
                this.addColumn(trElement, this.marginTdElements[1]);
                if ((orientation0_1 & 1) == 0) {
                    this.addColumn(trElement, this.tdElements[0]);
                } else {
                    this.addColumn(trElement, this.tdElements[1]);
                }
            } else {
                if ((orientation0_1 & 1) == 0) {
                    this.addColumn(trElement, this.tdElements[0]);
                } else {
                    this.addColumn(trElement, this.tdElements[1]);
                }
                this.addColumn(trElement, this.marginTdElements[1]);
                this.addColumn(trElement, this.tdElements[2]);
            }
            this.tbodyElement.appendChild(trElement);
            this.addRow(this.marginTdElements[0], id + "_trmargin_0_1");
            if ((orientation0_1 & 1) == 0) {
                this.addRow(this.tdElements[1], id + "_tr_1");
            } else {
                this.addRow(this.tdElements[0], id + "_tr_0");
            }
        } else {
            if ((orientation01_2 & 1) != 0) {
                this.addRow(this.tdElements[2], id + "_tr_2");
                this.addRow(this.marginTdElements[1], id + "_trmargin_01_2");
            }
            if ((orientation0_1 & 1) == 0) {
                this.addRow(this.tdElements[0], id + "_tr_0");
                this.addRow(this.marginTdElements[0], id + "_trmargin_0_1");
                this.addRow(this.tdElements[1], id + "_tr_1");
            } else {
                this.addRow(this.tdElements[1], id + "_tr_1");
                this.addRow(this.marginTdElements[0], id + "_trmargin_1_0");
                this.addRow(this.tdElements[0], id + "_tr_0");
            }
            if ((orientation01_2 & 1) == 0) {
                this.addRow(this.marginTdElements[1], id + "_trmargin_01_2");
                this.addRow(this.tdElements[2], id + "_tr_2");
            }
        }
    }

    private void addColumn(Element tr, Element td) {
        if (td != null) {
            tr.appendChild(td);
        }
    }

    void addCellCssText(String cssText) {
        int i;
        for (i = 0; i < this.tdElements.length; ++i) {
            if (this.tdElements[i].hasAttribute("style")) {
                this.tdElements[i].setAttribute("style", this.tdElements[i].getAttribute("style") + cssText);
                continue;
            }
            this.tdElements[i].setAttribute("style", cssText);
        }
        if (this.marginTdElements != null) {
            for (i = 0; i < this.marginTdElements.length; ++i) {
                if (this.marginTdElements[i] == null) continue;
                if (this.marginTdElements[i].hasAttribute("style")) {
                    this.marginTdElements[i].setAttribute("style", this.marginTdElements[i].getAttribute("style") + cssText);
                    continue;
                }
                this.marginTdElements[i].setAttribute("style", cssText);
            }
        }
    }

    private void addRow(Element tdElement, String trElementId) {
        if (tdElement != null) {
            Element trElement = this.document.createElement("tr");
            trElement.setAttribute("id", trElementId);
            trElement.appendChild(tdElement);
            this.tbodyElement.appendChild(trElement);
        }
    }

    private void addSpacer(Element parentElement, int size, boolean vertical) {
        Element imgElement = this.document.createElement("img");
        imgElement.setAttribute("src", this.rc.getContainerInstance().getServiceUri(TRANSPARENT_SPACER_IMAGE_SERVICE));
        imgElement.setAttribute("alt", "");
        imgElement.setAttribute("width", vertical ? "1" : Integer.toString(size));
        imgElement.setAttribute("height", vertical ? Integer.toString(size) : "1");
        parentElement.appendChild(imgElement);
    }

    Element getTableElement() {
        return this.tableElement;
    }

    Element getTdElement(int index) {
        return this.tdElements[index];
    }

    Element getMarginTdElement(int index) {
        return this.marginTdElements[index];
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TRANSPARENT_SPACER_IMAGE_SERVICE);
    }
}

