/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender.output;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class XmlDocument {
    private Document document;
    private Properties outputProperties;

    public XmlDocument(String qualifiedName, String publicId, String systemId, String namespaceUri) {
        DOMImplementation dom = DomUtil.getDocumentBuilder().getDOMImplementation();
        DocumentType docType = dom.createDocumentType(qualifiedName, publicId, systemId);
        this.document = dom.createDocument(namespaceUri, qualifiedName, docType);
        if (namespaceUri != null) {
            this.document.getDocumentElement().setAttribute("xmlns", namespaceUri);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void render(PrintWriter pw) throws IOException {
        try {
            TransformerFactory tFactory = DomUtil.getTransformerFactory();
            Transformer transformer = tFactory.newTransformer();
            if (this.outputProperties != null) {
                transformer.setOutputProperties(this.outputProperties);
            }
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(pw);
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new IOException("Unable to write document to OutputStream: " + ex.toString());
        }
    }

    public void setOutputProperties(Properties newValue) {
        this.outputProperties = newValue;
    }
}

