/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo2.webrender.util;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtil {
    private static final EntityResolver entityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new SAXException("External entities not supported.");
        }
    };
    private static final ThreadLocal documentBuilders = new ThreadLocal(){

        protected Object initialValue() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(entityResolver);
                return builder;
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
    };
    private static final ThreadLocal transformerFactories = new ThreadLocal(){

        protected Object initialValue() {
            TransformerFactory factory = null;
            try {
                factory = (TransformerFactory)Class.forName("nl.nn.org.apache.xalan.processor.TransformerFactoryImpl").getConstructor(null).newInstance(null);
            }
            catch (Exception e1) {
                try {
                    factory = (TransformerFactory)Class.forName("org.apache.xalan.processor.TransformerFactoryImpl").getConstructor(null).newInstance(null);
                }
                catch (Exception e2) {
                    try {
                        factory = (TransformerFactory)Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl").getConstructor(null).newInstance(null);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace(System.out);
                    }
                }
            }
            return factory;
        }
    };

    public static DocumentBuilder getDocumentBuilder() {
        return (DocumentBuilder)documentBuilders.get();
    }

    public static TransformerFactory getTransformerFactory() {
        return (TransformerFactory)transformerFactories.get();
    }

    public static boolean getBooleanAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public static Element getChildElementByTagName(Element parentElement, String name) {
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !name.equals(nodes.item(index).getNodeName())) continue;
            return (Element)nodes.item(index);
        }
        return null;
    }

    public static Element getChildElementByTagNameNS(Element parentElement, String namespaceURI, String localName) {
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !namespaceURI.equals(nodes.item(index).getNamespaceURI()) || !localName.equals(nodes.item(index).getNodeName())) continue;
            return (Element)nodes.item(index);
        }
        return null;
    }

    public static Element[] getChildElementsByTagName(Element parentElement, String name) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !name.equals(nodes.item(index).getNodeName())) continue;
            children.add(nodes.item(index));
        }
        Element[] childElements = new Element[children.size()];
        return children.toArray(childElements);
    }

    public static Element[] getChildElementsByTagNameNS(Element parentElement, String namespaceURI, String localName) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !namespaceURI.equals(nodes.item(index).getNamespaceURI()) || !localName.equals(nodes.item(index).getNodeName())) continue;
            children.add(nodes.item(index));
        }
        Element[] childElements = new Element[children.size()];
        return children.toArray(childElements);
    }

    public static int getChildElementCountByTagName(Element parentElement, String name) {
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        int count = 0;
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !name.equals(nodes.item(index).getNodeName())) continue;
            ++count;
        }
        return count;
    }

    public static int getChildElementCountByTagNameNS(Element parentElement, String namespaceURI, String localName) {
        NodeList nodes = parentElement.getChildNodes();
        int length = nodes.getLength();
        int count = 0;
        for (int index = 0; index < length; ++index) {
            if (nodes.item(index).getNodeType() != 1 || !namespaceURI.equals(nodes.item(index).getNamespaceURI()) || !localName.equals(nodes.item(index).getNodeName())) continue;
            ++count;
        }
        return count;
    }

    public static String getElementText(Element element) {
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int index = 0; index < childCount; ++index) {
            if (!(children.item(index) instanceof Text)) continue;
            Text text = (Text)children.item(index);
            return text.getData();
        }
        return null;
    }

    public static void setElementText(Element element, String value) {
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int index = 0; index < childCount; ++index) {
            if (!(children.item(index) instanceof Text)) continue;
            Text text = (Text)children.item(index);
            text.setData(value);
            return;
        }
        Text text = element.getOwnerDocument().createTextNode(value);
        element.appendChild(text);
    }

    private DomUtil() {
    }
}

