/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import nl.nn.testtool.MessageCapturer;
import nl.nn.testtool.MessageEncoder;
import nl.nn.testtool.Path;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.run.ReportRunner;
import nl.nn.testtool.run.RunResult;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.util.ImportResult;
import nl.nn.testtool.util.XmlUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpoint
implements Serializable,
Cloneable {
    private static final transient long serialVersionUID = 4L;
    private static final transient Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final transient Pattern GENERIC_VARIABLE_PATTERN = Pattern.compile("\\$\\{.*?\\}");
    private static final transient Pattern EXTERNAL_VARIABLE_PATTERN = Pattern.compile("\\$\\{checkpoint\\(([0-9]+#[0-9]+)\\)(\\.xpath\\((.*?)\\)|)\\}");
    public static final transient int TYPE_STARTPOINT = 1;
    public static final transient int TYPE_ENDPOINT = 2;
    public static final transient int TYPE_ABORTPOINT = 3;
    public static final transient int TYPE_INPUTPOINT = 4;
    public static final transient int TYPE_OUTPUTPOINT = 5;
    public static final transient int TYPE_INFOPOINT = 6;
    public static final transient int TYPE_THREADCREATEPOINT = 7;
    public static final transient int TYPE_THREADSTARTPOINT = 8;
    public static final transient int TYPE_THREADENDPOINT = 9;
    public static final transient int STUB_FOLLOW_REPORT_STRATEGY = -1;
    public static final transient int STUB_NO = 0;
    public static final transient int STUB_YES = 1;
    private Report report;
    private String threadName;
    private String sourceClassName;
    private String messageClassName;
    private String name;
    private String message;
    private String encoding;
    private String streaming;
    private boolean waitingForStream = false;
    private transient StringWriter messageCapturerWriter;
    private transient ByteArrayOutputStream messageCapturerOutputStream;
    private boolean noCloseReceivedForStream = false;
    private int type;
    private int level = 0;
    private int stub = -1;
    private boolean stubbed = false;
    private String stubNotFound;
    private int preTruncatedMessageLength = -1;
    private transient Map<String, Pattern> variablePatternMap;

    public Checkpoint() {
    }

    public Checkpoint(Report report, String threadName, String sourceClassName, String name, int type, int level) {
        this.report = report;
        this.threadName = threadName;
        this.sourceClassName = sourceClassName;
        this.name = name;
        this.type = type;
        this.level = level;
    }

    @JsonIgnore
    public void setReport(Report report) {
        this.report = report;
    }

    @JsonIgnore
    public Report getReport() {
        return this.report;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public void setMessageClassName(String messageClassName) {
        this.messageClassName = messageClassName;
    }

    public String getMessageClassName() {
        return this.messageClassName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setMessage(String message) {
        if (this.report != null) {
            message = this.report.truncateMessage(this, message);
            if (this.report.getMessageTransformer() != null) {
                message = this.report.getMessageTransformer().transform(message);
            }
        }
        this.message = message;
    }

    public <T> T setMessage(T message) {
        final MessageEncoder.ToStringResult toStringResult = this.report.getMessageEncoder().toString(message, null);
        this.setMessage(toStringResult.getString());
        this.setEncoding(toStringResult.getEncoding());
        this.setMessageClassName(toStringResult.getMessageClassName());
        if (message != null && this.report.getMessageCapturer() != null) {
            if (this.report.isKnownStreamingMessage(message)) {
                this.report.addStreamingMessageListener(message, this);
            } else {
                final MessageCapturer.StreamingType streamingType = this.report.getMessageCapturer().getStreamingType(message);
                if (streamingType == MessageCapturer.StreamingType.CHARACTER_STREAM || streamingType == MessageCapturer.StreamingType.BYTE_STREAM) {
                    this.setWaitingForStream(true);
                    this.setStreaming(streamingType.toString());
                    final TestTool testTool = this.report.getTestTool();
                    this.report.addStreamingMessageListener(message, this);
                    final Object[] messageToClose = new Object[]{message};
                    final String[] charset = new String[1];
                    final Throwable[] exception = new Throwable[1];
                    if (streamingType == MessageCapturer.StreamingType.CHARACTER_STREAM) {
                        this.messageCapturerWriter = new StringWriter(){
                            int length = 0;
                            boolean truncated = false;

                            @Override
                            public void write(String str) {
                                this.write(str.toCharArray(), 0, str.length());
                            }

                            @Override
                            public void write(String str, int off, int len) {
                                this.write(str.toCharArray(), off, len);
                            }

                            @Override
                            public void write(int c) {
                                char[] cbuf = new char[]{(char)c};
                                this.write(cbuf, 0, 1);
                            }

                            @Override
                            public void write(char[] cbuf) {
                                this.write(cbuf, 0, cbuf.length);
                            }

                            @Override
                            public void write(char[] cbuf, int off, int len) {
                                if (this.length + len > testTool.getMaxMessageLength() && !this.truncated) {
                                    super.write(cbuf, off, testTool.getMaxMessageLength() - this.length);
                                    this.truncated = true;
                                }
                                this.length += len;
                                if (this.truncated) {
                                    return;
                                }
                                super.write(cbuf, off, len);
                            }

                            @Override
                            public void close() throws IOException {
                                super.close();
                                int preTruncatedMessageLength = -1;
                                if (this.truncated) {
                                    preTruncatedMessageLength = this.length;
                                }
                                Checkpoint.this.messageCapturerWriter = null;
                                Checkpoint.this.report.closeStreamingMessage(toStringResult.getMessageClassName(), messageToClose[0], streamingType.toString(), charset[0], this.toString(), preTruncatedMessageLength, exception[0]);
                            }
                        };
                        message = this.report.getMessageCapturer().toWriter(message, this.messageCapturerWriter, exceptionNotifier -> {
                            exception[0] = exceptionNotifier;
                        });
                    } else {
                        this.messageCapturerOutputStream = new ByteArrayOutputStream(){
                            int length = 0;
                            boolean truncated = false;

                            @Override
                            public void write(int b) {
                                byte[] buf = new byte[]{(byte)b};
                                this.write(buf, 0, 1);
                            }

                            @Override
                            public void write(byte[] b) {
                                this.write(b, 0, b.length);
                            }

                            @Override
                            public void write(byte[] b, int off, int len) {
                                if (this.length + len > testTool.getMaxMessageLength() && !this.truncated) {
                                    super.write(b, off, testTool.getMaxMessageLength() - this.length);
                                    this.truncated = true;
                                }
                                this.length += len;
                                if (this.truncated) {
                                    return;
                                }
                                super.write(b, off, len);
                            }

                            @Override
                            public void close() throws IOException {
                                super.close();
                                int preTruncatedMessageLength = -1;
                                if (this.truncated) {
                                    preTruncatedMessageLength = this.length;
                                }
                                Checkpoint.this.messageCapturerOutputStream = null;
                                Checkpoint.this.report.closeStreamingMessage(toStringResult.getMessageClassName(), messageToClose[0], streamingType.toString(), charset[0], this.toByteArray(), preTruncatedMessageLength, exception[0]);
                            }
                        };
                        message = this.report.getMessageCapturer().toOutputStream(message, this.messageCapturerOutputStream, charsetNotifier -> {
                            charset[0] = charsetNotifier;
                        }, exceptionNotifier -> {
                            exception[0] = exceptionNotifier;
                        });
                    }
                    if (message != messageToClose[0]) {
                        this.report.addStreamingMessageListener(message, this);
                        Object origMessage = messageToClose[0];
                        messageToClose[0] = message;
                        this.report.removeStreamingMessageListener(origMessage, this);
                    }
                }
            }
        }
        return message;
    }

    public String getMessage() {
        return this.message;
    }

    public void closeMessageCapturer() {
        try {
            if (this.messageCapturerWriter != null) {
                this.noCloseReceivedForStream = true;
                this.messageCapturerWriter.close();
            }
        }
        catch (IOException e) {
            log.warn("Could not close messageCapturerWriter", (Throwable)e);
        }
        try {
            if (this.messageCapturerOutputStream != null) {
                this.noCloseReceivedForStream = true;
                this.messageCapturerOutputStream.close();
            }
        }
        catch (IOException e) {
            log.warn("Could not close messageCapturerOutputStream", (Throwable)e);
        }
    }

    @JsonIgnore
    public Object getMessageAsObject() {
        return this.report.getMessageEncoder().toObject(this);
    }

    @JsonIgnore
    public <T> T getMessageAsObject(T messageToStub) {
        return this.report.getMessageEncoder().toObject(this, messageToStub);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStreaming(String streaming) {
        this.streaming = streaming;
    }

    public String getStreaming() {
        return this.streaming;
    }

    public void setWaitingForStream(boolean waitingForStream) {
        this.waitingForStream = waitingForStream;
    }

    public boolean isWaitingForStream() {
        return this.waitingForStream;
    }

    public void setNoCloseReceivedForStream(boolean noCloseReceivedForStream) {
        this.noCloseReceivedForStream = noCloseReceivedForStream;
    }

    public boolean isNoCloseReceivedForStream() {
        return this.noCloseReceivedForStream;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return Checkpoint.getTypeAsString(this.getType());
    }

    public static String getTypeAsString(int type) {
        String typeAsString = null;
        switch (type) {
            case 1: {
                typeAsString = "Startpoint";
                break;
            }
            case 2: {
                typeAsString = "Endpoint";
                break;
            }
            case 3: {
                typeAsString = "Abortpoint";
                break;
            }
            case 4: {
                typeAsString = "Inputpoint";
                break;
            }
            case 5: {
                typeAsString = "Outputpoint";
                break;
            }
            case 6: {
                typeAsString = "Infopoint";
                break;
            }
            case 7: {
                typeAsString = "ThreadCreatepoint";
                break;
            }
            case 8: {
                typeAsString = "ThreadStartpoint";
                break;
            }
            case 9: {
                typeAsString = "ThreadEndpoint";
            }
        }
        return typeAsString;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setStub(int stub) {
        this.stub = stub;
    }

    public int getStub() {
        return this.stub;
    }

    public void setStubbed(boolean stubbed) {
        this.stubbed = stubbed;
    }

    public boolean isStubbed() {
        return this.stubbed;
    }

    public void setStubNotFound(String stubNotFound) {
        this.stubNotFound = stubNotFound;
    }

    public String getStubNotFound() {
        return this.stubNotFound;
    }

    @JsonIgnore
    public Path getPath() {
        return this.getPath(false);
    }

    protected Path getPath(boolean checkpointInProgress) {
        Path path = new Path(this.level + 1);
        path.setName(this.level, this.name);
        int currentLevel = this.level;
        String currentName = this.name;
        int i = this.report.getCheckpoints().indexOf(this);
        if (i == -1 && checkpointInProgress) {
            i = this.report.getCheckpoints().size();
        }
        --i;
        while (i >= 0) {
            Checkpoint currentCheckpoint = this.report.getCheckpoints().get(i);
            if (currentCheckpoint.getLevel() == currentLevel && currentCheckpoint.getName().equals(currentName)) {
                path.incrementCount(currentLevel);
            } else if (currentCheckpoint.getLevel() < currentLevel) {
                currentLevel = currentCheckpoint.getLevel();
                currentName = currentCheckpoint.getName();
                path.setName(currentLevel, currentCheckpoint.getName());
            }
            --i;
        }
        return path;
    }

    public long getEstimatedMemoryUsage() {
        if (this.message == null) {
            return 0L;
        }
        return this.message.length() * 2;
    }

    public Checkpoint clone() throws CloneNotSupportedException {
        Checkpoint checkpoint = (Checkpoint)super.clone();
        checkpoint.setReport(null);
        return checkpoint;
    }

    public String toString() {
        return this.name;
    }

    public void setPreTruncatedMessageLength(int length) {
        this.preTruncatedMessageLength = length;
    }

    public int getPreTruncatedMessageLength() {
        return this.preTruncatedMessageLength;
    }

    public String getMessageWithResolvedVariables(ReportRunner reportRunner) {
        String result = this.getMessage();
        if (this.getMessage() != null && this.containsVariables()) {
            if (reportRunner != null) {
                ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>();
                Matcher m = EXTERNAL_VARIABLE_PATTERN.matcher(this.getMessage());
                while (m.find()) {
                    matchResults.add(m.toMatchResult());
                }
                for (MatchResult matchResult : matchResults) {
                    int reportStorageId = Integer.parseInt(matchResult.group(1).split("#")[0]);
                    int checkpointIndex = Integer.parseInt(matchResult.group(1).split("#")[1]);
                    String xpathExpression = null;
                    if (StringUtils.isNotEmpty((String)matchResult.group(2))) {
                        xpathExpression = matchResult.group(3);
                    }
                    Report targetReport = null;
                    try {
                        for (Map.Entry<Integer, RunResult> entry : reportRunner.getResults().entrySet()) {
                            if (entry.getKey() != reportStorageId) continue;
                            targetReport = reportRunner.getRunResultReport(entry.getValue().correlationId);
                        }
                    }
                    catch (StorageException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    if (targetReport != null) {
                        try {
                            String targetCheckpointMessage = targetReport.getCheckpoints().get(checkpointIndex).getMessage();
                            if (StringUtils.isNotEmpty((String)targetCheckpointMessage)) {
                                if (StringUtils.isNotEmpty((String)xpathExpression)) {
                                    try {
                                        String xpathResult = XmlUtil.createXPathExpression(xpathExpression).evaluate(XmlUtil.createXmlSourceFromString(targetCheckpointMessage));
                                        if (xpathResult == null) continue;
                                        try {
                                            result = result.replace(matchResult.group(), xpathResult);
                                        }
                                        catch (IllegalArgumentException e) {
                                            if (!GENERIC_VARIABLE_PATTERN.matcher(xpathResult).find()) continue;
                                            log.warn(this.warningMessageHeader(matchResult.group()) + "Specified xpath expression points to incorrectly parsed parameter " + xpathResult + "; see other recent log warnings for a possible cause");
                                        }
                                    }
                                    catch (XPathExpressionException e) {
                                        log.warn(this.warningMessageHeader(matchResult.group()) + "Invalid xpath expression or XML message in target checkpoint");
                                    }
                                    continue;
                                }
                                result = result.replaceAll(Pattern.quote(matchResult.group()), targetCheckpointMessage);
                                continue;
                            }
                            log.warn(this.warningMessageHeader(matchResult.group()) + "Target checkpoint [" + targetReport.getCheckpoints().get(checkpointIndex) + "] contains no message");
                        }
                        catch (IndexOutOfBoundsException e) {
                            log.warn(this.warningMessageHeader(matchResult.group()) + "Index out of bounds: checkpoint with index [" + checkpointIndex + "] does not exist in report with storageId [" + reportStorageId + "]");
                        }
                        continue;
                    }
                    log.warn(this.warningMessageHeader(matchResult.group()) + "Run result not found for storageId [" + reportStorageId + "] - please make sure it runs before this report");
                }
            }
            if (StringUtils.isNotEmpty((String)this.report.getVariableCsv())) {
                Map<String, String> variableMap = this.report.getVariablesAsMap();
                Map<String, Pattern> variablePatternMap = this.getVariablePatternMap(variableMap);
                for (Map.Entry entry : variableMap.entrySet()) {
                    Matcher m = variablePatternMap.get(entry.getKey()).matcher(this.getMessage());
                    while (m.find()) {
                        result = result.replaceAll(Pattern.quote(m.group()), (String)entry.getValue());
                    }
                }
            }
        }
        return result;
    }

    private String warningMessageHeader(String parameter) {
        return "Could not parse parameter " + parameter + " found in the input of report [" + this.report.getFullPath() + "] with storageId [" + this.report.getStorageId() + "]\n";
    }

    public boolean containsVariables() {
        if (StringUtils.isEmpty((String)this.getMessage())) {
            return false;
        }
        return GENERIC_VARIABLE_PATTERN.matcher(this.getMessage()).find();
    }

    protected Map<String, Pattern> getVariablePatternMap(Map<String, String> variableMap) {
        if (this.variablePatternMap == null) {
            this.variablePatternMap = new HashMap<String, Pattern>();
            for (Map.Entry<String, String> entry : variableMap.entrySet()) {
                this.variablePatternMap.put(entry.getKey(), Pattern.compile("\\$\\{" + entry.getKey() + "\\}"));
            }
        }
        return this.variablePatternMap;
    }

    public int getIndex() {
        return this.report.getCheckpoints().indexOf(this);
    }

    public String getUID() {
        return this.report.getStorageId() + "#" + this.report.getCheckpoints().indexOf(this);
    }

    public boolean updateVariables(List<ImportResult> importResults) {
        boolean isVariablesUpdated = false;
        Matcher m = EXTERNAL_VARIABLE_PATTERN.matcher(this.getMessage());
        ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>();
        while (m.find()) {
            matchResults.add(m.toMatchResult());
        }
        for (MatchResult matchResult : matchResults) {
            int matchResultStorageId = Integer.valueOf(matchResult.group(1).split("#")[0]);
            for (ImportResult importResult : importResults) {
                if (matchResultStorageId != importResult.getOldStorageId()) continue;
                int newStorageId = importResult.getNewStorageId();
                String newVar = matchResult.group().replaceAll(String.valueOf(matchResultStorageId), String.valueOf(newStorageId));
                this.setMessage(this.getMessage().replace(matchResult.group(), newVar));
                isVariablesUpdated = true;
            }
        }
        return isVariablesUpdated;
    }
}

