/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.function.Consumer;
import nl.nn.testtool.MessageCapturer;

public class MessageCapturerImpl
implements MessageCapturer {
    @Override
    public MessageCapturer.StreamingType getStreamingType(Object message) {
        if (message instanceof Reader || message instanceof Writer) {
            return MessageCapturer.StreamingType.CHARACTER_STREAM;
        }
        if (message instanceof InputStream || message instanceof OutputStream) {
            return MessageCapturer.StreamingType.BYTE_STREAM;
        }
        return MessageCapturer.StreamingType.NONE;
    }

    @Override
    public <T> T toWriter(T message, final Writer writer, Consumer<Throwable> exceptionNotifier) {
        if (message instanceof Reader) {
            return (T)new BufferedReader((Reader)message){

                @Override
                public int read() throws IOException {
                    int c = super.read();
                    writer.write(c);
                    return c;
                }

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    int read = super.read(cbuf, off, len);
                    if (read > 0) {
                        writer.write(cbuf, off, read);
                    }
                    return read;
                }

                @Override
                public void close() throws IOException {
                    writer.close();
                    super.close();
                }
            };
        }
        return (T)new BufferedWriter((Writer)message){

            @Override
            public void write(String str, int off, int len) throws IOException {
                writer.write(str, off, len);
                super.write(str, off, len);
            }

            @Override
            public void write(int c) throws IOException {
                writer.write(c);
                super.write(c);
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                writer.write(cbuf, off, len);
                super.write(cbuf, off, len);
            }

            @Override
            public void close() throws IOException {
                writer.close();
                super.close();
            }
        };
    }

    @Override
    public <T> T toOutputStream(T message, final OutputStream outputStream, Consumer<String> charsetNotifier, Consumer<Throwable> exceptionNotifier) {
        if (message instanceof InputStream) {
            return (T)new BufferedInputStream((InputStream)message){

                @Override
                public synchronized int read() throws IOException {
                    int b = super.read();
                    outputStream.write(b);
                    return b;
                }

                @Override
                public synchronized int read(byte[] buf, int off, int len) throws IOException {
                    int read = super.read(buf, off, len);
                    if (read > 0) {
                        outputStream.write(buf, off, read);
                    }
                    return read;
                }

                @Override
                public void close() throws IOException {
                    outputStream.close();
                    super.close();
                }
            };
        }
        return (T)new BufferedOutputStream((OutputStream)message){

            @Override
            public synchronized void write(int b) throws IOException {
                outputStream.write(b);
                super.write(b);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                outputStream.write(b, off, len);
                super.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                outputStream.close();
                super.close();
            }
        };
    }
}

