/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool;

import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.MessageEncoder;
import nl.nn.testtool.XMLEncoderExceptionListener;
import nl.nn.testtool.util.XmlUtil;
import nl.nn.xmldecoder.XMLDecoder;
import org.w3c.dom.Node;

public class MessageEncoderImpl
implements MessageEncoder {
    public static final String XML_ENCODER = "XMLEncoder";
    public static final String UTF8_ENCODER = "UTF-8";
    public static final String CHARSET_ENCODER_PREFIX = "CHARSET-";
    public static final String BASE64_ENCODER = "Base64";
    public static final String THROWABLE_ENCODER = "printStackTrace()";
    public static final String TO_STRING_ENCODER = "toString()";
    public static final String DOM_NODE_ENCODER = "XmlUtil.nodeToString()";
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String DATE_ENCODER = "SimpleDateFormat(\"yyyy-MM-dd'T'HH:mm:ss.SSSZ\")";
    public static final String WAITING_FOR_STREAM_MESSAGE = "Waiting for stream to be read, captured and closed...";

    @Override
    public MessageEncoder.ToStringResult toString(Object message, String charset) {
        MessageEncoder.ToStringResult toStringResult;
        if (message == null) {
            toStringResult = new MessageEncoder.ToStringResult(null, null);
        } else if (message instanceof String) {
            toStringResult = new MessageEncoder.ToStringResult((String)message, null);
        } else {
            if (message instanceof byte[]) {
                String encoding;
                if (charset == null) {
                    charset = UTF8_ENCODER;
                    encoding = UTF8_ENCODER;
                } else {
                    encoding = CHARSET_ENCODER_PREFIX + charset;
                }
                CharsetDecoder charsetDecoder = Charset.forName(charset).newDecoder();
                try {
                    CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap((byte[])message));
                    toStringResult = new MessageEncoder.ToStringResult(charBuffer.toString(), encoding);
                }
                catch (CharacterCodingException e) {
                    toStringResult = new MessageEncoder.ToStringResult(Base64.getEncoder().encodeToString((byte[])message), BASE64_ENCODER);
                }
            } else if (message instanceof Reader || message instanceof InputStream || message instanceof Writer || message instanceof OutputStream) {
                toStringResult = new MessageEncoder.ToStringResult(WAITING_FOR_STREAM_MESSAGE, null);
            } else if (message instanceof Throwable) {
                StringWriter stringWriter = new StringWriter();
                ((Throwable)message).printStackTrace(new PrintWriter(stringWriter));
                toStringResult = new MessageEncoder.ToStringResult(stringWriter.toString(), THROWABLE_ENCODER);
            } else if (message instanceof Node) {
                Node node = (Node)message;
                toStringResult = new MessageEncoder.ToStringResult(XmlUtil.nodeToString(node), DOM_NODE_ENCODER);
            } else if (message instanceof Date) {
                toStringResult = new MessageEncoder.ToStringResult(new SimpleDateFormat(DATE_PATTERN).format((Date)message), DATE_ENCODER);
            } else {
                String xml = null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XMLEncoder encoder = new XMLEncoder(byteArrayOutputStream);
                XMLEncoderExceptionListener exceptionListener = new XMLEncoderExceptionListener();
                encoder.setExceptionListener(exceptionListener);
                encoder.writeObject(message);
                encoder.close();
                xml = byteArrayOutputStream.toString(UTF8_ENCODER);
                toStringResult = exceptionListener.isExceptionThrown() ? new MessageEncoder.ToStringResult(message.toString(), TO_STRING_ENCODER) : new MessageEncoder.ToStringResult(xml, XML_ENCODER);
            }
            toStringResult.setMessageClassName(message.getClass().getTypeName());
        }
        return toStringResult;
    }

    @Override
    public Object toObject(Checkpoint checkpoint) {
        return this.toObject(checkpoint, null);
    }

    @Override
    public <T> T toObject(Checkpoint originalCheckpoint, T messageToStub) {
        if (messageToStub instanceof AutoCloseable) {
            ((AutoCloseable)messageToStub).close();
        }
        if (originalCheckpoint == null || originalCheckpoint.getMessage() == null) {
            return null;
        }
        String message = originalCheckpoint.getMessage();
        String encoding = originalCheckpoint.getEncoding();
        if (encoding == null) {
            if (originalCheckpoint.getStreaming() == null) {
                return (T)message;
            }
            if (messageToStub instanceof Writer) {
                ((Writer)messageToStub).write(message);
                return messageToStub;
            }
            return (T)new StringReader(message);
        }
        if (encoding.equals(UTF8_ENCODER) || encoding.startsWith(CHARSET_ENCODER_PREFIX)) {
            if (encoding.startsWith(CHARSET_ENCODER_PREFIX)) {
                encoding = encoding.substring(CHARSET_ENCODER_PREFIX.length());
            }
            CharsetEncoder charsetEncoder = Charset.forName(encoding).newEncoder();
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(message));
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            if (originalCheckpoint.getStreaming() == null) {
                return (T)bytes;
            }
            if (messageToStub instanceof OutputStream) {
                ((OutputStream)messageToStub).write(bytes);
                return messageToStub;
            }
            return (T)new ByteArrayInputStream(bytes);
        }
        if (encoding.equals(BASE64_ENCODER)) {
            byte[] bytes = Base64.getDecoder().decode(message);
            if (originalCheckpoint.getStreaming() == null) {
                return (T)bytes;
            }
            return (T)new ByteArrayInputStream(bytes);
        }
        if (encoding.equals(DOM_NODE_ENCODER)) {
            return (T)XmlUtil.stringToNode(message);
        }
        if (encoding.equals(DATE_ENCODER)) {
            return (T)new SimpleDateFormat(DATE_PATTERN).parse(message);
        }
        if (encoding.equals(XML_ENCODER)) {
            ByteArrayInputStream byteArrayInputStream = null;
            byteArrayInputStream = new ByteArrayInputStream(message.getBytes(UTF8_ENCODER));
            XMLDecoder xmlDecoder = new XMLDecoder(byteArrayInputStream);
            return (T)xmlDecoder.readObject();
        }
        return (T)message;
    }
}

