/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool;

import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import nl.nn.testtool.MetadataFieldExtractor;
import nl.nn.testtool.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractor {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int VALUE_TYPE_OBJECT = 0;
    public static final int VALUE_TYPE_STRING = 1;
    public static final int VALUE_TYPE_GUI = 2;
    private static final SimpleDateFormat FORMAT_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public List extraMetadataFieldExtractors;

    public void setExtraMetadataFieldExtractors(List extraMetadataFieldExtractors) {
        this.extraMetadataFieldExtractors = extraMetadataFieldExtractors;
    }

    public String getLabel(String metadataName) {
        if (metadataName.equals("storageId")) {
            return "Storage Id";
        }
        if (metadataName.equals("storageSize")) {
            return "Storage size";
        }
        if (metadataName.equals("name")) {
            return "Name";
        }
        if (metadataName.equals("description")) {
            return "Description";
        }
        if (metadataName.equals("path")) {
            return "Path";
        }
        if (metadataName.equals("correlationId")) {
            return "Correlation Id";
        }
        if (metadataName.equals("startTime")) {
            return "Start time";
        }
        if (metadataName.equals("endTime")) {
            return "End time";
        }
        if (metadataName.equals("estimatedMemoryUsage")) {
            return "Estimated memory usage";
        }
        if (metadataName.equals("numberOfCheckpoints")) {
            return "Number of checkpoints";
        }
        if (metadataName.equals("duration")) {
            return "Duration";
        }
        String label = null;
        if (this.extraMetadataFieldExtractors != null) {
            Iterator iterator = this.extraMetadataFieldExtractors.iterator();
            while (iterator.hasNext() && label == null) {
                MetadataFieldExtractor metadataFieldExtractor = (MetadataFieldExtractor)iterator.next();
                if (!metadataFieldExtractor.getName().equals(metadataName)) continue;
                label = metadataFieldExtractor.getLabel();
            }
        }
        if (label == null) {
            label = metadataName;
        }
        return label;
    }

    public String getShortLabel(String metadataName) {
        if (metadataName.equals("storageId")) {
            return "StorageId";
        }
        if (metadataName.equals("storageSize")) {
            return "StorageSize";
        }
        if (metadataName.equals("name")) {
            return "Name";
        }
        if (metadataName.equals("description")) {
            return "Description";
        }
        if (metadataName.equals("path")) {
            return "Path";
        }
        if (metadataName.equals("correlationId")) {
            return "CorrelationId";
        }
        if (metadataName.equals("startTime")) {
            return "StartTime";
        }
        if (metadataName.equals("endTime")) {
            return "EndTime";
        }
        if (metadataName.equals("estimatedMemoryUsage")) {
            return "EstMemUsage";
        }
        if (metadataName.equals("numberOfCheckpoints")) {
            return "NrChpts";
        }
        if (metadataName.equals("duration")) {
            return "Duration";
        }
        String shortLabel = null;
        if (this.extraMetadataFieldExtractors != null) {
            Iterator iterator = this.extraMetadataFieldExtractors.iterator();
            while (iterator.hasNext() && shortLabel == null) {
                MetadataFieldExtractor metadataFieldExtractor = (MetadataFieldExtractor)iterator.next();
                if (!metadataFieldExtractor.getName().equals(metadataName)) continue;
                shortLabel = metadataFieldExtractor.getShortLabel();
            }
        }
        if (shortLabel == null) {
            shortLabel = this.getLabel(metadataName);
        }
        return shortLabel;
    }

    public Object getMetadata(Report report, String metadataName, int metadataValueType) {
        return this.fromObjectToMetadataValueType(metadataName, this.getMetadataAsObject(report, metadataName), metadataValueType);
    }

    private Object getMetadataAsObject(Report report, String metadataName) {
        if (metadataName.equals("storageId")) {
            return report.getStorageId();
        }
        if (metadataName.equals("storageSize")) {
            return report.getStorageSize();
        }
        if (metadataName.equals("name")) {
            return report.getName();
        }
        if (metadataName.equals("description")) {
            return report.getDescription();
        }
        if (metadataName.equals("path")) {
            return report.getPath();
        }
        if (metadataName.equals("correlationId")) {
            return report.getCorrelationId();
        }
        if (metadataName.equals("startTime")) {
            return new Long(report.getStartTime());
        }
        if (metadataName.equals("endTime")) {
            return new Long(report.getEndTime());
        }
        if (metadataName.equals("estimatedMemoryUsage")) {
            return new Long(report.getEstimatedMemoryUsage());
        }
        if (metadataName.equals("numberOfCheckpoints")) {
            return new Integer(report.getNumberOfCheckpoints());
        }
        if (metadataName.equals("duration")) {
            return "" + (report.getEndTime() - report.getStartTime());
        }
        if (metadataName.equals("variableCsv")) {
            return report.getVariableCsv();
        }
        Object metadata = null;
        if (this.extraMetadataFieldExtractors != null) {
            Iterator iterator = this.extraMetadataFieldExtractors.iterator();
            while (iterator.hasNext() && metadata == null) {
                MetadataFieldExtractor metadataFieldExtractor = (MetadataFieldExtractor)iterator.next();
                if (!metadataFieldExtractor.getName().equals(metadataName)) continue;
                metadata = metadataFieldExtractor.extractMetadata(report);
            }
        }
        return metadata;
    }

    public Object fromObjectToMetadataValueType(String metadataName, Object metadataValue, int metadataValueType) {
        if (metadataValueType == 1) {
            metadataValue = this.fromObjectToString(metadataName, metadataValue);
        } else if (metadataValueType == 2) {
            metadataValue = this.fromObjectToGUI(metadataName, metadataValue);
        }
        return metadataValue;
    }

    public String fromObjectToString(String metadataName, Object metadataValue) {
        return "" + metadataValue;
    }

    public Object fromObjectToGUI(String metadataName, Object metadataValue) {
        if (metadataName.equals("startTime")) {
            return FORMAT_DATE_TIME.format(metadataValue);
        }
        if (metadataName.equals("endTime")) {
            return FORMAT_DATE_TIME.format(metadataValue);
        }
        return metadataValue;
    }

    public Object fromStringToMetadataValueType(String metadataName, String metadataValue, int metadataValueType) {
        Object value = metadataValue;
        if (metadataValueType == 0) {
            value = this.fromStringtoObject(metadataName, metadataValue);
        } else if (metadataValueType == 2) {
            value = this.fromStringtoObject(metadataName, metadataValue);
            value = this.fromObjectToGUI(metadataName, value);
        }
        return value;
    }

    public Object fromStringtoObject(String metadataName, String metadataValue) {
        if (metadataName.equals("storageId")) {
            return new Integer(metadataValue);
        }
        if (metadataName.equals("storageSize")) {
            return new Long(metadataValue);
        }
        if (metadataName.equals("startTime")) {
            return new Long(metadataValue);
        }
        if (metadataName.equals("endTime")) {
            return new Long(metadataValue);
        }
        if (metadataName.equals("estimatedMemoryUsage")) {
            return new Long(metadataValue);
        }
        if (metadataName.equals("numberOfCheckpoints")) {
            return new Integer(metadataValue);
        }
        return metadataValue;
    }
}

