/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.MessageCapturer;
import nl.nn.testtool.MessageEncoder;
import nl.nn.testtool.Path;
import nl.nn.testtool.RefCompareMap;
import nl.nn.testtool.StreamingMessageResult;
import nl.nn.testtool.StubableCode;
import nl.nn.testtool.StubableCodeThrowsException;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.run.ReportRunner;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.transform.MessageTransformer;
import nl.nn.testtool.transform.ReportXmlTransformer;
import nl.nn.testtool.util.CsvUtil;
import nl.nn.testtool.util.EscapeUtil;
import nl.nn.testtool.util.XmlUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Report
implements Serializable {
    private static final transient long serialVersionUID = 5L;
    private static transient Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final transient long TIME_NOT_SET_VALUE = Long.MIN_VALUE;
    private long startTime;
    private long endTime = Long.MIN_VALUE;
    private String correlationId;
    private String name;
    private String description;
    private String path;
    private String stubStrategy;
    private List<Checkpoint> checkpoints = new ArrayList<Checkpoint>();
    private String transformation;
    private String variableCsv;
    private transient String mainThread;
    private transient long mainThreadFinishedTime = Long.MIN_VALUE;
    private transient List<String> threads = new ArrayList<String>();
    private transient Map<String, Integer> threadCheckpointIndex = new HashMap<String, Integer>();
    private transient Map<String, Integer> threadFirstLevel = new HashMap<String, Integer>();
    private transient Map<String, Integer> threadLevel = new HashMap<String, Integer>();
    private transient Map<String, String> threadParent = new HashMap<String, String>();
    private transient int threadsActiveCount = 0;
    private transient TestTool testTool;
    private transient boolean closed;
    private transient Storage storage;
    private transient Integer storageId;
    private transient long storageSize;
    private transient ReportXmlTransformer reportXmlTransformer;
    private transient ReportXmlTransformer globalReportXmlTransformer;
    private transient String xml;
    private transient Report originalReport;
    private transient boolean differenceChecked = false;
    private transient boolean differenceFound = false;
    private transient Map<String, String> truncatedMessageMap = new RefCompareMap<String, String>();
    private transient boolean reportFilterMatching = true;
    private transient boolean logReportFilterMatching = true;
    private transient boolean logMaxCheckpoints = true;
    private transient boolean logMaxMemoryUsage = true;
    private transient Map<Object, Set<Checkpoint>> streamingMessageListeners = new HashMap<Object, Set<Checkpoint>>();
    private transient Map<Object, StreamingMessageResult> streamingMessageResults = new HashMap<Object, StreamingMessageResult>();

    public Report() {
        this.mainThread = Thread.currentThread().getName();
        this.threads.add(this.mainThread);
        this.threadCheckpointIndex.put(this.mainThread, new Integer(0));
        this.threadFirstLevel.put(this.mainThread, new Integer(0));
        this.threadLevel.put(this.mainThread, new Integer(0));
        ++this.threadsActiveCount;
    }

    @Transient
    @JsonIgnore
    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    @Transient
    @JsonIgnore
    public TestTool getTestTool() {
        return this.testTool;
    }

    @Transient
    @JsonIgnore
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Transient
    @JsonIgnore
    public boolean isClosed() {
        return this.closed;
    }

    @Transient
    @JsonIgnore
    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    @Transient
    @JsonIgnore
    public Storage getStorage() {
        return this.storage;
    }

    public void setStorageId(Integer storageId) {
        this.storageId = storageId;
    }

    public Integer getStorageId() {
        return this.storageId;
    }

    @Transient
    @JsonIgnore
    public void setStorageSize(long storageSize) {
        this.storageSize = storageSize;
    }

    @Transient
    @JsonIgnore
    public Long getStorageSize() {
        return this.storageSize;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Transient
    @JsonIgnore
    public void setMainThreadFinishedTime(long mainThreadFinishedTime) {
        this.mainThreadFinishedTime = mainThreadFinishedTime;
    }

    @Transient
    @JsonIgnore
    public long getMainThreadFinishedTime() {
        return this.mainThreadFinishedTime;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return (StringUtils.isNotEmpty((String)this.getPath()) ? this.getPath() : "/") + this.getName();
    }

    public void setStubStrategy(String stubStrategy) {
        this.stubStrategy = stubStrategy;
    }

    public String getStubStrategy() {
        return this.stubStrategy;
    }

    public void setTransformation(String transformation) {
        this.transformation = transformation;
    }

    public String getTransformation() {
        return this.transformation;
    }

    @Transient
    @JsonIgnore
    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }

    @Transient
    @JsonIgnore
    public ReportXmlTransformer getReportXmlTransformer() {
        return this.reportXmlTransformer;
    }

    @Transient
    @JsonIgnore
    public void setGlobalReportXmlTransformer(ReportXmlTransformer globalReportXmlTransformer) {
        this.globalReportXmlTransformer = globalReportXmlTransformer;
    }

    @Transient
    @JsonIgnore
    public ReportXmlTransformer getGlobalReportXmlTransformer() {
        return this.globalReportXmlTransformer;
    }

    @Transient
    @JsonIgnore
    public void setOriginalReport(Report originalReport) {
        this.originalReport = originalReport;
    }

    @Transient
    public Report getOriginalReport() {
        return this.originalReport;
    }

    @Transient
    public void setReportFilterMatching(boolean reportFilterMatching) {
        this.reportFilterMatching = reportFilterMatching;
    }

    @Transient
    public boolean isReportFilterMatching() {
        return this.reportFilterMatching;
    }

    protected <T> T checkpoint(String childThreadId, String sourceClassName, String name, T message, StubableCode stubableCode, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, int checkpointType, int levelChangeNextCheckpoint) {
        String parentThreadName = Thread.currentThread().getName();
        if (checkpointType == 7) {
            if (!this.threads.contains(parentThreadName)) {
                log.warn("Unknown parent thread '" + parentThreadName + "' for child thread '" + childThreadId + "' , ignored checkpoint " + this.getCheckpointLogDescription(name, checkpointType, null));
            } else {
                name = "Waiting for thread '" + childThreadId + "' to start...";
                this.threadCreatepoint(parentThreadName, childThreadId);
            }
        } else if (checkpointType == 8 && !this.threads.contains(childThreadId)) {
            if (this.threads.size() == 0) {
                this.warnNewChildThreadDetected(childThreadId, null, false, name, checkpointType);
                return message;
            }
            parentThreadName = this.threads.get(this.threads.size() - 1);
            this.threadCreatepoint(parentThreadName, childThreadId);
            this.warnNewChildThreadDetected(childThreadId, parentThreadName, false, name, checkpointType);
        } else if (checkpointType == 1 && !this.threads.contains(parentThreadName)) {
            checkpointType = 8;
            childThreadId = parentThreadName;
            if (this.threads.size() == 0) {
                this.warnNewChildThreadDetected(childThreadId, null, true, name, checkpointType);
                return message;
            }
            parentThreadName = this.threads.get(this.threads.size() - 1);
            this.threadCreatepoint(parentThreadName, childThreadId);
            this.warnNewChildThreadDetected(childThreadId, parentThreadName, true, name, checkpointType);
        }
        message = this.addCheckpoint(childThreadId, sourceClassName, name, message, stubableCode, stubableCodeThrowsException, matchingStubStrategies, checkpointType, levelChangeNextCheckpoint);
        return message;
    }

    private void warnNewChildThreadDetected(String childThreadId, String parentThreadName, boolean threadStartpointNotUsed, String checkpointName, int checkpointType) {
        String parentThreadWarning = " for guessed parent thread '" + parentThreadName + "'";
        if (parentThreadName == null) {
            parentThreadWarning = " for unknown parent thread";
        }
        String startpointWarning = " before threadStartpoint()";
        if (threadStartpointNotUsed) {
            startpointWarning = " and threadStartpoint() instead of startpoint()";
        }
        log.warn("New child thread '" + childThreadId + "'" + parentThreadWarning + " detected, use threadCreatepoint()" + startpointWarning + " for checkpoint " + this.getCheckpointLogDescription(checkpointName, checkpointType, null));
    }

    private void threadCreatepoint(String parentThreadName, String childThreadId) {
        this.threads.add(this.threads.indexOf(parentThreadName), childThreadId);
        this.threadCheckpointIndex.put(childThreadId, this.threadCheckpointIndex.get(parentThreadName));
        this.threadFirstLevel.put(childThreadId, this.threadLevel.get(parentThreadName));
        this.threadLevel.put(childThreadId, this.threadLevel.get(parentThreadName));
        this.threadParent.put(childThreadId, parentThreadName);
        ++this.threadsActiveCount;
    }

    private void removeThreadCreatepoint(int index, String threadName) {
        if (index < this.checkpoints.size() && this.checkpoints.get(index).getType() == 7) {
            this.checkpoints.remove(index);
            for (int i = this.threads.indexOf(threadName) + 1; i < this.threads.size(); ++i) {
                String key = this.threads.get(i);
                Integer value = this.threadCheckpointIndex.get(key);
                this.threadCheckpointIndex.put(key, new Integer(value - 1));
            }
        }
    }

    private <T> T addCheckpoint(String childThreadId, String sourceClassName, String name, T message, StubableCode stubableCode, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, int checkpointType, int levelChangeNextCheckpoint) {
        String threadName = Thread.currentThread().getName();
        Integer index = this.threadCheckpointIndex.get(threadName);
        Integer level = this.threadLevel.get(threadName);
        if (name == null) {
            log.warn("Ignored checkpoint with null name " + this.getCheckpointLogDescription(name, checkpointType, level));
        } else {
            if (checkpointType == 8) {
                if (index == null) {
                    index = this.threadCheckpointIndex.remove(childThreadId);
                    if (index != null) {
                        this.threads.add(this.threads.indexOf(childThreadId), threadName);
                        this.threads.remove(childThreadId);
                        this.threadCheckpointIndex.put(threadName, index);
                        level = this.threadFirstLevel.remove(childThreadId);
                        this.threadFirstLevel.put(threadName, level);
                        level = this.threadLevel.remove(childThreadId);
                        this.threadLevel.put(threadName, level);
                        String parent = this.threadParent.remove(childThreadId);
                        this.threadParent.put(threadName, parent);
                    } else {
                        log.warn("Unknown childThreadId '" + childThreadId + "', use the same childThreadId when calling threadCreatepoint() and threadStartpoint()");
                    }
                }
                if (index != null) {
                    this.removeThreadCreatepoint(index, threadName);
                }
            }
            if (index == null) {
                log.warn("Unknown thread, ignored checkpoint " + this.getCheckpointLogDescription(name, checkpointType, level));
            } else {
                if (!this.isReportFilterMatching()) {
                    message = TestTool.execute(stubableCode, stubableCodeThrowsException, message);
                    if (this.logReportFilterMatching) {
                        log.debug("Report name doesn't match report filter regex, ignored checkpoint " + this.getCheckpointLogDescription(name, checkpointType, level) + " " + this.getOtherCheckpointsLogDescription());
                        this.logReportFilterMatching = false;
                    }
                } else if (this.checkpoints.size() >= this.testTool.getMaxCheckpoints()) {
                    message = TestTool.execute(stubableCode, stubableCodeThrowsException, message);
                    if (this.logMaxCheckpoints) {
                        log.warn("Maximum number of checkpoints exceeded, ignored checkpoint " + this.getCheckpointLogDescription(name, checkpointType, level) + " " + this.getOtherCheckpointsLogDescription());
                        this.logMaxCheckpoints = false;
                    }
                } else if (this.getEstimatedMemoryUsage() >= this.testTool.getMaxMemoryUsage()) {
                    message = TestTool.execute(stubableCode, stubableCodeThrowsException, message);
                    if (this.logMaxMemoryUsage) {
                        log.warn("Maximum memory usage reached for this report, ignored checkpoint " + this.getCheckpointLogDescription(name, checkpointType, level) + " " + this.getOtherCheckpointsLogDescription());
                        this.logMaxMemoryUsage = false;
                    }
                } else {
                    message = this.addCheckpoint(threadName, sourceClassName, name, message, stubableCode, stubableCodeThrowsException, matchingStubStrategies, checkpointType, index, level);
                }
                Integer newLevel = new Integer(level + levelChangeNextCheckpoint);
                this.threadLevel.put(threadName, newLevel);
                if (newLevel.equals(this.threadFirstLevel.get(threadName))) {
                    this.closeThread(threadName, false);
                }
            }
        }
        return message;
    }

    private <T> T addCheckpoint(String threadName, String sourceClassName, String name, T message, StubableCode stubableCode, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, int checkpointType, Integer index, Integer level) {
        Checkpoint checkpoint = new Checkpoint(this, threadName, sourceClassName, name, checkpointType, level);
        boolean stub = false;
        if (this.originalReport != null) {
            Path path = checkpoint.getPath(true);
            Checkpoint originalCheckpoint = this.originalReport.getCheckpoint(path);
            if (originalCheckpoint == null) {
                if (matchingStubStrategies != null) {
                    if (matchingStubStrategies.contains(this.originalReport.getStubStrategy())) {
                        stub = true;
                    }
                } else if (this.testTool.getDebugger() != null) {
                    stub = this.testTool.stub(checkpoint, this.originalReport.getStubStrategy());
                }
            } else {
                checkpoint.setStub(originalCheckpoint.getStub());
                if (originalCheckpoint.getStub() == -1) {
                    if (matchingStubStrategies != null) {
                        if (matchingStubStrategies.contains(this.originalReport.getStubStrategy())) {
                            stub = true;
                        }
                    } else if (this.testTool.getDebugger() != null) {
                        stub = this.testTool.stub(originalCheckpoint, this.originalReport.getStubStrategy());
                    }
                } else if (originalCheckpoint.getStub() == 0) {
                    stub = false;
                } else if (originalCheckpoint.getStub() == 1) {
                    stub = true;
                }
            }
            if (stub) {
                checkpoint.setStubbed(true);
                if (originalCheckpoint == null) {
                    checkpoint.setStubNotFound(path.toString());
                }
                message = this.getMessageEncoder().toObject(originalCheckpoint, message);
                message = checkpoint.setMessage(message);
            }
        }
        if (!stub) {
            try {
                message = TestTool.execute(stubableCode, stubableCodeThrowsException, message);
            }
            catch (Throwable t) {
                this.testTool.abortpoint(this.correlationId, sourceClassName, name, t.getMessage());
                throw t;
            }
            message = checkpoint.setMessage(message);
        }
        for (int i = this.threads.indexOf(threadName); i < this.threads.size(); ++i) {
            String key = this.threads.get(i);
            Integer value = this.threadCheckpointIndex.get(key);
            this.threadCheckpointIndex.put(key, new Integer(value + 1));
        }
        this.checkpoints.add(index, checkpoint);
        if (log.isDebugEnabled()) {
            log.debug("Added checkpoint " + this.getCheckpointLogDescription(name, checkpointType, level));
        }
        return message;
    }

    protected String truncateMessage(Checkpoint checkpoint, String message) {
        if (this.testTool.getMaxMessageLength() > -1 && message != null && message.toString().length() > this.testTool.getMaxMessageLength()) {
            checkpoint.setPreTruncatedMessageLength(message.length());
            if (this.truncatedMessageMap.containsKey(message)) {
                return this.truncatedMessageMap.get(message);
            }
            String truncatedMessage = message.substring(0, this.testTool.getMaxMessageLength());
            this.truncatedMessageMap.put(message, truncatedMessage);
            return truncatedMessage;
        }
        return message;
    }

    public Checkpoint getOriginalEndpointOrAbortpointForCurrentLevel() {
        Checkpoint lastCheckpoint;
        Checkpoint checkpoint;
        Checkpoint result = null;
        if (this.originalReport != null && (checkpoint = this.originalReport.getCheckpoint((lastCheckpoint = this.checkpoints.get(this.checkpoints.size() - 1)).getPath())) != null) {
            for (int i = this.originalReport.checkpoints.indexOf(checkpoint) + 1; checkpoint.getType() != 2 && checkpoint.getType() != 3 && i < this.originalReport.checkpoints.size(); ++i) {
                checkpoint = this.originalReport.checkpoints.get(i);
            }
            if (checkpoint.getType() == 2 || checkpoint.getType() == 3) {
                result = checkpoint;
            }
        }
        return result;
    }

    protected void closeThreads() {
        while (this.threads.size() > 0) {
            this.closeThread(this.threads.get(0), false);
        }
    }

    protected void closeThread(String threadName, boolean removeThreadCreatepoint) {
        if (this.threads.remove(threadName)) {
            Integer index = this.threadCheckpointIndex.remove(threadName);
            this.threadFirstLevel.remove(threadName);
            this.threadLevel.remove(threadName);
            this.threadParent.remove(threadName);
            --this.threadsActiveCount;
            if (removeThreadCreatepoint) {
                this.removeThreadCreatepoint(index, threadName);
            }
        } else {
            log.warn("Thread '" + threadName + "' to close for report with correlationId '" + this.correlationId + "' not found");
        }
    }

    protected boolean threadsFinished() {
        return this.threadsActiveCount < 1;
    }

    protected boolean mainThreadFinished() {
        return !this.threads.contains(this.mainThread);
    }

    protected boolean streamingMessageListenersFinished() {
        return this.streamingMessageListeners.size() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStreamingMessageListener(Object streamingMessage, Checkpoint checkpoint) {
        Map<Object, Set<Checkpoint>> map = this.streamingMessageListeners;
        synchronized (map) {
            Set<Checkpoint> checkpoints = this.streamingMessageListeners.get(streamingMessage);
            if (checkpoints == null) {
                checkpoints = new HashSet<Checkpoint>();
            }
            checkpoints.add(checkpoint);
            this.streamingMessageListeners.put(streamingMessage, checkpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStreamingMessageListener(Object streamingMessage, Checkpoint checkpoint) {
        Map<Object, Set<Checkpoint>> map = this.streamingMessageListeners;
        synchronized (map) {
            Set<Checkpoint> checkpoints = this.streamingMessageListeners.remove(streamingMessage);
            if (checkpoints != null) {
                checkpoints.remove(checkpoint);
                if (checkpoints.size() > 0) {
                    this.streamingMessageListeners.put(streamingMessage, checkpoints);
                }
            }
        }
    }

    protected void closeMessageCapturers() {
        for (Checkpoint checkpoint : this.checkpoints) {
            checkpoint.closeMessageCapturer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isKnownStreamingMessage(Object streamingMessage) {
        Map<Object, Set<Checkpoint>> map = this.streamingMessageListeners;
        synchronized (map) {
            return this.streamingMessageListeners.get(streamingMessage) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStreamingMessage(String messageClassName, Object streamingMessage, String streamingType, String charset, Object message, int preTruncatedMessageLength, Throwable exception) {
        StreamingMessageResult streamingMessageResult = new StreamingMessageResult();
        streamingMessageResult.setMessageClassName(messageClassName);
        streamingMessageResult.setStreamingType(streamingType);
        streamingMessageResult.setCharset(charset);
        streamingMessageResult.setMessage(message);
        streamingMessageResult.setPreTruncatedMessageLength(preTruncatedMessageLength);
        streamingMessageResult.setException(exception);
        Map<Object, Set<Checkpoint>> map = this.streamingMessageListeners;
        synchronized (map) {
            if (this.streamingMessageListeners.containsKey(streamingMessage)) {
                this.streamingMessageResults.put(streamingMessage, streamingMessageResult);
            }
            this.closeStreamingMessageListeners();
        }
        this.getTestTool().closeReportIfFinished(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStreamingMessageListeners() {
        Map<Object, Set<Checkpoint>> map = this.streamingMessageListeners;
        synchronized (map) {
            HashSet<Object> finishedStreamingMessage = new HashSet<Object>();
            for (Object streamingMessage : this.streamingMessageListeners.keySet()) {
                StreamingMessageResult streamingMessageResult = this.streamingMessageResults.remove(streamingMessage);
                if (streamingMessageResult == null) continue;
                finishedStreamingMessage.add(streamingMessage);
                for (Checkpoint checkpoint : this.streamingMessageListeners.get(streamingMessage)) {
                    checkpoint.setWaitingForStream(false);
                    checkpoint.setStreaming(streamingMessageResult.getStreamingType());
                    if (streamingMessageResult.getException() != null) {
                        checkpoint.setMessage(streamingMessageResult.getException());
                        continue;
                    }
                    Object message = streamingMessageResult.getMessage();
                    String charset = streamingMessageResult.getCharset();
                    MessageEncoder.ToStringResult toStringResult = this.getMessageEncoder().toString(message, charset);
                    checkpoint.setMessage(toStringResult.getString());
                    checkpoint.setEncoding(toStringResult.getEncoding());
                    checkpoint.setMessageClassName(streamingMessageResult.getMessageClassName());
                    checkpoint.setPreTruncatedMessageLength(streamingMessageResult.getPreTruncatedMessageLength());
                }
            }
            for (Object streamingMessage : finishedStreamingMessage) {
                this.streamingMessageListeners.remove(streamingMessage);
            }
        }
    }

    public Checkpoint getCheckpoint(Path path) {
        Checkpoint result = null;
        Iterator<Checkpoint> iterator = this.checkpoints.iterator();
        while (result == null && iterator.hasNext()) {
            Checkpoint checkpoint = iterator.next();
            if (!path.equals(checkpoint.getPath())) continue;
            result = checkpoint;
        }
        return result;
    }

    public void setCheckpoints(List<Checkpoint> checkpoints) {
        this.checkpoints = checkpoints;
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public Checkpoint getInputCheckpoint() {
        return this.checkpoints.get(0);
    }

    public int getNumberOfCheckpoints() {
        return this.checkpoints.size();
    }

    public long getEstimatedMemoryUsage() {
        long estimatedMemoryUsage = 0L;
        for (Checkpoint checkpoint : this.checkpoints) {
            estimatedMemoryUsage += checkpoint.getEstimatedMemoryUsage();
        }
        return estimatedMemoryUsage;
    }

    @Transient
    @JsonIgnore
    public void setDifferenceChecked(boolean differenceChecked) {
        this.differenceChecked = differenceChecked;
    }

    @Transient
    @JsonIgnore
    public boolean isDifferenceChecked() {
        return this.differenceChecked;
    }

    @Transient
    @JsonIgnore
    public void setDifferenceFound(boolean differenceFound) {
        this.differenceFound = differenceFound;
    }

    @Transient
    @JsonIgnore
    public boolean isDifferenceFound() {
        return this.differenceFound;
    }

    @Transient
    @JsonIgnore
    public MessageTransformer getMessageTransformer() {
        return this.testTool.getMessageTransformer();
    }

    @Transient
    @JsonIgnore
    public MessageEncoder getMessageEncoder() {
        return this.testTool.getMessageEncoder();
    }

    @Transient
    @JsonIgnore
    public MessageCapturer getMessageCapturer() {
        return this.testTool.getMessageCapturer();
    }

    public Report clone() throws CloneNotSupportedException {
        Report report = new Report();
        report.setTestTool(this.testTool);
        report.setStartTime(this.startTime);
        report.setEndTime(this.endTime);
        report.setCorrelationId(this.correlationId);
        report.setName(this.name);
        report.setDescription(this.description);
        report.setPath(this.path);
        report.setStubStrategy(this.stubStrategy);
        report.setTransformation(this.transformation);
        report.setVariableCsv(this.variableCsv);
        ArrayList<Checkpoint> checkpoints = new ArrayList<Checkpoint>();
        for (Checkpoint checkpoint : this.checkpoints) {
            checkpoint = checkpoint.clone();
            checkpoint.setReport(report);
            checkpoints.add(checkpoint);
        }
        report.setCheckpoints(checkpoints);
        return report;
    }

    public String toString() {
        return this.name;
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(ReportRunner reportRunner) {
        if (this.xml == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<Report");
            stringBuffer.append(" Name=\"" + EscapeUtil.escapeXml(this.name) + "\"");
            stringBuffer.append(" Description=\"" + EscapeUtil.escapeXml(this.description) + "\"");
            stringBuffer.append(" Path=\"" + EscapeUtil.escapeXml(this.path) + "\"");
            stringBuffer.append(" CorrelationId=\"" + EscapeUtil.escapeXml(this.correlationId) + "\"");
            stringBuffer.append(" StartTime=\"" + this.startTime + "\"");
            stringBuffer.append(" EndTime=\"" + this.endTime + "\"");
            stringBuffer.append(" NumberOfCheckpoints=\"" + this.getNumberOfCheckpoints() + "\"");
            stringBuffer.append(" EstimatedMemoryUsage=\"" + this.getEstimatedMemoryUsage() + "\"");
            stringBuffer.append(">");
            for (Checkpoint checkpoint : this.checkpoints) {
                String message = reportRunner != null && checkpoint.containsVariables() ? checkpoint.getMessageWithResolvedVariables(reportRunner) : checkpoint.getMessage();
                stringBuffer.append("<Checkpoint");
                stringBuffer.append(" Name=\"" + EscapeUtil.escapeXml(checkpoint.getName()) + "\"");
                stringBuffer.append(" Type=\"" + EscapeUtil.escapeXml(checkpoint.getTypeAsString()) + "\"");
                stringBuffer.append(" Level=\"" + checkpoint.getLevel() + "\"");
                if (checkpoint.getSourceClassName() != null) {
                    stringBuffer.append(" SourceClassName=\"" + EscapeUtil.escapeXml(checkpoint.getSourceClassName()) + "\"");
                }
                if (checkpoint.getMessageClassName() != null) {
                    stringBuffer.append(" MessageClassName=\"" + EscapeUtil.escapeXml(checkpoint.getMessageClassName()) + "\"");
                }
                if (checkpoint.getPreTruncatedMessageLength() != -1) {
                    stringBuffer.append(" PreTruncatedMessageLength=\"" + checkpoint.getPreTruncatedMessageLength() + "\"");
                }
                if (checkpoint.getEncoding() != null) {
                    stringBuffer.append(" Encoding=\"" + EscapeUtil.escapeXml(checkpoint.getEncoding()) + "\"");
                }
                if (checkpoint.getStreaming() != null) {
                    stringBuffer.append(" Streaming=\"" + EscapeUtil.escapeXml(checkpoint.getStreaming()) + "\"");
                }
                if (checkpoint.isWaitingForStream()) {
                    stringBuffer.append(" WaitingForStream=\"" + checkpoint.isWaitingForStream() + "\"");
                }
                if (checkpoint.getStub() != -1) {
                    stringBuffer.append(" Stub=\"" + checkpoint.getStub() + "\"");
                }
                if (checkpoint.isStubbed()) {
                    stringBuffer.append(" Stubbed=\"" + checkpoint.isStubbed() + "\"");
                }
                if (checkpoint.getStubNotFound() != null) {
                    stringBuffer.append(" StubNotFound=\"" + checkpoint.getStubNotFound() + "\"");
                }
                if (message == null) {
                    stringBuffer.append(" Null=\"true\"/>");
                    continue;
                }
                if (XmlUtil.isXml(message)) {
                    String textDecl = null;
                    if (message.startsWith("<?")) {
                        int i = message.indexOf("?>") + 2;
                        textDecl = message.substring(0, i);
                        stringBuffer.append(" TextDecl=\"");
                        stringBuffer.append(EscapeUtil.escapeXml(textDecl));
                        stringBuffer.append("\">");
                        message = message.substring(i);
                    } else {
                        stringBuffer.append(">");
                    }
                    stringBuffer.append(message);
                } else {
                    stringBuffer.append(">");
                    stringBuffer.append(EscapeUtil.escapeXml(message));
                }
                stringBuffer.append("</Checkpoint>");
            }
            stringBuffer.append("</Report>");
            this.xml = stringBuffer.toString();
            if (this.reportXmlTransformer != null || this.transformation != null && this.transformation.trim().length() > 0) {
                if (this.reportXmlTransformer == null) {
                    this.reportXmlTransformer = new ReportXmlTransformer();
                    this.reportXmlTransformer.setXslt(this.transformation);
                }
                this.xml = this.reportXmlTransformer.transform(this.xml);
            } else if (this.globalReportXmlTransformer != null) {
                this.xml = this.globalReportXmlTransformer.transform(this.xml);
            }
        }
        return this.xml;
    }

    public void flushCachedXml() {
        this.reportXmlTransformer = null;
        this.xml = null;
    }

    private String getCheckpointLogDescription(String name, int type, Integer level) {
        return Report.getCheckpointLogDescription(name, type, level, this.correlationId);
    }

    protected static String getCheckpointLogDescription(String name, int type, Integer level, String correlationId) {
        return "(name: " + name + ", type: " + Checkpoint.getTypeAsString(type) + ", level: " + level + ", correlationId: " + correlationId + ")";
    }

    private String getOtherCheckpointsLogDescription() {
        return "(next checkpoints for this report will be ignored without any logging)";
    }

    public String getVariableCsv() {
        return this.variableCsv;
    }

    public void setVariableCsv(String variableCsv) {
        if (StringUtils.isEmpty((String)variableCsv)) {
            this.variableCsv = null;
            return;
        }
        String errorMessage = CsvUtil.validateCsv(variableCsv, ";", 2);
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
        this.variableCsv = variableCsv;
    }

    public String setVariableCsvWithoutException(String variableCsv) {
        try {
            this.setVariableCsv(variableCsv);
            return null;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    public Map<String, String> getVariablesAsMap() {
        if (StringUtils.isEmpty((String)this.variableCsv)) {
            return null;
        }
        LinkedHashMap<String, String> variableMap = new LinkedHashMap<String, String>();
        Scanner scanner = new Scanner(this.variableCsv);
        ArrayList<String> lines = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            if (!StringUtils.isNotEmpty((String)nextLine) || nextLine.startsWith("#")) continue;
            lines.add(nextLine);
        }
        scanner.close();
        List<String> params = Arrays.asList(((String)lines.get(0)).split(";"));
        for (String key : params) {
            String value = ((String)lines.get(1)).split(";")[params.indexOf(key)];
            variableMap.put(key, value);
        }
        return variableMap;
    }
}

