/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool;

import java.lang.invoke.MethodHandles;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Debugger;
import nl.nn.testtool.ExternalConnectionCode;
import nl.nn.testtool.ExternalConnectionCodeThrowsException;
import nl.nn.testtool.MessageCapturer;
import nl.nn.testtool.MessageCapturerImpl;
import nl.nn.testtool.MessageEncoder;
import nl.nn.testtool.MessageEncoderImpl;
import nl.nn.testtool.Report;
import nl.nn.testtool.Rerunner;
import nl.nn.testtool.SecurityContext;
import nl.nn.testtool.StubableCode;
import nl.nn.testtool.StubableCodeThrowsException;
import nl.nn.testtool.filter.View;
import nl.nn.testtool.filter.Views;
import nl.nn.testtool.run.ReportRunner;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.LogStorage;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.transform.MessageTransformer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTool {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Logger securityLog;
    private String configName;
    private String configVersion;
    private int maxCheckpoints = 2500;
    private int maxMessageLength = 10000000;
    private long maxMemoryUsage = 100000000L;
    private Debugger debugger;
    private Rerunner rerunner;
    private boolean reportGeneratorEnabled = true;
    private List<Report> reportsInProgress = new ArrayList<Report>();
    private Map<String, Report> reportsInProgressByCorrelationId = new HashMap<String, Report>();
    private long numberOfReportsInProgress = 0L;
    private Map<String, Report> originalReports = new HashMap<String, Report>();
    private LogStorage debugStorage;
    private CrudStorage testStorage;
    private MessageEncoder messageEncoder = new MessageEncoderImpl();
    private MessageCapturer messageCapturer = new MessageCapturerImpl();
    private MessageTransformer messageTransformer;
    private String regexFilter;
    private String defaultStubStrategy = "Stub all external connection code";
    private List<String> stubStrategies = new ArrayList<String>();
    private Set<String> matchingStubStrategiesForExternalConnectionCode;
    private boolean closeThreads;
    private boolean closeMessageCapturers;
    private Views views;

    public TestTool() {
        this.stubStrategies.add(this.defaultStubStrategy);
        this.matchingStubStrategiesForExternalConnectionCode = new HashSet<String>(this.stubStrategies);
        this.closeThreads = false;
        this.closeMessageCapturers = false;
    }

    public void setSecurityLoggerName(String securityLoggerName) {
        securityLog = LoggerFactory.getLogger((String)securityLoggerName);
    }

    public Logger getSecurityLog() {
        return securityLog;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigVersion(String configVersion) {
        this.configVersion = configVersion;
    }

    public String getConfigVersion() {
        return this.configVersion;
    }

    public void setMaxCheckpoints(int maxCheckpoints) {
        this.maxCheckpoints = maxCheckpoints;
    }

    public int getMaxCheckpoints() {
        return this.maxCheckpoints;
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMemoryUsage(long maxMemoryUsage) {
        this.maxMemoryUsage = maxMemoryUsage;
    }

    public long getMaxMemoryUsage() {
        return this.maxMemoryUsage;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void setRerunner(Rerunner rerunner) {
        this.rerunner = rerunner;
    }

    public Rerunner getRerunner() {
        return this.rerunner;
    }

    public void setReportGeneratorEnabled(boolean reportGeneratorEnabled) {
        this.reportGeneratorEnabled = reportGeneratorEnabled;
    }

    public boolean isReportGeneratorEnabled() {
        return this.reportGeneratorEnabled;
    }

    public void sendReportGeneratorStatusUpdate() {
        if (this.debugger != null) {
            this.debugger.updateReportGeneratorStatus(this.isReportGeneratorEnabled());
        }
    }

    public void setMessageEncoder(MessageEncoder messageEncoder) {
        this.messageEncoder = messageEncoder;
    }

    public MessageEncoder getMessageEncoder() {
        return this.messageEncoder;
    }

    public void setMessageTransformer(MessageTransformer messageTransformer) {
        this.messageTransformer = messageTransformer;
    }

    public MessageTransformer getMessageTransformer() {
        return this.messageTransformer;
    }

    public void setMessageCapturer(MessageCapturer messageCapturer) {
        this.messageCapturer = messageCapturer;
    }

    public MessageCapturer getMessageCapturer() {
        return this.messageCapturer;
    }

    public void setRegexFilter(String regexFilter) {
        this.regexFilter = regexFilter;
    }

    public String getRegexFilter() {
        return this.regexFilter;
    }

    public void setDefaultStubStrategy(String defaultStubStrategy) {
        this.defaultStubStrategy = defaultStubStrategy;
    }

    public String getDefaultStubStrategy() {
        if (this.debugger == null) {
            return this.defaultStubStrategy;
        }
        return this.debugger.getDefaultStubStrategy();
    }

    public void setStubStrategies(List<String> stubStrategies) {
        this.stubStrategies = stubStrategies;
    }

    public List<String> getStubStrategies() {
        if (this.debugger == null) {
            return this.stubStrategies;
        }
        return this.debugger.getStubStrategies();
    }

    public void setMatchingStubStrategiesForExternalConnectionCode(Set<String> matchingStubStrategiesForExternalConnectionCode) {
        this.matchingStubStrategiesForExternalConnectionCode = matchingStubStrategiesForExternalConnectionCode;
    }

    public Set<String> getMatchingStubStrategiesForExternalConnectionCode() {
        return this.matchingStubStrategiesForExternalConnectionCode;
    }

    public void setCloseThreads(boolean closeThreads) {
        this.closeThreads = closeThreads;
    }

    public boolean isCloseThreads() {
        return this.closeThreads;
    }

    public void setCloseMessageCapturers(boolean closeMessageCapturers) {
        this.closeMessageCapturers = closeMessageCapturers;
    }

    public boolean isCloseMessageCapturers() {
        return this.closeMessageCapturers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T checkpoint(String correlationId, String childThreadId, String sourceClassName, String name, T message, StubableCode stubableCode, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, int checkpointType, int levelChangeNextCheckpoint) {
        boolean executeStubableCode = true;
        if (this.reportGeneratorEnabled) {
            Report report = this.getReportInProgress(correlationId, name, checkpointType);
            while (report != null) {
                Report report2 = report;
                synchronized (report2) {
                    if (report.isClosed()) {
                        report = this.getReportInProgress(correlationId, name, checkpointType);
                        continue;
                    }
                    executeStubableCode = false;
                    message = report.checkpoint(childThreadId, sourceClassName, name, message, stubableCode, stubableCodeThrowsException, matchingStubStrategies, checkpointType, levelChangeNextCheckpoint);
                    this.closeReportIfFinished(report);
                }
                report = null;
            }
        }
        if (executeStubableCode) {
            message = TestTool.execute(stubableCode, stubableCodeThrowsException, message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Report getReportInProgress(String correlationId, String name, int checkpointType) {
        Report report;
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            report = this.reportsInProgressByCorrelationId.get(correlationId);
            if (report == null) {
                if (checkpointType == 1) {
                    Report originalReport;
                    log.debug("Create new report for '" + correlationId + "'");
                    report = new Report();
                    report.setStartTime(System.currentTimeMillis());
                    report.setTestTool(this);
                    report.setCorrelationId(correlationId);
                    report.setName(name);
                    if (StringUtils.isNotEmpty((String)this.regexFilter) && !name.matches(this.regexFilter)) {
                        report.setReportFilterMatching(false);
                    }
                    Map<String, Report> map = this.originalReports;
                    synchronized (map) {
                        originalReport = this.originalReports.remove(correlationId);
                    }
                    if (originalReport == null) {
                        report.setStubStrategy(this.getDefaultStubStrategy());
                    } else {
                        report.setStubStrategy(originalReport.getStubStrategy());
                        report.setOriginalReport(originalReport);
                    }
                    this.reportsInProgress.add(0, report);
                    this.reportsInProgressByCorrelationId.put(correlationId, report);
                    ++this.numberOfReportsInProgress;
                } else {
                    log.warn("No report in progress for correlationId and checkpoint not a startpoint, ignored checkpoint " + Report.getCheckpointLogDescription(name, checkpointType, null, correlationId));
                }
            }
        }
        return report;
    }

    protected static <T> T execute(StubableCode stubableCode, StubableCodeThrowsException stubableCodeThrowsException, T message) {
        if (stubableCode != null) {
            message = stubableCode.execute();
        }
        if (stubableCodeThrowsException != null) {
            message = stubableCodeThrowsException.execute();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeReportIfFinished(Report report) {
        Report report2 = report;
        synchronized (report2) {
            if (!report.isClosed()) {
                if (report.mainThreadFinished()) {
                    if (!report.threadsFinished() && this.closeThreads) {
                        report.closeThreads();
                    }
                    if (report.getMainThreadFinishedTime() == Long.MIN_VALUE) {
                        report.setMainThreadFinishedTime(System.currentTimeMillis());
                    }
                }
                if (report.threadsFinished()) {
                    if (report.getEndTime() == Long.MIN_VALUE) {
                        report.setEndTime(System.currentTimeMillis());
                    }
                    if (!report.streamingMessageListenersFinished() && this.closeMessageCapturers) {
                        report.closeMessageCapturers();
                    }
                    if (!report.isClosed() && report.streamingMessageListenersFinished()) {
                        report.setClosed(true);
                        log.debug("Report is finished for '" + report.getCorrelationId() + "'");
                        List<Report> list = this.reportsInProgress;
                        synchronized (list) {
                            this.reportsInProgress.remove(report);
                            this.reportsInProgressByCorrelationId.remove(report.getCorrelationId());
                            --this.numberOfReportsInProgress;
                        }
                        if (report.isReportFilterMatching()) {
                            this.debugStorage.storeWithoutException(report);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean warnReportsInProgress() {
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            for (Report report : this.reportsInProgress) {
                if (this.messageCapturerWaitingForClose(report) || report.getStartTime() + 300000L >= System.currentTimeMillis()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean warnMessageCapturerWaitingForClose() {
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            for (Report report : this.reportsInProgress) {
                if (!this.messageCapturerWaitingForClose(report) || report.getEndTime() + 30000L >= System.currentTimeMillis()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean messageCapturerWaitingForClose(Report report) {
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            return report.threadsFinished() && !report.streamingMessageListenersFinished();
        }
    }

    public <T> T startpoint(String correlationId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, null, 1, 1);
    }

    public <T> T startpoint(String correlationId, String sourceClassName, String name, T message, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, matchingStubStrategies, 1, 1);
    }

    public <T> T startpoint(String correlationId, String sourceClassName, String name, StubableCode stubableCode, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, stubableCode, null, matchingStubStrategies, 1, 1);
    }

    public <E extends Exception> Object startpoint(String correlationId, String sourceClassName, String name, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, E throwsException) throws E {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, null, stubableCodeThrowsException, matchingStubStrategies, 1, 1);
    }

    public <T> T endpoint(String correlationId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, null, 2, -1);
    }

    public <T> T endpoint(String correlationId, String sourceClassName, String name, T message, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, matchingStubStrategies, 2, -1);
    }

    public <T> T endpoint(String correlationId, String sourceClassName, String name, StubableCode stubableCode, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, stubableCode, null, matchingStubStrategies, 2, -1);
    }

    public <T, E extends Exception> T endpoint(String correlationId, String sourceClassName, String name, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, E throwsException) throws E {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, null, stubableCodeThrowsException, matchingStubStrategies, 2, -1);
    }

    public <T> T endpoint(String correlationId, String sourceClassName, String name, ExternalConnectionCode externalConnectionCode) {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, externalConnectionCode, null, this.matchingStubStrategiesForExternalConnectionCode, 2, -1);
    }

    public <T, E extends Exception> T endpoint(String correlationId, String sourceClassName, String name, ExternalConnectionCodeThrowsException externalConnectionCodeThrowsException, E throwsException) throws E {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, null, externalConnectionCodeThrowsException, this.matchingStubStrategiesForExternalConnectionCode, 2, -1);
    }

    public <T> T inputpoint(String correlationId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, null, 4, 0);
    }

    public <T> T inputpoint(String correlationId, String sourceClassName, String name, T message, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, matchingStubStrategies, 4, 0);
    }

    public <T> T inputpoint(String correlationId, String sourceClassName, String name, StubableCode stubableCode, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, stubableCode, null, matchingStubStrategies, 4, 0);
    }

    public <T, E extends Exception> T inputpoint(String correlationId, String sourceClassName, String name, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, E throwsException) throws E {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, null, stubableCodeThrowsException, matchingStubStrategies, 4, 0);
    }

    public <T> T outputpoint(String correlationId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, null, 5, 0);
    }

    public <T> T outputpoint(String correlationId, String sourceClassName, String name, T message, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, matchingStubStrategies, 5, 0);
    }

    public <T> T outputpoint(String correlationId, String sourceClassName, String name, StubableCode stubableCode, Set<String> matchingStubStrategies) {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, stubableCode, null, matchingStubStrategies, 5, 0);
    }

    public <T, E extends Exception> T outputpoint(String correlationId, String sourceClassName, String name, StubableCodeThrowsException stubableCodeThrowsException, Set<String> matchingStubStrategies, E throwsException) throws E {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, null, stubableCodeThrowsException, matchingStubStrategies, 5, 0);
    }

    public <T> T outputpoint(String correlationId, String sourceClassName, String name, ExternalConnectionCode externalConnectionCode) {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, externalConnectionCode, null, this.matchingStubStrategiesForExternalConnectionCode, 5, 0);
    }

    public <T, E extends Exception> T outputpoint(String correlationId, String sourceClassName, String name, ExternalConnectionCodeThrowsException externalConnectionCodeThrowsException, E throwsException) throws E {
        return this.checkpoint(correlationId, null, sourceClassName, name, null, null, externalConnectionCodeThrowsException, this.matchingStubStrategiesForExternalConnectionCode, 5, 0);
    }

    public <T> T infopoint(String correlationId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, null, 6, 0);
    }

    public <T> T abortpoint(String correlationId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, null, 3, -1);
    }

    public void threadCreatepoint(String correlationId, String childThreadId) {
        this.checkpoint(correlationId, childThreadId, null, null, null, null, null, null, 7, 0);
    }

    public <T> T threadStartpoint(String correlationId, String childThreadId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, childThreadId, sourceClassName, name, message, null, null, null, 8, 1);
    }

    public <T> T threadStartpoint(String correlationId, String sourceClassName, String name, T message) {
        return this.threadStartpoint(correlationId, Thread.currentThread().getName(), sourceClassName, name, message);
    }

    public <T> T threadEndpoint(String correlationId, String sourceClassName, String name, T message) {
        return this.checkpoint(correlationId, null, sourceClassName, name, message, null, null, null, 9, -1);
    }

    public void close(String correlationId) {
        this.close(correlationId, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String correlationId, boolean closeThreads, boolean closeMessageCapturers) {
        if (closeThreads) {
            this.close(correlationId, null);
        }
        if (closeMessageCapturers) {
            Report report;
            Object object = this.reportsInProgress;
            synchronized (object) {
                report = this.reportsInProgressByCorrelationId.get(correlationId);
            }
            if (report != null) {
                object = report;
                synchronized (object) {
                    report.closeMessageCapturers();
                    this.closeReportIfFinished(report);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String correlationId, String threadName) {
        Report report;
        Object object = this.reportsInProgress;
        synchronized (object) {
            report = this.reportsInProgressByCorrelationId.get(correlationId);
        }
        if (report != null) {
            object = report;
            synchronized (object) {
                if (threadName == null) {
                    report.closeThreads();
                } else {
                    report.closeThread(threadName, true);
                }
                this.closeReportIfFinished(report);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(long threadsTime, long messageCapturersTime, boolean waitForMainThreadToFinish) {
        HashSet<Report> reports = new HashSet<Report>();
        Object object = this.reportsInProgress;
        synchronized (object) {
            for (Report report : this.reportsInProgress) {
                reports.add(report);
            }
        }
        object = reports.iterator();
        while (object.hasNext()) {
            Report report;
            Report report2 = report = (Report)object.next();
            synchronized (report2) {
                boolean closeThreads = false;
                boolean closeMessageCapturers = false;
                if (waitForMainThreadToFinish) {
                    if (report.mainThreadFinished()) {
                        if (report.getMainThreadFinishedTime() + threadsTime <= System.currentTimeMillis() && threadsTime != -1L) {
                            closeThreads = true;
                        }
                        if (report.getMainThreadFinishedTime() + messageCapturersTime <= System.currentTimeMillis() && messageCapturersTime != -1L) {
                            closeMessageCapturers = true;
                        }
                    }
                } else {
                    if (report.getStartTime() + threadsTime <= System.currentTimeMillis() && threadsTime != -1L) {
                        closeThreads = true;
                    }
                    if (report.getStartTime() + messageCapturersTime <= System.currentTimeMillis() && messageCapturersTime != -1L) {
                        closeMessageCapturers = true;
                    }
                }
                this.close(report.getCorrelationId(), closeThreads, closeMessageCapturers);
                this.closeReportIfFinished(report);
            }
        }
    }

    public static String getCorrelationId() {
        return TestTool.getName().replaceAll(" ", "_") + "-" + TestTool.getVersion().replaceAll(" ", "_") + "-" + new UID().toString();
    }

    public String rerun(Report report, SecurityContext securityContext) {
        return this.rerun(null, report, securityContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rerun(String correlationId, Report report, SecurityContext securityContext, ReportRunner reportRunner) {
        String errorMessage = null;
        if (this.rerunner == null && this.debugger == null) {
            errorMessage = "No rerunner or debugger configured";
        } else if (this.rerunner != null && this.debugger != null) {
            errorMessage = "Both rerunner and debugger configured";
        } else {
            boolean reportGeneratorEnabled;
            if (correlationId == null) {
                correlationId = TestTool.getCorrelationId();
            }
            if (reportGeneratorEnabled = this.isReportGeneratorEnabled()) {
                Map<String, Report> map = this.originalReports;
                synchronized (map) {
                    this.originalReports.put(correlationId, report);
                }
            }
            try {
                errorMessage = this.rerunner != null ? this.rerunner.rerun(correlationId, report, securityContext, reportRunner) : this.debugger.rerun(correlationId, report, securityContext, reportRunner);
            }
            finally {
                if (reportGeneratorEnabled) {
                    Report originalReport;
                    Map<String, Report> map = this.originalReports;
                    synchronized (map) {
                        originalReport = this.originalReports.remove(correlationId);
                    }
                    if (errorMessage == null && originalReport != null) {
                        errorMessage = "Rerun didn't trigger any checkpoint or new report didn't get correlationId '" + correlationId + "'";
                    }
                }
            }
        }
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Checkpoint getOriginalEndpointOrAbortpointForCurrentLevel(String correlationId) {
        Checkpoint result = null;
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            Report report = this.reportsInProgressByCorrelationId.get(correlationId);
            if (report != null) {
                result = report.getOriginalEndpointOrAbortpointForCurrentLevel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report getReportInProgress(String correlationId) {
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            return this.reportsInProgressByCorrelationId.get(correlationId);
        }
    }

    public boolean stub(Checkpoint checkpoint, String strategy) {
        return this.debugger.stub(checkpoint, strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report getReportInProgress(int index) {
        Report reportClone = null;
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            if (index > -1 && index < this.reportsInProgress.size()) {
                Report report = this.reportsInProgress.get(index);
                try {
                    reportClone = report.clone();
                }
                catch (CloneNotSupportedException e) {
                    log.error("Unable to clone report in progress", (Throwable)e);
                }
            }
        }
        return reportClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report removeReportInProgress(int index) {
        Report report = null;
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            if (index > -1 && index < this.reportsInProgress.size()) {
                report = this.reportsInProgress.remove(index);
                --this.numberOfReportsInProgress;
            }
        }
        return report;
    }

    public long getNumberOfReportsInProgress() {
        return this.numberOfReportsInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReportsInProgressEstimatedMemoryUsage() {
        long reportsInProgressEstimatedMemoryUsage = 0L;
        List<Report> list = this.reportsInProgress;
        synchronized (list) {
            for (Report report : this.reportsInProgress) {
                reportsInProgressEstimatedMemoryUsage += report.getEstimatedMemoryUsage();
            }
        }
        return reportsInProgressEstimatedMemoryUsage;
    }

    public Storage getStorage(String name) {
        for (View view : this.views) {
            Storage storage = view.getStorage();
            if (!name.equals(storage.getName())) continue;
            return storage;
        }
        if (name.equals("Test")) {
            return this.getTestStorage();
        }
        return null;
    }

    public static String getName() {
        return Package.getPackage("nl.nn.testtool").getSpecificationTitle();
    }

    public static String getVersion() {
        return TestTool.getImplementationVersion();
    }

    public static String getSpecificationVersion() {
        return Package.getPackage("nl.nn.testtool").getSpecificationVersion();
    }

    public static String getImplementationVersion() {
        return Package.getPackage("nl.nn.testtool").getImplementationVersion();
    }

    public void setDebugStorage(LogStorage debugStorage) {
        this.debugStorage = debugStorage;
    }

    public LogStorage getDebugStorage() {
        return this.debugStorage;
    }

    public void setTestStorage(CrudStorage testStorage) {
        this.testStorage = testStorage;
    }

    public CrudStorage getTestStorage() {
        return this.testStorage;
    }

    public void setViews(Views views) {
        this.views = views;
    }

    public Views getViews() {
        return this.views;
    }
}

