/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2;

import java.lang.invoke.MethodHandles;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import nl.nn.testtool.echo2.Echo2Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseComponent
extends Column {
    private static final long serialVersionUID = 1L;
    protected Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Label errorLabel;
    protected Label okayLabel;

    public void initBean() {
        this.setInsets(new Insets(10));
        this.errorLabel = Echo2Application.createErrorLabelWithColumnLayoutData();
        this.errorLabel.setVisible(false);
        this.okayLabel = Echo2Application.createOkayLabelWithColumnLayoutData();
        this.okayLabel.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.hideMessages();
    }

    public void displayOkay(String message) {
        if (message != null) {
            this.displayMessage(this.okayLabel, message);
        }
    }

    public void displayError(String message) {
        if (message != null) {
            this.handleError(message, false, null, null);
        }
    }

    public void displayAndLogError(String message) {
        if (message != null) {
            this.handleError(message, true, message, null);
        }
    }

    public void displayAndLogError(Throwable t) {
        this.handleError(t.getClass().getName() + ": " + t.getMessage(), true, null, t);
    }

    private void handleError(String displayMessage, boolean useLog, String logMessage, Throwable t) {
        if (useLog) {
            if (t == null) {
                this.log.error(logMessage);
            } else {
                if (logMessage == null) {
                    logMessage = t.getMessage();
                }
                this.log.error(logMessage, t);
            }
        }
        this.displayMessage(this.errorLabel, displayMessage);
    }

    private void displayMessage(Label label, String message) {
        if (label.isVisible()) {
            label.setText(label.getText() + " [" + message + "]");
        } else {
            label.setText("[" + message + "]");
            label.setVisible(true);
        }
    }

    protected void hideMessages() {
        this.errorLabel.setVisible(false);
        this.okayLabel.setVisible(false);
    }
}

