/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2;

import echopointng.tree.DefaultMutableTreeNode;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.layout.ColumnLayoutData;
import nextapp.echo2.app.layout.RowLayoutData;
import nextapp.echo2.extras.app.TabPane;
import nextapp.echo2.extras.app.layout.TabPaneLayoutData;
import nextapp.echo2.webcontainer.ContainerContext;
import nl.nn.testtool.Report;
import nl.nn.testtool.SecurityContext;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.echo2.BaseComponent;
import nl.nn.testtool.echo2.BeanParent;
import nl.nn.testtool.echo2.ComparePane;
import nl.nn.testtool.echo2.ReportPane;
import nl.nn.testtool.echo2.Tab;
import nl.nn.testtool.echo2.TabPaneListener;
import nl.nn.testtool.echo2.Tabs;
import nl.nn.testtool.echo2.TransformationWindow;
import nl.nn.testtool.echo2.reports.CheckpointComponent;
import nl.nn.testtool.echo2.reports.InfoPane;
import nl.nn.testtool.echo2.reports.PathComponent;
import nl.nn.testtool.echo2.reports.ReportComponent;
import nl.nn.testtool.echo2.reports.ReportsComponent;
import nl.nn.testtool.echo2.reports.ReportsTreeCellRenderer;
import nl.nn.testtool.echo2.reports.TreePane;
import nl.nn.testtool.run.ReportRunner;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.transform.ReportXmlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Echo2Application
extends ApplicationInstance
implements ApplicationContextAware,
BeanParent,
SecurityContext {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Color MAIN_COLOR_BUTTON = new Color(135, 160, 184);
    private static Color MAIN_COLOR_BUTTON_ROLLOVER = new Color(162, 182, 200);
    private static Color MAIN_COLOR_BUTTON_PRESSED = new Color(202, 214, 223);
    private static Color applicationBackgroundColor = Color.WHITE;
    private static Color paneBackgroundColor = MAIN_COLOR_BUTTON_PRESSED;
    private static Color buttonForegroundColor = Color.WHITE;
    private static Color buttonBackgroundColor = MAIN_COLOR_BUTTON;
    private static Color buttonPressedBackgroundColor = MAIN_COLOR_BUTTON_PRESSED;
    private static Color buttonRolloverBackgroundColor = MAIN_COLOR_BUTTON_ROLLOVER;
    private static Border buttonBorder = new Border(1, Color.BLACK, 7);
    private static Border buttonRolloverBorder = new Border(1, Color.DARKGRAY, 7);
    private static Color errorBackgroundColor = new Color(216, 73, 83);
    private static Color errorForegroundColor = Color.WHITE;
    private static Color okayBackgroundColor = new Color(83, 216, 73);
    private static Color okayForegroundColor = Color.WHITE;
    private static Color differenceFoundLabelColor = Color.RED;
    private static Color noDifferenceFoundLabelColor = new Color(59, 152, 59);
    private static Color differenceFoundTextColor = Color.RED;
    private static Color noDifferenceFoundTextColor = noDifferenceFoundLabelColor;
    private static Color lineNumberTextColor = Color.WHITE;
    private static Font messageFont = new Font(Font.MONOSPACE, 0, new Extent(12));
    private static ColumnLayoutData columnLayoutDataForLabel = new ColumnLayoutData();
    private static RowLayoutData rowLayoutDataForLabel;
    private ApplicationContext applicationContext;
    private ContentPane contentPane;
    private TabPane tabPane;
    private Tabs tabs;
    private List<Integer> activeTabIndexHistory = new ArrayList<Integer>();
    private TransformationWindow transformationWindow;
    private TestTool testTool;
    private ReportXmlTransformer reportXmlTransformer;
    private ReportsTreeCellRenderer reportsTreeCellRenderer;
    private CrudStorage testStorage;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setContentPane(ContentPane contentPane) {
        this.contentPane = contentPane;
    }

    public ContentPane getContentPane() {
        return this.contentPane;
    }

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }

    public void setReportsTreeCellRenderer(ReportsTreeCellRenderer reportsTreeCellRenderer) {
        this.reportsTreeCellRenderer = reportsTreeCellRenderer;
    }

    public void setTabs(Tabs tabs) {
        this.tabs = tabs;
    }

    public Tabs getTabs() {
        return this.tabs;
    }

    public void setTestStorage(CrudStorage testStorage) {
        this.testStorage = testStorage;
    }

    public TransformationWindow getTransformationWindow() {
        return this.transformationWindow;
    }

    public void initBean() {
        this.contentPane.setBackground(applicationBackgroundColor);
        this.transformationWindow = new TransformationWindow();
        this.tabPane = new TabPane();
        this.tabPane.setBackground(paneBackgroundColor);
        this.tabPane.setTabActiveBackground(buttonBackgroundColor);
        this.tabPane.setTabActiveForeground(buttonForegroundColor);
        this.tabPane.setTabInactiveBackground(paneBackgroundColor);
        this.tabPane.addPropertyChangeListener((PropertyChangeListener)new TabPaneListener(this));
        this.transformationWindow.setReportXmlTransformer(this.reportXmlTransformer);
        for (ContentPane tab : this.tabs) {
            this.tabPane.add((Component)tab);
        }
        this.contentPane.add((Component)this.transformationWindow);
        this.contentPane.add((Component)this.tabPane);
        this.transformationWindow.initBean();
        this.initBean(this);
    }

    @Override
    public void initBean(BeanParent beanParent) {
        this.tabs.initBean(this);
    }

    @Override
    public BeanParent getBeanParent() {
        return null;
    }

    public static Echo2Application getEcho2Application(BeanParent beanParent, Object child) {
        String message = beanParent.getClass().getSimpleName() + "(" + beanParent.hashCode() + "), " + child.getClass().getSimpleName() + "(" + child.hashCode() + ")";
        while (beanParent.getBeanParent() != null) {
            beanParent = beanParent.getBeanParent();
            message = beanParent.getClass().getSimpleName() + "(" + beanParent.hashCode() + "), " + message;
        }
        message = "BeanParent path: " + message;
        log.debug(message);
        return (Echo2Application)beanParent;
    }

    public Window init() {
        String version = TestTool.getName() + " " + TestTool.getVersion();
        if (this.testTool.getConfigName() != null) {
            version = version + " - " + this.testTool.getConfigName();
            if (this.testTool.getConfigVersion() != null) {
                version = version + " " + this.testTool.getConfigVersion();
            }
        }
        Window window = new Window();
        window.setTitle(version);
        window.setContent(this.contentPane);
        return window;
    }

    public Report getReport(Storage storage, Integer storageId, BaseComponent baseComponent) {
        Report report = null;
        try {
            report = storage.getReport(storageId);
            if (report == null) {
                baseComponent.displayAndLogError("Report with storage id '" + storageId + "' not found");
            }
        }
        catch (StorageException storageException) {
            baseComponent.displayAndLogError(storageException);
        }
        if (report != null) {
            report.setTestTool(this.testTool);
        }
        return report;
    }

    public void openReport(Report report, String isOpenReportAllowed) {
        boolean reportFound = false;
        for (int i = 0; i < this.tabPane.getComponentCount(); ++i) {
            Component component = this.tabPane.getComponent(i);
            if (!(component instanceof ReportPane) || ((ReportPane)component).getReport().getStorageId().intValue() != report.getStorageId().intValue()) continue;
            this.tabPane.setActiveTabIndex(i);
            reportFound = true;
        }
        if (!reportFound) {
            ReportPane reportPane = new ReportPane();
            TabPaneLayoutData tabPaneLayoutReportPane = new TabPaneLayoutData();
            TreePane treePane = new TreePane();
            InfoPane infoPane = new InfoPane();
            PathComponent pathComponent = new PathComponent();
            reportPane.setLayoutData((LayoutData)tabPaneLayoutReportPane);
            reportPane.setReport(report);
            reportPane.setTreePane(treePane);
            reportPane.setInfoPane(infoPane);
            String title = report.getName();
            if (title.length() > 10) {
                title = title.subSequence(0, 10) + "...";
            }
            tabPaneLayoutReportPane.setTitle(title);
            treePane.setInfoPane(infoPane);
            treePane.setReportsTreeCellRenderer(this.reportsTreeCellRenderer);
            ReportComponent reportComponent = new ReportComponent();
            reportComponent.setTestTool(this.testTool);
            reportComponent.setTestStorage(this.testStorage);
            reportComponent.setTreePane(treePane);
            reportComponent.setInfoPane(infoPane);
            reportComponent.initBean();
            reportComponent.initBean(this);
            CheckpointComponent checkpointComponent = new CheckpointComponent();
            checkpointComponent.setTestTool(this.testTool);
            checkpointComponent.setTreePane(treePane);
            checkpointComponent.setInfoPane(infoPane);
            checkpointComponent.initBean();
            checkpointComponent.initBean(this);
            infoPane.setReportComponent(reportComponent);
            infoPane.setPathComponent(pathComponent);
            infoPane.setCheckpointComponent(checkpointComponent);
            reportPane.initBean();
            treePane.initBean();
            infoPane.initBean();
            pathComponent.initBean();
            this.tabPane.add((Component)reportPane);
            this.tabPane.setActiveTabIndex(this.tabPane.getComponentCount() - 1);
            ReportsComponent reportsComponent = (ReportsComponent)this.applicationContext.getBean("reportsComponent");
            reportsComponent.setTreePane(treePane);
            reportsComponent.setReportXmlTransformer(this.reportXmlTransformer);
            reportsComponent.initBean(this);
            reportsComponent.openReport(report, isOpenReportAllowed);
        }
    }

    public void addToActiveTabIndexHistory(Integer index) {
        for (int i = 0; i < this.activeTabIndexHistory.size(); ++i) {
            if (!this.activeTabIndexHistory.get(i).equals(index)) continue;
            this.activeTabIndexHistory.remove(i);
            --i;
        }
        this.activeTabIndexHistory.add(index);
    }

    public void closeReport() {
        int tabToRemove = this.tabPane.getActiveTabIndex();
        this.tabPane.remove(tabToRemove);
        for (int i = 0; i < this.activeTabIndexHistory.size(); ++i) {
            if (this.activeTabIndexHistory.get(i) == tabToRemove) {
                this.activeTabIndexHistory.remove(i);
                --i;
                continue;
            }
            if (this.activeTabIndexHistory.get(i) <= tabToRemove) continue;
            this.activeTabIndexHistory.add(i, this.activeTabIndexHistory.get(i) - 1);
            this.activeTabIndexHistory.remove(i + 1);
        }
        this.tabPane.setActiveTabIndex(this.activeTabIndexHistory.get(this.activeTabIndexHistory.size() - 1).intValue());
    }

    public void openReportCompare(Report report1, Report report2, ReportRunner reportRunner) {
        this.tabPane.setActiveTabIndex(2);
        ComparePane comparePane = null;
        for (Tab tab : this.tabs) {
            if (!(tab instanceof ComparePane)) continue;
            comparePane = (ComparePane)tab;
        }
        DefaultMutableTreeNode reportNode1 = comparePane.getTreePane1().addReport(report1, comparePane.getReportsComponent1().getViews().getDefaultView(), false);
        DefaultMutableTreeNode reportNode2 = comparePane.getTreePane2().addReport(report2, comparePane.getReportsComponent2().getViews().getDefaultView(), false);
        comparePane.compare(report1, report2, reportRunner);
        comparePane.getTreePane1().selectNode(reportNode1);
    }

    public static String store(CrudStorage storage, Report report) {
        String errorMessage = null;
        try {
            storage.store(report);
        }
        catch (StorageException e) {
            log.error(e.getMessage(), (Throwable)e);
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    public static String update(CrudStorage storage, Report report) {
        String errorMessage = null;
        try {
            storage.update(report);
        }
        catch (StorageException e) {
            log.error(e.getMessage(), (Throwable)e);
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    public static String delete(CrudStorage storage, Report report) {
        String errorMessage = null;
        try {
            storage.delete(report);
        }
        catch (StorageException e) {
            log.error(e.getMessage(), (Throwable)e);
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    public static String deleteAll(CrudStorage storage) {
        String errorMessage = null;
        try {
            List ids = storage.getStorageIds();
            for (int i = 0; i < ids.size(); ++i) {
                Integer id = (Integer)ids.get(i);
                Report report = storage.getReport(id);
                storage.delete(report);
            }
        }
        catch (StorageException e) {
            log.error(e.getMessage(), (Throwable)e);
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    public static Color getApplicationBackgroundColor() {
        return applicationBackgroundColor;
    }

    public static Color getPaneBackgroundColor() {
        return paneBackgroundColor;
    }

    public static Color getButtonBackgroundColor() {
        return buttonBackgroundColor;
    }

    public static Color getButtonForegroundColor() {
        return buttonForegroundColor;
    }

    public static Color getButtonPressedBackgroundColor() {
        return buttonPressedBackgroundColor;
    }

    public static Color getButtonRolloverBackgroundColor() {
        return buttonRolloverBackgroundColor;
    }

    public static Color getErrorBackgroundColor() {
        return errorBackgroundColor;
    }

    public static Color getErrorForegroundColor() {
        return errorForegroundColor;
    }

    public static Color getOkayBackgroundColor() {
        return okayBackgroundColor;
    }

    public static Color getOkayForegroundColor() {
        return okayForegroundColor;
    }

    public static Color getDifferenceFoundLabelColor() {
        return differenceFoundLabelColor;
    }

    public static Color getNoDifferenceFoundLabelColor() {
        return noDifferenceFoundLabelColor;
    }

    public static Color getDifferenceFoundTextColor() {
        return differenceFoundTextColor;
    }

    public static Color getNoDifferenceFoundTextColor() {
        return noDifferenceFoundTextColor;
    }

    public static Color getLineNumberTextColor() {
        return lineNumberTextColor;
    }

    public static Row getNewRow() {
        Row row = new Row();
        row.setCellSpacing(new Extent(5));
        return row;
    }

    public static void decorateButton(Button button) {
        button.setInsets(new Insets(5, 2));
        button.setForeground(Color.WHITE);
        button.setBackground(buttonBackgroundColor);
        button.setPressedEnabled(true);
        button.setPressedBackground(buttonPressedBackgroundColor);
        button.setBorder(buttonBorder);
        button.setRolloverEnabled(true);
        button.setRolloverBorder(buttonRolloverBorder);
        button.setRolloverBackground(buttonRolloverBackgroundColor);
    }

    public static void decorateRadioButton(RadioButton radioButton) {
        radioButton.setInsets(new Insets(5, 2));
        radioButton.setForeground(Color.WHITE);
        radioButton.setBackground(buttonPressedBackgroundColor);
        radioButton.setPressedEnabled(true);
        radioButton.setPressedBackground(buttonRolloverBackgroundColor);
        radioButton.setBorder(buttonRolloverBorder);
        radioButton.setRolloverEnabled(true);
        radioButton.setRolloverBorder(buttonRolloverBorder);
        radioButton.setRolloverBackground(buttonBackgroundColor);
    }

    private static Label createInfoLabel(LayoutData layoutData) {
        Label label = new Label();
        if (layoutData != null) {
            label.setLayoutData(layoutData);
        }
        label.setBackground(Echo2Application.getButtonRolloverBackgroundColor());
        return label;
    }

    private static Label createErrorLabel(LayoutData layoutData) {
        Label label = Echo2Application.createInfoLabel(layoutData);
        label.setBackground(Echo2Application.getErrorBackgroundColor());
        label.setForeground(Echo2Application.getErrorForegroundColor());
        return label;
    }

    private static Label createOkayLabel(LayoutData layoutData) {
        Label label = Echo2Application.createInfoLabel(layoutData);
        label.setBackground(Echo2Application.getOkayBackgroundColor());
        label.setForeground(Echo2Application.getOkayForegroundColor());
        return label;
    }

    public static Label createInfoLabel() {
        return Echo2Application.createInfoLabel(null);
    }

    public static Label createErrorLabel() {
        return Echo2Application.createErrorLabel(null);
    }

    public static Label createOkayLabel() {
        return Echo2Application.createOkayLabel(null);
    }

    public static Label createInfoLabelWithColumnLayoutData() {
        return Echo2Application.createInfoLabel((LayoutData)columnLayoutDataForLabel);
    }

    public static Label createErrorLabelWithColumnLayoutData() {
        return Echo2Application.createErrorLabel((LayoutData)columnLayoutDataForLabel);
    }

    public static Label createOkayLabelWithColumnLayoutData() {
        return Echo2Application.createOkayLabel((LayoutData)columnLayoutDataForLabel);
    }

    public static Label createInfoLabelWithRowLayoutData() {
        return Echo2Application.createInfoLabel((LayoutData)rowLayoutDataForLabel);
    }

    public static Label createErrorLabelWithRowLayoutData() {
        return Echo2Application.createErrorLabel((LayoutData)rowLayoutDataForLabel);
    }

    public static Font getMessageFont() {
        return messageFont;
    }

    private ContainerContext getContainerContext() {
        return (ContainerContext)this.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
    }

    @Override
    public Principal getUserPrincipal() {
        ContainerContext containerContext = this.getContainerContext();
        if (containerContext != null) {
            return containerContext.getUserPrincipal();
        }
        return null;
    }

    @Override
    public boolean isUserInRoles(List<String> roles) {
        ContainerContext containerContext = this.getContainerContext();
        if (containerContext.getUserPrincipal() == null) {
            return true;
        }
        for (String role : roles) {
            if (!containerContext.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    public String getCommandIssuedBy() {
        ContainerContext containerContext = this.getContainerContext();
        if (containerContext != null) {
            String commandIssuedBy = " remoteHost [" + containerContext.getClientProperties().getString("remoteHost") + "]";
            commandIssuedBy = commandIssuedBy + " remoteUser [" + this.getUserPrincipal() + "]";
            return commandIssuedBy;
        }
        return null;
    }

    public ReportsTreeCellRenderer getReportsTreeCellRenderer() {
        return this.reportsTreeCellRenderer;
    }

    static {
        columnLayoutDataForLabel.setInsets(new Insets(0, 5, 0, 0));
    }
}

