/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import nextapp.echo2.app.filetransfer.DownloadProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadProvider
implements DownloadProvider {
    private Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private File file;
    private String fileName;

    public FileDownloadProvider(File file, String fileName) {
        this.file = file;
        this.fileName = fileName;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSize() {
        return (int)this.file.length();
    }

    public void writeFile(OutputStream outputStream) throws IOException {
        this.log.debug("Start download for file: " + this.fileName);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            byte[] buffer = new byte[1024];
            int i = fileInputStream.read(buffer);
            while (i != -1) {
                outputStream.write(buffer, 0, i);
                i = fileInputStream.read(buffer);
            }
        }
        catch (IOException e) {
            this.log.error("IOException during download", (Throwable)e);
            throw e;
        }
        finally {
            try {
                outputStream.close();
                fileInputStream.close();
                this.file.delete();
            }
            catch (IOException e) {
                this.log.error("IOException closing streams", (Throwable)e);
                throw e;
            }
        }
    }
}

