/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2;

import echopointng.tree.DefaultTreeCellRenderer;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.TextArea;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nl.nn.testtool.echo2.Echo2Application;
import nl.nn.testtool.transform.ReportXmlTransformer;

public class TransformationWindow
extends WindowPane
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int TEXT_AREA_HEIGHT = 400;
    private TextArea textArea;
    private Label errorLabel;
    private ReportXmlTransformer reportXmlTransformer = null;

    public TransformationWindow() {
        this.setTitle("Report XML transformation");
        this.setVisible(false);
        this.setWidth(new Extent(800));
        this.setHeight(new Extent(600));
        this.setInsets(new Insets(5, 5, 10, 5));
        this.setDefaultCloseOperation(1);
        Column column = new Column();
        column.setCellSpacing(new Extent(10));
        this.textArea = new TextArea();
        this.textArea.setFont(DefaultTreeCellRenderer.DEFAULT_FONT);
        this.textArea.setWidth(new Extent(100, 2));
        this.textArea.setHeight(new Extent(400));
        Button buttonSaveTranformation = new Button("Save transformation");
        buttonSaveTranformation.setActionCommand("SaveTransformation");
        Echo2Application.decorateButton(buttonSaveTranformation);
        buttonSaveTranformation.addActionListener((ActionListener)this);
        Button buttonMoreHeight = new Button("More height");
        buttonMoreHeight.setActionCommand("MoreHeight");
        Echo2Application.decorateButton(buttonMoreHeight);
        buttonMoreHeight.addActionListener((ActionListener)this);
        Button buttonLessHeight = new Button("Less height");
        buttonLessHeight.setActionCommand("LessHeight");
        Echo2Application.decorateButton(buttonLessHeight);
        buttonLessHeight.addActionListener((ActionListener)this);
        Row buttonRow = Echo2Application.getNewRow();
        this.errorLabel = Echo2Application.createErrorLabelWithRowLayoutData();
        this.errorLabel.setVisible(false);
        buttonRow.add((Component)buttonSaveTranformation);
        buttonRow.add((Component)buttonMoreHeight);
        buttonRow.add((Component)buttonLessHeight);
        buttonRow.add((Component)this.errorLabel);
        column.add((Component)buttonRow);
        column.add((Component)this.textArea);
        this.add((Component)column);
    }

    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }

    public ReportXmlTransformer getReportXmlTransformer() {
        return this.reportXmlTransformer;
    }

    public void initBean() {
        this.textArea.setText(this.reportXmlTransformer.getXslt());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("SaveTransformation")) {
            String errorMessage = this.reportXmlTransformer.updateXslt(this.textArea.getText());
            if (errorMessage == null) {
                this.errorLabel.setVisible(false);
            } else {
                this.errorLabel.setText(errorMessage);
                this.errorLabel.setVisible(true);
            }
        } else if (e.getActionCommand().equals("MoreHeight")) {
            this.textArea.setHeight(Extent.add((Extent)this.textArea.getHeight(), (Extent)new Extent(10)));
        } else if (e.getActionCommand().equals("LessHeight")) {
            this.textArea.setHeight(Extent.add((Extent)this.textArea.getHeight(), (Extent)new Extent(-10)));
        }
    }
}

