/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.reports;

import echopointng.tree.DefaultMutableTreeNode;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.echo2.Echo2Application;
import nl.nn.testtool.echo2.reports.MessageComponent;
import nl.nn.testtool.echo2.reports.TreePane;
import nl.nn.testtool.echo2.util.Download;
import nl.nn.testtool.storage.CrudStorage;

public class CheckpointComponent
extends MessageComponent {
    private static final long serialVersionUID = 1L;
    private Checkpoint checkpoint;
    private Label namePropertyLabel;
    private Label threadNamePropertyLabel;
    private Label sourceClassNamePropertyLabel;
    private Label messageClassNamePropertyLabel;
    private Label pathPropertyLabel;
    private Label checkpointUIDPropertyLabel;
    private Label encodingPropertyLabel;
    private Label numberOfCharactersPropertyLabel;
    private Label estimatedMemoryUsagePropertyLabel;
    private RadioButton radioButtonStubOptionFollowReportStrategy;
    private RadioButton radioButtonStubOptionYes;
    private RadioButton radioButtonStubOptionNo;
    private Label messageIsStubbedLabel;
    private Label messageStubNotFoundLabel;
    private Label messageIsNullLabel;
    private Label messageIsEmptyStringLabel;
    private Label messageIsTruncatedLabel;
    private Label messageEncodingLabel;
    private Label messageStreamingLabel;
    private Label messageNoCloseReceivedForStream;
    protected Button toggleBase64Button;

    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    @Override
    public void initBean() {
        super.initBeanPre();
        this.toggleBase64Button = new Button("Base64");
        this.toggleBase64Button.setVisible(false);
        this.toggleBase64Button.setActionCommand("ToggleBase64");
        this.toggleBase64Button.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(this.toggleBase64Button);
        this.buttonRow.add((Component)this.toggleBase64Button);
        Button downloadButton = new Button("Download");
        downloadButton.setActionCommand("Download");
        downloadButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(downloadButton);
        this.buttonRow.add((Component)downloadButton);
        Button expandAll = new Button("Expand all");
        expandAll.setActionCommand("ExpandAll");
        Echo2Application.decorateButton(expandAll);
        expandAll.addActionListener((ActionListener)this);
        this.buttonRow.add((Component)expandAll);
        Button collapseAll = new Button("Collapse all");
        collapseAll.setActionCommand("CollapseAll");
        Echo2Application.decorateButton(collapseAll);
        collapseAll.addActionListener((ActionListener)this);
        this.buttonRow.add((Component)collapseAll);
        Button closeButton = new Button("Close");
        closeButton.setActionCommand("Close");
        closeButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(closeButton);
        this.buttonRow.add((Component)closeButton);
        Row optionsRow = Echo2Application.getNewRow();
        optionsRow.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)optionsRow);
        optionsRow.add((Component)new Label("Stub:"));
        ButtonGroup stubButtonGroup = new ButtonGroup();
        this.radioButtonStubOptionYes = new RadioButton("Yes");
        Echo2Application.decorateRadioButton(this.radioButtonStubOptionYes);
        this.radioButtonStubOptionYes.setGroup(stubButtonGroup);
        this.radioButtonStubOptionYes.addActionListener((ActionListener)this);
        optionsRow.add((Component)this.radioButtonStubOptionYes);
        this.radioButtonStubOptionNo = new RadioButton("No");
        Echo2Application.decorateRadioButton(this.radioButtonStubOptionNo);
        this.radioButtonStubOptionNo.setGroup(stubButtonGroup);
        this.radioButtonStubOptionNo.addActionListener((ActionListener)this);
        optionsRow.add((Component)this.radioButtonStubOptionNo);
        this.radioButtonStubOptionFollowReportStrategy = new RadioButton("Follow report strategy");
        Echo2Application.decorateRadioButton(this.radioButtonStubOptionFollowReportStrategy);
        this.radioButtonStubOptionFollowReportStrategy.setGroup(stubButtonGroup);
        this.radioButtonStubOptionFollowReportStrategy.addActionListener((ActionListener)this);
        optionsRow.add((Component)this.radioButtonStubOptionFollowReportStrategy);
        optionsRow.add((Component)new Label("Download:"));
        optionsRow.add((Component)this.downloadSelectField);
        this.add((Component)this.errorLabel);
        this.add((Component)this.okayLabel);
        this.messageIsStubbedLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageIsStubbedLabel.setVisible(false);
        this.messageIsStubbedLabel.setText("Message is stubbed (copied from original report)");
        this.add((Component)this.messageIsStubbedLabel);
        this.messageStubNotFoundLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageStubNotFoundLabel.setVisible(false);
        this.add((Component)this.messageStubNotFoundLabel);
        this.messageIsNullLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageIsNullLabel.setVisible(false);
        this.messageIsNullLabel.setText("Message is null");
        this.add((Component)this.messageIsNullLabel);
        this.messageIsEmptyStringLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageIsEmptyStringLabel.setVisible(false);
        this.messageIsEmptyStringLabel.setText("Message is an empty string");
        this.add((Component)this.messageIsEmptyStringLabel);
        this.messageIsTruncatedLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageIsTruncatedLabel.setVisible(false);
        this.add((Component)this.messageIsTruncatedLabel);
        this.messageEncodingLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageEncodingLabel.setVisible(false);
        this.add((Component)this.messageEncodingLabel);
        this.messageStreamingLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageStreamingLabel.setVisible(false);
        this.add((Component)this.messageStreamingLabel);
        this.messageNoCloseReceivedForStream = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.messageNoCloseReceivedForStream.setVisible(false);
        this.messageNoCloseReceivedForStream.setText("No close received for stream");
        this.add((Component)this.messageNoCloseReceivedForStream);
        this.add((Component)this.messageColumn);
        this.add((Component)this.messageTextArea);
        this.namePropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.namePropertyLabel);
        this.threadNamePropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.threadNamePropertyLabel);
        this.sourceClassNamePropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.sourceClassNamePropertyLabel);
        this.messageClassNamePropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.messageClassNamePropertyLabel);
        this.pathPropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.pathPropertyLabel);
        this.checkpointUIDPropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.checkpointUIDPropertyLabel.setToolTipText("A unique identifier consisting of the report's storageId and this checkpoint's index. Use this value as part of a variable in another report's input message to use this checkpoint's message as input. Example: ${checkpoint(287#13)}.\n\nIf this message is a valid XML message and you'd like to use a specific part of its data instead, extend your variable to, for example, ${checkpoint(287#13).xpath(results/result[1])}.");
        this.add((Component)this.checkpointUIDPropertyLabel);
        this.encodingPropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.encodingPropertyLabel);
        this.numberOfCharactersPropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.numberOfCharactersPropertyLabel);
        this.estimatedMemoryUsagePropertyLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.estimatedMemoryUsagePropertyLabel);
        super.initBeanPost();
    }

    public void displayCheckpoint(DefaultMutableTreeNode node, Report report, Checkpoint checkpoint, Checkpoint checkpointCompare, boolean compare) {
        this.node = node;
        this.report = report;
        this.checkpoint = checkpoint;
        if (checkpoint.getStub() == -1) {
            this.radioButtonStubOptionFollowReportStrategy.setSelected(true);
        } else if (checkpoint.getStub() == 0) {
            this.radioButtonStubOptionNo.setSelected(true);
        } else if (checkpoint.getStub() == 1) {
            this.radioButtonStubOptionYes.setSelected(true);
        } else {
            this.radioButtonStubOptionFollowReportStrategy.setSelected(false);
            this.radioButtonStubOptionYes.setSelected(false);
            this.radioButtonStubOptionNo.setSelected(false);
        }
        this.messageIsStubbedLabel.setVisible(checkpoint.isStubbed());
        if (checkpoint.getStubNotFound() != null) {
            this.messageStubNotFoundLabel.setText("Could not find stub message for '" + checkpoint.getStubNotFound());
            this.messageStubNotFoundLabel.setVisible(true);
        } else {
            this.messageStubNotFoundLabel.setVisible(false);
        }
        String message = null;
        if (checkpoint.getMessage() != null) {
            message = checkpoint.getMessage();
            this.messageIsNullLabel.setVisible(false);
            this.messageIsEmptyStringLabel.setVisible(message.equals(""));
        } else {
            this.messageIsNullLabel.setVisible(true);
            this.messageIsEmptyStringLabel.setVisible(false);
        }
        if (checkpoint.getPreTruncatedMessageLength() > 0) {
            this.messageIsTruncatedLabel.setText("Message is truncated (" + (checkpoint.getPreTruncatedMessageLength() - checkpoint.getMessage().length()) + " characters removed)");
            this.messageIsTruncatedLabel.setVisible(true);
        } else {
            this.messageIsTruncatedLabel.setVisible(false);
        }
        if (checkpoint.getStreaming() != null) {
            String waiting = "Message is";
            if (checkpoint.isWaitingForStream()) {
                waiting = "Waiting for message to be";
            }
            this.messageStreamingLabel.setText(waiting + " captured asynchronously from a " + checkpoint.getStreaming().toLowerCase() + " stream");
            this.messageStreamingLabel.setVisible(true);
        } else {
            this.messageStreamingLabel.setVisible(false);
        }
        if (checkpoint.isNoCloseReceivedForStream()) {
            this.messageNoCloseReceivedForStream.setVisible(true);
        } else {
            this.messageNoCloseReceivedForStream.setVisible(false);
        }
        String messageCompare = null;
        if (compare && checkpointCompare != null) {
            messageCompare = checkpointCompare.getMessage();
        }
        if (checkpoint.getEncoding() != null) {
            this.messageEncodingLabel.setText("Message of type " + checkpoint.getMessageClassName() + " is encoded to string using " + checkpoint.getEncoding());
            this.messageEncodingLabel.setVisible(true);
            if (checkpoint.getEncoding().equals("Base64")) {
                if (this.toggleBase64Button.getText().equals("Base64")) {
                    message = this.decodeBase64AndUTF8(message);
                    if (messageCompare != null) {
                        messageCompare = this.decodeBase64AndUTF8(messageCompare);
                    }
                    this.messageEncodingLabel.setText(this.messageEncodingLabel.getText() + " and displayed using Base64 decoded to byte array and byte array decoded to string using UTF-8 (toggle with Base64 button)");
                }
                this.toggleBase64Button.setVisible(true);
            } else {
                this.toggleBase64Button.setVisible(false);
            }
        } else {
            this.messageEncodingLabel.setVisible(false);
            this.toggleBase64Button.setVisible(false);
        }
        if (compare) {
            this.setMessage(message, messageCompare);
        } else {
            this.setMessage(message);
        }
        this.namePropertyLabel.setText("Name: " + checkpoint.getName());
        this.threadNamePropertyLabel.setText("Thread name: " + checkpoint.getThreadName());
        this.sourceClassNamePropertyLabel.setText("Source class name: " + checkpoint.getSourceClassName());
        String messageClassName = checkpoint.getMessageClassName();
        if (messageClassName == null) {
            messageClassName = "java.lang.String";
        }
        this.messageClassNamePropertyLabel.setText("Message class name: " + messageClassName);
        this.pathPropertyLabel.setText("Path: " + checkpoint.getPath());
        this.checkpointUIDPropertyLabel.setText("Checkpoint UID: " + checkpoint.getUID());
        this.encodingPropertyLabel.setText("Encoding: " + checkpoint.getEncoding());
        this.numberOfCharactersPropertyLabel.setText("Number of characters: " + (checkpoint.getMessage() != null ? Integer.valueOf(checkpoint.getMessage().length()) : "0"));
        this.estimatedMemoryUsagePropertyLabel.setText("EstimatedMemoryUsage: " + checkpoint.getEstimatedMemoryUsage() + " bytes");
        this.hideMessages();
    }

    private String decodeBase64AndUTF8(String message) {
        byte[] bytes = Base64.getDecoder().decode(message);
        try {
            message = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            message = "Could not decode byte array (with length " + bytes.length + ") to string with UTF-8";
        }
        return message;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (this.radioButtonStubOptionFollowReportStrategy == e.getSource()) {
            this.checkpoint.setStub(-1);
        } else if (this.radioButtonStubOptionNo == e.getSource()) {
            this.checkpoint.setStub(0);
        } else if (this.radioButtonStubOptionYes == e.getSource()) {
            this.checkpoint.setStub(1);
        } else if (e.getActionCommand().equals("ToggleBase64")) {
            if (this.toggleBase64Button.getText().equals("Base64")) {
                this.toggleBase64Button.setText("UTF-8");
            } else {
                this.toggleBase64Button.setText("Base64");
            }
            this.treePane.selectNode(this.node);
        } else if (e.getActionCommand().equals("Download")) {
            if ("Both".equals(this.downloadSelectField.getSelectedItem())) {
                this.displayAndLogError(Download.download(this.report, this.checkpoint));
            } else if ("Message".equals(this.downloadSelectField.getSelectedItem())) {
                this.displayAndLogError(Download.download(this.checkpoint));
            }
        }
    }

    @Override
    protected void save() {
        super.save();
        this.checkpoint.setMessage(this.messageTextArea.getText());
        if (this.report.getStorage() instanceof CrudStorage) {
            this.displayAndLogError(Echo2Application.update((CrudStorage)this.report.getStorage(), this.report));
        }
    }
}

