/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.reports;

import echopointng.tree.DefaultMutableTreeNode;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.TextArea;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.layout.RowLayoutData;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.echo2.BaseComponent;
import nl.nn.testtool.echo2.BeanParent;
import nl.nn.testtool.echo2.Echo2Application;
import nl.nn.testtool.echo2.ReportPane;
import nl.nn.testtool.echo2.reports.InfoPane;
import nl.nn.testtool.echo2.reports.TreePane;
import nl.nn.testtool.echo2.util.Download;
import nl.nn.testtool.echo2.util.PopupWindow;
import org.springframework.util.StringUtils;

public class MessageComponent
extends BaseComponent
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final char REPLACE_NON_XML_CHAR = '\u00bf';
    protected TestTool testTool;
    private BeanParent beanParent;
    protected Echo2Application echo2Application;
    protected TreePane treePane;
    protected DefaultMutableTreeNode node;
    protected InfoPane infoPane;
    protected Report report;
    protected Row buttonRow;
    protected Button editButton;
    protected Button saveButton;
    protected SelectField downloadSelectField;
    private String message;
    private String messageCompare;
    private boolean compare;
    protected Column messageColumn;
    protected Button lineNumbersButton;
    protected TextArea messageTextArea;

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    protected void initBeanPre() {
        super.initBean();
        this.buttonRow = Echo2Application.getNewRow();
        this.add((Component)this.buttonRow);
        Button rerunButton = new Button("Rerun");
        rerunButton.setActionCommand("Rerun");
        rerunButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(rerunButton);
        this.buttonRow.add((Component)rerunButton);
        this.editButton = new Button();
        this.editButton.setActionCommand("ToggleEdit");
        this.editButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(this.editButton);
        this.buttonRow.add((Component)this.editButton);
        this.lineNumbersButton = new Button();
        this.lineNumbersButton.setActionCommand("ToggleShowLineNumbers");
        this.lineNumbersButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(this.lineNumbersButton);
        this.buttonRow.add((Component)this.lineNumbersButton);
        this.saveButton = new Button("Save");
        this.saveButton.setActionCommand("Save");
        this.saveButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(this.saveButton);
        this.buttonRow.add((Component)this.saveButton);
        this.downloadSelectField = new SelectField((Object[])new String[]{"Both", "Report", "Message"});
        this.downloadSelectField.setSelectedIndex(0);
        this.messageColumn = new Column();
        this.messageColumn.setInsets(new Insets(0, 5, 0, 0));
        this.messageTextArea = new TextArea();
        this.messageTextArea.setWidth(new Extent(100, 2));
        this.messageTextArea.setHeight(new Extent(300));
        this.messageTextArea.setVisible(false);
    }

    protected void initBeanPost() {
        this.updateLineNumbersButton();
        this.updateEditButton();
        this.updateSaveButton();
    }

    public void initBean(BeanParent beanParent) {
        this.beanParent = beanParent;
        this.echo2Application = Echo2Application.getEcho2Application(beanParent, (Object)this);
    }

    public BeanParent getBeanParent() {
        return this.beanParent;
    }

    public void setInfoPane(InfoPane infoPane) {
        this.infoPane = infoPane;
    }

    protected void setMessage(String message) {
        this.message = message;
        this.messageCompare = null;
        this.compare = false;
        this.updateMessageComponents();
    }

    protected void setMessage(String message, String messageCompare) {
        this.message = message;
        this.messageCompare = messageCompare;
        this.compare = true;
        this.updateMessageComponents();
    }

    protected String getMessage() {
        return this.message;
    }

    protected void toggleShowLineNumbers() {
        if (!this.infoPane.edit()) {
            if (this.infoPane.showLineNumbers()) {
                this.infoPane.showLineNumbers(false);
                MessageComponent.removeLineNumbers(this.messageColumn);
            } else {
                this.infoPane.showLineNumbers(true);
                MessageComponent.addLineNumbers(this.messageColumn);
            }
            this.updateLineNumbersButton();
        }
    }

    protected void toggleEdit() {
        if (this.infoPane.edit()) {
            this.infoPane.edit(false);
        } else {
            this.infoPane.edit(true);
        }
        this.updateMessageComponents();
    }

    protected void save() {
        this.message = this.messageTextArea.getText();
    }

    protected void updateMessageComponents() {
        this.updateLineNumbersButton();
        this.updateEditButton();
        this.updateSaveButton();
        if (this.infoPane.edit()) {
            this.messageColumn.setVisible(false);
            this.messageTextArea.setVisible(true);
        } else {
            this.messageColumn.setVisible(true);
            this.messageTextArea.setVisible(false);
        }
        MessageComponent.updateMessageColumn(this.message, this.messageColumn, this.compare, this.messageCompare);
        if (this.infoPane.showLineNumbers()) {
            MessageComponent.addLineNumbers(this.messageColumn);
        }
        if (this.message == null) {
            this.messageTextArea.setText(this.message);
        } else {
            this.messageTextArea.setText(MessageComponent.replaceNonValidXmlCharacters(this.message, null, false));
        }
    }

    public static void updateMessageColumn(String message, Column messageColumn) {
        MessageComponent.updateMessageColumn(message, messageColumn, false, null);
    }

    public static void updateMessageColumn(String message, Column messageColumn, boolean compare, String messageCompare) {
        messageColumn.removeAll();
        if (message == null || message.equals("")) {
            messageColumn.setVisible(false);
        } else {
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(message));
            String line = MessageComponent.readLineIgnoringExceptions(lineNumberReader);
            LineNumberReader lineNumberReaderCompare = null;
            String lineCompare = null;
            if (messageCompare != null) {
                lineNumberReaderCompare = new LineNumberReader(new StringReader(messageCompare));
                lineCompare = MessageComponent.readLineIgnoringExceptions(lineNumberReaderCompare);
            }
            while (line != null) {
                MessageComponent.addLine(line, messageColumn, compare, lineCompare);
                line = MessageComponent.readLineIgnoringExceptions(lineNumberReader);
                if (messageCompare == null) continue;
                lineCompare = MessageComponent.readLineIgnoringExceptions(lineNumberReaderCompare);
            }
        }
    }

    private static String readLineIgnoringExceptions(LineNumberReader lineNumberReader) {
        String line = null;
        try {
            line = lineNumberReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return line;
    }

    private static void addLine(String line, Column messageColumn, boolean compare, String lineCompare) {
        Row row = new Row();
        messageColumn.add((Component)row);
        boolean differenceFound = compare && !line.equals(lineCompare);
        MessageComponent.replaceNonValidXmlCharacters(line, row, differenceFound);
    }

    private static Label createLabel(String text, boolean applyIndent, boolean differenceFound) {
        RowLayoutData rowLayouData = new RowLayoutData();
        rowLayouData.setAlignment(Alignment.ALIGN_TOP);
        Label label = new Label();
        label.setLayoutData((LayoutData)rowLayouData);
        label.setFont(Echo2Application.getMessageFont());
        if (differenceFound) {
            label.setForeground(Echo2Application.getDifferenceFoundTextColor());
        }
        if (applyIndent) {
            MessageComponent.setIndentAndText(label, text);
        } else {
            label.setText(text);
        }
        return label;
    }

    private static void setIndentAndText(Label label, String line) {
        int preIndex;
        int preSpace = 0;
        for (preIndex = 0; line.length() > preIndex && (line.charAt(preIndex) == ' ' || line.charAt(preIndex) == '\t'); ++preIndex) {
            if (line.charAt(preIndex) == ' ') {
                ++preSpace;
                continue;
            }
            preSpace += 4;
        }
        boolean whiteSpaceOnly = preIndex == line.length();
        int postSpace = 0;
        if (!whiteSpaceOnly) {
            for (int postIndex = line.length() - 1; postIndex >= 0 && (line.charAt(postIndex) == ' ' || line.charAt(postIndex) == '\t'); --postIndex) {
                if (line.charAt(postIndex) == ' ') {
                    ++postSpace;
                    continue;
                }
                postSpace += 4;
            }
        }
        MessageComponent.setIndent(label, preSpace, postSpace, whiteSpaceOnly);
        label.setText(line.substring(preIndex));
    }

    private static void setIndent(Label label, int preNumberOfChars, int postNumberOfChars, boolean whiteSpaceOnly) {
        RowLayoutData rowLayoutData = (RowLayoutData)label.getLayoutData();
        int topPx = 0;
        if (whiteSpaceOnly) {
            topPx = 15;
        }
        rowLayoutData.setInsets(new Insets(preNumberOfChars * 7, topPx, postNumberOfChars * 7, 0));
    }

    private void updateLineNumbersButton() {
        if (this.infoPane.showLineNumbers()) {
            this.lineNumbersButton.setText("Hide line numbers");
        } else {
            this.lineNumbersButton.setText("Show line numbers");
        }
        if (this.infoPane.edit()) {
            this.lineNumbersButton.setVisible(false);
        } else {
            this.lineNumbersButton.setVisible(true);
        }
    }

    private void updateEditButton() {
        if (this.infoPane.edit()) {
            this.editButton.setText("Read-only");
        } else {
            this.editButton.setText("Edit");
        }
    }

    private void updateSaveButton() {
        if (this.saveButton != null) {
            if (this.infoPane.edit()) {
                this.saveButton.setVisible(true);
            } else {
                this.saveButton.setVisible(false);
            }
        }
    }

    public static void addLineNumbers(Column messageColumn) {
        int maxNumberLength = ("" + messageColumn.getComponentCount()).length();
        for (int i = 0; i < messageColumn.getComponentCount(); ++i) {
            Row row = (Row)messageColumn.getComponent(i);
            int lineNumber = i + 1;
            Label label = MessageComponent.createLabel(lineNumber + ":", false, false);
            label.setForeground(Echo2Application.getLineNumberTextColor());
            MessageComponent.setIndent(label, maxNumberLength - ("" + lineNumber).length(), 0, false);
            row.add((Component)label, 0);
        }
    }

    public static void removeLineNumbers(Column messageColumn) {
        for (int i = 0; i < messageColumn.getComponentCount(); ++i) {
            Row row = (Row)messageColumn.getComponent(i);
            row.remove(0);
        }
    }

    private static String replaceNonValidXmlCharacters(String string, Row row, boolean differenceFound) {
        int c;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length(); i += Character.charCount(c)) {
            c = string.codePointAt(i);
            if (MessageComponent.isPrintableUnicodeChar(c)) {
                buffer.appendCodePoint(c);
                continue;
            }
            String substitute = "\u00bf#" + c + ";";
            if (row == null) {
                buffer.append(substitute);
                continue;
            }
            row.add((Component)MessageComponent.createLabel(buffer.toString(), true, differenceFound));
            Label label = MessageComponent.createLabel(substitute, true, differenceFound);
            label.setBackground(Echo2Application.getButtonRolloverBackgroundColor());
            row.add((Component)label);
            buffer = new StringBuffer();
        }
        if (row != null) {
            row.add((Component)MessageComponent.createLabel(buffer.toString(), true, differenceFound));
        }
        return buffer.toString();
    }

    public static boolean isPrintableUnicodeChar(int c) {
        return c == 9 || c == 10 || c == 13 || c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 128512 && c <= 128591;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() != null) {
            if (e.getActionCommand().equals("ExpandAll")) {
                this.treePane.expandAll(this.node);
            } else if (e.getActionCommand().equals("CollapseAll")) {
                this.treePane.collapseAll(this.node);
            } else if (e.getActionCommand().equals("Close") || e.getActionCommand().equals("CloseOk")) {
                if (this.overwriteChanges(e.getActionCommand(), "CloseOk", "CloseCancel")) {
                    if (this.getParent().getParent().getParent() instanceof ReportPane) {
                        ((Echo2Application)this.getApplicationInstance()).closeReport();
                    } else {
                        this.treePane.closeReport(this.report);
                    }
                }
            } else if (e.getActionCommand().equals("Save")) {
                this.save();
            } else if (e.getActionCommand().equals("Download")) {
                if (!"Both".equals(this.downloadSelectField.getSelectedItem())) {
                    if ("Report".equals(this.downloadSelectField.getSelectedItem())) {
                        this.displayAndLogError(Download.download(this.report));
                    } else if (!"Message".equals(this.downloadSelectField.getSelectedItem())) {
                        this.displayError("No download type selected");
                    }
                }
            } else if (e.getActionCommand().equals("ToggleShowLineNumbers")) {
                this.toggleShowLineNumbers();
            } else if (e.getActionCommand().equals("ToggleEdit") || e.getActionCommand().equals("ToggleEditOk")) {
                if (this.overwriteChanges(e.getActionCommand(), "ToggleEditOk", "ToggleEditCancel")) {
                    this.toggleEdit();
                }
            } else if (e.getActionCommand().equals("Rerun")) {
                String errorMessage = this.testTool.rerun(this.report, this.echo2Application);
                if (errorMessage == null) {
                    this.displayOkay("Rerun succeeded");
                } else {
                    this.displayAndLogError(errorMessage);
                }
            }
        }
    }

    protected boolean overwriteChanges(String currentActionCommand, String actionCommandOk, String actionCommandCancel) {
        if (currentActionCommand.equals(actionCommandOk)) {
            return true;
        }
        if (this.hasChanges()) {
            ArrayList<String> actionLabels = new ArrayList<String>();
            ArrayList<String> actionCommands = new ArrayList<String>();
            ArrayList<ActionListener> actionListeners = new ArrayList<ActionListener>();
            actionLabels.add("Yes, discard changes");
            actionCommands.add(actionCommandOk);
            actionListeners.add(this);
            actionLabels.add("No, cancel this action");
            actionCommands.add(actionCommandCancel);
            actionListeners.add(this);
            PopupWindow popupWindow = new PopupWindow("", "Are you sure you want to continue and discard your changes?", 450, 100, actionLabels, actionCommands, actionListeners);
            this.echo2Application.getContentPane().add((Component)popupWindow);
            return false;
        }
        return true;
    }

    protected boolean hasChanges() {
        return this.infoPane.edit() && this.hasChanges(this.message, this.messageTextArea.getText());
    }

    protected boolean hasChanges(String string1, String string2) {
        if (StringUtils.isEmpty((Object)string1) && !StringUtils.isEmpty((Object)string2)) {
            return true;
        }
        if (!StringUtils.isEmpty((Object)string1) && StringUtils.isEmpty((Object)string2)) {
            return true;
        }
        if (StringUtils.isEmpty((Object)string1) && StringUtils.isEmpty((Object)string2)) {
            return false;
        }
        return !string1.equals(string2);
    }
}

