/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.reports;

import echopointng.tree.DefaultMutableTreeNode;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImageBorder;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.TextArea;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.echo2.BeanParent;
import nl.nn.testtool.echo2.Echo2Application;
import nl.nn.testtool.echo2.reports.MessageComponent;
import nl.nn.testtool.echo2.reports.TreePane;
import nl.nn.testtool.echo2.test.TestComponent;
import nl.nn.testtool.echo2.util.Download;
import nl.nn.testtool.storage.CrudStorage;
import org.springframework.util.StringUtils;

public class ReportComponent
extends MessageComponent {
    private static final long serialVersionUID = 1L;
    private CrudStorage testStorage;
    private Label nameLabel;
    private Label descriptionLabel;
    private Label pathLabel;
    private Label transformationLabel;
    private Label storageIdLabel;
    private Label storageLabel;
    private SelectField stubStrategySelectField;
    private SelectField copyToSelectField;
    private Label estimatedMemoryUsageLabel;
    private Label correlationIdLabel;
    private TextField nameTextField;
    protected Column descriptionColumn;
    private TextArea descriptionTextArea;
    private TextField pathTextField;
    protected Column transformationColumn;
    private TextArea transformationTextArea;
    private WindowPane deleteWarningWindow;
    private Label deleteIdLabel;
    private Label variableLabel;
    private Column variableColumn;
    private TextArea variableTextArea;
    private Label variableErrorMessageLabel;

    @Override
    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setTestStorage(CrudStorage testStorage) {
        this.testStorage = testStorage;
    }

    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    @Override
    public void initBean() {
        super.initBeanPre();
        Button copyButton = new Button("Copy");
        copyButton.setActionCommand("Copy");
        copyButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(copyButton);
        this.buttonRow.add((Component)copyButton);
        Button deleteButton = new Button("Delete");
        deleteButton.setActionCommand("Delete");
        deleteButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(deleteButton);
        this.buttonRow.add((Component)deleteButton);
        Button downloadButton = new Button("Download");
        downloadButton.setActionCommand("Download");
        downloadButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(downloadButton);
        this.buttonRow.add((Component)downloadButton);
        Button expandAll = new Button("Expand all");
        expandAll.setActionCommand("ExpandAll");
        Echo2Application.decorateButton(expandAll);
        expandAll.addActionListener((ActionListener)this);
        this.buttonRow.add((Component)expandAll);
        Button collapseAll = new Button("Collapse all");
        collapseAll.setActionCommand("CollapseAll");
        Echo2Application.decorateButton(collapseAll);
        collapseAll.addActionListener((ActionListener)this);
        this.buttonRow.add((Component)collapseAll);
        Button closeButton = new Button("Close");
        closeButton.setActionCommand("Close");
        closeButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(closeButton);
        this.buttonRow.add((Component)closeButton);
        Row optionsRow = Echo2Application.getNewRow();
        optionsRow.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)optionsRow);
        this.stubStrategySelectField = new SelectField(this.testTool.getStubStrategies().toArray());
        this.stubStrategySelectField.addActionListener((ActionListener)this);
        optionsRow.add((Component)new Label("Stub strategy:"));
        optionsRow.add((Component)this.stubStrategySelectField);
        this.copyToSelectField = new SelectField((Object[])new String[]{this.testStorage.getName()});
        this.copyToSelectField.setSelectedIndex(0);
        optionsRow.add((Component)new Label("Copy to:"));
        optionsRow.add((Component)this.copyToSelectField);
        optionsRow.add((Component)new Label("Download:"));
        optionsRow.add((Component)this.downloadSelectField);
        this.add((Component)this.errorLabel);
        this.add((Component)this.okayLabel);
        this.add((Component)this.messageColumn);
        this.add((Component)this.messageTextArea);
        this.variableErrorMessageLabel = Echo2Application.createErrorLabel();
        this.variableErrorMessageLabel.setVisible(false);
        this.add((Component)this.variableErrorMessageLabel);
        this.buttonRow = Echo2Application.getNewRow();
        this.add((Component)this.buttonRow);
        Row nameRow = Echo2Application.getNewRow();
        nameRow.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)nameRow);
        this.nameLabel = Echo2Application.createInfoLabel();
        nameRow.add((Component)this.nameLabel);
        this.nameTextField = new TextField();
        this.nameTextField.setWidth(new Extent(360));
        this.nameTextField.setVisible(false);
        nameRow.add((Component)this.nameTextField);
        Row descriptionRow = Echo2Application.getNewRow();
        descriptionRow.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)descriptionRow);
        this.descriptionLabel = Echo2Application.createInfoLabel();
        this.descriptionLabel.setText("Description:");
        descriptionRow.add((Component)this.descriptionLabel);
        this.descriptionColumn = new Column();
        this.descriptionColumn.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)this.descriptionColumn);
        this.descriptionTextArea = new TextArea();
        this.descriptionTextArea.setWidth(new Extent(50, 2));
        this.descriptionTextArea.setHeight(new Extent(100));
        this.descriptionTextArea.setVisible(false);
        this.add((Component)this.descriptionTextArea);
        Row pathRow = Echo2Application.getNewRow();
        pathRow.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)pathRow);
        this.pathLabel = Echo2Application.createInfoLabel();
        pathRow.add((Component)this.pathLabel);
        this.pathTextField = new TextField();
        this.pathTextField.setWidth(new Extent(360));
        this.pathTextField.setVisible(false);
        pathRow.add((Component)this.pathTextField);
        Row transformationRow = Echo2Application.getNewRow();
        transformationRow.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)transformationRow);
        this.transformationLabel = Echo2Application.createInfoLabel();
        this.transformationLabel.setText("Transformation:");
        transformationRow.add((Component)this.transformationLabel);
        this.transformationColumn = new Column();
        this.transformationColumn.setInsets(new Insets(0, 5, 0, 0));
        this.transformationTextArea = new TextArea();
        this.transformationTextArea.setWidth(new Extent(50, 2));
        this.transformationTextArea.setHeight(new Extent(400));
        this.transformationTextArea.setVisible(false);
        this.add((Component)this.transformationTextArea);
        Row variableRow = Echo2Application.getNewRow();
        variableRow.setInsets(new Insets(0, 5, 0, 0));
        this.add((Component)variableRow);
        this.variableLabel = Echo2Application.createInfoLabel();
        this.variableLabel.setText("Variables:");
        this.variableLabel.setVisible(false);
        this.variableLabel.setToolTipText("A map of variables to be written in CSV-format with delimiter ';'. These variables can be referred to in this report's input message by referring to their ${key}. Example:\n\nid;firstname;location\n3;jaco;de groot\n\nIn this case, any occurences of ${firstname} in the report's input message will be replaced with \"jaco\" at runtime.");
        variableRow.add((Component)this.variableLabel);
        this.variableColumn = new Column();
        this.variableColumn.setInsets(new Insets(0, 5, 0, 0));
        this.variableTextArea = new TextArea();
        this.variableTextArea.setWidth(new Extent(50, 2));
        this.variableTextArea.setHeight(new Extent(32));
        this.variableTextArea.setVisible(false);
        this.add((Component)this.variableTextArea);
        this.storageIdLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.storageIdLabel);
        this.storageLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.storageLabel);
        this.estimatedMemoryUsageLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.estimatedMemoryUsageLabel);
        this.correlationIdLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.add((Component)this.correlationIdLabel);
        Column deleteWarningColumn = new Column();
        this.deleteWarningWindow = new WindowPane();
        this.deleteWarningWindow.setVisible(false);
        this.deleteWarningWindow.setTitle("Warning");
        this.deleteWarningWindow.setTitleBackground(Echo2Application.getButtonBackgroundColor());
        this.deleteWarningWindow.setBorder(new FillImageBorder(Echo2Application.getButtonBackgroundColor(), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)));
        this.deleteWarningWindow.setWidth(new Extent(500));
        this.deleteWarningWindow.setHeight(new Extent(90));
        this.deleteWarningWindow.setInsets(new Insets(10, 5, 0, 0));
        this.deleteWarningWindow.add((Component)deleteWarningColumn);
        this.deleteWarningWindow.setDefaultCloseOperation(1);
        this.deleteWarningWindow.init();
        Button yesButton = new Button("Yes");
        yesButton.setActionCommand("DeleteYes");
        Echo2Application.decorateButton(yesButton);
        yesButton.addActionListener((ActionListener)this);
        Button noButton = new Button("No");
        noButton.setActionCommand("DeleteNo");
        Echo2Application.decorateButton(noButton);
        noButton.addActionListener((ActionListener)this);
        this.deleteIdLabel = new Label("?");
        Row deleteWarningButtonRow = Echo2Application.getNewRow();
        deleteWarningButtonRow.setInsets(new Insets(0, 5, 0, 0));
        deleteWarningButtonRow.add((Component)yesButton);
        deleteWarningButtonRow.add((Component)noButton);
        deleteWarningColumn.add((Component)this.deleteIdLabel);
        deleteWarningColumn.add((Component)deleteWarningButtonRow);
        super.initBeanPost();
    }

    @Override
    public void initBean(BeanParent beanParent) {
        super.initBean(beanParent);
        this.echo2Application.getContentPane().add((Component)this.deleteWarningWindow);
    }

    public void displayReport(DefaultMutableTreeNode node, String path, Report report, Report reportCompare, boolean compare) {
        this.node = node;
        this.report = report;
        this.stubStrategySelectField.setSelectedItem((Object)report.getStubStrategy());
        String reportXml = report.toXml();
        if (compare) {
            String reportCompareXml = null;
            if (reportCompare != null) {
                reportCompareXml = reportCompare.toXml();
            }
            this.setMessage(reportXml, reportCompareXml);
        } else {
            this.setMessage(reportXml);
        }
        this.messageTextArea.setVisible(false);
        this.storageIdLabel.setText("StorageId: " + (report.getStorageId() == null ? "" : report.getStorageId()));
        this.storageLabel.setText("Storage: " + (report.getStorage() == null ? "" : report.getStorage().getName()));
        this.estimatedMemoryUsageLabel.setText("EstimatedMemoryUsage: " + report.getEstimatedMemoryUsage() + " bytes");
        this.correlationIdLabel.setText("CorrelationId: " + report.getCorrelationId());
        this.hideMessages();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (this.stubStrategySelectField == e.getSource()) {
            this.report.setStubStrategy((String)this.stubStrategySelectField.getSelectedItem());
        } else if (e.getActionCommand().equals("Download")) {
            if ("Both".equals(this.downloadSelectField.getSelectedItem())) {
                this.displayAndLogError(Download.download(this.report, true, true));
            } else if ("Message".equals(this.downloadSelectField.getSelectedItem())) {
                this.displayAndLogError(Download.download(this.report, false, true));
            }
        } else if (e.getActionCommand().equals("Copy")) {
            this.displayAndLogError(Echo2Application.store(this.testStorage, this.report));
        } else if (e.getActionCommand().equals("Delete")) {
            if (this.report.getStorage() instanceof CrudStorage) {
                this.deleteIdLabel.setText("Are you sure you want to delete report with storage id " + this.report.getStorageId() + "?");
                this.deleteWarningWindow.setVisible(true);
            } else {
                this.displayError("Storage doesn't support delete method");
            }
        } else if (e.getActionCommand().equals("DeleteYes") || e.getActionCommand().equals("DeleteNo")) {
            if (e.getActionCommand().equals("DeleteYes")) {
                this.displayAndLogError(Echo2Application.delete((CrudStorage)this.report.getStorage(), this.report));
            }
            this.deleteWarningWindow.setVisible(false);
            this.deleteIdLabel.setText("?");
        }
    }

    @Override
    protected void toggleShowLineNumbers() {
        super.toggleShowLineNumbers();
        if (!this.infoPane.edit()) {
            if (this.infoPane.showLineNumbers()) {
                ReportComponent.addLineNumbers(this.descriptionColumn);
            } else {
                ReportComponent.removeLineNumbers(this.descriptionColumn);
            }
        }
    }

    @Override
    protected void toggleEdit() {
        super.toggleEdit();
        if (this.infoPane.edit()) {
            this.messageTextArea.setVisible(false);
        }
    }

    @Override
    protected void save() {
        this.report.setName(this.nameTextField.getText());
        this.report.setDescription(this.descriptionTextArea.getText());
        this.saveReportPathChanges();
        this.saveReportVariableChanges();
        this.report.setTransformation(this.transformationTextArea.getText());
        this.report.flushCachedXml();
        if (this.report.getStorage() instanceof CrudStorage) {
            this.displayAndLogError(Echo2Application.update((CrudStorage)this.report.getStorage(), this.report));
        }
        this.messageTextArea.setText(this.report.toXml());
        this.nameTextField.setText(this.report.getName());
        super.save();
    }

    private void saveReportPathChanges() {
        String input = this.pathTextField.getText();
        if (!StringUtils.isEmpty((Object)input)) {
            input = TestComponent.normalizePath(input);
            this.pathTextField.setText(input);
        }
        this.report.setPath(input);
    }

    private void saveReportVariableChanges() {
        if (!this.variableTextArea.getText().equals(this.report.getVariableCsv())) {
            String errorMessage = this.report.setVariableCsvWithoutException(this.variableTextArea.getText());
            if (errorMessage == null) {
                this.variableErrorMessageLabel.setVisible(false);
            } else {
                this.variableErrorMessageLabel.setText("[Variables] " + errorMessage);
                this.variableErrorMessageLabel.setVisible(true);
            }
        } else {
            this.variableErrorMessageLabel.setVisible(false);
        }
    }

    @Override
    protected void updateMessageComponents() {
        super.updateMessageComponents();
        this.updateNameLabelAndNameTextField();
        this.updateDescriptionLabelAndDescriptionColumnAndTextArea();
        this.updatePathLabelAndPathTextField();
        this.updateTransformationLabelAndTransformationColumnAndTextArea();
        this.updateVariableLabelAndTextArea();
        if (!this.infoPane.edit()) {
            this.variableErrorMessageLabel.setVisible(false);
        }
    }

    private void updateNameLabelAndNameTextField() {
        if (this.infoPane.edit()) {
            this.nameLabel.setText("Name: ");
            this.nameTextField.setText(this.report.getName());
            this.nameTextField.setVisible(true);
        } else {
            this.nameLabel.setText("Name: " + this.report.getName());
            this.nameTextField.setVisible(false);
        }
    }

    private void updateDescriptionLabelAndDescriptionColumnAndTextArea() {
        if (this.infoPane.edit()) {
            this.descriptionColumn.setVisible(false);
            this.descriptionTextArea.setVisible(true);
        } else {
            this.descriptionColumn.setVisible(true);
            this.descriptionTextArea.setVisible(false);
        }
        ReportComponent.updateMessageColumn(this.report.getDescription(), this.descriptionColumn);
        if (this.infoPane.showLineNumbers()) {
            ReportComponent.addLineNumbers(this.descriptionColumn);
        }
        this.descriptionTextArea.setText(this.report.getDescription());
    }

    private void updatePathLabelAndPathTextField() {
        if (this.infoPane.edit()) {
            this.pathLabel.setText("Path: ");
            this.pathTextField.setText(this.report.getPath());
            this.pathTextField.setVisible(true);
        } else {
            String text = "Path: ";
            if (this.report.getPath() != null) {
                text = text + this.report.getPath();
            }
            this.pathLabel.setText(text);
            this.pathTextField.setVisible(false);
        }
    }

    private void updateTransformationLabelAndTransformationColumnAndTextArea() {
        if (this.infoPane.edit()) {
            this.transformationColumn.setVisible(false);
            this.transformationTextArea.setVisible(true);
        } else {
            this.transformationColumn.setVisible(true);
            this.transformationTextArea.setVisible(false);
        }
        ReportComponent.updateMessageColumn(this.report.getTransformation(), this.transformationColumn);
        if (this.infoPane.showLineNumbers()) {
            ReportComponent.addLineNumbers(this.transformationColumn);
        }
        this.transformationTextArea.setText(this.report.getTransformation());
    }

    private void updateVariableLabelAndTextArea() {
        if (this.infoPane.edit()) {
            this.variableColumn.setVisible(false);
            this.variableLabel.setVisible(true);
            this.variableTextArea.setVisible(true);
        } else {
            this.variableColumn.setVisible(true);
            this.variableLabel.setVisible(false);
            this.variableTextArea.setVisible(false);
        }
        ReportComponent.updateMessageColumn(this.report.getVariableCsv(), this.variableColumn);
        if (this.infoPane.showLineNumbers()) {
            ReportComponent.addLineNumbers(this.variableColumn);
        }
        this.variableTextArea.setText(this.report.getVariableCsv());
    }

    @Override
    protected boolean hasChanges() {
        if (super.hasChanges()) {
            return true;
        }
        if (this.infoPane.edit()) {
            if (this.hasChanges(this.report.getName(), this.nameTextField.getText())) {
                return true;
            }
            if (this.hasChanges(this.report.getDescription(), this.descriptionTextArea.getText())) {
                return true;
            }
            if (this.hasChanges(this.report.getPath(), this.pathTextField.getText())) {
                return true;
            }
            if (this.hasChanges(this.report.getTransformation(), this.transformationTextArea.getText())) {
                return true;
            }
        }
        return false;
    }
}

