/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.reports;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.filetransfer.UploadEvent;
import nextapp.echo2.app.filetransfer.UploadListener;
import nl.nn.testtool.echo2.reports.ReportsComponent;
import nl.nn.testtool.echo2.test.TestComponent;
import nl.nn.testtool.echo2.util.Upload;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.storage.memory.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUploadListener
implements UploadListener {
    Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ReportsComponent reportsComponent;
    TestComponent testComponent;
    CrudStorage storage;

    public void setReportsComponent(ReportsComponent reportsComponent) {
        this.reportsComponent = reportsComponent;
    }

    public void setTestComponent(TestComponent testComponent) {
        this.testComponent = testComponent;
    }

    public void setStorage(CrudStorage storage) {
        this.storage = storage;
    }

    public void fileUpload(UploadEvent uploadEvent) {
        ArrayList reports = new ArrayList();
        CrudStorage storage = null;
        if (this.reportsComponent != null) {
            storage = new Storage();
        }
        if (this.testComponent != null) {
            storage = this.storage;
        }
        String errorMessage = Upload.upload(uploadEvent.getFileName(), uploadEvent.getInputStream(), storage, this.log);
        if (this.reportsComponent != null) {
            try {
                List storageIds = storage.getStorageIds();
                for (int i = storageIds.size() - 1; i > -1; --i) {
                    this.reportsComponent.openReport(storage.getReport((Integer)storageIds.get(i)), "Allowed", false, true);
                }
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        }
        if (errorMessage != null) {
            if (this.reportsComponent != null) {
                this.reportsComponent.displayAndLogError(errorMessage);
            }
            if (this.testComponent != null) {
                this.testComponent.displayAndLogError(errorMessage);
            }
        }
        if (this.reportsComponent != null) {
            this.reportsComponent.getUploadOptionsWindow().setVisible(false);
        }
        if (this.testComponent != null) {
            this.testComponent.getUploadOptionsWindow().setVisible(false);
            this.testComponent.refresh();
        }
    }

    public void invalidFileUpload(UploadEvent uploadEvent) {
        String message = "Invalid file upload: " + uploadEvent.getFileName() + ", " + uploadEvent.getContentType() + ", " + uploadEvent.getSize();
        this.log.error(message);
        if (this.reportsComponent != null) {
            this.reportsComponent.displayError(message);
            this.reportsComponent.getUploadOptionsWindow().setVisible(false);
        }
    }
}

