/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.reports;

import echopointng.SelectFieldEx;
import echopointng.table.DefaultSortableTableModel;
import echopointng.table.SortableTable;
import echopointng.tree.DefaultTreeCellRenderer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImageBorder;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.filetransfer.UploadListener;
import nextapp.echo2.app.filetransfer.UploadSelect;
import nextapp.echo2.app.layout.ColumnLayoutData;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableModel;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.echo2.BaseComponent;
import nl.nn.testtool.echo2.BeanParent;
import nl.nn.testtool.echo2.ComparePane;
import nl.nn.testtool.echo2.Echo2Application;
import nl.nn.testtool.echo2.TransformationWindow;
import nl.nn.testtool.echo2.reports.IntegerField;
import nl.nn.testtool.echo2.reports.MetadataTableCellRenderer;
import nl.nn.testtool.echo2.reports.MetadataTableHeaderRenderer;
import nl.nn.testtool.echo2.reports.ReportUploadListener;
import nl.nn.testtool.echo2.reports.TreePane;
import nl.nn.testtool.echo2.util.Download;
import nl.nn.testtool.filter.View;
import nl.nn.testtool.filter.Views;
import nl.nn.testtool.storage.LogStorage;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.transform.ReportXmlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsComponent
extends BaseComponent
implements BeanParent,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String OPEN_REPORT_ALLOWED = "Allowed";
    private List<String> changeReportGeneratorEnabledRoles;
    private TestTool testTool;
    private MetadataExtractor metadataExtractor;
    private Views views;
    private boolean addCompareButton = false;
    private boolean addSeparateOptionsRow = false;
    private TreePane treePane;
    private Label nameLabel;
    private IntegerField integerFieldMaxMetadataTableSize;
    private static final int defaultMaxMetadataTableSize = 10;
    private boolean focusMaxMetadataTableSize = true;
    private Label numberOfMetadataRecords;
    private SelectFieldEx viewSelect;
    private Row filterRow;
    private DefaultTableModel metadataTableModel;
    private DefaultSortableTableModel metadataSortableTableModel;
    private MetadataTableHeaderRenderer metadataTableHeaderRenderer;
    private MetadataTableCellRenderer metadataTableCellRenderer;
    private SortableTable metadataTable;
    private Label numberOfReportsInProgressLabel;
    private Label estimatedMemoryUsageReportsInProgressLabel;
    private ReportXmlTransformer reportXmlTransformer = null;
    private SelectField reportGeneratorEnabledSelectField;
    private Label reportGeneratorEnabledErrorLabel;
    private Label filterValuesLabel;
    private ListBox filterValuesListBox;
    private CheckBox checkBoxTransformReportXml;
    private IntegerField integerFieldOpenLatest;
    private TextField regexFilterField;
    private CheckBox checkBoxExcludeReportsWithEmptyReportXml;
    private IntegerField integerFieldOpenReportInProgress;
    private ComparePane comparePane;
    private WindowPane optionsWindow;
    private WindowPane filterWindow;
    private TransformationWindow transformationWindow;
    private WindowPane uploadWindow;
    private UploadSelect uploadSelect;
    private Object firstValueOfLastSelectedRow;
    private SelectField downloadSelectField;
    private BeanParent beanParent;
    private Echo2Application echo2Application;
    private boolean initCalled = false;

    public void setChangeReportGeneratorEnabledRoles(List<String> changeReportGeneratorEnabledRoles) {
        this.changeReportGeneratorEnabledRoles = changeReportGeneratorEnabledRoles;
    }

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public void setViews(Views views) {
        this.views = views;
    }

    public Views getViews() {
        return this.views;
    }

    public void setAddCompareButton(boolean addCompareButton) {
        this.addCompareButton = addCompareButton;
    }

    public void setAddSeparateOptionsRow(boolean addSeparateOptionsRow) {
        this.addSeparateOptionsRow = addSeparateOptionsRow;
    }

    public void setTransformationWindow(TransformationWindow transformationWindow) {
        this.transformationWindow = transformationWindow;
    }

    public void setFocusMaxMetadataTableSize(boolean focusMaxMetadataTableSize) {
        this.focusMaxMetadataTableSize = focusMaxMetadataTableSize;
    }

    @Override
    public void initBean() {
        super.initBean();
        DefaultListModel viewDefaultListModel = new DefaultListModel();
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            viewDefaultListModel.add(iterator.next());
        }
        this.viewSelect = new SelectFieldEx((ListModel)viewDefaultListModel);
        this.setSelectedView(this.views.getDefaultView());
        this.viewSelect.setActionCommand("ViewSelect");
        this.viewSelect.addActionListener((ActionListener)this);
        Column optionsColumn = new Column();
        this.optionsWindow = new WindowPane();
        this.optionsWindow.setVisible(false);
        this.optionsWindow.setTitle("Options");
        this.optionsWindow.setTitleBackground(Echo2Application.getButtonBackgroundColor());
        this.optionsWindow.setBorder(new FillImageBorder(Echo2Application.getButtonBackgroundColor(), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)));
        this.optionsWindow.setWidth(new Extent(500));
        this.optionsWindow.setHeight(new Extent(185));
        this.optionsWindow.setInsets(new Insets(10, 5, 0, 0));
        this.optionsWindow.add((Component)optionsColumn);
        this.optionsWindow.setDefaultCloseOperation(1);
        this.optionsWindow.init();
        Column filterColumn = new Column();
        this.filterWindow = new WindowPane();
        this.filterWindow.setVisible(false);
        this.filterWindow.setTitle("Filter");
        this.filterWindow.setTitleBackground(Echo2Application.getButtonBackgroundColor());
        this.filterWindow.setBorder(new FillImageBorder(Echo2Application.getButtonBackgroundColor(), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)));
        this.filterWindow.setWidth(new Extent(600));
        this.filterWindow.setHeight(new Extent(400));
        this.filterWindow.setInsets(new Insets(10, 5, 0, 0));
        this.filterWindow.add((Component)filterColumn);
        this.filterWindow.setDefaultCloseOperation(1);
        this.filterWindow.init();
        Column uploadColumn = new Column();
        this.uploadWindow = new WindowPane();
        this.uploadWindow.setVisible(false);
        this.uploadWindow.setTitle("Upload");
        this.uploadWindow.setTitleBackground(Echo2Application.getButtonBackgroundColor());
        this.uploadWindow.setBorder(new FillImageBorder(Echo2Application.getButtonBackgroundColor(), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)));
        this.uploadWindow.setWidth(new Extent(350));
        this.uploadWindow.setHeight(new Extent(110));
        this.uploadWindow.setInsets(new Insets(10, 0, 10, 0));
        this.uploadWindow.add((Component)uploadColumn);
        this.uploadWindow.setDefaultCloseOperation(1);
        this.uploadWindow.init();
        Row buttonRow = Echo2Application.getNewRow();
        Button expandAllButton = new Button("Expand all");
        expandAllButton.setActionCommand("ExpandAll");
        Echo2Application.decorateButton(expandAllButton);
        expandAllButton.addActionListener((ActionListener)this);
        Button collapseAllButton = new Button("Collapse all");
        collapseAllButton.setActionCommand("CollapseAll");
        Echo2Application.decorateButton(collapseAllButton);
        collapseAllButton.addActionListener((ActionListener)this);
        Button closeAllButton = new Button("Close all");
        closeAllButton.setActionCommand("CloseAll");
        Echo2Application.decorateButton(closeAllButton);
        closeAllButton.addActionListener((ActionListener)this);
        Button openAllButton = new Button("Open all");
        openAllButton.setActionCommand("OpenAll");
        openAllButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(openAllButton);
        Button downloadTableButton = new Button("Download table");
        downloadTableButton.setActionCommand("DownloadTable");
        downloadTableButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(downloadTableButton);
        Button downloadTreeButton = new Button("Download tree");
        downloadTreeButton.setActionCommand("DownloadTree");
        downloadTreeButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(downloadTreeButton);
        Button compareButton = new Button("Compare all");
        compareButton.setActionCommand("CompareAll");
        Echo2Application.decorateButton(compareButton);
        compareButton.addActionListener((ActionListener)this);
        Button prepareUploadButton = new Button("Upload...");
        prepareUploadButton.setActionCommand("OpenUploadWindow");
        Echo2Application.decorateButton(prepareUploadButton);
        prepareUploadButton.addActionListener((ActionListener)this);
        Button optionsButtonWindow = new Button("Options...");
        optionsButtonWindow.setActionCommand("OpenOptionsWindows");
        Echo2Application.decorateButton(optionsButtonWindow);
        optionsButtonWindow.addActionListener((ActionListener)this);
        Row optionsRow = null;
        if (this.addSeparateOptionsRow) {
            optionsRow = Echo2Application.getNewRow();
            optionsRow.setInsets(new Insets(0, 5, 0, 0));
        }
        Row uploadSelectRow = new Row();
        ReportUploadListener reportUploadListener = new ReportUploadListener();
        reportUploadListener.setReportsComponent(this);
        this.uploadSelect = new UploadSelect();
        this.uploadSelect.setEnabledSendButtonText("Upload");
        this.uploadSelect.setDisabledSendButtonText("Upload");
        try {
            this.uploadSelect.addUploadListener((UploadListener)reportUploadListener);
        }
        catch (TooManyListenersException e) {
            this.displayAndLogError(e);
        }
        Button buttonRefresh = new Button("Refresh");
        buttonRefresh.setActionCommand("Refresh");
        Echo2Application.decorateButton(buttonRefresh);
        buttonRefresh.addActionListener((ActionListener)this);
        this.downloadSelectField = new SelectField((Object[])new String[]{"Both", "Report", "Message"});
        this.downloadSelectField.setSelectedIndex(0);
        this.integerFieldMaxMetadataTableSize = new IntegerField();
        this.integerFieldMaxMetadataTableSize.setActionCommand("Refresh");
        this.integerFieldMaxMetadataTableSize.setWidth(new Extent(25));
        this.integerFieldMaxMetadataTableSize.setDefaultValue(10);
        this.integerFieldMaxMetadataTableSize.addActionListener(this);
        this.numberOfMetadataRecords = new Label();
        this.filterRow = Echo2Application.getNewRow();
        this.filterRow.setInsets(new Insets(0, 5, 0, 0));
        this.metadataTableModel = new DefaultTableModel();
        this.metadataSortableTableModel = new DefaultSortableTableModel((TableModel)this.metadataTableModel);
        this.metadataTableHeaderRenderer = new MetadataTableHeaderRenderer();
        this.metadataTableCellRenderer = new MetadataTableCellRenderer();
        ColumnLayoutData columnLayoutDataForTable = new ColumnLayoutData();
        this.metadataTable = new SortableTable((TableModel)this.metadataSortableTableModel);
        this.metadataTable.setDefaultHeaderRenderer((TableCellRenderer)this.metadataTableHeaderRenderer);
        this.metadataTable.setDefaultRenderer((TableCellRenderer)this.metadataTableCellRenderer);
        this.metadataTable.setLayoutData((LayoutData)columnLayoutDataForTable);
        this.metadataTable.setBorder(new Border(1, Color.BLACK, 7));
        this.metadataTable.setFont(DefaultTreeCellRenderer.DEFAULT_FONT);
        this.metadataTable.setRolloverBackground(Echo2Application.getButtonRolloverBackgroundColor());
        this.metadataTable.setRolloverEnabled(true);
        this.metadataTable.setSelectionBackground(Echo2Application.getButtonBackgroundColor());
        this.metadataTable.setSelectionEnabled(true);
        this.metadataTable.addActionListener((ActionListener)this);
        this.metadataTable.setActionCommand("OpenReport");
        columnLayoutDataForTable.setInsets(new Insets(0, 5, 0, 0));
        this.metadataTableCellRenderer.setMetadataExtractor(this.metadataExtractor);
        this.metadataTableHeaderRenderer.getLayoutData().setInsets(new Insets(0, 0, 0, 0));
        this.metadataTableHeaderRenderer.getLayoutData().setBackground(Echo2Application.getPaneBackgroundColor());
        this.metadataTableHeaderRenderer.setMetadataExtractor(this.metadataExtractor);
        this.nameLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.numberOfReportsInProgressLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.estimatedMemoryUsageReportsInProgressLabel = Echo2Application.createInfoLabelWithColumnLayoutData();
        this.reportGeneratorEnabledSelectField = new SelectField((Object[])new String[]{"Yes", "No"});
        this.reportGeneratorEnabledSelectField.setActionCommand("UpdateGeneratorEnabled");
        this.reportGeneratorEnabledSelectField.addActionListener((ActionListener)this);
        this.reportGeneratorEnabledErrorLabel = Echo2Application.createErrorLabelWithRowLayoutData();
        this.reportGeneratorEnabledErrorLabel.setVisible(false);
        this.filterValuesLabel = Echo2Application.createInfoLabelWithRowLayoutData();
        this.filterValuesListBox = new ListBox();
        this.filterValuesListBox.setSelectionMode(2);
        this.filterValuesListBox.setActionCommand("UpdateFilterValues");
        this.filterValuesListBox.addActionListener((ActionListener)this);
        this.filterValuesListBox.setHeight(new Extent(300));
        Row reportGeneratorEnabledRow = Echo2Application.getNewRow();
        reportGeneratorEnabledRow.setInsets(new Insets(0, 5, 0, 0));
        reportGeneratorEnabledRow.add((Component)new Label("Report generator enabled:"));
        reportGeneratorEnabledRow.add((Component)this.reportGeneratorEnabledSelectField);
        reportGeneratorEnabledRow.add((Component)this.reportGeneratorEnabledErrorLabel);
        this.regexFilterField = new TextField();
        this.regexFilterField.setWidth(new Extent(200));
        this.regexFilterField.setToolTipText("Example 1 (only store report when name is Hello World):\nHello World\n\nExample 2 (only store report when name contains Hello or World):\n.*(Hello|World).*\n\nExample 3 (only store report when name doesn't start with Hello World):\n^(?!Hello World).*");
        Button buttonRegexFilterField = new Button("Apply");
        buttonRegexFilterField.setActionCommand("UpdateRegexValues");
        Echo2Application.decorateButton(buttonRegexFilterField);
        buttonRegexFilterField.addActionListener((ActionListener)this);
        Row reportFilterRegexRow = Echo2Application.getNewRow();
        reportFilterRegexRow.setInsets(new Insets(0, 5, 0, 0));
        reportFilterRegexRow.add((Component)new Label("Report filter (regex):"));
        reportFilterRegexRow.add((Component)this.regexFilterField);
        reportFilterRegexRow.add((Component)buttonRegexFilterField);
        Row filterValuesLabelRow = Echo2Application.getNewRow();
        filterValuesLabelRow.setInsets(new Insets(0, 5, 0, 0));
        filterValuesLabelRow.add((Component)this.filterValuesLabel);
        Row filterValuesSelectRow = Echo2Application.getNewRow();
        filterValuesSelectRow.setInsets(new Insets(0, 5, 0, 0));
        filterValuesSelectRow.add((Component)new Label("Select one or more of:"));
        filterValuesSelectRow.add((Component)this.filterValuesListBox);
        this.checkBoxTransformReportXml = new CheckBox("Transform report xml");
        this.checkBoxTransformReportXml.setInsets(new Insets(0, 5, 0, 0));
        this.checkBoxTransformReportXml.setSelected(true);
        Button buttonOpenTransformationWindow = new Button("Transformation...");
        buttonOpenTransformationWindow.setActionCommand("OpenTransformationWindow");
        Echo2Application.decorateButton(buttonOpenTransformationWindow);
        buttonOpenTransformationWindow.addActionListener((ActionListener)this);
        Row transformationRow = Echo2Application.getNewRow();
        transformationRow.setInsets(new Insets(0, 5, 0, 0));
        transformationRow.add((Component)this.checkBoxTransformReportXml);
        transformationRow.add((Component)buttonOpenTransformationWindow);
        Row openLatestReportsRow = Echo2Application.getNewRow();
        openLatestReportsRow.setInsets(new Insets(0, 5, 0, 0));
        Button buttonOpen = new Button("Open");
        buttonOpen.setActionCommand("OpenLatestReports");
        Echo2Application.decorateButton(buttonOpen);
        buttonOpen.addActionListener((ActionListener)this);
        this.integerFieldOpenLatest = new IntegerField();
        this.integerFieldOpenLatest.setWidth(new Extent(25));
        this.integerFieldOpenLatest.setDefaultValue(10);
        this.checkBoxExcludeReportsWithEmptyReportXml = new CheckBox("Exclude reports with empty report xml");
        this.checkBoxExcludeReportsWithEmptyReportXml.setSelected(true);
        Button buttonOpenReportInProgress = new Button("Open");
        buttonOpenReportInProgress.setActionCommand("OpenReportInProgress");
        Echo2Application.decorateButton(buttonOpenReportInProgress);
        buttonOpenReportInProgress.addActionListener((ActionListener)this);
        this.integerFieldOpenReportInProgress = new IntegerField();
        this.integerFieldOpenReportInProgress.setWidth(new Extent(25));
        this.integerFieldOpenReportInProgress.setDefaultValue(1);
        Row openReportInProgressRow = Echo2Application.getNewRow();
        openReportInProgressRow.setInsets(new Insets(0, 5, 0, 0));
        openReportInProgressRow.add((Component)buttonOpenReportInProgress);
        openReportInProgressRow.add((Component)new Label("report in progress number"));
        openReportInProgressRow.add((Component)this.integerFieldOpenReportInProgress);
        buttonRow.add((Component)buttonRefresh);
        buttonRow.add((Component)optionsButtonWindow);
        if (this.addCompareButton) {
            buttonRow.add((Component)compareButton);
        }
        buttonRow.add((Component)prepareUploadButton);
        buttonRow.add((Component)downloadTableButton);
        buttonRow.add((Component)downloadTreeButton);
        buttonRow.add((Component)openAllButton);
        buttonRow.add((Component)expandAllButton);
        buttonRow.add((Component)collapseAllButton);
        buttonRow.add((Component)closeAllButton);
        uploadSelectRow.add((Component)new Label("Upload"));
        uploadSelectRow.add((Component)this.uploadSelect);
        uploadColumn.add((Component)uploadSelectRow);
        openLatestReportsRow.add((Component)buttonOpen);
        openLatestReportsRow.add((Component)this.integerFieldOpenLatest);
        openLatestReportsRow.add((Component)new Label("latest reports"));
        openLatestReportsRow.add((Component)this.checkBoxExcludeReportsWithEmptyReportXml);
        Row rowForAdditinalOptions = this.addSeparateOptionsRow ? optionsRow : buttonRow;
        rowForAdditinalOptions.add((Component)new Label("Download:"));
        rowForAdditinalOptions.add((Component)this.downloadSelectField);
        rowForAdditinalOptions.add((Component)new Label("View:"));
        rowForAdditinalOptions.add((Component)this.viewSelect);
        rowForAdditinalOptions.add((Component)this.integerFieldMaxMetadataTableSize);
        rowForAdditinalOptions.add((Component)this.numberOfMetadataRecords);
        optionsColumn.add((Component)reportGeneratorEnabledRow);
        optionsColumn.add((Component)reportFilterRegexRow);
        optionsColumn.add((Component)transformationRow);
        optionsColumn.add((Component)openLatestReportsRow);
        optionsColumn.add((Component)openReportInProgressRow);
        filterColumn.add((Component)filterValuesLabelRow);
        filterColumn.add((Component)filterValuesSelectRow);
        this.add((Component)buttonRow);
        if (this.addSeparateOptionsRow) {
            this.add((Component)optionsRow);
        }
        this.add((Component)this.errorLabel);
        this.add((Component)this.filterRow);
        this.add((Component)this.metadataTable);
        this.add((Component)this.nameLabel);
        this.add((Component)this.numberOfReportsInProgressLabel);
        this.add((Component)this.estimatedMemoryUsageReportsInProgressLabel);
    }

    @Override
    public void initBean(BeanParent beanParent) {
        this.beanParent = beanParent;
        this.echo2Application = Echo2Application.getEcho2Application(beanParent, this);
        this.echo2Application.getContentPane().add((Component)this.optionsWindow);
        this.echo2Application.getContentPane().add((Component)this.filterWindow);
        this.echo2Application.getContentPane().add((Component)this.uploadWindow);
        if (this.focusMaxMetadataTableSize) {
            this.echo2Application.setFocusedComponent((Component)this.getIntegerFieldMaxMetadataTableSize());
        }
        this.views.initBean(this);
    }

    @Override
    public BeanParent getBeanParent() {
        return this.beanParent;
    }

    public void init() {
        super.init();
        if (!this.initCalled) {
            this.initCalled = true;
            this.displayReports(true);
        }
    }

    public void setTreePane(TreePane treePane) {
        this.treePane = treePane;
    }

    public void setComparePane(ComparePane comparePane) {
        this.comparePane = comparePane;
    }

    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }

    public TextField getIntegerFieldMaxMetadataTableSize() {
        return this.integerFieldMaxMetadataTableSize;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hideMessages();
        if (e.getActionCommand().equals("ExpandAll")) {
            this.treePane.expandAll();
        } else if (e.getActionCommand().equals("CollapseAll")) {
            this.treePane.collapseAll();
        } else if (e.getActionCommand().equals("CloseAll")) {
            this.treePane.closeAllReports();
        } else if (e.getActionCommand().equals("DownloadTree")) {
            try {
                Storage storage = this.treePane.getStorage();
                List storageIds = storage.getStorageIds();
                this.download(storage, storageIds);
            }
            catch (StorageException storageException) {
                this.displayAndLogError(storageException);
            }
        } else if (e.getActionCommand().equals("DownloadTable")) {
            try {
                View view = this.getSelectedView();
                Storage storage = view.getStorage();
                nl.nn.testtool.storage.memory.Storage memStorage = new nl.nn.testtool.storage.memory.Storage();
                for (int i = 0; i < this.metadataTableModel.getRowCount(); ++i) {
                    Integer storageId = (Integer)this.metadataTableModel.getValueAt(0, i);
                    String isOpenReportAllowed = view.isOpenReportAllowed(storageId);
                    if (OPEN_REPORT_ALLOWED.equals(isOpenReportAllowed)) {
                        Report report = storage.getReport(storageId);
                        memStorage.store(report);
                        continue;
                    }
                    this.displayError(isOpenReportAllowed);
                }
                List storageIds = memStorage.getStorageIds();
                this.download(memStorage, storageIds);
            }
            catch (StorageException storageException) {
                this.displayAndLogError(storageException);
            }
        } else if (e.getActionCommand().equals("Refresh")) {
            this.displayReports(false);
        } else if (e.getActionCommand().equals("OpenReport")) {
            View view = this.getSelectedView();
            Table table = (Table)e.getSource();
            int selectedIndex = table.getSelectionModel().getMinSelectedIndex();
            this.firstValueOfLastSelectedRow = this.metadataTableModel.getValueAt(0, selectedIndex);
            this.openReport(view, (Integer)this.firstValueOfLastSelectedRow);
        } else if (e.getActionCommand().equals("OpenAll")) {
            View view = this.getSelectedView();
            for (int i = 0; i < this.metadataTableModel.getRowCount(); ++i) {
                Integer storageId = (Integer)this.metadataTableModel.getValueAt(0, i);
                this.openReport(view, storageId);
            }
        } else if (e.getActionCommand().equals("ViewSelect")) {
            this.treePane.redisplayReports(this.getSelectedView());
            this.displayReports(true);
        } else if (e.getActionCommand().equals("CompareAll")) {
            this.comparePane.compare();
        } else if (e.getActionCommand().equals("OpenOptionsWindows")) {
            this.reportGeneratorEnabledErrorLabel.setVisible(false);
            if (this.testTool.isReportGeneratorEnabled()) {
                this.reportGeneratorEnabledSelectField.setSelectedItem((Object)"Yes");
            } else {
                this.reportGeneratorEnabledSelectField.setSelectedItem((Object)"No");
            }
            this.regexFilterField.setText(this.testTool.getRegexFilter());
            this.optionsWindow.setVisible(true);
        } else if (e.getActionCommand().equals("UpdateGeneratorEnabled")) {
            if (this.echo2Application.isUserInRoles(this.changeReportGeneratorEnabledRoles)) {
                String msg = "Report generator ";
                if ("Yes".equals(this.reportGeneratorEnabledSelectField.getSelectedItem())) {
                    this.testTool.setReportGeneratorEnabled(true);
                    this.testTool.sendReportGeneratorStatusUpdate();
                    msg = msg + "enabled";
                } else if ("No".equals(this.reportGeneratorEnabledSelectField.getSelectedItem())) {
                    this.testTool.setReportGeneratorEnabled(false);
                    this.testTool.sendReportGeneratorStatusUpdate();
                    msg = msg + "disabled";
                }
                msg = msg + " by" + this.echo2Application.getCommandIssuedBy();
                if (this.testTool.getSecurityLog() != null) {
                    this.testTool.getSecurityLog().info(msg);
                } else {
                    log.debug(msg);
                }
            } else {
                this.reportGeneratorEnabledErrorLabel.setText("Not allowed");
                this.reportGeneratorEnabledErrorLabel.setVisible(true);
            }
        } else if (e.getActionCommand().equals("UpdateRegexValues")) {
            if (this.echo2Application.isUserInRoles(this.changeReportGeneratorEnabledRoles)) {
                this.testTool.setRegexFilter(this.regexFilterField.getText());
            } else {
                this.reportGeneratorEnabledErrorLabel.setText("Not allowed");
                this.reportGeneratorEnabledErrorLabel.setVisible(true);
            }
        } else if (e.getActionCommand().equals("OpenTransformationWindow")) {
            this.transformationWindow.setVisible(true);
        } else if (e.getActionCommand().equals("OpenLatestReports")) {
            View view = this.getSelectedView();
            Storage storage = view.getStorage();
            List storageIds = null;
            try {
                storageIds = storage.getStorageIds();
            }
            catch (StorageException storageException) {
                this.displayAndLogError(storageException);
            }
            if (storageIds != null) {
                int max = this.integerFieldOpenLatest.getValue();
                int size = storageIds.size();
                if (size < max) {
                    max = size;
                }
                for (int i = max - 1; i > -1; --i) {
                    this.openReport(view, (Integer)storageIds.get(i));
                }
            }
        } else if (e.getActionCommand().equals("OpenReportInProgress")) {
            Report report = this.testTool.getReportInProgress(this.integerFieldOpenReportInProgress.getValue() - 1);
            if (report != null) {
                View view = this.getSelectedView();
                String isOpenReportAllowed = view.isOpenReportAllowed(null);
                this.openReport(report, isOpenReportAllowed, this.checkBoxExcludeReportsWithEmptyReportXml.isSelected(), false);
            }
        } else if (e.getActionCommand().equals("OpenUploadWindow")) {
            this.uploadWindow.setVisible(true);
        } else if (e.getActionCommand().startsWith("Reset filter ")) {
            Column column;
            Button button;
            Component component;
            String metadataName = e.getActionCommand().substring(13);
            String filterValue = "";
            Map<String, String> metadataFilter = this.getSelectedView().getMetadataFilter();
            if (metadataFilter != null) {
                filterValue = metadataFilter.get(metadataName);
            }
            if ((component = (button = (Button)e.getSource()).getParent()) instanceof Grid) {
                Grid grid = (Grid)button.getParent();
                column = (Column)grid.getParent();
            } else {
                column = (Column)button.getParent();
            }
            TextField textField = (TextField)column.getComponent(1);
            textField.setText(filterValue);
            this.displayReports(false);
        } else if (e.getActionCommand().startsWith("Select filter ")) {
            String metadataName = e.getActionCommand().substring(14);
            Storage storage = this.getSelectedView().getStorage();
            List filterValues = null;
            try {
                filterValues = storage.getFilterValues(metadataName);
            }
            catch (StorageException storageException) {
                this.displayAndLogError(storageException);
            }
            if (filterValues != null) {
                Column column;
                this.filterValuesLabel.setText(metadataName);
                DefaultListModel filterListModel = (DefaultListModel)this.filterValuesListBox.getModel();
                filterListModel.removeAll();
                for (int i = 0; i < filterValues.size(); ++i) {
                    String fv;
                    Object o = filterValues.get(i);
                    if (o == null || (fv = (String)o).trim().length() <= 0) continue;
                    filterListModel.add((Object)fv);
                }
                Button button = (Button)e.getSource();
                Component component = button.getParent();
                if (component instanceof Grid) {
                    Grid grid = (Grid)button.getParent();
                    column = (Column)grid.getParent();
                } else {
                    column = (Column)button.getParent();
                }
                TextField textField = (TextField)column.getComponent(1);
                String currentFilterValue = textField.getText();
                String[] cfvs = currentFilterValue.split(",");
                int[] indices = new int[cfvs.length];
                for (int i = 0; i < cfvs.length; ++i) {
                    String cfv = cfvs[i];
                    int selectedIndex = filterListModel.indexOf((Object)cfv);
                    if (selectedIndex < 0) continue;
                    indices[i] = selectedIndex;
                }
                this.filterValuesListBox.setSelectedIndices(indices);
                this.filterWindow.setVisible(true);
            }
        } else if (e.getActionCommand().equals("UpdateFilterValues")) {
            String columnId = this.filterValuesLabel.getText();
            Column column = (Column)this.filterRow.getComponent(columnId);
            TextField textField = (TextField)column.getComponent(1);
            String listBoxValues = "";
            for (int i = 0; i < this.filterValuesListBox.getSelectedValues().length; ++i) {
                listBoxValues = i == 0 ? (String)this.filterValuesListBox.getSelectedValues()[i] : listBoxValues + "," + (String)this.filterValuesListBox.getSelectedValues()[i];
            }
            textField.setText(listBoxValues);
            this.displayReports(false);
        }
    }

    public void download(Storage storage, List storageIds) throws StorageException {
        if (storageIds.size() > 0) {
            String filename = storage.getReport((Integer)storageIds.get(0)).getName();
            if (storageIds.size() > 1) {
                filename = filename + " and " + (storageIds.size() - 1) + " more";
            }
            if ("Both".equals(this.downloadSelectField.getSelectedItem())) {
                this.displayAndLogError(Download.download(storage, filename, true, true));
            } else if ("Report".equals(this.downloadSelectField.getSelectedItem())) {
                this.displayAndLogError(Download.download(storage, filename));
            } else if ("Message".equals(this.downloadSelectField.getSelectedItem())) {
                this.displayAndLogError(Download.download(storage, filename, false, true));
            } else {
                this.displayError("No download type selected");
            }
        } else {
            this.displayError("No reports to download");
        }
    }

    private void openReport(View view, Integer storageId) {
        String isOpenReportAllowed = view.isOpenReportAllowed(storageId);
        if (OPEN_REPORT_ALLOWED.equals(isOpenReportAllowed)) {
            Storage storage = view.getStorage();
            Report report = this.echo2Application.getReport(storage, storageId, this);
            if (report != null) {
                this.openReport(report, isOpenReportAllowed);
            } else {
                this.displayError("Could not find report with storage id '" + storageId + "'");
            }
        } else {
            this.displayError(isOpenReportAllowed);
        }
    }

    public void openReport(Report report, String isOpenReportAllowed) {
        this.openReport(report, isOpenReportAllowed, false, false);
    }

    public void openReport(Report report, String isOpenReportAllowed, boolean excludeReportsWithEmptyReportXml, boolean sortReports) {
        if (OPEN_REPORT_ALLOWED.equals(isOpenReportAllowed)) {
            if (this.checkBoxTransformReportXml.isSelected()) {
                report.setGlobalReportXmlTransformer(this.reportXmlTransformer);
            }
            if (!excludeReportsWithEmptyReportXml || report.toXml().length() >= 1) {
                this.treePane.addReport(report, this.getSelectedView(), sortReports);
            }
        } else {
            this.displayError(isOpenReportAllowed);
        }
    }

    public void displayReports(boolean metadataNamesChanged) {
        int i;
        Storage storage;
        if (this.testTool.warnReportsInProgress()) {
            this.displayError("One or more reports are in progress for more than 5 minutes");
        }
        if (this.testTool.warnMessageCapturerWaitingForClose()) {
            this.displayError("One or more reports are finished but waiting for more than 30 seconds for one or more message capturers to close");
        }
        if ((storage = this.getSelectedView().getStorage()) instanceof LogStorage) {
            this.displayError(((LogStorage)storage).getWarningsAndErrors());
        }
        try {
            this.numberOfMetadataRecords.setText("/ " + storage.getSize());
        }
        catch (StorageException storageException) {
            this.displayAndLogError(storageException);
        }
        List<String> metadataNames = this.getSelectedView().getMetadataNames();
        if (metadataNamesChanged) {
            this.filterRow.removeAll();
            Map<String, String> metadataFilter = this.getSelectedView().getMetadataFilter();
            for (String metadataName : this.getSelectedView().getMetadataNames()) {
                int filterType = storage.getFilterType(metadataName);
                Button button = new Button(this.metadataExtractor.getShortLabel(metadataName));
                Column column = new Column();
                column.setId(metadataName);
                if (filterType == 1) {
                    Grid grid = new Grid();
                    column.add((Component)grid);
                    grid.add((Component)button);
                    Button selectButton = new Button("...");
                    grid.add((Component)selectButton);
                    grid.setWidth(new Extent(100, 2));
                    Echo2Application.decorateButton(selectButton);
                    selectButton.setFont(DefaultTreeCellRenderer.DEFAULT_FONT);
                    selectButton.setWidth(new Extent(35, 2));
                    String actionCommand = "Select filter ";
                    selectButton.setToolTipText(actionCommand + "value for " + this.metadataExtractor.getLabel(metadataName));
                    selectButton.setActionCommand(actionCommand + metadataName);
                    selectButton.addActionListener((ActionListener)this);
                    button.setWidth(new Extent(150, 2));
                } else {
                    column.add((Component)button);
                    button.setWidth(new Extent(100, 2));
                }
                TextField textField = new TextField();
                column.add((Component)textField);
                textField.setFont(DefaultTreeCellRenderer.DEFAULT_FONT);
                textField.setWidth(new Extent(104, 2));
                if (metadataFilter != null) {
                    textField.setText(metadataFilter.get(metadataName));
                }
                textField.setToolTipText(storage.getUserHelp(metadataName));
                if (filterType == 1) {
                    textField.setBackground(Echo2Application.getPaneBackgroundColor());
                    textField.setEnabled(false);
                }
                textField.setActionCommand("Refresh");
                textField.addActionListener((ActionListener)this);
                Echo2Application.decorateButton(button);
                button.setFont(DefaultTreeCellRenderer.DEFAULT_FONT);
                String actionCommand = "Reset filter ";
                button.setToolTipText(actionCommand + "value for " + this.metadataExtractor.getLabel(metadataName));
                button.setActionCommand(actionCommand + metadataName);
                button.addActionListener((ActionListener)this);
                this.filterRow.add((Component)column);
            }
            this.metadataTableHeaderRenderer.setMetadataNames(metadataNames);
            this.metadataTableCellRenderer.setMetadataNames(metadataNames);
            this.metadataTableModel.setColumnCount(metadataNames.size());
            for (i = 0; i < metadataNames.size(); ++i) {
                String metadataName = metadataNames.get(i);
                this.metadataTableModel.setColumnName(i, this.metadataExtractor.getShortLabel(metadataName));
            }
        }
        while (this.metadataTableModel.getRowCount() > 0) {
            this.metadataTableModel.deleteRow(0);
        }
        int numberOfRecords = this.integerFieldMaxMetadataTableSize.getValue();
        if (numberOfRecords < 0) {
            numberOfRecords = 10;
            this.integerFieldMaxMetadataTableSize.setText("10");
        }
        ArrayList<String> searchValues = new ArrayList<String>();
        for (i = 0; i < this.filterRow.getComponentCount(); ++i) {
            Column column = (Column)this.filterRow.getComponent(i);
            TextField textField = (TextField)column.getComponent(1);
            searchValues.add(textField.getText());
        }
        List<List<Object>> metadata = null;
        try {
            metadata = storage.getMetadata(numberOfRecords, metadataNames, searchValues, 2);
        }
        catch (StorageException storageException) {
            this.displayAndLogError(storageException);
        }
        if (metadata != null) {
            for (List<Object> metadataRecord : metadata) {
                Object[] rowData = new Object[metadataNames.size()];
                for (int i2 = 0; i2 < metadataRecord.size(); ++i2) {
                    rowData[i2] = metadataRecord.get(i2);
                }
                this.metadataTableModel.addRow(rowData);
            }
        }
        this.metadataTable.getSelectionModel().clearSelection();
        for (int i3 = 0; i3 < this.metadataTableModel.getRowCount(); ++i3) {
            if (this.firstValueOfLastSelectedRow == null || !this.metadataTableModel.getValueAt(0, i3).equals(this.firstValueOfLastSelectedRow)) continue;
            this.metadataTable.getSelectionModel().setSelectedIndex(i3, true);
        }
        this.nameLabel.setText("Name: " + storage.getName());
        this.numberOfReportsInProgressLabel.setText("Number of reports in progress: " + this.testTool.getNumberOfReportsInProgress());
        this.estimatedMemoryUsageReportsInProgressLabel.setText("Estimated memory usage reports in progress: " + this.testTool.getReportsInProgressEstimatedMemoryUsage() + " bytes");
    }

    public WindowPane getUploadOptionsWindow() {
        return this.uploadWindow;
    }

    public void setSelectedView(View view) {
        this.viewSelect.setSelectedItem((Object)view);
    }

    public View getSelectedView() {
        return (View)this.viewSelect.getSelectedItem();
    }
}

