/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.reports;

import echopointng.Tree;
import echopointng.tree.DefaultMutableTreeNode;
import echopointng.tree.DefaultTreeCellRenderer;
import java.lang.invoke.MethodHandles;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.ResourceImageReference;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.echo2.Echo2Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean showReportAndCheckpointIds;

    public Label getTreeCellRendererText(Tree tree, Object node, boolean selected, boolean expanded, boolean leaf) {
        boolean specialForeground = false;
        Label label = null;
        if (node != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)node;
            Object userObject = defaultMutableTreeNode.getUserObject();
            if (userObject instanceof Report) {
                label = super.getTreeCellRendererText(tree, node, selected, expanded, leaf);
                Report report = (Report)userObject;
                if (this.showReportAndCheckpointIds) {
                    label.setText("[" + report.getStorageId() + "] " + report.getName());
                }
                if (report.isDifferenceChecked()) {
                    if (report.isDifferenceFound()) {
                        label.setForeground(Echo2Application.getDifferenceFoundLabelColor());
                        specialForeground = true;
                    } else {
                        label.setForeground(Echo2Application.getNoDifferenceFoundLabelColor());
                        specialForeground = true;
                    }
                }
            } else if (userObject instanceof Checkpoint) {
                Checkpoint checkpoint = (Checkpoint)userObject;
                label = new Label();
                label.setIconTextMargin(new Extent(0));
                label.setFont(DefaultTreeCellRenderer.DEFAULT_FONT);
                if (this.showReportAndCheckpointIds) {
                    label.setText(checkpoint.getIndex() + ". " + checkpoint.getName());
                } else {
                    label.setText(checkpoint.getName());
                }
                String path = "/nl/nn/testtool/echo2/reports/";
                String error = "";
                if ("printStackTrace()".equals(checkpoint.getEncoding()) || checkpoint.isWaitingForStream()) {
                    error = "-error";
                }
                if (checkpoint.getType() == 1) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "startpoint" + error + "-even.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "startpoint" + error + "-odd.gif"));
                    }
                } else if (checkpoint.getType() == 2) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "endpoint" + error + "-odd.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "endpoint" + error + "-even.gif"));
                    }
                } else if (checkpoint.getType() == 3) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "abortpoint-odd.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "abortpoint-even.gif"));
                    }
                } else if (checkpoint.getType() == 4) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "inputpoint" + error + "-even.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "inputpoint" + error + "-odd.gif"));
                    }
                } else if (checkpoint.getType() == 5) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "outputpoint" + error + "-even.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "outputpoint" + error + "-odd.gif"));
                    }
                } else if (checkpoint.getType() == 6) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "infopoint" + error + "-even.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "infopoint" + error + "-odd.gif"));
                    }
                } else if (checkpoint.getType() == 7) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "threadStartpoint-error-even.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "threadStartpoint-error-odd.gif"));
                    }
                } else if (checkpoint.getType() == 8) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "threadStartpoint" + error + "-even.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "threadStartpoint" + error + "-odd.gif"));
                    }
                } else if (checkpoint.getType() == 9) {
                    if (defaultMutableTreeNode.getLevel() % 2 == 0) {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "threadEndpoint" + error + "-odd.gif"));
                    } else {
                        label.setIcon((ImageReference)new ResourceImageReference(path + "threadEndpoint" + error + "-even.gif"));
                    }
                }
            }
        }
        if (label == null) {
            if (selected) {
                expanded = true;
            }
            label = super.getTreeCellRendererText(tree, node, selected, expanded, false);
        }
        if (selected) {
            label.setBackground(Echo2Application.getButtonBackgroundColor());
            if (!specialForeground) {
                label.setForeground(Echo2Application.getButtonForegroundColor());
            }
        } else {
            label.setBackground(Echo2Application.getPaneBackgroundColor());
            if (!specialForeground) {
                label.setForeground(Color.BLACK);
            }
        }
        return label;
    }

    public void setShowReportAndCheckpointIds(boolean showReportAndCheckpointIds) {
        this.showReportAndCheckpointIds = showReportAndCheckpointIds;
    }
}

