/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.reports;

import echopointng.Tree;
import echopointng.tree.DefaultMutableTreeNode;
import echopointng.tree.DefaultTreeModel;
import echopointng.tree.MutableTreeNode;
import echopointng.tree.TreeCellRenderer;
import echopointng.tree.TreeModel;
import echopointng.tree.TreeNode;
import echopointng.tree.TreePath;
import echopointng.tree.TreeSelectionEvent;
import echopointng.tree.TreeSelectionListener;
import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.echo2.reports.InfoPane;
import nl.nn.testtool.echo2.reports.ReportsTreeCellRenderer;
import nl.nn.testtool.filter.View;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreePane
extends ContentPane
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    protected Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected InfoPane infoPane;
    private TreePane treePaneCounterpart;
    private ReportsTreeCellRenderer reportsTreeCellRenderer;
    private static final String ROOT_NODE_NAME = "Reports";
    protected DefaultMutableTreeNode rootNode;
    protected Tree tree;

    public void setInfoPane(InfoPane infoPane) {
        this.infoPane = infoPane;
    }

    public void setTreePaneCounterpart(TreePane treePane) {
        this.treePaneCounterpart = treePane;
    }

    public void setReportsTreeCellRenderer(ReportsTreeCellRenderer reportsTreeCellRenderer) {
        this.reportsTreeCellRenderer = reportsTreeCellRenderer;
    }

    public void initBean() {
        Column layoutColumn = new Column();
        this.add((Component)layoutColumn);
        this.rootNode = new DefaultMutableTreeNode((Object)ROOT_NODE_NAME);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)this.rootNode);
        this.tree = new Tree((TreeModel)defaultTreeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer((TreeCellRenderer)this.reportsTreeCellRenderer);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this);
        layoutColumn.add((Component)this.tree);
    }

    public void init() {
        super.init();
        this.selectNode(this.rootNode, null, false);
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public DefaultMutableTreeNode getReportNode(int reportIndex) {
        DefaultMutableTreeNode reportNode = null;
        if (reportIndex < this.rootNode.getChildCount()) {
            reportNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(reportIndex);
        }
        return reportNode;
    }

    public Checkpoint getSelectedCheckpoint() {
        Object[] path;
        Checkpoint selectedCheckpoint = null;
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath != null && (path = selectionPath.getPath()).length > 2) {
            selectedCheckpoint = (Checkpoint)((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getUserObject();
        }
        return selectedCheckpoint;
    }

    public DefaultMutableTreeNode findNodeWithEqualCheckpointPath(DefaultMutableTreeNode reportNode, Checkpoint checkpoint) {
        DefaultMutableTreeNode resultNode = null;
        if (reportNode.getChildCount() > 0) {
            DefaultMutableTreeNode checkpointRootNode = (DefaultMutableTreeNode)reportNode.getChildAt(0);
            Enumeration enumeration = checkpointRootNode.depthFirstEnumeration();
            while (resultNode == null && enumeration.hasMoreElements()) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
                Checkpoint currentCheckpoint = (Checkpoint)currentNode.getUserObject();
                if (!currentCheckpoint.getPath().equals(checkpoint.getPath())) continue;
                resultNode = currentNode;
            }
        }
        return resultNode;
    }

    public void selectNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode counterpartNode = null;
        boolean compare = false;
        if (this.treePaneCounterpart != null && node.getPath().length > 0) {
            if (node.getPath().length == 1) {
                this.treePaneCounterpart.selectNode(this.treePaneCounterpart.getRootNode(), null, false);
            } else {
                compare = true;
                int reportIndex = node.getRoot().getIndex(node.getPath()[1]);
                DefaultMutableTreeNode counterpartReportNode = this.treePaneCounterpart.getReportNode(reportIndex);
                if (counterpartReportNode != null) {
                    if (node.getPath().length == 2) {
                        counterpartNode = counterpartReportNode;
                    } else {
                        Checkpoint checkpoint = (Checkpoint)node.getUserObject();
                        counterpartNode = this.treePaneCounterpart.findNodeWithEqualCheckpointPath(counterpartReportNode, checkpoint);
                    }
                }
                if (counterpartNode != null) {
                    this.treePaneCounterpart.selectNode(counterpartNode, node, compare);
                } else {
                    this.treePaneCounterpart.unselect();
                }
            }
        }
        this.selectNode(node, counterpartNode, compare);
    }

    protected void selectNode(DefaultMutableTreeNode node, DefaultMutableTreeNode nodeFromOtherTree, boolean compare) {
        if (node != null) {
            Object userObject = node.getUserObject();
            TreePath treePath = new TreePath((Object[])node.getPath());
            this.tree.setSelectionPath(treePath);
            if (userObject instanceof Report) {
                Report report = (Report)node.getUserObject();
                Report reportFromOtherTree = null;
                if (nodeFromOtherTree != null) {
                    reportFromOtherTree = (Report)nodeFromOtherTree.getUserObject();
                }
                this.log.debug("Display report: " + report.getName());
                this.infoPane.displayReport(this.tree, treePath, node, report, reportFromOtherTree, compare);
            } else if (node.getUserObject() instanceof Checkpoint) {
                Report report = this.getReportParent(node);
                Checkpoint checkpoint = (Checkpoint)userObject;
                Checkpoint checkpointFromOtherTree = null;
                if (nodeFromOtherTree != null) {
                    checkpointFromOtherTree = (Checkpoint)nodeFromOtherTree.getUserObject();
                }
                this.log.debug("Display checkpoint: " + checkpoint.getName());
                this.infoPane.displayCheckpoint(this.tree, treePath, node, report, checkpoint, checkpointFromOtherTree, compare);
            } else if (userObject instanceof String) {
                String name = treePath.getPathComponent(treePath.getPathCount() - 1).toString();
                if (treePath.getPathCount() == 1) {
                    this.log.debug("Display reports: " + name);
                    this.infoPane.displayReports();
                } else {
                    this.log.debug("Display path: " + name);
                    this.infoPane.displayPath(this.tree, treePath, node, (String)userObject);
                }
            } else {
                this.log.debug("Display nothing");
                this.infoPane.displayNothing();
            }
        }
    }

    public void unselect() {
        this.tree.removeSelectionPaths(this.tree.getSelectionPaths());
    }

    public void expandDirectChilds() {
        this.tree.expandPath(new TreePath((Object)this.rootNode));
    }

    public void expandAll() {
        this.tree.expandAll();
    }

    public void expandAll(DefaultMutableTreeNode node) {
        this.tree.expandPath(new TreePath((Object[])node.getPath()));
        Enumeration enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumeration.nextElement();
            this.tree.expandPath(new TreePath((Object[])node.getPath()));
        }
    }

    public void collapseAll() {
        this.tree.collapseAll();
    }

    public void collapseAll(DefaultMutableTreeNode node) {
        this.tree.collapsePath(new TreePath((Object[])node.getPath()));
        Enumeration enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumeration.nextElement();
            this.tree.collapsePath(new TreePath((Object[])node.getPath()));
        }
    }

    public synchronized DefaultMutableTreeNode addReport(Report report, View view, boolean sortReports) {
        int insertPosition = 0;
        if (sortReports) {
            insertPosition = -1;
            for (int i = this.rootNode.getChildCount() - 1; i > -1 && insertPosition == -1; --i) {
                DefaultMutableTreeNode currentReportNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
                Report currentReport = (Report)currentReportNode.getUserObject();
                if (report.toXml().compareTo(currentReport.toXml()) <= 0) continue;
                insertPosition = i + 1;
            }
            if (insertPosition == -1) {
                insertPosition = 0;
            }
        }
        DefaultMutableTreeNode reportNode = new DefaultMutableTreeNode((Object)report);
        this.rootNode.insert((MutableTreeNode)reportNode, insertPosition);
        this.addCheckpoints(reportNode, view);
        DefaultMutableTreeNode nodeToSelect = this.expandOnlyChilds(reportNode);
        this.selectNode(nodeToSelect);
        return reportNode;
    }

    public DefaultMutableTreeNode expandOnlyChilds(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode nodeToExpandTo = node;
        while (nodeToExpandTo.getChildCount() == 1 && this.isStartpoint(((Checkpoint)((DefaultMutableTreeNode)nodeToExpandTo.getFirstChild()).getUserObject()).getType())) {
            this.tree.expandPath(new TreePath((Object[])nodeToExpandTo.getPath()));
            nodeToExpandTo = (DefaultMutableTreeNode)nodeToExpandTo.getFirstChild();
        }
        this.tree.expandPath(new TreePath((Object[])nodeToExpandTo.getPath()));
        return nodeToExpandTo;
    }

    public void addCheckpoints(DefaultMutableTreeNode reportNode, View view) {
        Report report = (Report)reportNode.getUserObject();
        for (Checkpoint checkpoint : report.getCheckpoints()) {
            if (!view.showCheckpoint(report, checkpoint)) continue;
            reportNode = this.addCheckpoint(reportNode, checkpoint);
        }
    }

    public DefaultMutableTreeNode addCheckpoint(DefaultMutableTreeNode parentNode, Checkpoint checkpoint) {
        if (parentNode.getChildCount() > 0) {
            int lastChildLevel = ((Checkpoint)((DefaultMutableTreeNode)parentNode.getLastChild()).getUserObject()).getLevel();
            if (checkpoint.getLevel() > lastChildLevel) {
                parentNode = (DefaultMutableTreeNode)parentNode.getLastChild();
            } else if (checkpoint.getLevel() < lastChildLevel) {
                parentNode = (DefaultMutableTreeNode)parentNode.getParent();
            }
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)checkpoint);
        parentNode.add((MutableTreeNode)node);
        return parentNode;
    }

    public void closeReport(Report report) {
        int childToSelect = -1;
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode reportNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
            if (!report.toString().equals(reportNode.getUserObject().toString())) continue;
            this.rootNode.remove(i);
            childToSelect = i < this.rootNode.getChildCount() ? i : i - 1;
        }
        if (childToSelect != -1) {
            this.tree.setSelectionPath(new TreePath(new TreePath((Object)this.rootNode), (Object)this.rootNode.getChildAt(childToSelect)));
        } else {
            this.tree.setSelectionPath(new TreePath((Object)this.rootNode));
        }
    }

    public void closeAllReports() {
        this.rootNode.removeAllChildren();
        this.selectNode(this.rootNode);
        this.tree.setVisible(false);
        this.tree.setVisible(true);
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e.getNewLeadSelectionPath() != null) {
            if (this.infoPane != null && this.infoPane.hasChanges()) {
                this.infoPane.displayError("First Save or change to Read-only");
                this.unselect();
            } else {
                TreePath treePath = e.getNewLeadSelectionPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                this.selectNode(node);
            }
        }
    }

    private Report getReportParent(DefaultMutableTreeNode node) {
        Object o = node.getUserObject();
        TreeNode parent = node.getParent();
        if (o instanceof Report) {
            return (Report)o;
        }
        if (parent == null || !(parent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return this.getReportParent((DefaultMutableTreeNode)parent);
    }

    public Storage getStorage() throws StorageException {
        nl.nn.testtool.storage.memory.Storage storage = new nl.nn.testtool.storage.memory.Storage();
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
            storage.store((Report)node.getUserObject());
        }
        return storage;
    }

    public void redisplayReports(View view) {
        if (this.rootNode.getChildCount() > 0) {
            DefaultMutableTreeNode selectedReportNode = this.getReportNodeFromSelectionPath();
            Checkpoint selectedCheckpoint = this.getSelectedCheckpoint();
            for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                DefaultMutableTreeNode reportNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
                reportNode.removeAllChildren();
                this.addCheckpoints(reportNode, view);
                this.expandOnlyChilds(reportNode);
            }
            if (selectedReportNode != null) {
                DefaultMutableTreeNode nodeToSelect = null;
                if (selectedCheckpoint != null && (nodeToSelect = this.findNodeWithEqualCheckpointPath(selectedReportNode, selectedCheckpoint)) != null) {
                    this.expandOnlyChilds(nodeToSelect);
                }
                if (nodeToSelect == null) {
                    nodeToSelect = this.expandOnlyChilds(selectedReportNode);
                }
                this.selectNode(nodeToSelect);
            }
        }
    }

    public DefaultMutableTreeNode getReportNodeFromSelectionPath() {
        Object[] path;
        DefaultMutableTreeNode reportNodeFromSelectionPath = null;
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath != null && (path = selectionPath.getPath()).length > 1) {
            reportNodeFromSelectionPath = (DefaultMutableTreeNode)path[1];
        }
        return reportNodeFromSelectionPath;
    }

    private boolean isStartpoint(int type) {
        return type == 1 || type == 8;
    }
}

