/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.test;

import echopointng.ProgressBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TooManyListenersException;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImageBorder;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.TextArea;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.filetransfer.UploadListener;
import nextapp.echo2.app.filetransfer.UploadSelect;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.echo2.BaseComponent;
import nl.nn.testtool.echo2.BeanParent;
import nl.nn.testtool.echo2.Echo2Application;
import nl.nn.testtool.echo2.TestPane;
import nl.nn.testtool.echo2.reports.MessageComponent;
import nl.nn.testtool.echo2.reports.ReportUploadListener;
import nl.nn.testtool.echo2.test.MetadataComparator;
import nl.nn.testtool.echo2.test.TreePane;
import nl.nn.testtool.echo2.util.Download;
import nl.nn.testtool.echo2.util.PopupWindow;
import nl.nn.testtool.run.ReportRunner;
import nl.nn.testtool.run.RunResult;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.transform.ReportXmlTransformer;
import nl.nn.testtool.util.CsvUtil;
import org.apache.commons.lang.StringUtils;

public class TestComponent
extends BaseComponent
implements BeanParent,
ActionListener {
    private static final long serialVersionUID = 1L;
    private TestTool testTool;
    private Storage debugStorage;
    private CrudStorage testStorage;
    private Echo2Application echo2Application;
    private TreePane treePane;
    private ProgressBar progressBar;
    private ReportRunner reportRunner;
    private TextField pathTextField;
    private ReportXmlTransformer reportXmlTransformer = null;
    private WindowPane uploadWindow;
    private WindowPane reportGenerationWindow;
    private WindowPane optionsWindow;
    private UploadSelect uploadSelect;
    private int numberOfComponentsToSkipForRowManipulation = 0;
    private String lastDisplayedPath;
    private BeanParent beanParent;
    private TextArea cloneGenerationTextArea;
    private Label reportGenerationWarningLabel;
    private final int INDEX_CHECKBOX = 0;
    private final int INDEX_RUN_BUTTON = 1;
    private final int INDEX_OPEN_BUTTON = 2;
    private final int INDEX_COMPARE_BUTTON = 3;
    private final int INDEX_REPLACE_BUTTON = 4;
    private final int INDEX_STORAGEID_LABEL = 5;
    private final int INDEX_ERROR_LABEL = 6;
    private final int INDEX_RESULT_LABEL = 7;
    private final int INDEX_DYNAMIC_VAR_LABEL = 8;
    private TextArea cloneGenerationReportInputTextArea;
    private Label cloneGenerationReportInputLabel;
    private CheckBox showReportStorageIdsCheckbox;
    private CheckBox showCheckpointIdsCheckbox;
    private boolean showReportStorageIds;
    private boolean showCheckpointIds;

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setDebugStorage(Storage debugStorage) {
        this.debugStorage = debugStorage;
    }

    public void setTestStorage(CrudStorage testStorage) {
        this.testStorage = testStorage;
    }

    public void setReportXmlTransformer(ReportXmlTransformer reportXmlTransformer) {
        this.reportXmlTransformer = reportXmlTransformer;
    }

    @Override
    public void initBean() {
        super.initBean();
        Column uploadColumn = new Column();
        Column cloneGenerationColumn = new Column();
        Column optionsColumn = new Column();
        this.uploadWindow = new WindowPane();
        this.uploadWindow.setVisible(false);
        this.uploadWindow.setTitle("Upload");
        this.uploadWindow.setTitleBackground(Echo2Application.getButtonBackgroundColor());
        this.uploadWindow.setBorder(new FillImageBorder(Echo2Application.getButtonBackgroundColor(), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)));
        this.uploadWindow.setWidth(new Extent(480));
        this.uploadWindow.setHeight(new Extent(360));
        this.uploadWindow.setInsets(new Insets(10, 0, 10, 0));
        this.uploadWindow.add((Component)uploadColumn);
        this.uploadWindow.setDefaultCloseOperation(1);
        this.uploadWindow.init();
        this.reportGenerationWindow = new WindowPane();
        this.reportGenerationWindow.setTitle("Generate report clones");
        this.reportGenerationWindow.setVisible(false);
        this.reportGenerationWindow.setWidth(new Extent(464));
        this.reportGenerationWindow.setHeight(new Extent(610));
        this.reportGenerationWindow.setInsets(new Insets(5, 5, 5, 5));
        this.reportGenerationWindow.add((Component)cloneGenerationColumn);
        this.reportGenerationWindow.setDefaultCloseOperation(1);
        this.reportGenerationWindow.init();
        this.optionsWindow = new WindowPane();
        this.optionsWindow.setTitle("Options");
        this.optionsWindow.setVisible(false);
        this.optionsWindow.setWidth(new Extent(280));
        this.optionsWindow.setHeight(new Extent(120));
        this.optionsWindow.setInsets(new Insets(5, 5, 5, 5));
        this.optionsWindow.add((Component)optionsColumn);
        this.optionsWindow.setDefaultCloseOperation(1);
        this.optionsWindow.init();
        Row buttonRow = Echo2Application.getNewRow();
        Button refreshButton = new Button("Refresh");
        refreshButton.setActionCommand("Refresh");
        refreshButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(refreshButton);
        buttonRow.add((Component)refreshButton);
        Button runSelectedButton = new Button("Run");
        runSelectedButton.setActionCommand("RunSelected");
        runSelectedButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(runSelectedButton);
        buttonRow.add((Component)runSelectedButton);
        Button resetSelectedButton = new Button("Reset");
        resetSelectedButton.setActionCommand("Reset");
        resetSelectedButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(resetSelectedButton);
        buttonRow.add((Component)resetSelectedButton);
        Button prepareOptionsButton = new Button("Options...");
        prepareOptionsButton.setActionCommand("OpenOptionsWindow");
        Echo2Application.decorateButton(prepareOptionsButton);
        prepareOptionsButton.addActionListener((ActionListener)this);
        buttonRow.add((Component)prepareOptionsButton);
        Button selectAllButton = new Button("Select all");
        selectAllButton.setActionCommand("SelectAll");
        selectAllButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(selectAllButton);
        buttonRow.add((Component)selectAllButton);
        Button deselectAllButton = new Button("Deselect all");
        deselectAllButton.setActionCommand("DeselectAll");
        deselectAllButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(deselectAllButton);
        buttonRow.add((Component)deselectAllButton);
        Button moveSelectedButton = new Button("Move");
        moveSelectedButton.setActionCommand("MoveSelected");
        moveSelectedButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(moveSelectedButton);
        buttonRow.add((Component)moveSelectedButton);
        Button copySelectedButton = new Button("Copy");
        copySelectedButton.setActionCommand("CopySelected");
        copySelectedButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(copySelectedButton);
        buttonRow.add((Component)copySelectedButton);
        Button cloneSelectedButton = new Button("Clone");
        cloneSelectedButton.setToolTipText("Generates clone reports based on a custom CSV-formatted table of parameters and their values. Example:\n\nid;firstname;lastname\n0;jaco;de groot\n1;daniel;meyer\n\nOne clone report is made for every row of values - two in this case. The parameters can be referred to in each report's input message by writing, for example, ${firstname}, which would be parsed to the corresponding value for that parameter at runtime.");
        cloneSelectedButton.setActionCommand("CloneSelected");
        cloneSelectedButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(cloneSelectedButton);
        buttonRow.add((Component)cloneSelectedButton);
        Button deleteSelectedButton = new Button("Delete");
        deleteSelectedButton.setActionCommand("DeleteSelected");
        deleteSelectedButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(deleteSelectedButton);
        buttonRow.add((Component)deleteSelectedButton);
        Button downloadAllButton = new Button("Download all");
        downloadAllButton.setActionCommand("DownloadAll");
        downloadAllButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(downloadAllButton);
        buttonRow.add((Component)downloadAllButton);
        Button prepareUploadButton = new Button("Upload...");
        prepareUploadButton.setActionCommand("OpenUploadWindow");
        Echo2Application.decorateButton(prepareUploadButton);
        prepareUploadButton.addActionListener((ActionListener)this);
        buttonRow.add((Component)prepareUploadButton);
        this.progressBar = new ProgressBar();
        buttonRow.add((Component)this.progressBar);
        this.reportRunner = new ReportRunner();
        this.reportRunner.setTestTool(this.testTool);
        this.reportRunner.setDebugStorage(this.debugStorage);
        Row uploadSelectRow = new Row();
        ReportUploadListener reportUploadListener = new ReportUploadListener();
        reportUploadListener.setTestComponent(this);
        reportUploadListener.setStorage(this.testStorage);
        this.uploadSelect = new UploadSelect();
        this.uploadSelect.setEnabledSendButtonText("Upload");
        this.uploadSelect.setDisabledSendButtonText("Upload");
        try {
            this.uploadSelect.addUploadListener((UploadListener)reportUploadListener);
        }
        catch (TooManyListenersException e) {
            this.displayAndLogError(e);
        }
        Row pathRow = Echo2Application.getNewRow();
        pathRow.setInsets(new Insets(0, 5, 0, 5));
        pathRow.add((Component)new Label("Move/Copy to:"));
        this.pathTextField = new TextField();
        this.pathTextField.setWidth(new Extent(400));
        pathRow.add((Component)this.pathTextField);
        uploadSelectRow.add((Component)new Label("Upload"));
        uploadSelectRow.add((Component)this.uploadSelect);
        uploadColumn.add((Component)uploadSelectRow);
        this.reportGenerationWarningLabel = Echo2Application.createErrorLabel();
        this.reportGenerationWarningLabel.setVisible(false);
        Row row = Echo2Application.getNewRow();
        row.add((Component)this.reportGenerationWarningLabel);
        cloneGenerationColumn.add((Component)row);
        Label cloneGenerationCsvLabel = Echo2Application.createInfoLabel();
        cloneGenerationCsvLabel.setText("Variable CSV:");
        row = Echo2Application.getNewRow();
        row.add((Component)cloneGenerationCsvLabel);
        cloneGenerationColumn.add((Component)row);
        this.cloneGenerationTextArea = new TextArea();
        this.cloneGenerationTextArea.setWidth(new Extent(440));
        this.cloneGenerationTextArea.setHeight(new Extent(240));
        row = Echo2Application.getNewRow();
        row.add((Component)this.cloneGenerationTextArea);
        cloneGenerationColumn.add((Component)row);
        this.cloneGenerationReportInputLabel = Echo2Application.createInfoLabel();
        this.cloneGenerationReportInputLabel.setText("Report input message to clone:");
        row = Echo2Application.getNewRow();
        row.add((Component)this.cloneGenerationReportInputLabel);
        cloneGenerationColumn.add((Component)row);
        this.cloneGenerationReportInputTextArea = new TextArea();
        this.cloneGenerationReportInputTextArea.setWidth(new Extent(440));
        this.cloneGenerationReportInputTextArea.setHeight(new Extent(240));
        row = Echo2Application.getNewRow();
        row.add((Component)this.cloneGenerationReportInputTextArea);
        cloneGenerationColumn.add((Component)row);
        Button generateClonesButton = new Button("Generate");
        generateClonesButton.setActionCommand("GenerateClonesFromCsv");
        generateClonesButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(generateClonesButton);
        row = Echo2Application.getNewRow();
        row.add((Component)generateClonesButton);
        cloneGenerationColumn.add((Component)row);
        this.showReportStorageIdsCheckbox = new CheckBox("Show report storage IDs");
        this.showReportStorageIdsCheckbox.setActionCommand("ToggleReportStorageIds");
        this.showReportStorageIdsCheckbox.addActionListener((ActionListener)this);
        this.showReportStorageIdsCheckbox.setSelected(this.showReportStorageIds);
        this.showCheckpointIdsCheckbox = new CheckBox("Show checkpoint IDs");
        this.showCheckpointIdsCheckbox.setActionCommand("ToggleCheckpointIds");
        this.showCheckpointIdsCheckbox.addActionListener((ActionListener)this);
        this.showCheckpointIdsCheckbox.setSelected(this.showCheckpointIds);
        Button restoreDefaultsButton = new Button("Restore defaults");
        restoreDefaultsButton.setActionCommand("RestoreDefaults");
        restoreDefaultsButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(restoreDefaultsButton);
        row = Echo2Application.getNewRow();
        row.add((Component)this.showReportStorageIdsCheckbox);
        optionsColumn.add((Component)row);
        row = Echo2Application.getNewRow();
        row.add((Component)this.showCheckpointIdsCheckbox);
        optionsColumn.add((Component)row);
        row = Echo2Application.getNewRow();
        row.add((Component)restoreDefaultsButton);
        optionsColumn.add((Component)row);
        this.add((Component)buttonRow);
        ++this.numberOfComponentsToSkipForRowManipulation;
        this.add((Component)pathRow);
        ++this.numberOfComponentsToSkipForRowManipulation;
        this.add((Component)this.errorLabel);
        ++this.numberOfComponentsToSkipForRowManipulation;
        this.add((Component)this.okayLabel);
        ++this.numberOfComponentsToSkipForRowManipulation;
    }

    @Override
    public void initBean(BeanParent beanParent) {
        this.beanParent = beanParent;
        this.echo2Application = Echo2Application.getEcho2Application(beanParent, this);
        this.echo2Application.getContentPane().add((Component)this.uploadWindow);
        this.echo2Application.getContentPane().add((Component)this.reportGenerationWindow);
        this.echo2Application.getContentPane().add((Component)this.optionsWindow);
        TestPane testPane = (TestPane)beanParent.getBeanParent();
        this.treePane = testPane.getTreePane();
        this.reportRunner.setSecurityContext(this.echo2Application);
    }

    @Override
    public BeanParent getBeanParent() {
        return this.beanParent;
    }

    /*
     * WARNING - void declaration
     */
    public void display(String path, Set<String> selectedStorageIds) {
        boolean selected;
        String metadataPath;
        while (this.getComponentCount() > this.numberOfComponentsToSkipForRowManipulation) {
            this.remove(this.numberOfComponentsToSkipForRowManipulation);
        }
        List<Object> metadata = new ArrayList();
        ArrayList<String> metadataNames = new ArrayList<String>();
        metadataNames.add("storageId");
        metadataNames.add("path");
        metadataNames.add("name");
        metadataNames.add("description");
        ArrayList<String> searchValues = new ArrayList<String>();
        searchValues.add(null);
        searchValues.add("[" + path + "*]");
        searchValues.add(null);
        searchValues.add(null);
        try {
            metadata = this.testStorage.getMetadata(-1, metadataNames, searchValues, 1);
        }
        catch (StorageException e) {
            this.displayAndLogError(e);
        }
        if (path.equals("/")) {
            for (Integer storageId : this.treePane.getReportsWithDirtyPaths()) {
                try {
                    void var8_12;
                    boolean bl = false;
                    while (var8_12 < metadata.size()) {
                        List metadataRecord = (List)metadata.get((int)var8_12);
                        if (metadataRecord.get(0).equals(storageId.toString())) {
                            metadata.remove((int)var8_12);
                            --var8_12;
                        }
                        ++var8_12;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(storageId.toString());
                    arrayList.add("/");
                    Report report = this.testStorage.getReport(storageId);
                    arrayList.add(report.getName());
                    arrayList.add(report.getDescription());
                    metadata.add(arrayList);
                }
                catch (NumberFormatException numberFormatException) {
                    this.displayAndLogError(numberFormatException);
                }
                catch (StorageException storageException) {
                    this.displayAndLogError(storageException);
                }
            }
        }
        boolean directChildReportsPresent = false;
        Collections.sort(metadata, new MetadataComparator());
        for (List list : metadata) {
            metadataPath = (String)list.get(1);
            if (!path.equals(metadataPath)) continue;
            selected = selectedStorageIds != null ? selectedStorageIds.contains(list.get(0)) : true;
            this.displayReport(list, selected);
            directChildReportsPresent = true;
        }
        for (List list : metadata) {
            metadataPath = (String)list.get(1);
            if (path.equals(metadataPath)) continue;
            selected = selectedStorageIds != null ? selectedStorageIds.contains(list.get(0)) : !directChildReportsPresent;
            this.displayReport(list, selected);
        }
        this.pathTextField.setText(path);
        this.lastDisplayedPath = path;
        this.updateProgressBar();
    }

    private void displayReport(List<Object> metadataRecord, boolean selected) {
        String storageId = (String)metadataRecord.get(0);
        String path = (String)metadataRecord.get(1);
        String name = (String)metadataRecord.get(2);
        String description = (String)metadataRecord.get(3);
        this.displayReport(storageId, path, name, description, selected);
    }

    private void displayReport(String storageId, String path, String name, String description, boolean selected) {
        Row row = Echo2Application.getNewRow();
        row.setId(storageId);
        row.setInsets(new Insets(0, 5, 0, 0));
        CheckBox checkBox = new CheckBox("");
        checkBox.setSelected(selected);
        row.add((Component)checkBox, 0);
        Button runButton = new Button("Run");
        runButton.setActionCommand("Run");
        runButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(runButton);
        row.add((Component)runButton, 1);
        Button openButton = new Button("Open");
        openButton.setActionCommand("Open");
        openButton.addActionListener((ActionListener)this);
        Echo2Application.decorateButton(openButton);
        row.add((Component)openButton, 2);
        Button button = new Button("Compare");
        button.setActionCommand("Compare");
        button.addActionListener((ActionListener)this);
        button.setVisible(false);
        Echo2Application.decorateButton(button);
        row.add((Component)button, 3);
        button = new Button("Replace");
        button.setActionCommand("Replace");
        button.addActionListener((ActionListener)this);
        button.setVisible(false);
        Echo2Application.decorateButton(button);
        row.add((Component)button, 4);
        Report report = null;
        try {
            report = this.testStorage.getReport(Integer.parseInt(storageId));
        }
        catch (StorageException e) {
            this.displayAndLogError(e);
        }
        Label storageIdLabel = new Label(String.valueOf(report.getStorageId()));
        storageIdLabel.setForeground(Echo2Application.getButtonBackgroundColor());
        storageIdLabel.setVisible(this.showReportStorageIds);
        row.add((Component)storageIdLabel, 5);
        Label fullPathLabel = new Label(report.getFullPath());
        row.add((Component)fullPathLabel, 5);
        Label errorLabel = Echo2Application.createErrorLabel();
        errorLabel.setVisible(false);
        row.add((Component)errorLabel, 6);
        Label resultLabel = new Label();
        RunResult runResult = this.reportRunner.getResults().get(Integer.parseInt(storageId));
        if (runResult != null) {
            if (runResult.errorMessage != null) {
                errorLabel.setText(runResult.errorMessage);
                errorLabel.setVisible(true);
            } else {
                Report runResultReport = this.getRunResultReport(runResult.correlationId);
                if (runResultReport == null) {
                    errorLabel.setText("Result report not found. Report generator not enabled?");
                    errorLabel.setVisible(true);
                } else if (report != null) {
                    int stubbed = 0;
                    boolean first = true;
                    for (Checkpoint checkpoint : runResultReport.getCheckpoints()) {
                        if (first) {
                            first = false;
                            continue;
                        }
                        if (!checkpoint.isStubbed()) continue;
                        ++stubbed;
                    }
                    int total = runResultReport.getCheckpoints().size() - 1;
                    String stubInfo = " (" + stubbed + "/" + total + " stubbed)";
                    resultLabel.setText("(" + (report.getEndTime() - report.getStartTime()) + " >> " + (runResultReport.getEndTime() - runResultReport.getStartTime()) + " ms)" + stubInfo);
                    report.setGlobalReportXmlTransformer(this.reportXmlTransformer);
                    runResultReport.setGlobalReportXmlTransformer(this.reportXmlTransformer);
                    runResultReport.setTransformation(report.getTransformation());
                    runResultReport.setReportXmlTransformer(report.getReportXmlTransformer());
                    if (report.toXml(this.reportRunner).equals(runResultReport.toXml(this.reportRunner))) {
                        resultLabel.setForeground(Echo2Application.getNoDifferenceFoundTextColor());
                    } else {
                        resultLabel.setForeground(Echo2Application.getDifferenceFoundTextColor());
                    }
                    ((Button)row.getComponent(3)).setVisible(true);
                    ((Button)row.getComponent(4)).setVisible(true);
                }
            }
        }
        row.add((Component)resultLabel, 7);
        Label dynamicVarLabel = this.newDynamicVariableLabel(report);
        row.add((Component)dynamicVarLabel, 8);
        this.add((Component)row);
        if (description != null && !"".equals(description) && !"null".equals(description)) {
            Column descriptionColumn = new Column();
            descriptionColumn.setInsets(new Insets(0, 5, 0, 0));
            MessageComponent.updateMessageColumn(description, descriptionColumn);
            this.add((Component)descriptionColumn);
        }
    }

    private Label newDynamicVariableLabel(Report report) {
        Label label = new Label();
        label.setForeground(Echo2Application.getButtonRolloverBackgroundColor());
        if (report.getVariableCsv() != null) {
            String labelText = "[";
            boolean tooManyChars = false;
            for (Map.Entry<String, String> entry : report.getVariablesAsMap().entrySet()) {
                if (labelText.length() + entry.getValue().length() < 50) {
                    labelText = labelText + entry.getKey() + "=" + entry.getValue() + ", ";
                    continue;
                }
                tooManyChars = true;
                break;
            }
            labelText = labelText.substring(0, labelText.length() - 2) + (tooManyChars ? "...]" : "]");
            label.setText(labelText);
        } else {
            label.setVisible(false);
        }
        return label;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Button button;
        Row row;
        Report report;
        this.hideMessages();
        if (e.getActionCommand().equals("Refresh")) {
            this.refresh();
        } else if (e.getActionCommand().equals("Reset")) {
            this.displayError(this.reportRunner.reset());
            this.refresh();
        } else if (e.getActionCommand().equals("SelectAll") || e.getActionCommand().equals("DeselectAll")) {
            for (Row row2 : this.getReportRows()) {
                CheckBox checkBox = (CheckBox)row2.getComponent(0);
                if (e.getActionCommand().equals("SelectAll")) {
                    checkBox.setSelected(true);
                    continue;
                }
                checkBox.setSelected(false);
            }
        } else if (e.getActionCommand().equals("RunSelected")) {
            if (this.minimalOneSelected()) {
                ArrayList<Row> rows = new ArrayList<Row>();
                for (Row row2 : this.getReportRows()) {
                    CheckBox checkBox = (CheckBox)row2.getComponent(0);
                    if (!checkBox.isSelected()) continue;
                    rows.add(row2);
                }
                ArrayList<Report> reports = new ArrayList<Report>();
                for (Row row3 : rows) {
                    Report report2 = this.getReport(row3);
                    if (report2 == null) continue;
                    reports.add(report2);
                }
                String string = this.reportRunner.run(reports, true, false);
                if (string == null) {
                    this.displayOkay("Report runner started, use Refresh to see results");
                } else {
                    this.displayError(string);
                }
            }
        } else if (e.getActionCommand().equals("DownloadAll")) {
            this.displayAndLogError(Download.download(this.testStorage));
        } else if (e.getActionCommand().equals("OpenUploadWindow")) {
            this.uploadWindow.setVisible(true);
        } else if (e.getActionCommand().equals("OpenOptionsWindow")) {
            this.optionsWindow.setVisible(true);
        } else if (e.getActionCommand().equals("ToggleReportStorageIds")) {
            this.showReportStorageIds = this.showReportStorageIdsCheckbox.isSelected();
            this.refresh();
        } else if (e.getActionCommand().equals("ToggleCheckpointIds")) {
            this.showCheckpointIds = this.showCheckpointIdsCheckbox.isSelected();
            this.echo2Application.getReportsTreeCellRenderer().setShowReportAndCheckpointIds(this.showCheckpointIds);
        } else if (e.getActionCommand().equals("RestoreDefaults")) {
            this.showReportStorageIds = false;
            this.showReportStorageIdsCheckbox.setSelected(false);
            this.showCheckpointIds = false;
            this.showCheckpointIdsCheckbox.setSelected(false);
            this.echo2Application.getReportsTreeCellRenderer().setShowReportAndCheckpointIds(this.showCheckpointIds);
            this.refresh();
        } else if (e.getActionCommand().equals("DeleteSelected")) {
            if (this.minimalOneSelected()) {
                String confirmActionLabelText;
                String popupMessage;
                ArrayList<String> actionLabels = new ArrayList<String>();
                ArrayList<String> actionCommands = new ArrayList<String>();
                ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>();
                int n = this.getSelectedReportCount();
                if (n > 1) {
                    popupMessage = "Are you sure you want to delete the " + n + " selected reports?";
                    confirmActionLabelText = "Yes, delete " + n + " selected reports";
                } else {
                    popupMessage = "Are you sure you want to delete the selected report?";
                    confirmActionLabelText = "Yes, delete 1 selected report";
                }
                actionLabels.add(confirmActionLabelText);
                actionCommands.add("DeleteOk");
                arrayList.add(this);
                actionLabels.add("No, cancel this action");
                actionCommands.add("DeleteCancel");
                arrayList.add(this);
                PopupWindow popupWindow = new PopupWindow("", popupMessage, 450, 100, actionLabels, actionCommands, arrayList);
                this.echo2Application.getContentPane().add((Component)popupWindow);
            }
        } else if (e.getActionCommand().equals("DeleteOk")) {
            for (Row row5 : this.getReportRows()) {
                Report report2;
                CheckBox checkBox = (CheckBox)row5.getComponent(0);
                if (!checkBox.isSelected() || (report2 = this.getReport(row5)) == null) continue;
                String errorMessage = Echo2Application.delete(this.testStorage, report2);
                if (errorMessage == null) {
                    this.remove((Component)row5);
                    this.treePane.getReportsWithDirtyPaths().remove(report2.getStorageId());
                    continue;
                }
                this.displayAndLogError(errorMessage);
            }
            this.refresh();
        } else if (e.getActionCommand().equals("MoveSelected")) {
            if (this.minimalOneSelected()) {
                String newPath = TestComponent.normalizePath(this.pathTextField.getText());
                for (Row row4 : this.getReportRows()) {
                    CheckBox checkBox = (CheckBox)row4.getComponent(0);
                    if (!checkBox.isSelected()) continue;
                    this.movePath(row4, newPath);
                }
                this.treePane.redisplayReports(newPath, null);
            }
        } else if (e.getActionCommand().equals("CopySelected") || e.getActionCommand().equals("CopyPathOk")) {
            if (this.minimalOneSelected()) {
                String newPath = TestComponent.normalizePath(this.pathTextField.getText());
                if (newPath.equals(this.lastDisplayedPath) && !e.getActionCommand().equals("CopyPathOk")) {
                    ArrayList<String> actionLabels = new ArrayList<String>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<ActionListener> arrayList2 = new ArrayList<ActionListener>();
                    actionLabels.add("Yes, duplicate reports");
                    arrayList.add("CopyPathOk");
                    arrayList2.add(this);
                    actionLabels.add("No, cancel this action");
                    arrayList.add("CopyPathCancel");
                    arrayList2.add(this);
                    PopupWindow popupWindow = new PopupWindow("", "Are you sure you want to copy to the same folder?", 375, 100, actionLabels, arrayList, arrayList2);
                    this.echo2Application.getContentPane().add((Component)popupWindow);
                } else {
                    this.copyPath(newPath);
                    this.treePane.redisplayReports(newPath, null);
                }
            }
        } else if (e.getActionCommand().equals("CloneSelected")) {
            if (this.getSelectedReportCount() == 1) {
                this.reportGenerationWindow.setVisible(true);
                for (Row r : this.getReportRows()) {
                    if (!((CheckBox)r.getComponent(0)).isSelected()) continue;
                    this.cloneGenerationReportInputTextArea.setText(this.getReport(r).getCheckpoints().get(0).getMessage());
                }
            } else if (this.getSelectedReportCount() > 1) {
                this.displayError("Please clone reports one at a time");
            } else {
                this.displayError("No report selected");
            }
        } else if (e.getActionCommand().equals("GenerateClonesFromCsv")) {
            if (this.getSelectedReportCount() == 1) {
                String errorMessage = CsvUtil.validateCsv(this.cloneGenerationTextArea.getText(), ";");
                if (errorMessage == null) {
                    Report reportToClone = null;
                    for (Row row5 : this.getReportRows()) {
                        if (!((CheckBox)row5.getComponent(0)).isSelected()) continue;
                        reportToClone = this.getReport(row5);
                    }
                    if (StringUtils.isNotEmpty((String)this.cloneGenerationReportInputTextArea.getText())) {
                        reportToClone.getInputCheckpoint().setMessage(this.cloneGenerationReportInputTextArea.getText());
                    }
                    if (!(reportToClone.getInputCheckpoint().containsVariables() || this.reportGenerationWarningLabel.getText() != null && this.reportGenerationWarningLabel.getText().endsWith("press again to confirm"))) {
                        this.reportGenerationWarningLabel.setText("No variables found in input message; press again to confirm");
                        this.reportGenerationWarningLabel.setVisible(true);
                    } else {
                        this.generateReportClonesFromCsv(reportToClone);
                        this.reportGenerationWindow.setVisible(false);
                        this.reportGenerationWarningLabel.setText(null);
                        this.reportGenerationWarningLabel.setVisible(false);
                        this.refresh();
                    }
                } else {
                    this.reportGenerationWarningLabel.setText(errorMessage);
                    this.reportGenerationWarningLabel.setVisible(true);
                }
            } else if (this.getSelectedReportCount() > 1) {
                this.displayError("Please clone reports one at a time");
            } else {
                this.displayError("No report selected");
            }
        } else if (e.getActionCommand().equals("Run")) {
            Button button2 = (Button)e.getSource();
            Row row7 = (Row)button2.getParent();
            Report report3 = this.getReport(row7);
            if (report3 != null) {
                ArrayList<Report> arrayList = new ArrayList<Report>();
                arrayList.add(report3);
                this.displayError(this.reportRunner.run(arrayList, false, true));
                this.refresh();
            }
        } else if (e.getActionCommand().equals("Open") || e.getActionCommand().equals("Compare")) {
            Button button3 = (Button)e.getSource();
            Row row8 = (Row)button3.getParent();
            Report report4 = this.getReport(row8);
            report4.setGlobalReportXmlTransformer(this.reportXmlTransformer);
            Integer n = new Integer(row8.getId());
            RunResult runResult = this.reportRunner.getResults().get(n);
            if (e.getActionCommand().equals("Open")) {
                this.echo2Application.openReport(report4, "Allowed");
            } else {
                Report runResultReport = this.getRunResultReport(runResult.correlationId);
                if (runResultReport != null) {
                    runResultReport.setGlobalReportXmlTransformer(this.reportXmlTransformer);
                    runResultReport.setTransformation(report4.getTransformation());
                    runResultReport.setReportXmlTransformer(report4.getReportXmlTransformer());
                    this.echo2Application.openReportCompare(report4, runResultReport, this.reportRunner);
                }
            }
        } else if (e.getActionCommand().equals("Delete")) {
            Button button4 = (Button)e.getSource();
            Row row9 = (Row)button4.getParent();
            Report report5 = this.getReport(row9);
            if (report5 != null) {
                String string = Echo2Application.delete(this.testStorage, report5);
                if (string == null) {
                    this.remove((Component)row9);
                } else {
                    this.displayAndLogError(string);
                }
            }
        } else if (e.getActionCommand().equals("Replace") && (report = this.getReport(row = (Row)(button = (Button)e.getSource()).getParent())) != null) {
            Integer n = new Integer(row.getId());
            boolean isSelected = ((CheckBox)row.getComponent(0)).isSelected();
            Report runResultReport = this.getRunResultReport(this.reportRunner.getResults().get((Object)n).correlationId);
            runResultReport.setTestTool(report.getTestTool());
            runResultReport.setName(report.getName());
            runResultReport.setDescription(report.getDescription());
            if (report.getCheckpoints().get(0).containsVariables()) {
                runResultReport.getCheckpoints().get(0).setMessage(report.getCheckpoints().get(0).getMessage());
            }
            runResultReport.setPath(report.getPath());
            runResultReport.setTransformation(report.getTransformation());
            runResultReport.setReportXmlTransformer(report.getReportXmlTransformer());
            runResultReport.setVariableCsvWithoutException(report.getVariableCsv());
            runResultReport.setStorageId(report.getStorageId());
            String errorMessage = Echo2Application.update(this.testStorage, runResultReport);
            if (errorMessage == null) {
                this.reportRunner.getResults().remove(n);
                if (this.treePane.getReportsWithDirtyPaths().remove(report.getStorageId())) {
                    this.treePane.getReportsWithDirtyPaths().add(runResultReport.getStorageId());
                }
                this.refresh();
                for (Row reportRow : this.getReportRows()) {
                    CheckBox checkbox = (CheckBox)reportRow.getComponent(0);
                    if (!new Integer(reportRow.getId()).equals(runResultReport.getStorageId())) continue;
                    checkbox.setSelected(isSelected);
                }
            } else {
                this.displayAndLogError(errorMessage);
            }
        }
        this.updateProgressBar();
    }

    private void generateReportClonesFromCsv(Report reportToClone) {
        Scanner scanner = new Scanner(this.cloneGenerationTextArea.getText());
        ArrayList<String> lines = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String nextLine = scanner.nextLine();
            if (!StringUtils.isNotEmpty((String)nextLine) || nextLine.startsWith("#")) continue;
            lines.add(nextLine);
        }
        scanner.close();
        try {
            reportToClone.setVariableCsvWithoutException((String)lines.get(0) + "\n" + (String)lines.get(1));
            this.displayAndLogError(Echo2Application.update(this.testStorage, reportToClone));
            if (lines.size() > 2) {
                for (int i = 2; i < lines.size(); ++i) {
                    Report cloneReport = reportToClone.clone();
                    cloneReport.setVariableCsvWithoutException((String)lines.get(0) + "\n" + (String)lines.get(i));
                    this.displayAndLogError(Echo2Application.store(this.testStorage, cloneReport));
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    private int getSelectedReportCount() {
        int count = 0;
        for (Row row : this.getReportRows()) {
            if (!((CheckBox)row.getComponent(0)).isSelected()) continue;
            ++count;
        }
        return count;
    }

    private void updateProgressBar() {
        this.progressBar.setMaximum(this.reportRunner.getMaximum());
        this.progressBar.setValue(this.reportRunner.getProgressValue());
        this.progressBar.setToolTipText(this.reportRunner.getProgressValue() + " / " + this.reportRunner.getMaximum());
    }

    public void refresh() {
        this.treePane.redisplayReports(this.lastDisplayedPath, this.getSelectedStorageIds());
    }

    private List<Row> getReportRows() {
        ArrayList<Row> result = new ArrayList<Row>();
        for (int i = this.numberOfComponentsToSkipForRowManipulation; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof Row)) continue;
            result.add((Row)component);
        }
        return result;
    }

    private Set<String> getSelectedStorageIds() {
        HashSet<String> selectedStorageIds = new HashSet<String>();
        for (Row row : this.getReportRows()) {
            CheckBox checkbox = (CheckBox)row.getComponent(0);
            if (!checkbox.isSelected()) continue;
            selectedStorageIds.add(row.getId());
        }
        return selectedStorageIds;
    }

    private boolean minimalOneSelected() {
        if (this.getSelectedStorageIds().size() > 0) {
            return true;
        }
        this.displayError("No reports selected");
        return false;
    }

    private Report getReport(Row row) {
        Integer storageId = new Integer(row.getId());
        return this.echo2Application.getReport(this.testStorage, storageId, this);
    }

    private Report getRunResultReport(String runResultCorrelationId) {
        Report report = null;
        try {
            report = this.reportRunner.getRunResultReport(runResultCorrelationId);
        }
        catch (StorageException storageException) {
            this.displayAndLogError(storageException);
        }
        return report;
    }

    public static String normalizePath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (Character.isLetterOrDigit(path.charAt(i)) || "/ -_.()".indexOf(path.charAt(i)) != -1) continue;
            if (path.length() > i + 1) {
                path = path.substring(0, i) + path.substring(i + 1);
                --i;
                continue;
            }
            path = path.substring(0, i);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        while (path.indexOf("//") != -1) {
            path = path.substring(0, path.indexOf("//")) + path.substring(path.indexOf("//") + 1);
        }
        return path;
    }

    private void movePath(Row row, String path) {
        Report report = this.getReport(row);
        if (report != null) {
            report.setPath(path);
            try {
                this.testStorage.update(report);
            }
            catch (StorageException e) {
                this.displayAndLogError(e);
            }
        }
    }

    private void copyPath(String newPath) {
        for (Row row : this.getReportRows()) {
            CheckBox checkbox = (CheckBox)row.getComponent(0);
            if (!checkbox.isSelected()) continue;
            this.copyPath(row, newPath);
        }
    }

    private void copyPath(Row row, String newPath) {
        Report report = this.getReport(row);
        if (report != null) {
            Integer storageId = new Integer(row.getId());
            this.log.debug("Copy report " + storageId + " from '" + report.getPath() + "' to '" + newPath + "'");
            try {
                Report clone = report.clone();
                clone.setPath(newPath);
                try {
                    this.testStorage.store(clone);
                }
                catch (StorageException e) {
                    this.displayAndLogError(e);
                }
            }
            catch (CloneNotSupportedException e) {
                this.displayAndLogError(e);
            }
        }
    }

    public WindowPane getUploadOptionsWindow() {
        return this.uploadWindow;
    }
}

