/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.echo2.test;

import echopointng.tree.DefaultMutableTreeNode;
import echopointng.tree.MutableTreeNode;
import echopointng.tree.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import nl.nn.testtool.Report;
import nl.nn.testtool.echo2.BeanParent;
import nl.nn.testtool.echo2.TestPane;
import nl.nn.testtool.echo2.test.InfoPane;
import nl.nn.testtool.echo2.test.TestComponent;
import nl.nn.testtool.filter.View;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;

public class TreePane
extends nl.nn.testtool.echo2.reports.TreePane
implements BeanParent {
    private static final long serialVersionUID = 1L;
    private InfoPane infoPane;
    private BeanParent beanParent;
    private Storage storage;
    private List<Integer> reportsWithDirtyPaths = new ArrayList<Integer>();

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    @Override
    public void setInfoPane(nl.nn.testtool.echo2.reports.InfoPane infoPane) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void initBean(BeanParent beanParent) {
        this.beanParent = beanParent;
        TestPane testPane = (TestPane)beanParent;
        this.infoPane = testPane.getInfoPane();
    }

    @Override
    public BeanParent getBeanParent() {
        return this.beanParent;
    }

    @Override
    public void init() {
        super.init();
        this.redisplayReports(null, null);
    }

    @Override
    public void selectNode(DefaultMutableTreeNode node) {
        this.selectNode(node, null);
    }

    @Override
    protected void selectNode(DefaultMutableTreeNode node, DefaultMutableTreeNode nodeFromOtherTree, boolean compare) {
        this.selectNode(node, null);
    }

    protected void selectNode(DefaultMutableTreeNode node, Set<String> selectedStorageIds) {
        if (node != null) {
            TreePath treePath = new TreePath((Object[])node.getPath());
            this.tree.setSelectionPath(treePath);
            String path = "";
            for (int i = 1; i < treePath.getPath().length; ++i) {
                path = path + "/" + treePath.getPath()[i];
            }
            path = path + "/";
            this.log.debug("Display: " + path);
            this.infoPane.display(path, selectedStorageIds);
        }
    }

    @Override
    public synchronized DefaultMutableTreeNode addReport(Report report, View view, boolean sortReports) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Storage getStorage() throws StorageException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void redisplayReports(View view) {
        throw new RuntimeException("Not implemented");
    }

    public void redisplayReports(String selectPath, Set<String> selectedStorageIds) {
        this.rootNode.removeAllChildren();
        this.reportsWithDirtyPaths.clear();
        ArrayList<String> metadataNames = new ArrayList<String>();
        metadataNames.add("storageId");
        metadataNames.add("path");
        List<List<Object>> metadata = null;
        try {
            metadata = this.storage.getMetadata(-1, metadataNames, null, 0);
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        ArrayList<String> pathsToAdd = new ArrayList<String>();
        for (List<Object> metadataRecord : metadata) {
            Integer storageId = (Integer)metadataRecord.get(0);
            String path = (String)metadataRecord.get(1);
            if (path == null || !path.equals(TestComponent.normalizePath(path))) {
                this.reportsWithDirtyPaths.add(storageId);
                continue;
            }
            if (path.length() <= 1) continue;
            pathsToAdd.add(path);
        }
        Collections.sort(pathsToAdd);
        DefaultMutableTreeNode selectNode = this.addPaths(pathsToAdd, this.rootNode, selectPath);
        if (selectNode == null) {
            selectNode = this.rootNode;
        }
        this.selectNode(selectNode, selectedStorageIds);
        this.tree.collapseAll();
        this.tree.expandAll();
    }

    private DefaultMutableTreeNode addPaths(List<String> paths, DefaultMutableTreeNode rootNode, String pathOfNodeToReturn) {
        DefaultMutableTreeNode returnNode = null;
        while (paths.size() > 0) {
            DefaultMutableTreeNode returnedNode;
            String path = paths.get(0);
            String firstElement = path.substring(1, path.indexOf(47, 1));
            DefaultMutableTreeNode subNode = new DefaultMutableTreeNode((Object)firstElement);
            rootNode.add((MutableTreeNode)subNode);
            if (pathOfNodeToReturn != null) {
                if (pathOfNodeToReturn.equals("/")) {
                    returnNode = rootNode;
                } else if (path.startsWith(pathOfNodeToReturn)) {
                    returnNode = subNode;
                }
            }
            ArrayList<String> subPaths = new ArrayList<String>();
            int i = 0;
            while (i < paths.size()) {
                path = paths.get(i);
                if (path.startsWith("/" + firstElement + "/")) {
                    String subPath = paths.remove(i);
                    if (subPath.length() <= firstElement.length() + 2) continue;
                    subPath = subPath.substring(firstElement.length() + 1);
                    subPaths.add(subPath);
                    continue;
                }
                ++i;
            }
            if (subPaths.size() <= 0) continue;
            String subPathOfNodeToReturn = null;
            if (pathOfNodeToReturn != null && pathOfNodeToReturn.startsWith("/" + firstElement + "/")) {
                subPathOfNodeToReturn = pathOfNodeToReturn.substring(firstElement.length() + 1);
            }
            if ((returnedNode = this.addPaths(subPaths, subNode, subPathOfNodeToReturn)) == null) continue;
            returnNode = returnedNode;
        }
        return returnNode;
    }

    public List<Integer> getReportsWithDirtyPaths() {
        return this.reportsWithDirtyPaths;
    }
}

