/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.metadata;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.metadata.DefaultValueMetadataFieldExtractor;

public class RegexMetadataFieldExtractor
extends DefaultValueMetadataFieldExtractor {
    protected String regex;
    protected Pattern pattern;
    protected boolean extractFromFirstCheckpointOnly = true;

    public void setRegex(String regex) {
        this.regex = regex;
        this.pattern = regex == null ? null : Pattern.compile(regex);
    }

    public void setExtractFromFirstCheckpointOnly(boolean extractFromFirstCheckpointOnly) {
        this.extractFromFirstCheckpointOnly = extractFromFirstCheckpointOnly;
    }

    @Override
    public Object extractMetadata(Report report) {
        String value = null;
        Iterator<Checkpoint> iterator = report.getCheckpoints().iterator();
        while (value == null && iterator.hasNext()) {
            String message = iterator.next().getMessage();
            Matcher matcher = this.pattern.matcher(message);
            if (matcher.find()) {
                value = matcher.group(matcher.groupCount());
            }
            if (!this.extractFromFirstCheckpointOnly) continue;
            break;
        }
        if (value == null) {
            value = this.defaultValue;
        }
        return value;
    }
}

