/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.metadata;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.metadata.DefaultValueMetadataFieldExtractor;
import nl.nn.testtool.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpathMetadataFieldExtractor
extends DefaultValueMetadataFieldExtractor {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String xpath;
    protected XPathExpression xpathExpression;
    protected String extractFrom = "first";

    public void setXpath(String xpath) throws XPathExpressionException {
        this.xpath = xpath;
        this.xpathExpression = xpath == null ? null : XmlUtil.createXPathExpression(xpath);
    }

    public void setExtractFrom(String extractFrom) {
        this.extractFrom = extractFrom;
    }

    @Override
    public Object extractMetadata(Report report) {
        String value = null;
        List<Checkpoint> extractFromList = null;
        if (this.extractFrom.equals("all")) {
            extractFromList = report.getCheckpoints();
        } else {
            extractFromList = new ArrayList<Checkpoint>();
            if (report.getCheckpoints().size() > 0) {
                if (this.extractFrom.equals("first")) {
                    extractFromList.add(report.getCheckpoints().get(0));
                } else if (this.extractFrom.equals("last")) {
                    extractFromList.add(report.getCheckpoints().get(report.getCheckpoints().size() - 1));
                }
            }
        }
        Iterator<Checkpoint> iterator = extractFromList.iterator();
        while (value == null && iterator.hasNext()) {
            String message = iterator.next().getMessage();
            if (message == null) continue;
            try {
                value = this.xpathExpression.evaluate(XmlUtil.createXmlSourceFromString(message));
            }
            catch (XPathExpressionException e) {
                log.debug("The message probably isn't in XML format", (Throwable)e);
            }
        }
        if (value == null) {
            value = this.defaultValue;
        }
        return value;
    }
}

