/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.run;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.nn.testtool.Report;
import nl.nn.testtool.SecurityContext;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.run.RunResult;
import nl.nn.testtool.storage.Storage;
import nl.nn.testtool.storage.StorageException;

public class ReportRunner
implements Runnable {
    private TestTool testTool;
    private SecurityContext securityContext;
    private List<Report> reportsTodo = new ArrayList<Report>();
    private int maximum = 1;
    private Map<Integer, RunResult> results = Collections.synchronizedMap(new HashMap());
    private boolean running = false;
    private Storage debugStorage;

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }

    public void setDebugStorage(Storage debugStorage) {
        this.debugStorage = debugStorage;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public synchronized String run(List<Report> reports, boolean reset, boolean wait) {
        if (this.running) {
            return "Already running!";
        }
        if (reset) {
            this.reset();
        }
        this.running = true;
        this.reportsTodo.addAll(reports);
        this.maximum = this.reportsTodo.size();
        if (wait) {
            this.run();
        } else {
            Thread thread = new Thread(this);
            thread.start();
        }
        return null;
    }

    public synchronized String reset() {
        if (this.running) {
            return "Still running!";
        }
        this.results.clear();
        return null;
    }

    @Override
    public void run() {
        for (Report report : this.reportsTodo) {
            this.run(report);
        }
        this.reportsTodo.clear();
        this.running = false;
    }

    private void run(Report report) {
        RunResult runResult = new RunResult();
        runResult.correlationId = TestTool.getCorrelationId();
        runResult.errorMessage = this.testTool.rerun(runResult.correlationId, report, this.securityContext, this);
        this.results.put(report.getStorageId(), runResult);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getProgressValue() {
        return this.results.size();
    }

    public Map<Integer, RunResult> getResults() {
        return this.results;
    }

    public Report getRunResultReport(String runResultCorrelationId) throws StorageException {
        Report report = null;
        ArrayList<String> metadataNames = new ArrayList<String>();
        metadataNames.add("storageId");
        metadataNames.add("correlationId");
        ArrayList<String> searchValues = new ArrayList<String>();
        searchValues.add(null);
        searchValues.add(runResultCorrelationId);
        List<List<Object>> metadata = null;
        metadata = this.debugStorage.getMetadata(-1, metadataNames, searchValues, 0);
        if (metadata != null && metadata.size() > 0) {
            Integer runResultStorageId = (Integer)metadata.get(0).get(0);
            report = this.debugStorage.getReport(runResultStorageId);
        }
        return report;
    }

    public Storage getDebugStorage() {
        return this.debugStorage;
    }
}

