/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.database;

import java.io.ByteArrayInputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.LogStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.storage.database.DbmsSupport;
import nl.nn.testtool.util.Export;
import nl.nn.testtool.util.Import;
import nl.nn.testtool.util.SearchUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;

public class DatabaseStorage
implements LogStorage,
CrudStorage {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private String name;
    private String table;
    private String storageIdColumnName;
    private List<String> metadataColumns;
    private List<String> integerColumns;
    private List<String> longColumns;
    private List<String> timestampColumns;
    private List<String> bigValueColumns;
    private JdbcTemplate jdbcTemplate;
    private DbmsSupport dbmsSupport;
    private MetadataExtractor metadataExtractor;
    private String lastExceptionMessage;

    @PostConstruct
    public void init() throws StorageException {
        if (this.storageIdColumnName == null) {
            this.storageIdColumnName = "storageId";
        }
        if (this.metadataColumns == null || !this.metadataColumns.contains(this.storageIdColumnName)) {
            throw new StorageException("List metadataColumns should at least contain storageId column name '" + this.storageIdColumnName + "'");
        }
        if (this.integerColumns == null) {
            this.integerColumns = new ArrayList<String>();
        }
        if (this.longColumns == null) {
            this.longColumns = new ArrayList<String>();
        }
        if (this.timestampColumns == null) {
            this.timestampColumns = new ArrayList<String>();
        }
        if (this.bigValueColumns == null) {
            this.bigValueColumns = new ArrayList<String>();
        }
    }

    @Override
    public void store(final Report report) throws StorageException {
        final byte[] reportBytes = Export.getReportBytes(report);
        report.setStorageSize(new Long(reportBytes.length));
        StringBuilder query = new StringBuilder("insert into " + this.table + " (");
        for (String column : this.metadataColumns) {
            if (column.equals(this.storageIdColumnName)) continue;
            if (query.charAt(query.length() - 1) != '(') {
                query.append(", ");
            }
            query.append(column);
        }
        query.append(", report) values (");
        for (String column : this.metadataColumns) {
            if (column.equals(this.storageIdColumnName)) continue;
            if (query.charAt(query.length() - 1) != '(') {
                query.append(", ");
            }
            query.append("?");
        }
        query.append(", ?)");
        log.debug("Store report query: " + query.toString());
        this.jdbcTemplate.update(query.toString(), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                int i = 1;
                for (String column : DatabaseStorage.this.metadataColumns) {
                    if (column.equals(DatabaseStorage.this.storageIdColumnName)) continue;
                    if (DatabaseStorage.this.integerColumns.contains(column)) {
                        ps.setInt(i, (Integer)DatabaseStorage.this.metadataExtractor.getMetadata(report, column, 0));
                    } else if (DatabaseStorage.this.longColumns.contains(column)) {
                        ps.setLong(i, (Long)DatabaseStorage.this.metadataExtractor.getMetadata(report, column, 0));
                    } else if (DatabaseStorage.this.timestampColumns.contains(column)) {
                        ps.setTimestamp(i, new Timestamp((Long)DatabaseStorage.this.metadataExtractor.getMetadata(report, column, 0)));
                    } else {
                        ps.setString(i, (String)DatabaseStorage.this.metadataExtractor.getMetadata(report, column, 0));
                    }
                    ++i;
                }
                ps.setBlob(i, new ByteArrayInputStream(reportBytes));
            }
        });
    }

    @Override
    public void storeWithoutException(Report report) {
        block2: {
            try {
                this.store(report);
            }
            catch (Throwable throwable) {
                if (throwable instanceof StorageException) break block2;
                this.lastExceptionMessage = throwable.getMessage();
                log.error("Caught unexpected throwable storing report", throwable);
            }
        }
    }

    @Override
    public String getWarningsAndErrors() {
        return this.lastExceptionMessage;
    }

    @Override
    public Report getReport(Integer storageId) throws StorageException {
        String query = "select report, storageSize from " + this.table + " where " + this.storageIdColumnName + " = ?";
        log.debug("Get report query: " + query);
        List result = this.jdbcTemplate.query(query, new Object[]{storageId}, new int[]{4}, (resultSet, rowNum) -> DatabaseStorage.getReport(storageId, resultSet.getBlob(1), resultSet.getLong(2)));
        return (Report)result.get(0);
    }

    private static Report getReport(Integer storageId, Blob blob, long storageSize) {
        return Import.getReport(blob.getBinaryStream(), storageId, blob.length(), log);
    }

    @Override
    public void update(Report report) throws StorageException {
        throw new StorageException("Update method is not implemented yet...");
    }

    @Override
    public void delete(final Report report) throws StorageException {
        String query = "delete from " + this.table + " where " + this.storageIdColumnName + " = ?";
        log.debug("Delete report query: " + query);
        this.jdbcTemplate.update(query, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setInt(1, report.getStorageId());
            }
        });
    }

    @Override
    public void clear() throws StorageException {
        throw new StorageException("Clear method is not implemented yet...");
    }

    @Override
    public int getSize() throws StorageException {
        String query = "select count(*) from " + this.table;
        log.debug("Get size query: " + query);
        try {
            return (Integer)this.jdbcTemplate.queryForObject(query, Integer.class);
        }
        catch (DataAccessException e) {
            throw new StorageException("Could not read size", e);
        }
    }

    @Override
    public List<Integer> getStorageIds() throws StorageException {
        String query = "select " + this.storageIdColumnName + " from " + this.table + " order by " + this.storageIdColumnName + " desc";
        log.debug("Get storage id's query: " + query);
        try {
            List storageIds = this.jdbcTemplate.query(query, (rs, rowNum) -> rs.getInt(1));
            return storageIds;
        }
        catch (DataAccessException e) {
            throw new StorageException("Could not read storage id's", e);
        }
    }

    @Override
    public List<List<Object>> getMetadata(int maxNumberOfRecords, List<String> metadataNames, List<String> searchValues, int metadataValueType) throws StorageException {
        List metadata;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIMESTAMP_PATTERN);
        ArrayList<String> rangeSearchValues = new ArrayList<String>();
        ArrayList<String> regexSearchValues = new ArrayList<String>();
        for (int i2 = 0; i2 < searchValues.size(); ++i2) {
            String searchValue = searchValues.get(i2);
            if (searchValue != null && searchValue.startsWith("<") && searchValue.endsWith(">")) {
                rangeSearchValues.add(searchValue);
                regexSearchValues.add(null);
                searchValues.remove(i2);
                searchValues.add(i2, null);
                continue;
            }
            if (searchValue != null && searchValue.startsWith("(") && searchValue.endsWith(")")) {
                rangeSearchValues.add(null);
                regexSearchValues.add(searchValue);
                searchValues.remove(i2);
                searchValues.add(i2, null);
                continue;
            }
            rangeSearchValues.add(null);
            regexSearchValues.add(null);
        }
        StringBuilder query = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<Integer> argTypes = new ArrayList<Integer>();
        this.buildMetadataQuery(maxNumberOfRecords, metadataNames, searchValues, rangeSearchValues, simpleDateFormat, query, args, argTypes);
        if (log.isDebugEnabled()) {
            log.debug("Get metadata query: " + query.toString());
        }
        try {
            metadata = this.jdbcTemplate.query(query.toString(), args.toArray(), argTypes.stream().mapToInt(i -> i).toArray(), (rs, rowNum) -> {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < metadataNames.size(); ++i) {
                    if (this.integerColumns.contains(metadataNames.get(i))) {
                        row.add(rs.getInt(i + 1));
                        continue;
                    }
                    if (this.timestampColumns.contains(metadataNames.get(i))) {
                        Timestamp timestamp = rs.getTimestamp(i + 1);
                        String value = null;
                        if (timestamp != null) {
                            value = simpleDateFormat.format(timestamp);
                        }
                        row.add(value);
                        continue;
                    }
                    row.add(rs.getString(i + 1));
                }
                return row;
            });
        }
        catch (DataAccessException e) {
            throw new StorageException("Could not read metadata", e);
        }
        for (int i3 = 0; i3 < metadata.size(); ++i3) {
            if (SearchUtil.matches((List)metadata.get(i3), regexSearchValues)) continue;
            metadata.remove(i3);
            --i3;
        }
        return metadata;
    }

    protected void buildMetadataQuery(int maxNumberOfRecords, List<String> metadataNames, List<String> searchValues, List<String> rangeSearchValues, SimpleDateFormat simpleDateFormat, StringBuilder query, List<Object> args, List<Integer> argTypes) throws StorageException {
        String searchValue;
        int i;
        query.append("select " + this.dbmsSupport.provideFirstRowsHintAfterFirstKeyword(maxNumberOfRecords));
        boolean first = true;
        for (String metadataName : metadataNames) {
            if (first) {
                first = false;
            } else {
                query.append(", ");
            }
            if (this.bigValueColumns.contains(metadataName)) {
                query.append("substr(" + metadataName + ", 1, 100)");
                continue;
            }
            query.append(metadataName);
        }
        String rowNumber = this.dbmsSupport.getRowNumber(metadataNames.get(0), "desc");
        if (StringUtils.isNotEmpty((String)rowNumber)) {
            if (first) {
                first = false;
            } else {
                query.append(", ");
            }
            query.append(rowNumber);
        }
        query.append(" from " + this.table);
        for (i = 0; i < rangeSearchValues.size(); ++i) {
            searchValue = rangeSearchValues.get(i);
            if (searchValue == null) continue;
            int j = searchValue.indexOf(124);
            if (j != -1) {
                String column = metadataNames.get(i);
                String searchValueLeft = searchValue.substring(1, j);
                String searchValueRight = searchValue.substring(j + 1, searchValue.length() - 1);
                if (StringUtils.isNotEmpty((String)searchValueLeft)) {
                    if (this.integerColumns.contains(column)) {
                        this.addNumberExpression(query, args, argTypes, column, ">=", searchValueLeft);
                    } else if (this.timestampColumns.contains(column)) {
                        this.addTimestampExpression(query, args, argTypes, column, ">=", searchValueLeft, simpleDateFormat);
                    }
                }
                if (!StringUtils.isNotEmpty((String)searchValueRight)) continue;
                if (this.integerColumns.contains(column)) {
                    this.addNumberExpression(query, args, argTypes, column, "<=", searchValueRight);
                    continue;
                }
                if (!this.timestampColumns.contains(column)) continue;
                this.addTimestampExpression(query, args, argTypes, column, "<=", searchValueRight, simpleDateFormat);
                continue;
            }
            throw new StorageException("Separator | not found");
        }
        for (i = 0; i < searchValues.size(); ++i) {
            searchValue = searchValues.get(i);
            if (!StringUtils.isNotEmpty((String)searchValue)) continue;
            String column = metadataNames.get(i);
            if (this.integerColumns.contains(column)) {
                this.addNumberExpression(query, args, argTypes, column, "<=", searchValue);
                continue;
            }
            if (this.timestampColumns.contains(column)) {
                this.addTimestampExpression(query, args, argTypes, column, "<=", searchValue, simpleDateFormat);
                continue;
            }
            this.addLikeExpression(query, args, argTypes, column, searchValue);
        }
        if (query.charAt(query.length() - 1) == ' ') {
            query.deleteCharAt(query.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)rowNumber)) {
            query.append(" where " + this.dbmsSupport.getRowNumberShortName() + " < ?");
            args.add(maxNumberOfRecords + 1);
            argTypes.add(4);
        }
        query.append(" order by ");
        query.append(metadataNames.get(0) + " desc");
        query.append(this.dbmsSupport.provideTrailingFirstRowsHint(maxNumberOfRecords));
    }

    @Override
    public void close() {
    }

    private void addLikeExpression(StringBuilder query, List<Object> args, List<Integer> argTypes, String column, String searchValue) throws StorageException {
        if (searchValue.startsWith("~") && searchValue.contains("*")) {
            this.addExpression(query, "lower(" + column + ") like lower(?)");
        } else if (searchValue.startsWith("~")) {
            this.addExpression(query, "lower(" + column + ") = lower(?)");
        } else if (searchValue.contains("*")) {
            this.addExpression(query, column + " like ?");
        } else {
            this.addExpression(query, column + " = ?");
        }
        if (searchValue.startsWith("~")) {
            searchValue = searchValue.substring(1);
        }
        searchValue = searchValue.replaceAll("\\*", "%");
        args.add(searchValue);
        argTypes.add(12);
    }

    private void addNumberExpression(StringBuilder query, List<Object> args, List<Integer> argTypes, String column, String operator, String searchValue) throws StorageException {
        try {
            BigDecimal bigDecimal = new BigDecimal(searchValue);
            this.addExpression(query, column + " " + operator + " ?");
            args.add(bigDecimal);
            argTypes.add(3);
        }
        catch (NumberFormatException e) {
            throw new StorageException("Search value '" + searchValue + "' isn't a valid number");
        }
    }

    private void addTimestampExpression(StringBuilder query, List<Object> args, List<Integer> argTypes, String column, String operator, String searchValue, SimpleDateFormat simpleDateFormat) throws StorageException {
        String searchValueToParse;
        if (searchValue.length() < 23) {
            GregorianCalendar calendar;
            int maxDayOfMonth;
            searchValueToParse = ">=".equals(operator) ? searchValue + "0000-00-00T00:00:00.000".substring(searchValue.length()) : searchValue + "9999-12-31T23:59:59.999".substring(searchValue.length());
            int year = -1;
            int month = -1;
            int dayOfMonth = -1;
            try {
                year = Integer.parseInt(searchValueToParse.substring(0, 4));
                month = Integer.parseInt(searchValueToParse.substring(5, 7)) - 1;
                dayOfMonth = Integer.parseInt(searchValueToParse.substring(8, 10));
                Integer.parseInt(searchValueToParse.substring(11, 13));
                Integer.parseInt(searchValueToParse.substring(14, 16));
                Integer.parseInt(searchValueToParse.substring(17, 19));
                Integer.parseInt(searchValueToParse.substring(20, 23));
            }
            catch (NumberFormatException e) {
                this.throwExceptionOnInvalidTimestamp(searchValue);
            }
            if (searchValueToParse.charAt(4) != '-' || searchValueToParse.charAt(7) != '-' || searchValueToParse.charAt(7) != '-' || searchValueToParse.charAt(10) != 'T' || searchValueToParse.charAt(13) != ':' || searchValueToParse.charAt(16) != ':' || searchValueToParse.charAt(19) != '.') {
                this.throwExceptionOnInvalidTimestamp(searchValue);
            }
            if (!">=".equals(operator) && dayOfMonth > (maxDayOfMonth = ((Calendar)(calendar = new GregorianCalendar(year, month, 1))).getActualMaximum(5))) {
                searchValueToParse = searchValueToParse.substring(0, 8) + maxDayOfMonth + searchValueToParse.substring(10);
            }
        } else {
            searchValueToParse = searchValue;
        }
        try {
            args.add(new Date(simpleDateFormat.parse(searchValueToParse).getTime()));
            argTypes.add(91);
            this.addExpression(query, column + " " + operator + " ?");
        }
        catch (ParseException e) {
            this.throwExceptionOnInvalidTimestamp(searchValue);
        }
    }

    private void throwExceptionOnInvalidTimestamp(String searchValue) throws StorageException {
        throw new StorageException("Search value '" + searchValue + "' doesn't comply with (the beginning of) pattern " + TIMESTAMP_PATTERN);
    }

    private void addExpression(StringBuilder query, String expression) {
        if (query.charAt(query.length() - 1) == ' ') {
            query.append("and " + expression + " ");
        } else {
            query.append(" where " + expression + " ");
        }
    }

    @Override
    public int getFilterType(String column) {
        return 0;
    }

    @Override
    public List<Object> getFilterValues(String column) throws StorageException {
        return null;
    }

    @Override
    public String getUserHelp(String column) {
        if (this.integerColumns.contains(column)) {
            return "Search all rows which are less than or equal to the search value";
        }
        if (this.timestampColumns.contains(column)) {
            return "Search all rows which are less than or equal to the search value. When the search value only complies with the beginning of pattern yyyy-MM-dd'T'HH:mm:ss.SSS, it will be internally completed according to the value 9999-12-31T23:59:59.999";
        }
        return "Search all rows which completely equal the search value (case sensitive). The wilcard character '*' is supported. When the search value start with the character '~', the search is performed case insensitive";
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public void setStorageIdColumnName(String storageIdColumnName) {
        this.storageIdColumnName = storageIdColumnName;
    }

    public String getStorageIdColumnName() {
        return this.storageIdColumnName;
    }

    public void setMetadataColumns(List<String> metadataColumns) {
        this.metadataColumns = metadataColumns;
    }

    public List<String> getMetadataColumns() {
        return this.metadataColumns;
    }

    public void setIntegerColumns(List<String> integerColumns) {
        this.integerColumns = integerColumns;
    }

    public List<String> getIntegerColumns() {
        return this.integerColumns;
    }

    public void setLongColumns(List<String> longColumns) {
        this.longColumns = longColumns;
    }

    public List<String> getLongColumns() {
        return this.longColumns;
    }

    public void setTimestampColumns(List<String> timestampColumns) {
        this.timestampColumns = timestampColumns;
    }

    public List<String> getTimestampColumns() {
        return this.timestampColumns;
    }

    public void setBigValueColumns(List<String> bigValueColumns) {
        this.bigValueColumns = bigValueColumns;
    }

    public List<String> getBigValueColumns() {
        return this.bigValueColumns;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setDbmsSupport(DbmsSupport dbmsSupport) {
        this.dbmsSupport = dbmsSupport;
    }

    public DbmsSupport getDbmsSupport() {
        return this.dbmsSupport;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }
}

