/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.database;

import java.sql.SQLException;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class DbmsSupport {
    private JdbcTemplate jdbcTemplate;
    private String commonDatabaseName;

    @PostConstruct
    public void init() throws SQLException, MetaDataAccessException {
        String databaseProductName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.jdbcTemplate.getDataSource(), dbmd -> dbmd.getDatabaseProductName());
        this.commonDatabaseName = JdbcUtils.commonDatabaseName((String)databaseProductName);
    }

    public String provideFirstRowsHintAfterFirstKeyword(int rowCount) {
        String sql = "";
        if ("Oracle".equals(this.commonDatabaseName)) {
            sql = sql + " /*+ first_rows( " + rowCount + " ) */";
        } else if ("Microsoft SQL Server".equals(this.commonDatabaseName)) {
            sql = sql + " top( " + rowCount + " )";
        }
        return sql;
    }

    public String provideTrailingFirstRowsHint(int rowCount) {
        String sql = "";
        if (rowCount > -1 && !"Oracle".equals(this.commonDatabaseName) && !"Microsoft SQL Server".equals(this.commonDatabaseName)) {
            sql = sql + " limit " + rowCount;
        }
        return sql;
    }

    public String getRowNumber(String order, String sort) {
        if ("Oracle".equals(this.commonDatabaseName) || "Microsoft SQL Server".equals(this.commonDatabaseName)) {
            return "row_number() over (order by " + order + (sort == null ? "" : " " + sort) + ") " + this.getRowNumberShortName();
        }
        return "";
    }

    public String getRowNumberShortName() {
        return "rn";
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

