/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Storage
extends nl.nn.testtool.storage.memory.Storage {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String reportsDirectory;

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public void init() throws StorageException {
        this.readReports();
    }

    @Override
    public synchronized void store(Report report) {
        super.store(report);
        this.writeReports();
    }

    @Override
    public void update(Report report) throws StorageException {
        super.update(report);
        this.writeReports();
    }

    @Override
    public void delete(Report report) throws StorageException {
        super.delete(report);
        this.writeReports();
    }

    @Override
    public void storeWithoutException(Report report) {
        super.storeWithoutException(report);
        this.writeReports();
    }

    private void readReports() {
        File directory = new File(this.reportsDirectory);
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("report-") && name.endsWith(".ttr");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            ArrayList reportsList = new ArrayList();
            Report report = (Report)reportsList.get(0);
            report.setStorage(this);
            report.setStorageId(new Integer(this.storageId++));
            this.storageIds.add(report.getStorageId());
            this.reports.put(report.getStorageId(), report);
            this.metadata.add(new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReports() {
        Iterator iterator = this.storageIds.iterator();
        while (iterator.hasNext()) {
            FileOutputStream fileOutputStream = null;
            try {
                Integer storageId = (Integer)iterator.next();
                fileOutputStream = new FileOutputStream(this.reportsDirectory + "/report-" + storageId + ".ttr");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileOutputStream == null) continue;
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

