/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.util.CSVReader;
import nl.nn.testtool.util.Import;
import nl.nn.testtool.util.SearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String reportsFilename;
    private String metadataFilename;
    private File reportsFile;
    private File metadataFile;
    private int maximumBackupIndex;
    private long metadataFileLastModifiedByWriter = Long.MIN_VALUE;
    private long metadataFileLastModifiedByOthers = Long.MIN_VALUE;
    private List metadataCacheReadOnly = new ArrayList();
    private List metadataCacheReadOnlyPerFile = new ArrayList();
    private MetadataExtractor metadataExtractor;
    private static final List METADATA_NAMES_STORAGE_ID = new ArrayList();

    protected void setReportsFilename(String reportsFilename) {
        this.reportsFilename = reportsFilename;
    }

    protected void setMetadataFilename(String metadataFilename) {
        this.metadataFilename = metadataFilename;
    }

    protected void setMaximumBackupIndex(int maximumBackupIndex) {
        this.maximumBackupIndex = maximumBackupIndex;
    }

    protected void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    protected void init() {
        this.reportsFile = new File(this.reportsFilename);
        this.metadataFile = new File(this.metadataFilename);
    }

    protected List getStorageIds(long metadataFileLastModifiedByWriter, String synchronizeRotate) throws StorageException {
        ArrayList result = new ArrayList();
        List metadata = this.getMetadata(-1, METADATA_NAMES_STORAGE_ID, null, 0, metadataFileLastModifiedByWriter, synchronizeRotate);
        for (List record : metadata) {
            result.add(record.get(0));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getMetadata(int maxNumberOfRecords, List metadataNames, List searchValues, int metadataValueType, long metadataFileLastModifiedByWriter, String synchronizeRotate) throws StorageException {
        List metadataReadOnly;
        List list = this.metadataCacheReadOnly;
        synchronized (list) {
            String string = synchronizeRotate;
            synchronized (string) {
                if (metadataFileLastModifiedByWriter != this.metadataFileLastModifiedByWriter || this.metadataFile.lastModified() != this.metadataFileLastModifiedByOthers) {
                    this.metadataFileLastModifiedByWriter = metadataFileLastModifiedByWriter;
                    this.metadataFileLastModifiedByOthers = this.metadataFile.lastModified();
                    ArrayList newMetadataCacheReadOnly = new ArrayList();
                    for (int i = this.maximumBackupIndex; i >= 0; --i) {
                        File file = i == 0 ? this.metadataFile : new File(this.metadataFilename + "." + i);
                        if (!file.exists()) continue;
                        while (this.metadataCacheReadOnlyPerFile.size() <= i) {
                            this.metadataCacheReadOnlyPerFile.add(0, new ArrayList());
                        }
                        List oldMetadataCurrentFile = (List)this.metadataCacheReadOnlyPerFile.get(i);
                        ArrayList metadataCurrentFile = new ArrayList();
                        this.getMetadataOrReportLocationFromFile(this.metadataExtractor, file, oldMetadataCurrentFile, metadataCurrentFile, null);
                        newMetadataCacheReadOnly.addAll(0, metadataCurrentFile);
                        this.metadataCacheReadOnlyPerFile.set(i, metadataCurrentFile);
                    }
                    this.metadataCacheReadOnly = newMetadataCacheReadOnly;
                }
            }
            metadataReadOnly = this.metadataCacheReadOnly;
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < metadataReadOnly.size() && (maxNumberOfRecords == -1 || i < maxNumberOfRecords); ++i) {
            Map metadataRecord = (Map)metadataReadOnly.get(i);
            boolean exclude = false;
            if (searchValues != null) {
                ArrayList<Object> partialValues = new ArrayList<Object>();
                ArrayList<String> partialSearchValues = new ArrayList<String>();
                for (int j = 0; j < searchValues.size(); ++j) {
                    String searchValue = (String)searchValues.get(j);
                    if (searchValue == null) continue;
                    String metadataName = (String)metadataNames.get(j);
                    Map map = metadataRecord;
                    synchronized (map) {
                        if (metadataRecord.keySet().contains(metadataName)) {
                            partialValues.add(this.metadataExtractor.fromObjectToMetadataValueType(metadataName, metadataRecord.get(metadataName), metadataValueType));
                            partialSearchValues.add(searchValue);
                        }
                        continue;
                    }
                }
                if (!SearchUtil.matches(partialValues, partialSearchValues)) {
                    exclude = true;
                    if (log.isTraceEnabled()) {
                        log.trace("Exclude report based on search values (" + partialSearchValues + ") and already available metadata (" + partialValues + ")");
                    }
                }
            }
            if (exclude) continue;
            Report report = null;
            ArrayList<Object> resultRecord = new ArrayList<Object>();
            for (String metadataName : metadataNames) {
                Object metadataValue;
                boolean metadataRecordContainsMetadataName;
                Map map = metadataRecord;
                synchronized (map) {
                    metadataRecordContainsMetadataName = metadataRecord.keySet().contains(metadataName);
                }
                if (!metadataRecordContainsMetadataName) {
                    Integer storageId;
                    Map map2 = metadataRecord;
                    synchronized (map2) {
                        storageId = (Integer)metadataRecord.get("storageId");
                    }
                    if (report == null) {
                        report = this.getReportWithoutException(storageId, synchronizeRotate);
                    }
                    if (report == null) {
                        resultRecord = null;
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Extract metadata '" + metadataName + "' for report with storage id " + storageId);
                    }
                    metadataValue = this.metadataExtractor.getMetadata(report, metadataName, 0);
                    map2 = metadataRecord;
                    synchronized (map2) {
                        metadataRecord.put(metadataName, metadataValue);
                    }
                }
                map = metadataRecord;
                synchronized (map) {
                    metadataValue = metadataRecord.get(metadataName);
                }
                resultRecord.add(this.metadataExtractor.fromObjectToMetadataValueType(metadataName, metadataValue, metadataValueType));
            }
            if (resultRecord == null || !SearchUtil.matches(resultRecord, searchValues)) continue;
            result.add(resultRecord);
        }
        return result;
    }

    private Report getReportWithoutException(Integer storageId, String synchronizeRotate) {
        Report report;
        block2: {
            report = null;
            try {
                report = this.getReport(storageId, synchronizeRotate);
            }
            catch (Throwable throwable) {
                if (throwable instanceof StorageException) break block2;
                log.error("Caught unexpected throwable reading report from file", throwable);
            }
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getReportBytes(Integer storageId, String synchronizeRotate) throws StorageException {
        byte[] reportBytes = null;
        ReportLocation reportLocation = null;
        int foundInIndex = -1;
        String string = synchronizeRotate;
        synchronized (string) {
            for (int i = this.maximumBackupIndex; i >= 0 && foundInIndex == -1; --i) {
                File file = i == 0 ? this.metadataFile : new File(this.metadataFilename + "." + i);
                if (!file.exists() || (reportLocation = this.getMetadataOrReportLocationFromFile(null, file, null, null, storageId)) == null) continue;
                foundInIndex = i;
                i = -1;
            }
            if (foundInIndex != -1) {
                File file = foundInIndex == 0 ? this.reportsFile : new File(this.reportsFilename + "." + foundInIndex);
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    fileInputStream.skip(reportLocation.offset);
                    reportBytes = new byte[reportLocation.size.intValue()];
                    fileInputStream.read(reportBytes, 0, reportBytes.length);
                }
                catch (IOException e) {
                    Import.logAndThrow(log, e, "IOException reading report " + storageId + " from file " + file.getAbsolutePath());
                }
                finally {
                    if (fileInputStream != null) {
                        Import.closeInputStream(fileInputStream, "closing file input stream after reading report " + storageId + " from file " + file.getAbsolutePath(), log);
                    }
                }
            }
        }
        return reportBytes;
    }

    protected Report getReport(Integer storageId, String synchronizeRotate) throws StorageException {
        byte[] reportBytes = this.getReportBytes(storageId, synchronizeRotate);
        return Reader.getReport(storageId, reportBytes);
    }

    public static Report getReport(Integer storageId, byte[] reportBytes) throws StorageException {
        Report report = null;
        if (reportBytes != null) {
            ByteArrayInputStream byteArrayInputStream = null;
            byteArrayInputStream = new ByteArrayInputStream(reportBytes);
            report = Import.getReport(byteArrayInputStream, storageId, new Long(reportBytes.length), log);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReportLocation getMetadataOrReportLocationFromFile(MetadataExtractor metadataExtractor, File metadataFile, List oldMetadata, List metadata, Integer storageIdOfReportToLocate) throws StorageException {
        LineNumberReader lineNumberReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        block34: {
            CSVReader csvReader = null;
            fileInputStream = null;
            inputStreamReader = null;
            lineNumberReader = null;
            try {
                fileInputStream = new FileInputStream(metadataFile);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                lineNumberReader = new LineNumberReader(inputStreamReader);
                int recordNumber = 0;
                csvReader = new CSVReader(lineNumberReader);
                List metadataHeaderParsed = csvReader.nextCSV();
                int storageIdIndex = -1;
                int storageSizeIndex = -1;
                for (int i = 0; i < metadataHeaderParsed.size() && (storageIdIndex == -1 || storageSizeIndex == -1); ++i) {
                    if ("storageId".equals(metadataHeaderParsed.get(i))) {
                        storageIdIndex = i;
                        continue;
                    }
                    if (!"storageSize".equals(metadataHeaderParsed.get(i))) continue;
                    storageSizeIndex = i;
                }
                if (storageIdIndex == -1 || storageSizeIndex == -1) {
                    log.warn("Invalid header in metadata file '" + metadataFile.getAbsolutePath() + "'");
                } else {
                    long offset = 0L;
                    int oldMetadataIndex = -1;
                    if (oldMetadata != null) {
                        oldMetadataIndex = oldMetadata.size() - 1;
                    }
                    while (csvReader.hasMoreElements()) {
                        ++recordNumber;
                        List list = csvReader.nextCSV();
                        if (list.size() == metadataHeaderParsed.size()) {
                            Integer storageId;
                            Integer storageSize = null;
                            try {
                                storageId = new Integer((String)list.get(storageIdIndex));
                                storageSize = new Integer((String)list.get(storageSizeIndex));
                            }
                            catch (NumberFormatException e) {
                                storageId = null;
                            }
                            if (storageId != null) {
                                if (storageIdOfReportToLocate != null) {
                                    if (storageIdOfReportToLocate.equals(storageId)) {
                                        ReportLocation reportLocation = new ReportLocation();
                                        reportLocation.offset = offset;
                                        reportLocation.size = storageSize;
                                        ReportLocation reportLocation2 = reportLocation;
                                        if (csvReader != null) {
                                            Import.closeCSVReader(csvReader, "closing cvs reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                                        }
                                        if (lineNumberReader != null) {
                                            Import.closeReader(lineNumberReader, "closing line number reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                                        }
                                        if (inputStreamReader != null) {
                                            Import.closeReader(inputStreamReader, "closing input stream reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                                        }
                                        if (fileInputStream == null) return reportLocation2;
                                        Import.closeInputStream(fileInputStream, "closing file input stream after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                                        return reportLocation2;
                                    }
                                    offset += (long)storageSize.intValue();
                                    continue;
                                }
                                Map oldMetadataRecord = null;
                                if (oldMetadataIndex > -1) {
                                    oldMetadataRecord = (Map)oldMetadata.get(oldMetadataIndex);
                                    if (storageId.equals(oldMetadataRecord.get("storageId"))) {
                                        --oldMetadataIndex;
                                    } else {
                                        oldMetadataRecord = null;
                                    }
                                }
                                if (oldMetadataRecord == null) {
                                    if (log.isTraceEnabled()) {
                                        log.trace("Get metadata for report with storage id " + storageId + " from metadata file");
                                    }
                                    HashMap metadataRecord = new HashMap();
                                    for (int i = 0; i < metadataHeaderParsed.size(); ++i) {
                                        String metadataName = (String)metadataHeaderParsed.get(i);
                                        Object metadataValue = list.get(i);
                                        metadataValue = metadataExtractor.fromStringToMetadataValueType(metadataName, (String)metadataValue, 0);
                                        metadataRecord.put(metadataName, metadataValue);
                                    }
                                    metadata.add(0, metadataRecord);
                                    continue;
                                }
                                if (log.isTraceEnabled()) {
                                    log.trace("Reusing old metadata for report with storage id " + storageId);
                                }
                                metadata.add(0, oldMetadataRecord);
                                continue;
                            }
                            log.warn("Invalid metadata record (invalid storage id) found with record number: " + recordNumber);
                            continue;
                        }
                        log.warn("Invalid metadata record (number of fields not equal to number of fields in header) found with record number: " + recordNumber);
                    }
                }
                if (csvReader == null) break block34;
            }
            catch (IOException e) {
                block35: {
                    try {
                        Import.logAndThrow(log, e, "IOException reading metadata from file '" + metadataFile.getAbsolutePath() + "'");
                        if (csvReader == null) break block35;
                    }
                    catch (Throwable throwable) {
                        if (csvReader != null) {
                            Import.closeCSVReader(csvReader, "closing cvs reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                        }
                        if (lineNumberReader != null) {
                            Import.closeReader(lineNumberReader, "closing line number reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                        }
                        if (inputStreamReader != null) {
                            Import.closeReader(inputStreamReader, "closing input stream reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                        }
                        if (fileInputStream == null) throw throwable;
                        Import.closeInputStream(fileInputStream, "closing file input stream after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                        throw throwable;
                    }
                    Import.closeCSVReader(csvReader, "closing cvs reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                }
                if (lineNumberReader != null) {
                    Import.closeReader(lineNumberReader, "closing line number reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                }
                if (inputStreamReader != null) {
                    Import.closeReader(inputStreamReader, "closing input stream reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                }
                if (fileInputStream == null) return null;
                Import.closeInputStream(fileInputStream, "closing file input stream after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
                return null;
            }
            Import.closeCSVReader(csvReader, "closing cvs reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
        }
        if (lineNumberReader != null) {
            Import.closeReader(lineNumberReader, "closing line number reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
        }
        if (inputStreamReader != null) {
            Import.closeReader(inputStreamReader, "closing input stream reader after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
        }
        if (fileInputStream == null) return null;
        Import.closeInputStream(fileInputStream, "closing file input stream after reading metadata from file '" + metadataFile.getAbsolutePath() + "'", log);
        return null;
    }

    protected void clear() throws StorageException {
        this.metadataCacheReadOnly.clear();
        this.metadataCacheReadOnlyPerFile.clear();
    }

    static {
        METADATA_NAMES_STORAGE_ID.add("storageId");
    }

    class ReportLocation {
        protected long offset = 0L;
        protected Integer size;

        ReportLocation() {
        }
    }
}

