/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.file;

import java.util.List;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.LogStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.storage.file.Reader;
import nl.nn.testtool.storage.file.Writer;
import nl.nn.testtool.util.SearchUtil;

public class Storage
implements LogStorage {
    public static final long DEFAULT_MAXIMUM_FILE_SIZE = 0x100000L;
    public static final int DEFAULT_MAXIMUM_BACKUP_INDEX = 9;
    private String name;
    private Reader reader = new Reader();
    private Writer writer = new Writer();

    public Storage() {
        this.reader.setMaximumBackupIndex(9);
        this.writer.setMaximumFileSize(0x100000L);
        this.writer.setMaximumBackupIndex(9);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setReportsFilename(String reportsFilename) {
        this.reader.setReportsFilename(reportsFilename);
        this.writer.setReportsFilename(reportsFilename);
    }

    public void setMetadataFilename(String metadataFilename) {
        this.reader.setMetadataFilename(metadataFilename);
        this.writer.setMetadataFilename(metadataFilename);
    }

    public void setMaximumFileSize(long maximumFileSize) {
        this.writer.setMaximumFileSize(maximumFileSize);
    }

    public void setMaximumBackupIndex(int maximumBackupIndex) {
        this.reader.setMaximumBackupIndex(maximumBackupIndex);
        this.writer.setMaximumBackupIndex(maximumBackupIndex);
    }

    public void setFreeSpaceMinimum(long freeSpaceMinimum) {
        this.writer.setFreeSpaceMinimum(freeSpaceMinimum);
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.reader.setMetadataExtractor(metadataExtractor);
        this.writer.setMetadataExtractor(metadataExtractor);
    }

    public void setPersistentMetadata(List metadataNames) {
        this.writer.setPersistentMetadata(metadataNames);
    }

    public void init() throws StorageException {
        this.reader.init();
        this.writer.init(this.reader.getStorageIds(this.writer.getMetadataFileLastModified(), this.writer.getSynchronizeRotate()));
    }

    @Override
    public void storeWithoutException(Report report) {
        this.writer.storeWithoutException(report, false);
    }

    @Override
    public String getWarningsAndErrors() {
        return this.writer.getWarningsAndErrors();
    }

    @Override
    public int getSize() throws StorageException {
        return this.getStorageIds().size();
    }

    @Override
    public List getStorageIds() throws StorageException {
        return this.reader.getStorageIds(this.writer.getMetadataFileLastModified(), this.writer.getSynchronizeRotate());
    }

    public List getMetadata(int maxNumberOfRecords, List metadataNames, List searchValues, int metadataValueType) throws StorageException {
        return this.reader.getMetadata(maxNumberOfRecords, metadataNames, searchValues, metadataValueType, this.writer.getMetadataFileLastModified(), this.writer.getSynchronizeRotate());
    }

    @Override
    public Report getReport(Integer storageId) throws StorageException {
        Report report = this.reader.getReport(storageId, this.writer.getSynchronizeRotate());
        report.setStorage(this);
        return report;
    }

    @Override
    public void clear() throws StorageException {
        this.writer.clear();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public int getFilterType(String column) {
        return 0;
    }

    @Override
    public List getFilterValues(String column) throws StorageException {
        return null;
    }

    @Override
    public String getUserHelp(String column) {
        return SearchUtil.getUserHelp();
    }
}

