/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.storage.file.Reader;
import nl.nn.testtool.storage.file.Writer;
import nl.nn.testtool.util.SearchUtil;

public class TestStorage
implements CrudStorage {
    private String name;
    private Reader[] reader = new Reader[2];
    private Writer[] writer = new Writer[2];
    private short active;

    public TestStorage() {
        this.reader[0] = new Reader();
        this.reader[1] = new Reader();
        this.writer[0] = new Writer();
        this.writer[1] = new Writer();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setReportsFilename(String reportsFilename) {
        this.reader[0].setReportsFilename(reportsFilename + ".a");
        this.reader[1].setReportsFilename(reportsFilename + ".b");
        this.writer[0].setReportsFilename(reportsFilename + ".a");
        this.writer[1].setReportsFilename(reportsFilename + ".b");
    }

    public void setMetadataFilename(String metadataFilename) {
        this.reader[0].setMetadataFilename(metadataFilename + ".a");
        this.reader[1].setMetadataFilename(metadataFilename + ".b");
        this.writer[0].setMetadataFilename(metadataFilename + ".a");
        this.writer[1].setMetadataFilename(metadataFilename + ".b");
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.reader[0].setMetadataExtractor(metadataExtractor);
        this.reader[1].setMetadataExtractor(metadataExtractor);
        this.writer[0].setMetadataExtractor(metadataExtractor);
        this.writer[1].setMetadataExtractor(metadataExtractor);
    }

    public void setPersistentMetadata(List metadataNames) {
        this.writer[0].setPersistentMetadata(metadataNames);
        this.writer[1].setPersistentMetadata(metadataNames);
    }

    public void init() throws StorageException {
        this.reader[0].init();
        this.reader[1].init();
        this.writer[0].init(this.reader[0].getStorageIds(this.writer[0].getMetadataFileLastModified(), this.writer[0].getSynchronizeRotate()));
        this.writer[1].init(this.reader[1].getStorageIds(this.writer[1].getMetadataFileLastModified(), this.writer[1].getSynchronizeRotate()));
        int size0 = this.reader[0].getStorageIds(this.writer[0].getMetadataFileLastModified(), this.writer[0].getSynchronizeRotate()).size();
        int size1 = this.reader[1].getStorageIds(this.writer[1].getMetadataFileLastModified(), this.writer[1].getSynchronizeRotate()).size();
        this.active = size1 > size0 ? (short)1 : 0;
    }

    @Override
    public void store(Report report) throws StorageException {
        report.setStorage(this);
        this.writer[this.active].store(report, false);
    }

    @Override
    public int getSize() throws StorageException {
        return this.getStorageIds().size();
    }

    @Override
    public List getStorageIds() throws StorageException {
        return this.reader[this.active].getStorageIds(this.writer[this.active].getMetadataFileLastModified(), this.writer[this.active].getSynchronizeRotate());
    }

    @Override
    public void update(Report report) throws StorageException {
        this.update(report, false);
    }

    @Override
    public void delete(Report report) throws StorageException {
        this.update(report, true);
    }

    private void update(Report report, boolean delete) throws StorageException {
        short source = this.active;
        int destination = source == 0 ? 1 : 0;
        List storageIds = this.reader[source].getStorageIds(this.writer[source].getMetadataFileLastModified(), this.writer[source].getSynchronizeRotate());
        Collections.sort(storageIds);
        for (Integer storageId : storageIds) {
            if (storageId.equals(report.getStorageId())) {
                if (delete) continue;
                this.writer[destination].store(report, true);
                continue;
            }
            byte[] reportBytes = this.reader[source].getReportBytes(storageId, this.writer[source].getSynchronizeRotate());
            List persistentMetadata = this.writer[destination].getPersistentMetadata();
            ArrayList<String> searchValues = new ArrayList<String>();
            searchValues.add("(" + storageId + ")");
            for (int i = 1; i < persistentMetadata.size(); ++i) {
                searchValues.add(null);
            }
            List metadata = this.reader[source].getMetadata(-1, persistentMetadata, searchValues, 1, this.writer[source].getMetadataFileLastModified(), this.writer[source].getSynchronizeRotate());
            this.writer[destination].store(report.getName(), reportBytes, (List)metadata.get(0));
        }
        this.writer[destination].latestStorageId = this.writer[source].latestStorageId;
        this.writer[source].clear();
        this.reader[source].clear();
        this.active = (short)destination;
    }

    public List getMetadata(int maxNumberOfRecords, List metadataNames, List searchValues, int metadataValueType) throws StorageException {
        return this.reader[this.active].getMetadata(maxNumberOfRecords, metadataNames, searchValues, metadataValueType, this.writer[this.active].getMetadataFileLastModified(), this.writer[this.active].getSynchronizeRotate());
    }

    @Override
    public Report getReport(Integer storageId) throws StorageException {
        Report report = this.reader[this.active].getReport(storageId, this.writer[this.active].getSynchronizeRotate());
        if (report != null) {
            report.setStorage(this);
        }
        return report;
    }

    @Override
    public void clear() throws StorageException {
        this.writer[this.active].clear();
    }

    @Override
    public void close() {
        this.writer[0].close();
        this.writer[1].close();
    }

    @Override
    public int getFilterType(String column) {
        return 0;
    }

    @Override
    public List getFilterValues(String column) throws StorageException {
        return null;
    }

    @Override
    public String getUserHelp(String column) {
        return SearchUtil.getUserHelp();
    }
}

