/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.util.EscapeUtil;
import nl.nn.testtool.util.Export;
import nl.nn.testtool.util.Import;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Writer {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String synchronizeStore = "";
    private final String synchronizeRotate = "";
    private String reportsFilename;
    private String metadataFilename;
    private File reportsFile;
    private File metadataFile;
    private long maximumFileSize = -1L;
    private int maximumBackupIndex;
    private long freeSpaceMinimum = -1L;
    private FileOutputStream reportsFileOutputStream;
    private FileOutputStream metadataFileOutputStream;
    private OutputStreamWriter metadataOutputStreamWriter;
    private List persistentMetadata;
    private String metadataHeader;
    private MetadataExtractor metadataExtractor;
    protected int latestStorageId = 1;
    private long reportsFileLength;
    private long metadataFileLastModified;
    private SimpleDateFormat freeSpaceDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private String lastExceptionMessage;

    protected void setReportsFilename(String reportsFilename) {
        this.reportsFilename = reportsFilename;
    }

    protected void setMetadataFilename(String metadataFilename) {
        this.metadataFilename = metadataFilename;
    }

    protected void setMaximumFileSize(long maximumFileSize) {
        this.maximumFileSize = maximumFileSize;
    }

    protected void setMaximumBackupIndex(int maximumBackupIndex) {
        this.maximumBackupIndex = maximumBackupIndex;
    }

    protected void setFreeSpaceMinimum(long freeSpaceMinimum) {
        this.freeSpaceMinimum = freeSpaceMinimum;
    }

    private long getFreeSpaceMinimum() {
        return this.freeSpaceMinimum;
    }

    protected void setPersistentMetadata(List metadataNames) {
        this.persistentMetadata = metadataNames;
        this.metadataHeader = EscapeUtil.escapeCsv(this.persistentMetadata);
    }

    protected List getPersistentMetadata() {
        return this.persistentMetadata;
    }

    protected void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    protected void init(List storageIds) {
        this.reportsFile = new File(this.reportsFilename);
        this.metadataFile = new File(this.metadataFilename);
        if (storageIds != null && storageIds.size() > 0) {
            Integer id = (Integer)storageIds.get(0);
            this.latestStorageId = id;
            ++this.latestStorageId;
        }
        this.metadataFileLastModified = System.currentTimeMillis();
        if (this.freeSpaceMinimum == -1L) {
            this.freeSpaceMinimum = this.maximumFileSize * (long)(this.maximumBackupIndex + 1) * 10L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(Report report, boolean preserveStorageId) throws StorageException {
        byte[] reportBytes = Export.getReportBytes(report);
        String string = "";
        synchronized ("") {
            if (!preserveStorageId) {
                Integer storageId = new Integer(this.latestStorageId++);
                report.setStorageId(storageId);
            }
            report.setStorageSize(new Long(reportBytes.length));
            ArrayList<Object> metadataValues = new ArrayList<Object>();
            for (int i = 0; i < this.persistentMetadata.size(); ++i) {
                String metadataName = (String)this.persistentMetadata.get(i);
                metadataValues.add(this.metadataExtractor.getMetadata(report, metadataName, 1));
            }
            this.store(report.getName(), reportBytes, metadataValues);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(String reportName, byte[] reportBytes, List metadataValues) throws StorageException {
        String string = "";
        synchronized ("") {
            try {
                if (this.reportsFileOutputStream == null) {
                    if (!this.metadataFile.exists()) {
                        this.openFiles(false);
                        this.checkFreeSpace(reportName, reportBytes.length);
                        this.writeMetadataHeader();
                    } else if (this.validHeader()) {
                        this.openFiles(true);
                    } else {
                        this.rotateFiles();
                        this.openFiles(false);
                        this.checkFreeSpace(reportName, reportBytes.length);
                        this.writeMetadataHeader();
                    }
                }
                if (this.maximumFileSize != -1L && this.reportsFileLength > this.maximumFileSize) {
                    this.closeFiles();
                    this.rotateFiles();
                    this.openFiles(false);
                    this.checkFreeSpace(reportName, reportBytes.length);
                    this.writeMetadataHeader();
                    this.reportsFileLength = 0L;
                }
                this.checkFreeSpace(reportName, reportBytes.length);
                this.writeReportAndMetadata(reportBytes, EscapeUtil.escapeCsv(metadataValues));
            }
            catch (Throwable throwable) {
                StorageException storageException;
                if (throwable instanceof StorageException) {
                    this.lastExceptionMessage = throwable.getMessage();
                    storageException = (StorageException)throwable;
                } else {
                    String message = "Caught unexpected throwable storing report";
                    this.lastExceptionMessage = message + ": " + throwable.getMessage();
                    log.error(message, throwable);
                    storageException = new StorageException(message, throwable);
                }
                this.closeFiles();
                throw storageException;
            }
            return;
        }
    }

    protected void storeWithoutException(Report report, boolean preserveStorageId) {
        block2: {
            try {
                this.store(report, preserveStorageId);
            }
            catch (Throwable throwable) {
                if (throwable instanceof StorageException) break block2;
                this.lastExceptionMessage = throwable.getMessage();
                log.error("Caught unexpected throwable storing report", throwable);
            }
        }
    }

    protected long getMetadataFileLastModified() {
        return this.metadataFileLastModified;
    }

    protected String getSynchronizeRotate() {
        return "";
    }

    protected void clear() throws StorageException {
        this.closeFiles();
        this.openFiles(false);
        this.writeMetadataHeader();
        this.reportsFileLength = 0L;
        this.latestStorageId = 1;
        this.metadataFileLastModified = System.currentTimeMillis();
    }

    protected void close() {
        this.closeFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validHeader() throws StorageException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        String header = null;
        try {
            fileReader = new FileReader(this.metadataFile);
            bufferedReader = new BufferedReader(fileReader);
            header = bufferedReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Export.logAndThrow(log, fileNotFoundException, "FileNotFoundException reading metadata header from file '" + this.metadataFile.getAbsolutePath() + "'");
        }
        catch (IOException ioException) {
            Export.logAndThrow(log, ioException, "IOException reading metadata header from file '" + this.metadataFile.getAbsolutePath() + "'");
        }
        finally {
            if (bufferedReader != null) {
                Import.closeReader(bufferedReader, "closing buffered reader after reading metadata header from file '" + this.metadataFile.getAbsolutePath() + "'", log);
            }
            if (fileReader != null) {
                Import.closeReader(fileReader, "closing file reader after reading metadata header from file '" + this.metadataFile.getAbsolutePath() + "'", log);
            }
        }
        return this.metadataHeader.equals(header);
    }

    private void openFiles(boolean append) throws StorageException {
        try {
            this.reportsFileLength = this.reportsFile.length();
            this.reportsFileOutputStream = new FileOutputStream(this.reportsFile, append);
        }
        catch (IOException e) {
            Export.logAndThrow(log, e, "IOException opening reports file '" + this.reportsFile.getAbsolutePath() + "'");
        }
        try {
            this.metadataFileOutputStream = new FileOutputStream(this.metadataFile, append);
        }
        catch (IOException e) {
            Export.logAndThrow(log, e, "IOException opening metadata file '" + this.metadataFile.getAbsolutePath() + "'");
        }
        try {
            this.metadataOutputStreamWriter = new OutputStreamWriter((OutputStream)this.metadataFileOutputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Export.logAndThrow(log, e, "UnsupportedEncodingException opening metadata output stream");
        }
    }

    private void writeMetadataHeader() throws StorageException {
        try {
            this.metadataOutputStreamWriter.write(this.metadataHeader);
            this.metadataOutputStreamWriter.flush();
        }
        catch (IOException ioException) {
            Export.logAndThrow(log, ioException, "IOException writing metadata header to file '" + this.metadataFile.getAbsolutePath() + "'");
        }
        this.metadataFileLastModified = System.currentTimeMillis();
    }

    private void writeReportAndMetadata(byte[] reportBytes, String metadataCsvRecord) throws StorageException {
        try {
            this.reportsFileOutputStream.write(reportBytes);
            this.reportsFileOutputStream.flush();
            this.reportsFileLength += (long)reportBytes.length;
        }
        catch (IOException e) {
            Export.logAndThrow(log, e, "IOException writing report to file '" + this.reportsFile.getAbsolutePath() + "'");
        }
        try {
            this.metadataOutputStreamWriter.write("\n");
            this.metadataOutputStreamWriter.write(metadataCsvRecord);
            this.metadataOutputStreamWriter.flush();
        }
        catch (IOException e) {
            Export.logAndThrow(log, e, "IOException writing metadata to file '" + this.metadataFile.getAbsolutePath() + "'");
        }
        this.metadataFileLastModified = System.currentTimeMillis();
    }

    private void closeFiles() {
        if (this.reportsFileOutputStream != null) {
            Export.closeOutputStream(this.reportsFileOutputStream, "closing reports file '" + this.reportsFile.getAbsolutePath() + "'", log);
            this.reportsFileOutputStream = null;
        }
        if (this.metadataOutputStreamWriter != null) {
            Export.closeOutputStreamWriter(this.metadataOutputStreamWriter, "closing metadata output stream writer", log);
            this.metadataOutputStreamWriter = null;
        }
        if (this.metadataFileOutputStream != null) {
            Export.closeOutputStream(this.metadataFileOutputStream, "closing metadata file output stream '" + this.metadataFile.getAbsolutePath() + "'", log);
            this.metadataFileOutputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateFiles() throws StorageException {
        String string = "";
        synchronized ("") {
            for (int i = this.maximumBackupIndex; i >= 0; --i) {
                this.rotateFile(this.reportsFilename, i);
                this.rotateFile(this.metadataFilename, i);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void rotateFile(String filename, int i) throws StorageException {
        File oldFile = i == 0 ? new File(filename) : new File(filename + "." + i);
        if (i == this.maximumBackupIndex && oldFile.exists()) {
            Writer.deleteFile(oldFile);
        } else if (oldFile.exists()) {
            File newFile = new File(filename + "." + (i + 1));
            Writer.renameFile(oldFile, newFile);
        }
    }

    private static void deleteFile(File file) throws StorageException {
        if (!file.delete()) {
            Export.logAndThrow(log, "Could not delete file '" + file.getAbsolutePath() + "'");
        }
    }

    private static void renameFile(File oldFile, File newFile) throws StorageException {
        try {
            Files.move(oldFile.toPath(), newFile.toPath(), new CopyOption[0]);
        }
        catch (Exception e) {
            Export.logAndThrow(log, e, "Could not rename file '" + oldFile.getAbsolutePath() + "' to '" + newFile.getAbsolutePath() + "'");
        }
    }

    protected void finalize() throws Throwable {
        this.closeFiles();
        super.finalize();
    }

    public String getWarningsAndErrors() {
        String message = this.getFreeSpaceWarning();
        if (this.lastExceptionMessage != null) {
            message = message == null ? this.lastExceptionMessage : message + ". " + this.lastExceptionMessage;
        }
        return message;
    }

    private String getFreeSpaceWarning() {
        if (this.reportsFile.exists()) {
            long freeSpace = this.getFreeSpace();
            long minimum = this.getFreeSpaceMinimum();
            if (this.maximumFileSize != -1L && freeSpace < minimum) {
                return "Running out of disk space (" + freeSpace + " bytes left) (reports are not stored while free space is below " + minimum + " bytes to prevent corrupt storage files)";
            }
        }
        return null;
    }

    private String checkFreeSpace(String reportName, int reportSize) throws StorageException {
        String freeSpaceError = null;
        long freeSpace = this.getFreeSpace();
        long minimum = this.getFreeSpaceMinimum();
        if (this.maximumFileSize != -1L && freeSpace < minimum) {
            freeSpaceError = "Report '" + reportName + "' discarded because disk space too low (" + freeSpace + " bytes left) (" + this.freeSpaceDateFormat.format(new Date()) + ")";
        } else if (freeSpace < (long)reportSize) {
            freeSpaceError = "Report '" + reportName + "' discarded because disk space too low (" + freeSpace + " bytes left while report is " + reportSize + " bytes) (" + this.freeSpaceDateFormat.format(new Date()) + ")";
        }
        if (freeSpaceError != null) {
            this.lastExceptionMessage = freeSpaceError;
            throw new StorageException(freeSpaceError);
        }
        return null;
    }

    private long getFreeSpace() {
        return this.reportsFile.getFreeSpace();
    }
}

