/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.LogStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.util.SearchUtil;

public class Storage
implements CrudStorage,
LogStorage {
    protected String name;
    protected Map reports = new HashMap();
    protected List storageIds = new ArrayList();
    protected List metadata = new ArrayList();
    private int initialStorageId = 0;
    protected int storageId;
    protected MetadataExtractor metadataExtractor;

    @PostConstruct
    private void setInitialStorageId() {
        this.storageId = this.initialStorageId;
    }

    public void setInitialStorageId(int value) {
        this.initialStorageId = value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    @Override
    public synchronized void store(Report report) {
        report.setStorage(this);
        report.setStorageId(new Integer(this.storageId++));
        this.reports.put(report.getStorageId(), report);
        this.storageIds.add(report.getStorageId());
        this.metadata.add(new HashMap());
    }

    @Override
    public void update(Report report) throws StorageException {
        this.reports.put(report.getStorageId(), report);
        int i = this.storageIds.indexOf(report.getStorageId());
        this.metadata.remove(i);
        this.metadata.add(i, new HashMap());
    }

    @Override
    public void delete(Report report) throws StorageException {
        this.reports.remove(report);
        int i = this.storageIds.indexOf(report.getStorageId());
        this.storageIds.remove(report.getStorageId());
        this.metadata.remove(i);
    }

    @Override
    public void storeWithoutException(Report report) {
        this.store(report);
    }

    @Override
    public int getSize() {
        return this.storageIds.size();
    }

    @Override
    public synchronized List getStorageIds() {
        return new ArrayList(this.storageIds);
    }

    public synchronized List getMetadata(int maxNumberOfRecords, List metadataNames, List searchValues, int metadataValueType) throws StorageException {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.metadata.size() && (maxNumberOfRecords == -1 || i < maxNumberOfRecords); ++i) {
            Map metadataRecord = (Map)this.metadata.get(i);
            ArrayList<Object> resultRecord = new ArrayList<Object>();
            for (String metadataName : metadataNames) {
                Report report = this.getReport((Integer)this.storageIds.get(i));
                Object metadataValue = this.metadataExtractor.getMetadata(report, metadataName, metadataValueType);
                metadataRecord.put(metadataName, metadataValue);
                resultRecord.add(metadataValue);
            }
            if (!SearchUtil.matches(resultRecord, searchValues)) continue;
            result.add(resultRecord);
        }
        return result;
    }

    @Override
    public synchronized Report getReport(Integer storageId) throws StorageException {
        Report report = (Report)this.reports.get(storageId);
        if (report != null) {
            try {
                report = report.clone();
                report.setStorageId(storageId);
                report.setStorage(this);
            }
            catch (CloneNotSupportedException e) {
                throw new StorageException("Could not clone report", e);
            }
        }
        return report;
    }

    @Override
    public void clear() {
        this.reports.clear();
        this.storageIds.clear();
        this.metadata.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public int getFilterType(String column) {
        return 0;
    }

    @Override
    public List getFilterValues(String column) throws StorageException {
        return null;
    }

    @Override
    public String getUserHelp(String column) {
        return SearchUtil.getUserHelp();
    }

    @Override
    public String getWarningsAndErrors() {
        return null;
    }
}

