/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.proofofmigration;

import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import nl.nn.testtool.Checkpoint;
import nl.nn.testtool.Report;
import nl.nn.testtool.TestTool;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.storage.database.DatabaseStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofOfMigrationStorage
extends DatabaseStorage {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TestTool testTool;

    @Override
    protected void buildMetadataQuery(int maxNumberOfRecords, List<String> metadataNames, List<String> searchValues, List<String> rangeSearchValues, SimpleDateFormat simpleDateFormat, StringBuilder query, List<Object> args, List<Integer> argTypes) throws StorageException {
        super.buildMetadataQuery(maxNumberOfRecords, metadataNames, searchValues, rangeSearchValues, simpleDateFormat, query, args, argTypes);
        if (log.isDebugEnabled()) {
            log.debug("Get metadata original query: " + query.toString());
        }
        this.replace(query, "ID", "min(ID) as min_id");
        this.replace(query, "TIMESTAMP", "min(TIMESTAMP)");
        this.replace(query, "STATUS", "min(STATUS)");
        this.replace(query, "CHECKPOINT_NR", "max(CHECKPOINT_NR)");
        this.replace(query, "order by ID", "group by COMPONENT, CORRELATION_ID order by min_id");
    }

    @Override
    public Report getReport(Integer storageId) throws StorageException {
        String query = "select CORRELATION_ID, COMPONENT, CHECKPOINT_NR, ENDPOINT_NAME, ACTION, MESSAGE, TIMESTAMP from " + this.getTable() + " where CORRELATION_ID = (select CORRELATION_ID from " + this.getTable() + " where " + this.getStorageIdColumnName() + " = ?) and COMPONENT = (select COMPONENT from " + this.getTable() + " where " + this.getStorageIdColumnName() + " = ?) order by CHECKPOINT_NR";
        log.debug("Get report query: " + query);
        List result = this.getJdbcTemplate().query(query, new Object[]{storageId, storageId}, new int[]{4, 4}, (resultSet, rowNum) -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(resultSet.getString(1));
            list.add(resultSet.getString(2));
            list.add(resultSet.getString(3));
            list.add(resultSet.getString(4));
            list.add(resultSet.getString(5));
            list.add(resultSet.getString(6));
            list.add(resultSet.getString(7));
            return list;
        });
        Report report = new Report();
        report.setTestTool(this.testTool);
        report.setStorage(this);
        report.setStorageId(storageId);
        report.setName((String)((List)result.get(0)).get(1));
        report.setCorrelationId((String)((List)result.get(0)).get(0));
        int level = 0;
        ArrayList<Checkpoint> checkpoints = new ArrayList<Checkpoint>();
        Checkpoint checkpoint = new Checkpoint(report, null, null, "Timestamps", 6, 0);
        StringBuilder message = new StringBuilder();
        for (List list : result) {
            message.append(list.get(2) + ". " + list.get(6) + "\n");
        }
        checkpoint.setMessage(message.toString());
        checkpoints.add(checkpoint);
        for (List list : result) {
            int checkpointType = 3;
            if ("request".equals(list.get(4))) {
                checkpointType = 1;
            } else if ("response".equals(list.get(4))) {
                checkpointType = 2;
            }
            checkpoint = new Checkpoint(report, null, null, list.get(2) + ". " + list.get(3), checkpointType, level);
            checkpoint.setMessage(list.get(5));
            checkpoints.add(checkpoint);
            if ("request".equals(list.get(4))) {
                ++level;
                continue;
            }
            if (!"response".equals(list.get(4))) continue;
            --level;
        }
        report.setCheckpoints(checkpoints);
        return report;
    }

    @Override
    public void store(Report report) throws StorageException {
        throw new StorageException("Not implemented!");
    }

    @Override
    public void update(Report report) throws StorageException {
        throw new StorageException("Not implemented!");
    }

    @Override
    public void delete(Report report) throws StorageException {
        throw new StorageException("Not implemented!");
    }

    @Override
    public List<Integer> getStorageIds() throws StorageException {
        throw new StorageException("Not implemented!");
    }

    private void replace(StringBuilder stringBuilder, String from, String to) {
        char prefix = ' ';
        char postfix = ',';
        int i = stringBuilder.indexOf(prefix + from + postfix);
        if (i == -1) {
            postfix = ' ';
            i = stringBuilder.indexOf(prefix + from + postfix);
        }
        if (i > -1) {
            stringBuilder.replace(i, i + from.length() + 2, prefix + to + postfix);
        }
    }

    public void setTestTool(TestTool testTool) {
        this.testTool = testTool;
    }
}

