/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.xml;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import nl.nn.testtool.Report;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Metadata {
    protected int storageId;
    protected int nrChpts;
    protected long memoryUsage;
    protected long storageSize;
    protected long duration;
    protected long endTime;
    protected long lastModified;
    protected String name;
    protected String correlationId;
    protected String status;
    protected String path;
    protected String description;

    public Metadata(int storageId, long duration, int nrChpts, long memoryUsage, long storageSize, long endTime, String name, String correlationId, String status, String path, String description, long lastModified) {
        this.storageId = storageId;
        this.duration = duration;
        this.nrChpts = nrChpts;
        this.memoryUsage = memoryUsage;
        this.storageSize = storageSize;
        this.endTime = endTime;
        this.name = name;
        this.correlationId = correlationId;
        this.status = status;
        this.path = path;
        this.description = description;
        this.lastModified = lastModified;
    }

    public List<Object> toObjectList(List<String> names, int type) {
        ArrayList<Object> list = new ArrayList<Object>(names.size());
        for (String n : names) {
            if (type == 1) {
                list.add(String.valueOf(this.getFieldValue(n)));
                continue;
            }
            list.add(this.getFieldValue(n));
        }
        return list;
    }

    public String toXml() {
        String template = "<Metadata>\n    <StorageId>%d</StorageId>\n    <EndTime>%d</EndTime>\n    <Duration>%d</Duration>\n    <Name>%s</Name>\n    <CorrelationId>%s</CorrelationId>\n    <Status>%s</Status>\n    <NrChpts>%d</NrChpts>\n    <EstMemUsage>%d</EstMemUsage>\n    <StroageSize>%d</StroageSize>\n    <Path>%s</Path>\n    <LastModified>%d</LastModified>\n    <Description>%s</Description>\n</Metadata>\n";
        return String.format(template, this.storageId, this.endTime, this.duration, StringEscapeUtils.escapeXml((String)this.name), StringEscapeUtils.escapeXml((String)this.correlationId), StringEscapeUtils.escapeXml((String)this.status), this.nrChpts, this.memoryUsage, this.storageSize, StringEscapeUtils.escapeXml((String)this.path), this.lastModified, StringEscapeUtils.escapeXml((String)this.description));
    }

    public static Metadata fromReport(Report report, File file, File root) {
        String path;
        String status = "Success";
        if (report.getCheckpoints() != null && report.getCheckpoints().size() > 0 && report.getCheckpoints().get(report.getCheckpoints().size() - 1).getType() == 3) {
            status = "Error";
        }
        if (StringUtils.isNotEmpty((String)(path = root.toPath().relativize(file.getParentFile().toPath()).toString() + "/")) && !(path = path.replaceAll("\\\\", "/")).endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String filename = file.getName();
        filename = filename.substring(0, filename.length() - ".report.xml".length());
        return new Metadata(report.getStorageId(), report.getEndTime() - report.getStartTime(), report.getNumberOfCheckpoints(), report.getEstimatedMemoryUsage(), report.getStorageSize() != null ? report.getStorageSize() : 0L, report.getEndTime(), filename, report.getCorrelationId(), status, path, report.getDescription(), file.lastModified());
    }

    public static Metadata fromXml(String xml) {
        xml = Metadata.extractTagValue(xml, "Metadata");
        long storageId = Metadata.safeParse(Metadata.extractTagValue(xml, "StorageId"), -1L);
        long duration = Metadata.safeParse(Metadata.extractTagValue(xml, "Duration"), -1L);
        long nrChpts = Metadata.safeParse(Metadata.extractTagValue(xml, "NrChpts"), -1L);
        long estMemUsage = Metadata.safeParse(Metadata.extractTagValue(xml, "EstMemUsage"), -1L);
        long stroageSize = Metadata.safeParse(Metadata.extractTagValue(xml, "StroageSize"), -1L);
        long endTime = Metadata.safeParse(Metadata.extractTagValue(xml, "EndTime"), -1L);
        long lastModified = Metadata.safeParse(Metadata.extractTagValue(xml, "LastModified"), -1L);
        String name = Metadata.extractTagValue(xml, "Name");
        String correlationId = Metadata.extractTagValue(xml, "CorrelationId");
        String status = Metadata.extractTagValue(xml, "Status");
        String path = Metadata.extractTagValue(xml, "Path");
        String description = Metadata.extractTagValue(xml, "Description");
        return new Metadata(Long.valueOf(storageId).intValue(), duration, Long.valueOf(nrChpts).intValue(), estMemUsage, stroageSize, endTime, name, correlationId, status, path, description, lastModified);
    }

    private static String extractTagValue(String xml, String tag) {
        String startTag = "<" + tag + ">";
        int start = xml.indexOf(startTag);
        int end = xml.indexOf("</" + tag + ">", start + startTag.length());
        if (start < 0 || end < 0) {
            return null;
        }
        return StringEscapeUtils.unescapeXml((String)xml.substring(start + startTag.length(), end));
    }

    private static long safeParse(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String formatTime(long time) {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(time);
    }

    public int getStorageId() {
        return this.storageId;
    }

    public boolean fieldEquals(String field, Pattern pattern) {
        if (StringUtils.isEmpty((String)field) || pattern == null) {
            return true;
        }
        Object fieldval = this.getFieldValue(field);
        return fieldval != null && pattern.matcher(String.valueOf(fieldval)).find();
    }

    private Object getFieldValue(String field) {
        if (StringUtils.isEmpty((String)this.name)) {
            return null;
        }
        if (field.equalsIgnoreCase("storageId")) {
            return this.storageId;
        }
        if (field.equalsIgnoreCase("endtime")) {
            return Metadata.formatTime(this.endTime);
        }
        if (field.equalsIgnoreCase("duration")) {
            return this.duration;
        }
        if (field.equalsIgnoreCase("name")) {
            return this.name;
        }
        if (field.equalsIgnoreCase("correlationId")) {
            return this.correlationId;
        }
        if (field.equalsIgnoreCase("status")) {
            return this.status;
        }
        if (field.equalsIgnoreCase("numberOfCheckpoints")) {
            return this.nrChpts;
        }
        if (field.equalsIgnoreCase("estimatedMemoryUsage")) {
            return this.memoryUsage;
        }
        if (field.equalsIgnoreCase("storageSize")) {
            return this.storageSize;
        }
        if (field.equalsIgnoreCase("path")) {
            return this.path;
        }
        if (field.equalsIgnoreCase("description")) {
            return this.description;
        }
        if (field.equalsIgnoreCase("lastmodified")) {
            return this.lastModified;
        }
        return null;
    }
}

