/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.xml;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.storage.xml.Metadata;
import nl.nn.testtool.storage.xml.MetadataHandler;
import nl.nn.testtool.util.SearchUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlStorage
implements CrudStorage {
    public static final String FILE_EXTENSION = ".report.xml";
    private String name;
    private String metadataFile;
    private String reportsFolderPath;
    private MetadataHandler metadataHandler;
    private File reportsFolder;
    Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void init() throws StorageException {
        if (StringUtils.isEmpty((String)this.reportsFolderPath)) {
            throw new StorageException("Report folder path is empty. Please provide a path.");
        }
        this.reportsFolder = new File(this.reportsFolderPath);
        if (StringUtils.isEmpty((String)this.metadataFile)) {
            this.metadataFile = new File(this.reportsFolder, "metadata.xml").getAbsolutePath();
            this.log.warn("Metadatafile was not set. Using " + this.metadataFile);
        }
        try {
            this.metadataHandler = new MetadataHandler(this.metadataFile, this, false);
        }
        catch (IOException e) {
            throw new StorageException("Could not initialize xml storage", e);
        }
        this.updateMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(Report report, File file) throws StorageException {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(outputStream));
            try {
                encoder.writeObject(report);
            }
            finally {
                encoder.close();
                outputStream.close();
            }
        }
        catch (Exception e) {
            throw new StorageException("Could not write report [" + report.getCorrelationId() + "] to [" + file.getPath() + "].", e);
        }
    }

    @Override
    public void store(Report report) throws StorageException {
        try {
            Report copy = report.clone();
            this.store(copy, true);
        }
        catch (ClassCastException | CloneNotSupportedException e) {
            throw new StorageException("Could not clone the report for new storage.", e);
        }
    }

    private void store(Report report, boolean addNew) throws StorageException {
        try {
            File reportFile;
            Metadata metadata = this.metadataHandler.getMetadata(report.getStorageId());
            if (metadata == null || addNew) {
                String original_name;
                File parentFolder = report.getPath() != null ? new File(this.reportsFolder, report.getPath()) : this.reportsFolder;
                String filename = original_name = report.getName().replaceAll("[<>:\"\\/\\\\\\|\\?\\*]", "_");
                reportFile = new File(parentFolder, filename + FILE_EXTENSION);
                int i = 2;
                while (reportFile.isFile()) {
                    filename = original_name + " (" + i++ + ")";
                    reportFile = new File(parentFolder, filename + FILE_EXTENSION);
                }
                report.setName(filename);
            } else {
                reportFile = new File(this.resolvePath(report.getStorageId()));
            }
            if (addNew || report.getStorageId() == null || this.metadataHandler.contains(report.getStorageId())) {
                int storageId = this.metadataHandler.getNextStorageId();
                while (this.metadataHandler.contains(storageId)) {
                    storageId = this.metadataHandler.getNextStorageId();
                }
                report.setStorageId(storageId);
            }
            this.store(report, reportFile);
            metadata = Metadata.fromReport(report, reportFile, this.reportsFolder);
            this.metadataHandler.add(metadata);
        }
        catch (IOException e) {
            throw new StorageException("Error while writing the report!", e);
        }
    }

    @Override
    public Report getReport(Integer storageId) throws StorageException {
        Metadata m = this.metadataHandler.getMetadata(storageId);
        String path = this.resolvePath(m.storageId);
        if (StringUtils.isEmpty((String)path)) {
            this.log.warn("Given report path is empty.");
            return null;
        }
        File reportFile = new File(path);
        if (!reportFile.isFile()) {
            this.log.warn("Given report path does not resolve to a file.");
            return null;
        }
        Report report = this.readReportFromFile(reportFile);
        if (report.getStorageId() != m.storageId) {
            report.setStorageId(storageId);
        }
        return report;
    }

    @Override
    public void update(Report report) throws StorageException {
        try {
            Metadata metadata = this.metadataHandler.getMetadata(report.getStorageId());
            this.delete(report);
            metadata.path = report.getPath();
            this.metadataHandler.add(metadata);
            this.store(report, false);
        }
        catch (IOException e) {
            throw new StorageException("Returned an error while updating metadata.", e);
        }
    }

    @Override
    public void delete(Report report) throws StorageException {
        try {
            String path = this.resolvePath(report.getStorageId());
            if (path == null) {
                this.log.warn("Could not find report file for report with storage id [" + report.getStorageId() + "] correlation id [" + report.getCorrelationId() + "]");
                return;
            }
            File file = new File(path);
            if (!file.delete()) {
                throw new StorageException("Could not delete report with storage id [" + report.getStorageId() + "] correlation id [" + report.getCorrelationId() + "] at [" + path + "]");
            }
            file = file.getParentFile();
            while (file.delete()) {
                file = file.getParentFile();
            }
            this.metadataHandler.delete(report);
        }
        catch (IOException e) {
            throw new StorageException("Error while deleting the report with storage id [" + report.getStorageId() + "] correlation id [" + report.getCorrelationId() + "]", e);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() throws StorageException {
        return this.metadataHandler.getSize();
    }

    @Override
    public List getStorageIds() throws StorageException {
        return this.metadataHandler.getStorageIds();
    }

    @Override
    public List<List<Object>> getMetadata(int maxNumberOfRecords, List<String> metadataNames, List<String> searchValues, int metadataValueType) throws StorageException {
        this.updateMetadata();
        return this.metadataHandler.getAsListofObjects(maxNumberOfRecords, metadataNames, searchValues, metadataValueType);
    }

    @Override
    public void clear() throws StorageException {
        List storageIds = this.getStorageIds();
        for (Integer storageId : storageIds) {
            this.delete(this.getReport(storageId));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int getFilterType(String column) {
        return 0;
    }

    @Override
    public List getFilterValues(String column) throws StorageException {
        return null;
    }

    protected File getReportsFolder() {
        return this.reportsFolder;
    }

    @Override
    public String getUserHelp(String column) {
        return SearchUtil.getUserHelp();
    }

    protected Report readReportFromFile(File file) throws StorageException {
        if (file == null || !file.isFile() || !file.getName().endsWith(FILE_EXTENSION)) {
            return null;
        }
        this.log.debug("Reading from a new file: " + file.getPath());
        FileInputStream inputStream = null;
        XMLDecoder decoder = null;
        try {
            inputStream = new FileInputStream(file);
            decoder = new XMLDecoder(new BufferedInputStream(inputStream));
            Report report = (Report)decoder.readObject();
            report.setStorage(this);
            decoder.close();
            inputStream.close();
            return report;
        }
        catch (Exception e) {
            if (decoder != null) {
                decoder.close();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ignored) {
                    this.log.error("Could not close the xml file.", (Throwable)ignored);
                }
            }
            throw new StorageException("Exception while deserializing data from report file.", e);
        }
    }

    protected String resolvePath(Integer storageId) {
        Metadata metadata = this.metadataHandler.getMetadata(storageId);
        if (metadata == null) {
            return null;
        }
        File parentFolder = this.reportsFolder;
        if (StringUtils.isNotEmpty((String)metadata.path) && !metadata.path.equalsIgnoreCase("null")) {
            parentFolder = new File(this.reportsFolder, metadata.path);
        }
        return new File(parentFolder, metadata.name + FILE_EXTENSION).getPath();
    }

    public void setReportsFolder(String reportsFolder) {
        this.reportsFolderPath = reportsFolder;
    }

    public void setMetadataFile(String metadataFile) {
        this.metadataFile = metadataFile;
    }

    public void updateMetadata() {
        try {
            this.metadataHandler.updateMetadata();
        }
        catch (IOException ignored) {
            this.log.error("Exception while updating the metadata from filesystem.", (Throwable)ignored);
        }
    }
}

