/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.testtool.storage.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import nl.nn.testtool.MetadataExtractor;
import nl.nn.testtool.Report;
import nl.nn.testtool.storage.CrudStorage;
import nl.nn.testtool.storage.StorageException;
import nl.nn.testtool.util.SearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Storage
implements CrudStorage {
    private static Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private File file = new File("C:\\Temp\\tt.zip");
    private String name;
    private Map reports = new HashMap();
    private List storageIds = new ArrayList();
    private List metadata = new ArrayList();
    private int storageId = 0;
    private MetadataExtractor metadataExtractor;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    @Override
    public synchronized void store(Report report) {
        ZipEntry zipEntry = new ZipEntry(report.getStorageId().toString());
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        report.setStorage(this);
        report.setStorageId(new Integer(this.storageId++));
        this.reports.put(report.getStorageId(), report);
        this.storageIds.add(report.getStorageId());
        this.metadata.add(new HashMap());
    }

    @Override
    public void update(Report report) throws StorageException {
        throw new StorageException("Not implemented (yet)");
    }

    @Override
    public void delete(Report report) throws StorageException {
        throw new StorageException("Not implemented (yet)");
    }

    @Override
    public int getSize() {
        return this.storageIds.size();
    }

    @Override
    public synchronized List getStorageIds() {
        return new ArrayList(this.storageIds);
    }

    public synchronized List getMetadata(int maxNumberOfRecords, List metadataNames, List searchValues, int metadataValueType) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.metadata.size() && (maxNumberOfRecords == -1 || i < maxNumberOfRecords); ++i) {
            Map metadataRecord = (Map)this.metadata.get(i);
            ArrayList resultRecord = new ArrayList();
            for (String metadataName : metadataNames) {
                Object metadataValue;
                if (!metadataRecord.keySet().contains(metadataName)) {
                    Report report = this.getReport((Integer)this.storageIds.get(i));
                    metadataValue = this.metadataExtractor.getMetadata(report, metadataName, metadataValueType);
                    metadataRecord.put(metadataName, metadataValue);
                } else {
                    metadataValue = metadataRecord.get(metadataName);
                }
                resultRecord.add(metadataValue);
            }
            if (!SearchUtil.matches(resultRecord, searchValues)) continue;
            result.add(resultRecord);
        }
        return result;
    }

    @Override
    public synchronized Report getReport(Integer storageId) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.file);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ZipEntry zipEntry = zipFile.getEntry(storageId.toString());
        return (Report)this.reports.get(storageId);
    }

    @Override
    public void clear() throws StorageException {
        throw new StorageException("Not implemented (yet)");
    }

    @Override
    public void close() {
    }

    @Override
    public int getFilterType(String column) {
        return 0;
    }

    @Override
    public List getFilterValues(String column) throws StorageException {
        return null;
    }

    @Override
    public String getUserHelp(String column) {
        return SearchUtil.getUserHelp();
    }
}

